package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.RangoEdad;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * * ConsumidorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ConsumidorDaoImpl implements ConsumidorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Consumidor> rwMap = new RowMapper<Consumidor>() {
		public Consumidor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Consumidor(resultSet.getString("DTCODIGO"),
					new CensoMonitor(resultSet
							.getString("CensoMonitorMOCODIGO"), resultSet
							.getString("CensoMonitorMONOMBRE"), resultSet
							.getString("CensoMonitorMOCOEM"), resultSet
							.getString("CensoMonitorMODNI"), resultSet
							.getString("CensoMonitorUSUARIOXLNET"), resultSet
							.getString("CensoMonitorPUESTOXLNET"), resultSet
							.getDate("CensoMonitorMOFECBAJA"), new Organismo(
							resultSet.getString("CensoMonitorMOCOOR")), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null), new RangoEdad(
							resultSet.getString("RangoEdadRANCOD"),
							resultSet.getString("RangoEdadRANDESC")),
					resultSet.getString("DTNOMBRE"),
					resultSet.getString("DTAPELLIDO1"),
					resultSet.getString("DTAPELLIDO2"),
					resultSet.getString("DTNIF"),
					resultSet.getString("DTNODIR"),
					resultSet.getString("DTCOLO"),
					resultSet.getString("DTNRCOPO"),
					resultSet.getString("DTNRTEL"),
					resultSet.getString("DTNRFAX"),
					resultSet.getString("DTCOPA"),
					resultSet.getString("DTNRDIMU"),
					resultSet.getString("DTTECOEM"),
					resultSet.getString("DTNRTEL2"),
					resultSet.getString("DTNRTEL3"),
					resultSet.getString("DTCOIDCO"),
					resultSet.getString("DTINRECO"),
					resultSet.getString("DTCOORAC"),
					resultSet.getString("DTNOAP1"),
					resultSet.getString("DTNOAP2"),
					resultSet.getString("DTNRSOCI"),
					resultSet.getString("DTNRAN"),
					resultSet.getString("DTCOSX"),
					resultSet.getString("DTNOREP"),
					resultSet.getString("DTNIFREP"),
					resultSet.getString("DTFEMOD"),
					resultSet.getString("DTNOLO"),
					resultSet.getString("DTCOPV"),
					resultSet.getString("DTINRL"),
					resultSet.getString("DTNODIRR"),
					resultSet.getString("DTCOLOR"),
					resultSet.getString("DTNRCOPOR"),
					resultSet.getString("DTCOPVR"),
					resultSet.getString("DTNRTELR"),
					resultSet.getString("DTNRTEL2R"),
					resultSet.getString("DTNRFAXR"),
					resultSet.getString("DTTEEMR"),
					resultSet.getString("DTINTIPID"),
					resultSet.getString("DTNORAPAISID"),
					resultSet.getString("DTNORAPAISNOMBRE"),
					resultSet.getString("DTNORAPROVINCIAID"),
					resultSet.getString("DTNOMBREPROVINCIA"),
					resultSet.getString("DTNORAMUNICIPIOID"),
					resultSet.getString("DTNOMBREMUNICIPIO"),
					resultSet.getString("DTNORALOCALIDADID"),
					resultSet.getString("DTNOMBRELOCALIDAD"),
					resultSet.getString("DTNORACALLEID"),
					resultSet.getString("DTNOMBRECALLE"),
					resultSet.getString("DTNORACPID"),
					resultSet.getString("DTNOMBRECP"),
					resultSet.getString("DTNORAPORTALID"),
					resultSet.getString("DTNOMBREPORTAL"),
					resultSet.getString("DTNOMBREPISO"),
					resultSet.getString("DTDIRECCION_NOCAPV"), null, null,
					resultSet.getString("DTEXTRANJERO"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return Consumidor
	 */
	public Consumidor add(Consumidor consumidor) {

		String query = "INSERT INTO CONSUMIDOR( DTCODIGO,DTCOZS,DTRANGO_EDAD,DTNOMBRE,DTAPELLIDO1,DTAPELLIDO2,DTNIF,DTNODIR,DTCOLO,DTNRCOPO,DTNRTEL,DTNRFAX,DTCOPA,DTNRDIMU,DTTECOEM,DTNRTEL2,DTNRTEL3,DTCOIDCO,DTINRECO,DTCOORAC,DTNOAP1,DTNOAP2,DTNRSOCI,DTNRAN,DTCOSX,DTNOREP,DTNIFREP,DTFEMOD,DTNOLO,DTCOPV,DTINRL,DTNODIRR,DTCOLOR,DTNRCOPOR,DTCOPVR,DTNRTELR,DTNRTEL2R,DTNRFAXR,DTTEEMR,DTINTIPID,DTNORA_PAIS_ID,DTNORA_PAIS_NOMBRE,DTNORA_PROVINCIA_ID,DTNOMBRE_PROVINCIA,DTNORA_MUNICIPIO_ID,DTNOMBRE_MUNICIPIO,DTNORA_LOCALIDAD_ID,DTNOMBRE_LOCALIDAD,DTNORA_CALLE_ID,DTNOMBRE_CALLE,DTNORA_CP_ID,DTNOMBRE_CP,DTNORA_PORTAL_ID,DTNOMBRE_PORTAL,DTNOMBRE_PISO,DTDIRECCION_NOCAPV,DTEXTRANJERO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getCensoMonitorMocodigoAux = null;
		if (consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consumidor.getCensoMonitor()
					.getMocodigo();
		}
		Object getRangoEdadRancodAux = null;
		if (consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			getRangoEdadRancodAux = consumidor.getRangoEdad().getRancod();
		}
		this.jdbcTemplate.update(query, consumidor.getDtcodigo(),
				getCensoMonitorMocodigoAux, getRangoEdadRancodAux,
				consumidor.getDtnombre(), consumidor.getDtapellido1(),
				consumidor.getDtapellido2(), consumidor.getDtnif(),
				consumidor.getDtnodir(), consumidor.getDtcolo(),
				consumidor.getDtnrcopo(), consumidor.getDtnrtel(),
				consumidor.getDtnrfax(), consumidor.getDtcopa(),
				consumidor.getDtnrdimu(), consumidor.getDttecoem(),
				consumidor.getDtnrtel2(), consumidor.getDtnrtel3(),
				consumidor.getDtcoidco(), consumidor.getDtinreco(),
				consumidor.getDtcoorac(), consumidor.getDtnoap1(),
				consumidor.getDtnoap2(), consumidor.getDtnrsoci(),
				consumidor.getDtnran(), consumidor.getDtcosx(),
				consumidor.getDtnorep(), consumidor.getDtnifrep(),
				consumidor.getDtfemod(), consumidor.getDtnolo(),
				consumidor.getDtcopv(), consumidor.getDtinrl(),
				consumidor.getDtnodirr(), consumidor.getDtcolor(),
				consumidor.getDtnrcopor(), consumidor.getDtcopvr(),
				consumidor.getDtnrtelr(), consumidor.getDtnrtel2r(),
				consumidor.getDtnrfaxr(), consumidor.getDtteemr(),
				consumidor.getDtintipid(), consumidor.getDtnoraPaisId(),
				consumidor.getDtnoraPaisNombre(),
				consumidor.getDtnoraProvinciaId(),
				consumidor.getDtnombreProvincia(),
				consumidor.getDtnoraMunicipioId(),
				consumidor.getDtnombreMunicipio(),
				consumidor.getDtnoraLocalidadId(),
				consumidor.getDtnombreLocalidad(),
				consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(),
				consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(),
				consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
				consumidor.getDtnombrePiso(),
				consumidor.getDtdireccion_nocapv(),
				consumidor.getDtextranjero());
		return consumidor;
	}

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarConsumidorTelematico(SolicitudDetalle solicitudDetalle) {

		String query = "INSERT INTO CONSUMIDOR ( DTCODIGO,DTRANGO_EDAD,DTNOMBRE,DTAPELLIDO1,DTAPELLIDO2,DTNIF,DTNRTEL,DTTECOEM,DTNRTEL2,DTCOIDCO,DTCOSX,DTINTIPID,DTNORA_PAIS_ID,DTNORA_PAIS_NOMBRE,DTNORA_PROVINCIA_ID,DTNOMBRE_PROVINCIA,DTNORA_MUNICIPIO_ID,DTNOMBRE_MUNICIPIO,DTNORA_LOCALIDAD_ID,DTNOMBRE_LOCALIDAD,DTNORA_CALLE_ID,DTNOMBRE_CALLE,DTNORA_CP_ID,DTNOMBRE_CP,DTNORA_PORTAL_ID,DTNOMBRE_PORTAL,DTNOMBRE_PISO,DTDIRECCION_NOCAPV,DTEXTRANJERO,DTFEMOD,DTCOZS) SELECT ?,DTRANGO_EDAD,NOMBRE,APELLIDO1,APELLIDO2,NIF,NRTEL,COEM,NRTEL2,COIDCO,DTCOSX,DTINTIPID,NORA_PAIS_ID, NOMBRE_PAIS,NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD,NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO,DIRECCION_NOCAPV,EXTRANJERO,?,? FROM INTERVINIENTES_TELE WHERE HDCODIGO = ? ";
		this.jdbcTemplate.update(query, solicitudDetalle.getDtcodigo(),
				Y41bUtils.parseDateToString(new Date(),
						Y41bConstantes.CASTELLANO),
				Y41bConstantes.CODIGO_USUARIO_Y41R_CENSO_MONITOR,
				solicitudDetalle.getHdcodigo());
	}

	/**
	 * Update a single row in the Consumidor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void actualizarConsumidorTelematico(SolicitudDetalle solicitudDetalle) {

		String query = "UPDATE CONSUMIDOR SET ( DTRANGO_EDAD,DTNOMBRE,DTAPELLIDO1,DTAPELLIDO2,DTNIF,DTNRTEL,DTTECOEM,DTNRTEL2,DTCOIDCO,DTCOSX,DTINTIPID,DTNORA_PAIS_ID,DTNORA_PAIS_NOMBRE,DTNORA_PROVINCIA_ID,DTNOMBRE_PROVINCIA,DTNORA_MUNICIPIO_ID,DTNOMBRE_MUNICIPIO,DTNORA_LOCALIDAD_ID,DTNOMBRE_LOCALIDAD,DTNORA_CALLE_ID,DTNOMBRE_CALLE,DTNORA_CP_ID,DTNOMBRE_CP,DTNORA_PORTAL_ID,DTNOMBRE_PORTAL,DTNOMBRE_PISO,DTDIRECCION_NOCAPV,DTEXTRANJERO,DTFEMOD,DTCOZS) = (SELECT DTRANGO_EDAD,NOMBRE,APELLIDO1,APELLIDO2,NIF,NRTEL,COEM,NRTEL2,COIDCO,DTCOSX,DTINTIPID,NORA_PAIS_ID, NOMBRE_PAIS,NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD,NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO,DIRECCION_NOCAPV,EXTRANJERO,?,? FROM INTERVINIENTES_TELE WHERE HDCODIGO = ?) WHERE DTCODIGO = ? ";
		this.jdbcTemplate.update(query, Y41bUtils.parseDateToString(new Date(),
				Y41bConstantes.CASTELLANO),
				Y41bConstantes.CODIGO_USUARIO_Y41R_CENSO_MONITOR,
				solicitudDetalle.getHdcodigo(), solicitudDetalle.getDtcodigo());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeConsumidorTelematico(SolicitudDetalle solicitudDetalle) {
		String query = "DELETE  FROM INTERVINIENTES_TELE WHERE HDCODIGO=?";
		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return Consumidor
	 */
	public Consumidor update(Consumidor consumidor) {
		String query = "UPDATE CONSUMIDOR SET DTCOZS=?,DTRANGO_EDAD=?,DTNOMBRE=?,DTAPELLIDO1=?,DTAPELLIDO2=?,DTNIF=?,DTNRTEL=?,DTTECOEM=?,DTNRTEL2=?,DTCOIDCO=?,DTINRECO=?,DTCOORAC=?,DTCOSX=?,DTFEMOD=?,DTINTIPID=?,DTNORA_PAIS_ID=?,DTNORA_PAIS_NOMBRE=?,DTNORA_PROVINCIA_ID=?,DTNOMBRE_PROVINCIA=?,DTNORA_MUNICIPIO_ID=?,DTNOMBRE_MUNICIPIO=?,DTNORA_LOCALIDAD_ID=?,DTNOMBRE_LOCALIDAD=?,DTNORA_CALLE_ID=?,DTNOMBRE_CALLE=?,DTNORA_CP_ID=?,DTNOMBRE_CP=?,DTNORA_PORTAL_ID=?,DTNOMBRE_PORTAL=?,DTNOMBRE_PISO=?,DTDIRECCION_NOCAPV=?,DTEXTRANJERO=? WHERE DTCODIGO=?";
		Object getCensoMonitorMocodigoAux = null;
		if (consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consumidor.getCensoMonitor()
					.getMocodigo();
		}
		Object getRangoEdadRancodAux = null;
		if (consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			getRangoEdadRancodAux = consumidor.getRangoEdad().getRancod();
		}
		this.jdbcTemplate.update(query, getCensoMonitorMocodigoAux,
				getRangoEdadRancodAux, consumidor.getDtnombre(),
				consumidor.getDtapellido1(), consumidor.getDtapellido2(),
				consumidor.getDtnif(), consumidor.getDtnrtel(),
				consumidor.getDttecoem(), consumidor.getDtnrtel2(),
				consumidor.getDtcoidco(), consumidor.getDtinreco(),
				consumidor.getDtcoorac(), consumidor.getDtcosx(),
				consumidor.getDtfemod(), consumidor.getDtintipid(),
				consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
				consumidor.getDtnoraProvinciaId(),
				consumidor.getDtnombreProvincia(),
				consumidor.getDtnoraMunicipioId(),
				consumidor.getDtnombreMunicipio(),
				consumidor.getDtnoraLocalidadId(),
				consumidor.getDtnombreLocalidad(),
				consumidor.getDtnoraCalleId(), consumidor.getDtnombreCalle(),
				consumidor.getDtnoraCpId(), consumidor.getDtnombreCp(),
				consumidor.getDtnoraPortalId(), consumidor.getDtnombrePortal(),
				consumidor.getDtnombrePiso(),
				consumidor.getDtdireccion_nocapv(),
				consumidor.getDtextranjero(), consumidor.getDtcodigo());
		return consumidor;
	}

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return Consumidor
	 */
	public Consumidor updateNombreApellidos(Consumidor consumidor) {
		String query = "UPDATE CONSUMIDOR SET DTNOMBRE=?,DTAPELLIDO1=?,DTAPELLIDO2=?,DTNIF=?, DTFEMOD=?,DTCOZS=? WHERE DTNIF=?";

		this.jdbcTemplate.update(query, consumidor.getDtnombre(), consumidor
				.getDtapellido1(), consumidor.getDtapellido2(), consumidor
				.getDtnif(), Y41bUtils.parseDateToString(new Date(),
				Y41bConstantes.CASTELLANO),
				Y41bConstantes.CODIGO_USUARIO_Y41R_CENSO_MONITOR, consumidor
						.getDtnif());
		return consumidor;
	}

	/**
	 * Update a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 */
	public void updateConsumidorTelematico(Consumidor consumidor) {

		String query = "UPDATE CONSUMIDOR SET DTNOMBRE=?,DTAPELLIDO1=?,DTAPELLIDO2=?,DTNIF=?,DTNRTEL=?,DTTECOEM=?,DTNORA_PAIS_ID=?,DTNORA_PAIS_NOMBRE=?,DTNORA_PROVINCIA_ID=?,DTNOMBRE_PROVINCIA=?,DTNORA_MUNICIPIO_ID=?,DTNOMBRE_MUNICIPIO=?,DTNORA_LOCALIDAD_ID=?,DTNOMBRE_LOCALIDAD=?,DTNORA_CALLE_ID=?,DTNOMBRE_CALLE=?,DTNORA_CP_ID=?,DTNOMBRE_CP=?,DTNORA_PORTAL_ID=?,DTNOMBRE_PORTAL=?,DTNOMBRE_PISO=?,DTDIRECCION_NOCAPV=?,DTEXTRANJERO=?,DTFEMOD=?,DTCOZS=? WHERE DTNIF=? ";
		this.jdbcTemplate.update(query, consumidor.getDtnombre(), consumidor
				.getDtapellido1(), consumidor.getDtapellido2(), consumidor
				.getDtnif(), consumidor.getDtnrtel(), consumidor.getDttecoem(),
				consumidor.getDtnoraPaisId(), consumidor.getDtnoraPaisNombre(),
				consumidor.getDtnoraProvinciaId(), consumidor
						.getDtnombreProvincia(), consumidor
						.getDtnoraMunicipioId(), consumidor
						.getDtnombreMunicipio(), consumidor
						.getDtnoraLocalidadId(), consumidor
						.getDtnombreLocalidad(), consumidor.getDtnoraCalleId(),
				consumidor.getDtnombreCalle(), consumidor.getDtnoraCpId(),
				consumidor.getDtnombreCp(), consumidor.getDtnoraPortalId(),
				consumidor.getDtnombrePortal(), consumidor.getDtnombrePiso(),
				consumidor.getDtdireccion_nocapv(), consumidor
						.getDtextranjero(), Y41bUtils.parseDateToString(
						new Date(), Y41bConstantes.CASTELLANO),
				Y41bConstantes.CODIGO_USUARIO_Y41R_CENSO_MONITOR, consumidor
						.getDtnif());
	}

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return Consumidor
	 */
	@Transactional(readOnly = true)
	public Consumidor find(Consumidor consumidor) {
		String query = "SELECT t1.DTCODIGO DTCODIGO, t1.DTNOMBRE DTNOMBRE,t1.DTAPELLIDO1 DTAPELLIDO1,t1.DTAPELLIDO2 DTAPELLIDO2, t1.DTNIF DTNIF, t1.DTNODIR DTNODIR, t1.DTCOLO DTCOLO, t1.DTNRCOPO DTNRCOPO, t1.DTNRTEL DTNRTEL, t1.DTNRFAX DTNRFAX, t1.DTCOPA DTCOPA, t1.DTNRDIMU DTNRDIMU, t1.DTTECOEM DTTECOEM, t1.DTNRTEL2 DTNRTEL2, t1.DTNRTEL3 DTNRTEL3, t1.DTCOIDCO DTCOIDCO, t1.DTINRECO DTINRECO, t1.DTCOORAC DTCOORAC, t1.DTNOAP1 DTNOAP1, t1.DTNOAP2 DTNOAP2, t1.DTNRSOCI DTNRSOCI, t1.DTNRAN DTNRAN, t1.DTCOSX DTCOSX, t1.DTNOREP DTNOREP, t1.DTNIFREP DTNIFREP, t1.DTFEMOD DTFEMOD, t1.DTNOLO DTNOLO, t1.DTCOPV DTCOPV, t1.DTINRL DTINRL, t1.DTNODIRR DTNODIRR, t1.DTCOLOR DTCOLOR, t1.DTNRCOPOR DTNRCOPOR, t1.DTCOPVR DTCOPVR, t1.DTNRTELR DTNRTELR, t1.DTNRTEL2R DTNRTEL2R, t1.DTNRFAXR DTNRFAXR, t1.DTTEEMR DTTEEMR, t1.DTINTIPID DTINTIPID, t1.DTNORA_PAIS_ID DTNORAPAISID, t1.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE, t1.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID, t1.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA, t1.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t1.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, t1.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID, t1.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, t1.DTNORA_CALLE_ID DTNORACALLEID, t1.DTNOMBRE_CALLE DTNOMBRECALLE, t1.DTNORA_CP_ID DTNORACPID, t1.DTNOMBRE_CP DTNOMBRECP, t1.DTNORA_PORTAL_ID DTNORAPORTALID, t1.DTNOMBRE_PORTAL DTNOMBREPORTAL, t1.DTNOMBRE_PISO DTNOMBREPISO, t1.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, t1.DTEXTRANJERO DTEXTRANJERO, t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t2.PUESTOXLNET CENSOMONITORPUESTOXLNET, t2.MOCODIGO CENSOMONITORMOCODIGO, t2.MONOMBRE CENSOMONITORMONOMBRE, t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI, t2.MOFECBAJA CENSOMONITORMOFECBAJA, t3.RANCOD RANGOEDADRANCOD, t3.RANDESC RANGOEDADRANDESC, t2.MOCOOR CENSOMONITORMOCOOR "
				+ "FROM CONSUMIDOR t1 , CENSO_MONITOR t2 , RANGO_EDAD t3  "
				+ "WHERE t1.DTCODIGO = ?   AND t1.DTCOZS= t2.MOCODIGO(+) AND t1.DTRANGO_EDAD= t3.RANCOD(+)  ";
		return (Consumidor) this.jdbcTemplate.queryForObject(query, rwMap,
				consumidor.getDtcodigo());
	}

	/**
	 * Removes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return
	 */
	public void remove(Consumidor consumidor) {
		String query = "DELETE  FROM CONSUMIDOR WHERE DTCODIGO=?";
		this.jdbcTemplate.update(query, consumidor.getDtcodigo());
	}

	/**
	 * Finds a List of rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Consumidor> findAll(Consumidor consumidor, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.DTCOZS= t2.MOCODIGO(+) AND t1.DTRANGO_EDAD= t3.RANCOD(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DTCODIGO DTCODIGO,t1.DTNOMBRE DTNOMBRE,t1.DTNIF DTNIF,t1.DTNODIR DTNODIR,t1.DTCOLO DTCOLO,t1.DTNRCOPO DTNRCOPO,t1.DTNRTEL DTNRTEL,t1.DTNRFAX DTNRFAX,t1.DTCOPA DTCOPA,t1.DTNRDIMU DTNRDIMU,t1.DTTECOEM DTTECOEM,t1.DTNRTEL2 DTNRTEL2,t1.DTNRTEL3 DTNRTEL3,t1.DTCOIDCO DTCOIDCO,t1.DTINRECO DTINRECO,t1.DTCOORAC DTCOORAC,t1.DTNOAP1 DTNOAP1,t1.DTNOAP2 DTNOAP2,t1.DTNRSOCI DTNRSOCI,t1.DTNRAN DTNRAN,t1.DTCOSX DTCOSX,t1.DTNOREP DTNOREP,t1.DTNIFREP DTNIFREP,t1.DTFEMOD DTFEMOD,t1.DTNOLO DTNOLO,t1.DTCOPV DTCOPV,t1.DTINRL DTINRL,t1.DTNODIRR DTNODIRR,t1.DTCOLOR DTCOLOR,t1.DTNRCOPOR DTNRCOPOR,t1.DTCOPVR DTCOPVR,t1.DTNRTELR DTNRTELR,t1.DTNRTEL2R DTNRTEL2R,t1.DTNRFAXR DTNRFAXR,t1.DTTEEMR DTTEEMR,t1.DTINTIPID DTINTIPID,t1.DTNORA_PAIS_ID DTNORAPAISID,t1.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE,t1.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID,t1.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA,t1.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID,t1.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO,t1.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID,t1.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD,t1.DTNORA_CALLE_ID DTNORACALLEID,t1.DTNOMBRE_CALLE DTNOMBRECALLE,t1.DTNORA_CP_ID DTNORACPID,t1.DTNOMBRE_CP DTNOMBRECP,t1.DTNORA_PORTAL_ID DTNORAPORTALID,t1.DTNOMBRE_PORTAL DTNOMBREPORTAL, t1.DTNOMBRE_PISO DTNOMBREPISO, t1.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, t1.DTEXTRANJERO DTEXTRANJERO,t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t2.PUESTOXLNET CENSOMONITORPUESTOXLNET, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t3.RANCOD RANGOEDADRANCOD,t3.RANDESC RANGOEDADRANDESC,t2.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM CONSUMIDOR t1 ,CENSO_MONITOR t2 ,RANGO_EDAD t3 ");

		if (consumidor != null && consumidor.getDtcodigo() != null) {
			where.append(" AND t1.DTCODIGO = ?");
			params.add(consumidor.getDtcodigo());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(consumidor.getCensoMonitor().getMocodigo());
		}
		if (consumidor != null
				&& consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getOrganismo() != null
				&& consumidor.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(consumidor.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(consumidor.getCensoMonitor().getMonombre());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(consumidor.getCensoMonitor().getMocoem());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(consumidor.getCensoMonitor().getMofecbaja());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			where.append(" AND t3.RANCOD = ?");
			params.add(consumidor.getRangoEdad().getRancod());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRandesc() != null) {
			where.append(" AND t3.RANDESC = ?");
			params.add(consumidor.getRangoEdad().getRandesc());
		}
		if (consumidor != null && consumidor.getDtnombre() != null) {
			where.append(" AND t1.DTNOMBRE = ?");
			params.add(consumidor.getDtnombre());
		}
		if (consumidor != null && consumidor.getDtnif() != null) {
			where.append(" AND t1.DTNIF = ?");
			params.add(consumidor.getDtnif());
		}
		if (consumidor != null && consumidor.getDtnodir() != null) {
			where.append(" AND t1.DTNODIR = ?");
			params.add(consumidor.getDtnodir());
		}
		if (consumidor != null && consumidor.getDtcolo() != null) {
			where.append(" AND t1.DTCOLO = ?");
			params.add(consumidor.getDtcolo());
		}
		if (consumidor != null && consumidor.getDtnrcopo() != null) {
			where.append(" AND t1.DTNRCOPO = ?");
			params.add(consumidor.getDtnrcopo());
		}
		if (consumidor != null && consumidor.getDtnrtel() != null) {
			where.append(" AND t1.DTNRTEL = ?");
			params.add(consumidor.getDtnrtel());
		}
		if (consumidor != null && consumidor.getDtnrfax() != null) {
			where.append(" AND t1.DTNRFAX = ?");
			params.add(consumidor.getDtnrfax());
		}
		if (consumidor != null && consumidor.getDtcopa() != null) {
			where.append(" AND t1.DTCOPA = ?");
			params.add(consumidor.getDtcopa());
		}
		if (consumidor != null && consumidor.getDtnrdimu() != null) {
			where.append(" AND t1.DTNRDIMU = ?");
			params.add(consumidor.getDtnrdimu());
		}
		if (consumidor != null && consumidor.getDttecoem() != null) {
			where.append(" AND t1.DTTECOEM = ?");
			params.add(consumidor.getDttecoem());
		}
		if (consumidor != null && consumidor.getDtnrtel2() != null) {
			where.append(" AND t1.DTNRTEL2 = ?");
			params.add(consumidor.getDtnrtel2());
		}
		if (consumidor != null && consumidor.getDtnrtel3() != null) {
			where.append(" AND t1.DTNRTEL3 = ?");
			params.add(consumidor.getDtnrtel3());
		}
		if (consumidor != null && consumidor.getDtcoidco() != null) {
			where.append(" AND t1.DTCOIDCO = ?");
			params.add(consumidor.getDtcoidco());
		}
		if (consumidor != null && consumidor.getDtinreco() != null) {
			where.append(" AND t1.DTINRECO = ?");
			params.add(consumidor.getDtinreco());
		}
		if (consumidor != null && consumidor.getDtcoorac() != null) {
			where.append(" AND t1.DTCOORAC = ?");
			params.add(consumidor.getDtcoorac());
		}
		if (consumidor != null && consumidor.getDtnoap1() != null) {
			where.append(" AND t1.DTNOAP1 = ?");
			params.add(consumidor.getDtnoap1());
		}
		if (consumidor != null && consumidor.getDtnoap2() != null) {
			where.append(" AND t1.DTNOAP2 = ?");
			params.add(consumidor.getDtnoap2());
		}
		if (consumidor != null && consumidor.getDtnrsoci() != null) {
			where.append(" AND t1.DTNRSOCI = ?");
			params.add(consumidor.getDtnrsoci());
		}
		if (consumidor != null && consumidor.getDtnran() != null) {
			where.append(" AND t1.DTNRAN = ?");
			params.add(consumidor.getDtnran());
		}
		if (consumidor != null && consumidor.getDtcosx() != null) {
			where.append(" AND t1.DTCOSX = ?");
			params.add(consumidor.getDtcosx());
		}
		if (consumidor != null && consumidor.getDtnorep() != null) {
			where.append(" AND t1.DTNOREP = ?");
			params.add(consumidor.getDtnorep());
		}
		if (consumidor != null && consumidor.getDtnifrep() != null) {
			where.append(" AND t1.DTNIFREP = ?");
			params.add(consumidor.getDtnifrep());
		}
		if (consumidor != null && consumidor.getDtfemod() != null) {
			where.append(" AND t1.DTFEMOD = ?");
			params.add(consumidor.getDtfemod());
		}
		if (consumidor != null && consumidor.getDtnolo() != null) {
			where.append(" AND t1.DTNOLO = ?");
			params.add(consumidor.getDtnolo());
		}
		if (consumidor != null && consumidor.getDtcopv() != null) {
			where.append(" AND t1.DTCOPV = ?");
			params.add(consumidor.getDtcopv());
		}
		if (consumidor != null && consumidor.getDtinrl() != null) {
			where.append(" AND t1.DTINRL = ?");
			params.add(consumidor.getDtinrl());
		}
		if (consumidor != null && consumidor.getDtnodirr() != null) {
			where.append(" AND t1.DTNODIRR = ?");
			params.add(consumidor.getDtnodirr());
		}
		if (consumidor != null && consumidor.getDtcolor() != null) {
			where.append(" AND t1.DTCOLOR = ?");
			params.add(consumidor.getDtcolor());
		}
		if (consumidor != null && consumidor.getDtnrcopor() != null) {
			where.append(" AND t1.DTNRCOPOR = ?");
			params.add(consumidor.getDtnrcopor());
		}
		if (consumidor != null && consumidor.getDtcopvr() != null) {
			where.append(" AND t1.DTCOPVR = ?");
			params.add(consumidor.getDtcopvr());
		}
		if (consumidor != null && consumidor.getDtnrtelr() != null) {
			where.append(" AND t1.DTNRTELR = ?");
			params.add(consumidor.getDtnrtelr());
		}
		if (consumidor != null && consumidor.getDtnrtel2r() != null) {
			where.append(" AND t1.DTNRTEL2R = ?");
			params.add(consumidor.getDtnrtel2r());
		}
		if (consumidor != null && consumidor.getDtnrfaxr() != null) {
			where.append(" AND t1.DTNRFAXR = ?");
			params.add(consumidor.getDtnrfaxr());
		}
		if (consumidor != null && consumidor.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(consumidor.getDtteemr());
		}
		if (consumidor != null && consumidor.getDtintipid() != null) {
			where.append(" AND t1.DTINTIPID = ?");
			params.add(consumidor.getDtintipid());
		}
		if (consumidor != null && consumidor.getDtnoraPaisId() != null) {
			where.append(" AND t1.DTNORA_PAIS_ID = ?");
			params.add(consumidor.getDtnoraPaisId());
		}
		if (consumidor != null && consumidor.getDtnoraPaisNombre() != null) {
			where.append(" AND t1.DTNORA_PAIS_NOMBRE = ?");
			params.add(consumidor.getDtnoraPaisNombre());
		}
		if (consumidor != null && consumidor.getDtnoraProvinciaId() != null) {
			where.append(" AND t1.DTNORA_PROVINCIA_ID = ?");
			params.add(consumidor.getDtnoraProvinciaId());
		}
		if (consumidor != null && consumidor.getDtnombreProvincia() != null) {
			where.append(" AND t1.DTNOMBRE_PROVINCIA = ?");
			params.add(consumidor.getDtnombreProvincia());
		}
		if (consumidor != null && consumidor.getDtnoraMunicipioId() != null) {
			where.append(" AND t1.DTNORA_MUNICIPIO_ID = ?");
			params.add(consumidor.getDtnoraMunicipioId());
		}
		if (consumidor != null && consumidor.getDtnombreMunicipio() != null) {
			where.append(" AND t1.DTNOMBRE_MUNICIPIO = ?");
			params.add(consumidor.getDtnombreMunicipio());
		}
		if (consumidor != null && consumidor.getDtnoraLocalidadId() != null) {
			where.append(" AND t1.DTNORA_LOCALIDAD_ID = ?");
			params.add(consumidor.getDtnoraLocalidadId());
		}
		if (consumidor != null && consumidor.getDtnombreLocalidad() != null) {
			where.append(" AND t1.DTNOMBRE_LOCALIDAD = ?");
			params.add(consumidor.getDtnombreLocalidad());
		}
		if (consumidor != null && consumidor.getDtnoraCalleId() != null) {
			where.append(" AND t1.DTNORA_CALLE_ID = ?");
			params.add(consumidor.getDtnoraCalleId());
		}
		if (consumidor != null && consumidor.getDtnombreCalle() != null) {
			where.append(" AND t1.DTNOMBRE_CALLE = ?");
			params.add(consumidor.getDtnombreCalle());
		}
		if (consumidor != null && consumidor.getDtnoraCpId() != null) {
			where.append(" AND t1.DTNORA_CP_ID = ?");
			params.add(consumidor.getDtnoraCpId());
		}
		if (consumidor != null && consumidor.getDtnombreCp() != null) {
			where.append(" AND t1.DTNOMBRE_CP = ?");
			params.add(consumidor.getDtnombreCp());
		}
		if (consumidor != null && consumidor.getDtnoraPortalId() != null) {
			where.append(" AND t1.DTNORA_PORTAL_ID = ?");
			params.add(consumidor.getDtnoraPortalId());
		}
		if (consumidor != null && consumidor.getDtnombrePortal() != null) {
			where.append(" AND t1.DTNOMBRE_PORTAL = ?");
			params.add(consumidor.getDtnombrePortal());
		}
		if (consumidor != null && consumidor.getDtnombrePiso() != null) {
			where.append(" AND t1.DTNOMBRE_PISO = ?");
			params.add(consumidor.getDtnombrePiso());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Consumidor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Consumidor consumidor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.DTCOZS= t2.MOCODIGO(+) and t1.DTRANGO_EDAD= t3.RANCOD(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CONSUMIDOR t1   ,  CENSO_MONITOR t2   ,  RANGO_EDAD t3  ");
		if (consumidor != null && consumidor.getDtcodigo() != null) {
			where.append(" AND t1.DTCODIGO = ?");
			params.add(consumidor.getDtcodigo());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(consumidor.getCensoMonitor().getMocodigo());
		}
		if (consumidor != null
				&& consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getOrganismo() != null
				&& consumidor.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(consumidor.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(consumidor.getCensoMonitor().getMonombre());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(consumidor.getCensoMonitor().getMocoem());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(consumidor.getCensoMonitor().getMofecbaja());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			where.append(" AND t3.RANCOD = ?");
			params.add(consumidor.getRangoEdad().getRancod());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRandesc() != null) {
			where.append(" AND t3.RANDESC = ?");
			params.add(consumidor.getRangoEdad().getRandesc());
		}
		if (consumidor != null && consumidor.getDtnombre() != null) {
			where.append(" AND t1.DTNOMBRE = ?");
			params.add(consumidor.getDtnombre());
		}
		if (consumidor != null && consumidor.getDtnif() != null) {
			where.append(" AND t1.DTNIF = ?");
			params.add(consumidor.getDtnif());
		}
		if (consumidor != null && consumidor.getDtnodir() != null) {
			where.append(" AND t1.DTNODIR = ?");
			params.add(consumidor.getDtnodir());
		}
		if (consumidor != null && consumidor.getDtcolo() != null) {
			where.append(" AND t1.DTCOLO = ?");
			params.add(consumidor.getDtcolo());
		}
		if (consumidor != null && consumidor.getDtnrcopo() != null) {
			where.append(" AND t1.DTNRCOPO = ?");
			params.add(consumidor.getDtnrcopo());
		}
		if (consumidor != null && consumidor.getDtnrtel() != null) {
			where.append(" AND t1.DTNRTEL = ?");
			params.add(consumidor.getDtnrtel());
		}
		if (consumidor != null && consumidor.getDtnrfax() != null) {
			where.append(" AND t1.DTNRFAX = ?");
			params.add(consumidor.getDtnrfax());
		}
		if (consumidor != null && consumidor.getDtcopa() != null) {
			where.append(" AND t1.DTCOPA = ?");
			params.add(consumidor.getDtcopa());
		}
		if (consumidor != null && consumidor.getDtnrdimu() != null) {
			where.append(" AND t1.DTNRDIMU = ?");
			params.add(consumidor.getDtnrdimu());
		}
		if (consumidor != null && consumidor.getDttecoem() != null) {
			where.append(" AND t1.DTTECOEM = ?");
			params.add(consumidor.getDttecoem());
		}
		if (consumidor != null && consumidor.getDtnrtel2() != null) {
			where.append(" AND t1.DTNRTEL2 = ?");
			params.add(consumidor.getDtnrtel2());
		}
		if (consumidor != null && consumidor.getDtnrtel3() != null) {
			where.append(" AND t1.DTNRTEL3 = ?");
			params.add(consumidor.getDtnrtel3());
		}
		if (consumidor != null && consumidor.getDtcoidco() != null) {
			where.append(" AND t1.DTCOIDCO = ?");
			params.add(consumidor.getDtcoidco());
		}
		if (consumidor != null && consumidor.getDtinreco() != null) {
			where.append(" AND t1.DTINRECO = ?");
			params.add(consumidor.getDtinreco());
		}
		if (consumidor != null && consumidor.getDtcoorac() != null) {
			where.append(" AND t1.DTCOORAC = ?");
			params.add(consumidor.getDtcoorac());
		}
		if (consumidor != null && consumidor.getDtnoap1() != null) {
			where.append(" AND t1.DTNOAP1 = ?");
			params.add(consumidor.getDtnoap1());
		}
		if (consumidor != null && consumidor.getDtnoap2() != null) {
			where.append(" AND t1.DTNOAP2 = ?");
			params.add(consumidor.getDtnoap2());
		}
		if (consumidor != null && consumidor.getDtnrsoci() != null) {
			where.append(" AND t1.DTNRSOCI = ?");
			params.add(consumidor.getDtnrsoci());
		}
		if (consumidor != null && consumidor.getDtnran() != null) {
			where.append(" AND t1.DTNRAN = ?");
			params.add(consumidor.getDtnran());
		}
		if (consumidor != null && consumidor.getDtcosx() != null) {
			where.append(" AND t1.DTCOSX = ?");
			params.add(consumidor.getDtcosx());
		}
		if (consumidor != null && consumidor.getDtnorep() != null) {
			where.append(" AND t1.DTNOREP = ?");
			params.add(consumidor.getDtnorep());
		}
		if (consumidor != null && consumidor.getDtnifrep() != null) {
			where.append(" AND t1.DTNIFREP = ?");
			params.add(consumidor.getDtnifrep());
		}
		if (consumidor != null && consumidor.getDtfemod() != null) {
			where.append(" AND t1.DTFEMOD = ?");
			params.add(consumidor.getDtfemod());
		}
		if (consumidor != null && consumidor.getDtnolo() != null) {
			where.append(" AND t1.DTNOLO = ?");
			params.add(consumidor.getDtnolo());
		}
		if (consumidor != null && consumidor.getDtcopv() != null) {
			where.append(" AND t1.DTCOPV = ?");
			params.add(consumidor.getDtcopv());
		}
		if (consumidor != null && consumidor.getDtinrl() != null) {
			where.append(" AND t1.DTINRL = ?");
			params.add(consumidor.getDtinrl());
		}
		if (consumidor != null && consumidor.getDtnodirr() != null) {
			where.append(" AND t1.DTNODIRR = ?");
			params.add(consumidor.getDtnodirr());
		}
		if (consumidor != null && consumidor.getDtcolor() != null) {
			where.append(" AND t1.DTCOLOR = ?");
			params.add(consumidor.getDtcolor());
		}
		if (consumidor != null && consumidor.getDtnrcopor() != null) {
			where.append(" AND t1.DTNRCOPOR = ?");
			params.add(consumidor.getDtnrcopor());
		}
		if (consumidor != null && consumidor.getDtcopvr() != null) {
			where.append(" AND t1.DTCOPVR = ?");
			params.add(consumidor.getDtcopvr());
		}
		if (consumidor != null && consumidor.getDtnrtelr() != null) {
			where.append(" AND t1.DTNRTELR = ?");
			params.add(consumidor.getDtnrtelr());
		}
		if (consumidor != null && consumidor.getDtnrtel2r() != null) {
			where.append(" AND t1.DTNRTEL2R = ?");
			params.add(consumidor.getDtnrtel2r());
		}
		if (consumidor != null && consumidor.getDtnrfaxr() != null) {
			where.append(" AND t1.DTNRFAXR = ?");
			params.add(consumidor.getDtnrfaxr());
		}
		if (consumidor != null && consumidor.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(consumidor.getDtteemr());
		}
		if (consumidor != null && consumidor.getDtintipid() != null) {
			where.append(" AND t1.DTINTIPID = ?");
			params.add(consumidor.getDtintipid());
		}
		if (consumidor != null && consumidor.getDtnoraPaisId() != null) {
			where.append(" AND t1.DTNORA_PAIS_ID = ?");
			params.add(consumidor.getDtnoraPaisId());
		}
		if (consumidor != null && consumidor.getDtnoraPaisNombre() != null) {
			where.append(" AND t1.DTNORA_PAIS_NOMBRE = ?");
			params.add(consumidor.getDtnoraPaisNombre());
		}
		if (consumidor != null && consumidor.getDtnoraProvinciaId() != null) {
			where.append(" AND t1.DTNORA_PROVINCIA_ID = ?");
			params.add(consumidor.getDtnoraProvinciaId());
		}
		if (consumidor != null && consumidor.getDtnombreProvincia() != null) {
			where.append(" AND t1.DTNOMBRE_PROVINCIA = ?");
			params.add(consumidor.getDtnombreProvincia());
		}
		if (consumidor != null && consumidor.getDtnoraMunicipioId() != null) {
			where.append(" AND t1.DTNORA_MUNICIPIO_ID = ?");
			params.add(consumidor.getDtnoraMunicipioId());
		}
		if (consumidor != null && consumidor.getDtnombreMunicipio() != null) {
			where.append(" AND t1.DTNOMBRE_MUNICIPIO = ?");
			params.add(consumidor.getDtnombreMunicipio());
		}
		if (consumidor != null && consumidor.getDtnoraLocalidadId() != null) {
			where.append(" AND t1.DTNORA_LOCALIDAD_ID = ?");
			params.add(consumidor.getDtnoraLocalidadId());
		}
		if (consumidor != null && consumidor.getDtnombreLocalidad() != null) {
			where.append(" AND t1.DTNOMBRE_LOCALIDAD = ?");
			params.add(consumidor.getDtnombreLocalidad());
		}
		if (consumidor != null && consumidor.getDtnoraCalleId() != null) {
			where.append(" AND t1.DTNORA_CALLE_ID = ?");
			params.add(consumidor.getDtnoraCalleId());
		}
		if (consumidor != null && consumidor.getDtnombreCalle() != null) {
			where.append(" AND t1.DTNOMBRE_CALLE = ?");
			params.add(consumidor.getDtnombreCalle());
		}
		if (consumidor != null && consumidor.getDtnoraCpId() != null) {
			where.append(" AND t1.DTNORA_CP_ID = ?");
			params.add(consumidor.getDtnoraCpId());
		}
		if (consumidor != null && consumidor.getDtnombreCp() != null) {
			where.append(" AND t1.DTNOMBRE_CP = ?");
			params.add(consumidor.getDtnombreCp());
		}
		if (consumidor != null && consumidor.getDtnoraPortalId() != null) {
			where.append(" AND t1.DTNORA_PORTAL_ID = ?");
			params.add(consumidor.getDtnoraPortalId());
		}
		if (consumidor != null && consumidor.getDtnombrePortal() != null) {
			where.append(" AND t1.DTNOMBRE_PORTAL = ?");
			params.add(consumidor.getDtnombrePortal());
		}
		if (consumidor != null && consumidor.getDtnombrePiso() != null) {
			where.append(" AND t1.DTNOMBRE_PISO = ?");
			params.add(consumidor.getDtnombrePiso());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	// CHECKSTYLE:OFF
	@Transactional(readOnly = true)
	public List<Consumidor> findAllLike(Consumidor consumidor,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.DTCOZS= t2.MOCODIGO(+) AND t1.DTRANGO_EDAD= t3.RANCOD(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DTCODIGO DTCODIGO,t1.DTNOMBRE DTNOMBRE,t1.DTNIF DTNIF,t1.DTNODIR DTNODIR,t1.DTCOLO DTCOLO,t1.DTNRCOPO DTNRCOPO,t1.DTNRTEL DTNRTEL,t1.DTNRFAX DTNRFAX,t1.DTCOPA DTCOPA,t1.DTNRDIMU DTNRDIMU,t1.DTTECOEM DTTECOEM,t1.DTNRTEL2 DTNRTEL2,t1.DTNRTEL3 DTNRTEL3,t1.DTCOIDCO DTCOIDCO,t1.DTINRECO DTINRECO,t1.DTCOORAC DTCOORAC,t1.DTNOAP1 DTNOAP1,t1.DTNOAP2 DTNOAP2,t1.DTNRSOCI DTNRSOCI,t1.DTNRAN DTNRAN,t1.DTCOSX DTCOSX,t1.DTNOREP DTNOREP,t1.DTNIFREP DTNIFREP,t1.DTFEMOD DTFEMOD,t1.DTNOLO DTNOLO,t1.DTCOPV DTCOPV,t1.DTINRL DTINRL,t1.DTNODIRR DTNODIRR,t1.DTCOLOR DTCOLOR,t1.DTNRCOPOR DTNRCOPOR,t1.DTCOPVR DTCOPVR,t1.DTNRTELR DTNRTELR,t1.DTNRTEL2R DTNRTEL2R,t1.DTNRFAXR DTNRFAXR,t1.DTTEEMR DTTEEMR,t1.DTINTIPID DTINTIPID,t1.DTNORA_PAIS_ID DTNORAPAISID,t1.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE,t1.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID,t1.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA,t1.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID,t1.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO,t1.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID,t1.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD,t1.DTNORA_CALLE_ID DTNORACALLEID,t1.DTNOMBRE_CALLE DTNOMBRECALLE,t1.DTNORA_CP_ID DTNORACPID,t1.DTNOMBRE_CP DTNOMBRECP,t1.DTNORA_PORTAL_ID DTNORAPORTALID,t1.DTNOMBRE_PORTAL DTNOMBREPORTAL,t1.DTNOMBRE_PISO DTNOMBREPISO, t1.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, t1.DTEXTRANJERO DTEXTRANJERO,t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t2.PUESTOXLNET CENSOMONITORPUESTOXLNET, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t3.RANCOD RANGOEDADRANCOD,t3.RANDESC RANGOEDADRANDESC,t2.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM CONSUMIDOR t1 ,CENSO_MONITOR t2 ,RANGO_EDAD t3 ");

		if (consumidor != null && consumidor.getDtcodigo() != null) {
			where.append(" AND UPPER(t1.DTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCODIGO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getCensoMonitor().getMocodigo() + "%");
			} else {
				params.add("%" + consumidor.getCensoMonitor().getMocodigo()
						+ "%");
			}
			where.append(" AND t2.MOCODIGO IS NOT NULL");
		}
		if (consumidor != null
				&& consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getOrganismo() != null
				&& consumidor.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t2.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getCensoMonitor().getOrganismo()
						.getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getCensoMonitor().getOrganismo()
								.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOOR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t2.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getCensoMonitor().getMonombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getCensoMonitor().getMonombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MONOMBRE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t2.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getCensoMonitor().getMocoem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getCensoMonitor().getMocoem()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOEM IS NOT NULL");
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getCensoMonitor().getMofecbaja() + "%");
			} else {
				params.add("%" + consumidor.getCensoMonitor().getMofecbaja()
						+ "%");
			}
			where.append(" AND t2.MOFECBAJA IS NOT NULL");
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			where.append(" AND t3.RANCOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getRangoEdad().getRancod() + "%");
			} else {
				params.add("%" + consumidor.getRangoEdad().getRancod() + "%");
			}
			where.append(" AND t3.RANCOD IS NOT NULL");
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRandesc() != null) {
			where.append(" AND UPPER(t3.RANDESC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getRangoEdad().getRandesc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getRangoEdad().getRandesc().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.RANDESC IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombre() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombre().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOMBRE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnif() != null) {
			where.append(" AND UPPER(t1.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNIF IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnodir() != null) {
			where.append(" AND UPPER(t1.DTNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnodir().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnodir().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNODIR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcolo() != null) {
			where.append(" AND UPPER(t1.DTCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcolo().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcolo().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOLO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrcopo() != null) {
			where.append(" AND UPPER(t1.DTNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRCOPO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrtel() != null) {
			where.append(" AND UPPER(t1.DTNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRTEL IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrfax() != null) {
			where.append(" AND UPPER(t1.DTNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRFAX IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcopa() != null) {
			where.append(" AND UPPER(t1.DTCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcopa().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcopa().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOPA IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrdimu() != null) {
			where.append(" AND UPPER(t1.DTNRDIMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrdimu().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrdimu().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRDIMU IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDttecoem() != null) {
			where.append(" AND UPPER(t1.DTTECOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDttecoem().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDttecoem().toUpperCase() + "%");
			}
			where.append(" AND t1.DTTECOEM IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrtel2() != null) {
			where.append(" AND UPPER(t1.DTNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRTEL2 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrtel3() != null) {
			where.append(" AND UPPER(t1.DTNRTEL3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrtel3().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrtel3().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRTEL3 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcoidco() != null) {
			where.append(" AND UPPER(t1.DTCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcoidco().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcoidco().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOIDCO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtinreco() != null) {
			where.append(" AND UPPER(t1.DTINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtinreco().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtinreco().toUpperCase() + "%");
			}
			where.append(" AND t1.DTINRECO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcoorac() != null) {
			where.append(" AND UPPER(t1.DTCOORAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcoorac().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcoorac().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOORAC IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoap1() != null) {
			where.append(" AND UPPER(t1.DTNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoap1().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoap1().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOAP1 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoap2() != null) {
			where.append(" AND UPPER(t1.DTNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoap2().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoap2().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOAP2 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrsoci() != null) {
			where.append(" AND UPPER(t1.DTNRSOCI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrsoci().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrsoci().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRSOCI IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnran() != null) {
			where.append(" AND UPPER(t1.DTNRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnran().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnran().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRAN IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcosx() != null) {
			where.append(" AND UPPER(t1.DTCOSX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcosx().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcosx().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOSX IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnorep() != null) {
			where.append(" AND UPPER(t1.DTNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnorep().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnorep().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOREP IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnifrep() != null) {
			where.append(" AND UPPER(t1.DTNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnifrep().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNIFREP IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtfemod() != null) {
			where.append(" AND UPPER(t1.DTFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtfemod().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtfemod().toUpperCase() + "%");
			}
			where.append(" AND t1.DTFEMOD IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnolo() != null) {
			where.append(" AND UPPER(t1.DTNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnolo().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnolo().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOLO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcopv() != null) {
			where.append(" AND UPPER(t1.DTCOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcopv().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcopv().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOPV IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtinrl() != null) {
			where.append(" AND UPPER(t1.DTINRL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtinrl().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtinrl().toUpperCase() + "%");
			}
			where.append(" AND t1.DTINRL IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnodirr() != null) {
			where.append(" AND UPPER(t1.DTNODIRR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnodirr().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnodirr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNODIRR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcolor() != null) {
			where.append(" AND UPPER(t1.DTCOLOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcolor().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcolor().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOLOR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrcopor() != null) {
			where.append(" AND UPPER(t1.DTNRCOPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrcopor().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrcopor().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRCOPOR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtcopvr() != null) {
			where.append(" AND UPPER(t1.DTCOPVR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtcopvr().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtcopvr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTCOPVR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrtelr() != null) {
			where.append(" AND UPPER(t1.DTNRTELR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrtelr().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrtelr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRTELR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrtel2r() != null) {
			where.append(" AND UPPER(t1.DTNRTEL2R) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrtel2r().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrtel2r().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRTEL2R IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnrfaxr() != null) {
			where.append(" AND UPPER(t1.DTNRFAXR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnrfaxr().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnrfaxr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNRFAXR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtteemr() != null) {
			where.append(" AND UPPER(t1.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtteemr().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtteemr().toUpperCase() + "%");
			}
			where.append(" AND t1.DTTEEMR IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtintipid() != null) {
			where.append(" AND UPPER(t1.DTINTIPID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtintipid().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtintipid().toUpperCase() + "%");
			}
			where.append(" AND t1.DTINTIPID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraPaisId() != null) {
			where.append(" AND UPPER(t1.DTNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoraPaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNORA_PAIS_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.DTNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoraPaisNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.DTNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraProvinciaId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombreProvincia() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombreProvincia().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.DTNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraMunicipioId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombreMunicipio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.DTNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraLocalidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombreLocalidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraCalleId() != null) {
			where.append(" AND UPPER(t1.DTNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNORA_CALLE_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombreCalle() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNOMBRE_CALLE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraCpId() != null) {
			where.append(" AND UPPER(t1.DTNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNORA_CP_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombreCp() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNOMBRE_CP IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnoraPortalId() != null) {
			where.append(" AND UPPER(t1.DTNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNORA_PORTAL_ID IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombrePortal() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNOMBRE_PORTAL IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnombrePiso() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNOMBRE_PISO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Consumidor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Consumidor> findAllLikeConsumidor(Consumidor consumidor,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.DTCOZS= t2.MOCODIGO(+) AND t1.DTRANGO_EDAD= t3.RANCOD(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DTCODIGO DTCODIGO,t1.DTNOMBRE DTNOMBRE,t1.DTAPELLIDO1 DTAPELLIDO1,t1.DTAPELLIDO2 DTAPELLIDO2,t1.DTNIF DTNIF,t1.DTNODIR DTNODIR,t1.DTCOLO DTCOLO,t1.DTNRCOPO DTNRCOPO,t1.DTNRTEL DTNRTEL,t1.DTNRFAX DTNRFAX,t1.DTCOPA DTCOPA,t1.DTNRDIMU DTNRDIMU,t1.DTTECOEM DTTECOEM,t1.DTNRTEL2 DTNRTEL2,t1.DTNRTEL3 DTNRTEL3,t1.DTCOIDCO DTCOIDCO,t1.DTINRECO DTINRECO,t1.DTCOORAC DTCOORAC,t1.DTNOAP1 DTNOAP1,t1.DTNOAP2 DTNOAP2,t1.DTNRSOCI DTNRSOCI,t1.DTNRAN DTNRAN,t1.DTCOSX DTCOSX,t1.DTNOREP DTNOREP,t1.DTNIFREP DTNIFREP,t1.DTFEMOD DTFEMOD,t1.DTNOLO DTNOLO,t1.DTCOPV DTCOPV,t1.DTINRL DTINRL,t1.DTNODIRR DTNODIRR,t1.DTCOLOR DTCOLOR,t1.DTNRCOPOR DTNRCOPOR,t1.DTCOPVR DTCOPVR,t1.DTNRTELR DTNRTELR,t1.DTNRTEL2R DTNRTEL2R,t1.DTNRFAXR DTNRFAXR,t1.DTTEEMR DTTEEMR,t1.DTINTIPID DTINTIPID,t1.DTNORA_PAIS_ID DTNORAPAISID,t1.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE,t1.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID,t1.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA,t1.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID,t1.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO,t1.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID,t1.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD,t1.DTNORA_CALLE_ID DTNORACALLEID,t1.DTNOMBRE_CALLE DTNOMBRECALLE,t1.DTNORA_CP_ID DTNORACPID,t1.DTNOMBRE_CP DTNOMBRECP,t1.DTNORA_PORTAL_ID DTNORAPORTALID,t1.DTNOMBRE_PORTAL DTNOMBREPORTAL, t1.DTNOMBRE_PISO DTNOMBREPISO, t1.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, t1.DTEXTRANJERO DTEXTRANJERO,t2.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t2.PUESTOXLNET CENSOMONITORPUESTOXLNET, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM, t2.MODNI CENSOMONITORMODNI,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t3.RANCOD RANGOEDADRANCOD,t3.RANDESC RANGOEDADRANDESC,t2.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM CONSUMIDOR t1 ,CENSO_MONITOR t2 ,RANGO_EDAD t3 ");

		if (consumidor != null && consumidor.getDtcodigo() != null) {
			where.append(" AND t1.DTCODIGO = ?");
			params.add(consumidor.getDtcodigo());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(consumidor.getCensoMonitor().getMocodigo());
		}
		if (consumidor != null
				&& consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getOrganismo() != null
				&& consumidor.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(consumidor.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(consumidor.getCensoMonitor().getMonombre());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(consumidor.getCensoMonitor().getMocoem());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(consumidor.getCensoMonitor().getMofecbaja());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			where.append(" AND t3.RANCOD = ?");
			params.add(consumidor.getRangoEdad().getRancod());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRandesc() != null) {
			where.append(" AND t3.RANDESC = ?");
			params.add(consumidor.getRangoEdad().getRandesc());
		}
		if (consumidor != null && consumidor.getDtnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTNOMBRE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtapellido1() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtapellido1().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtapellido1().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTAPELLIDO1 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtapellido2() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtapellido2().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtapellido2().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTAPELLIDO2 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnif() != null) {
			where.append(" AND UPPER(t1.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNIF IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnodir() != null) {
			where.append(" AND t1.DTNODIR = ?");
			params.add(consumidor.getDtnodir());
		}
		if (consumidor != null && consumidor.getDtcolo() != null) {
			where.append(" AND t1.DTCOLO = ?");
			params.add(consumidor.getDtcolo());
		}
		if (consumidor != null && consumidor.getDtnrcopo() != null) {
			where.append(" AND t1.DTNRCOPO = ?");
			params.add(consumidor.getDtnrcopo());
		}
		if (consumidor != null && consumidor.getDtnrtel() != null) {
			where.append(" AND t1.DTNRTEL = ?");
			params.add(consumidor.getDtnrtel());
		}
		if (consumidor != null && consumidor.getDtnrfax() != null) {
			where.append(" AND t1.DTNRFAX = ?");
			params.add(consumidor.getDtnrfax());
		}
		if (consumidor != null && consumidor.getDtcopa() != null) {
			where.append(" AND t1.DTCOPA = ?");
			params.add(consumidor.getDtcopa());
		}
		if (consumidor != null && consumidor.getDtnrdimu() != null) {
			where.append(" AND t1.DTNRDIMU = ?");
			params.add(consumidor.getDtnrdimu());
		}
		if (consumidor != null && consumidor.getDttecoem() != null) {
			where.append(" AND t1.DTTECOEM = ?");
			params.add(consumidor.getDttecoem());
		}
		if (consumidor != null && consumidor.getDtnrtel2() != null) {
			where.append(" AND t1.DTNRTEL2 = ?");
			params.add(consumidor.getDtnrtel2());
		}
		if (consumidor != null && consumidor.getDtnrtel3() != null) {
			where.append(" AND t1.DTNRTEL3 = ?");
			params.add(consumidor.getDtnrtel3());
		}
		if (consumidor != null && consumidor.getDtcoidco() != null) {
			where.append(" AND t1.DTCOIDCO = ?");
			params.add(consumidor.getDtcoidco());
		}
		if (consumidor != null && consumidor.getDtinreco() != null) {
			where.append(" AND t1.DTINRECO = ?");
			params.add(consumidor.getDtinreco());
		}
		if (consumidor != null && consumidor.getDtcoorac() != null) {
			where.append(" AND t1.DTCOORAC = ?");
			params.add(consumidor.getDtcoorac());
		}
		if (consumidor != null && consumidor.getDtnoap1() != null) {
			where.append(" AND t1.DTNOAP1 = ?");
			params.add(consumidor.getDtnoap1());
		}
		if (consumidor != null && consumidor.getDtnoap2() != null) {
			where.append(" AND t1.DTNOAP2 = ?");
			params.add(consumidor.getDtnoap2());
		}
		if (consumidor != null && consumidor.getDtnrsoci() != null) {
			where.append(" AND t1.DTNRSOCI = ?");
			params.add(consumidor.getDtnrsoci());
		}
		if (consumidor != null && consumidor.getDtnran() != null) {
			where.append(" AND t1.DTNRAN = ?");
			params.add(consumidor.getDtnran());
		}
		if (consumidor != null && consumidor.getDtcosx() != null) {
			where.append(" AND t1.DTCOSX = ?");
			params.add(consumidor.getDtcosx());
		}
		if (consumidor != null && consumidor.getDtnorep() != null) {
			where.append(" AND t1.DTNOREP = ?");
			params.add(consumidor.getDtnorep());
		}
		if (consumidor != null && consumidor.getDtnifrep() != null) {
			where.append(" AND t1.DTNIFREP = ?");
			params.add(consumidor.getDtnifrep());
		}
		if (consumidor != null && consumidor.getDtfemod() != null) {
			where.append(" AND t1.DTFEMOD = ?");
			params.add(consumidor.getDtfemod());
		}
		if (consumidor != null && consumidor.getDtnolo() != null) {
			where.append(" AND t1.DTNOLO = ?");
			params.add(consumidor.getDtnolo());
		}
		if (consumidor != null && consumidor.getDtcopv() != null) {
			where.append(" AND t1.DTCOPV = ?");
			params.add(consumidor.getDtcopv());
		}
		if (consumidor != null && consumidor.getDtinrl() != null) {
			where.append(" AND t1.DTINRL = ?");
			params.add(consumidor.getDtinrl());
		}
		if (consumidor != null && consumidor.getDtnodirr() != null) {
			where.append(" AND t1.DTNODIRR = ?");
			params.add(consumidor.getDtnodirr());
		}
		if (consumidor != null && consumidor.getDtcolor() != null) {
			where.append(" AND t1.DTCOLOR = ?");
			params.add(consumidor.getDtcolor());
		}
		if (consumidor != null && consumidor.getDtnrcopor() != null) {
			where.append(" AND t1.DTNRCOPOR = ?");
			params.add(consumidor.getDtnrcopor());
		}
		if (consumidor != null && consumidor.getDtcopvr() != null) {
			where.append(" AND t1.DTCOPVR = ?");
			params.add(consumidor.getDtcopvr());
		}
		if (consumidor != null && consumidor.getDtnrtelr() != null) {
			where.append(" AND t1.DTNRTELR = ?");
			params.add(consumidor.getDtnrtelr());
		}
		if (consumidor != null && consumidor.getDtnrtel2r() != null) {
			where.append(" AND t1.DTNRTEL2R = ?");
			params.add(consumidor.getDtnrtel2r());
		}
		if (consumidor != null && consumidor.getDtnrfaxr() != null) {
			where.append(" AND t1.DTNRFAXR = ?");
			params.add(consumidor.getDtnrfaxr());
		}
		if (consumidor != null && consumidor.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(consumidor.getDtteemr());
		}
		if (consumidor != null && consumidor.getDtintipid() != null) {
			where.append(" AND t1.DTINTIPID = ?");
			params.add(consumidor.getDtintipid());
		}
		if (consumidor != null && consumidor.getDtnoraPaisId() != null) {
			where.append(" AND t1.DTNORA_PAIS_ID = ?");
			params.add(consumidor.getDtnoraPaisId());
		}
		if (consumidor != null && consumidor.getDtnoraPaisNombre() != null) {
			where.append(" AND t1.DTNORA_PAIS_NOMBRE = ?");
			params.add(consumidor.getDtnoraPaisNombre());
		}
		if (consumidor != null && consumidor.getDtnoraProvinciaId() != null) {
			where.append(" AND t1.DTNORA_PROVINCIA_ID = ?");
			params.add(consumidor.getDtnoraProvinciaId());
		}
		if (consumidor != null && consumidor.getDtnombreProvincia() != null) {
			where.append(" AND t1.DTNOMBRE_PROVINCIA = ?");
			params.add(consumidor.getDtnombreProvincia());
		}
		if (consumidor != null && consumidor.getDtnoraMunicipioId() != null) {
			where.append(" AND t1.DTNORA_MUNICIPIO_ID = ?");
			params.add(consumidor.getDtnoraMunicipioId());
		}
		if (consumidor != null && consumidor.getDtnombreMunicipio() != null) {
			where.append(" AND t1.DTNOMBRE_MUNICIPIO = ?");
			params.add(consumidor.getDtnombreMunicipio());
		}
		if (consumidor != null && consumidor.getDtnoraLocalidadId() != null) {
			where.append(" AND t1.DTNORA_LOCALIDAD_ID = ?");
			params.add(consumidor.getDtnoraLocalidadId());
		}
		if (consumidor != null && consumidor.getDtnombreLocalidad() != null) {
			where.append(" AND t1.DTNOMBRE_LOCALIDAD = ?");
			params.add(consumidor.getDtnombreLocalidad());
		}
		if (consumidor != null && consumidor.getDtnoraCalleId() != null) {
			where.append(" AND t1.DTNORA_CALLE_ID = ?");
			params.add(consumidor.getDtnoraCalleId());
		}
		if (consumidor != null && consumidor.getDtnombreCalle() != null) {
			where.append(" AND t1.DTNOMBRE_CALLE = ?");
			params.add(consumidor.getDtnombreCalle());
		}
		if (consumidor != null && consumidor.getDtnoraCpId() != null) {
			where.append(" AND t1.DTNORA_CP_ID = ?");
			params.add(consumidor.getDtnoraCpId());
		}
		if (consumidor != null && consumidor.getDtnombreCp() != null) {
			where.append(" AND t1.DTNOMBRE_CP = ?");
			params.add(consumidor.getDtnombreCp());
		}
		if (consumidor != null && consumidor.getDtnoraPortalId() != null) {
			where.append(" AND t1.DTNORA_PORTAL_ID = ?");
			params.add(consumidor.getDtnoraPortalId());
		}
		if (consumidor != null && consumidor.getDtnombrePortal() != null) {
			where.append(" AND t1.DTNOMBRE_PORTAL = ?");
			params.add(consumidor.getDtnombrePortal());
		}
		if (consumidor != null && consumidor.getDtnombrePiso() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNOMBRE_PISO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtdireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtdireccion_nocapv().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtdireccion_nocapv().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTDIRECCION_NOCAPV IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtextranjero() != null
				&& consumidor.getDtestado() == null) {
			where.append(" AND t1.DTEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (consumidor != null && consumidor.getDtestado() != null
				&& consumidor.getDtextranjero() == null) {
			where.append(" AND t1.DTEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Consumidor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeConsumidorCount(Consumidor consumidor,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.DTCOZS= t2.MOCODIGO(+) and t1.DTRANGO_EDAD= t3.RANCOD(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CONSUMIDOR t1   ,  CENSO_MONITOR t2   ,  RANGO_EDAD t3  ");

		if (consumidor != null && consumidor.getDtcodigo() != null) {
			where.append(" AND t1.DTCODIGO = ?");
			params.add(consumidor.getDtcodigo());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(consumidor.getCensoMonitor().getMocodigo());
		}
		if (consumidor != null
				&& consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getOrganismo() != null
				&& consumidor.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(consumidor.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(consumidor.getCensoMonitor().getMonombre());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(consumidor.getCensoMonitor().getMocoem());
		}
		if (consumidor != null && consumidor.getCensoMonitor() != null
				&& consumidor.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(consumidor.getCensoMonitor().getMofecbaja());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRancod() != null) {
			where.append(" AND t3.RANCOD = ?");
			params.add(consumidor.getRangoEdad().getRancod());
		}
		if (consumidor != null && consumidor.getRangoEdad() != null
				&& consumidor.getRangoEdad().getRandesc() != null) {
			where.append(" AND t3.RANDESC = ?");
			params.add(consumidor.getRangoEdad().getRandesc());
		}
		if (consumidor != null && consumidor.getDtnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtnombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTNOMBRE IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtapellido1() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtapellido1().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtapellido1().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTAPELLIDO1 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtapellido2() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtapellido2().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtapellido2().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTAPELLIDO2 IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnif() != null) {
			where.append(" AND UPPER(t1.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t1.DTNIF IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtnodir() != null) {
			where.append(" AND t1.DTNODIR = ?");
			params.add(consumidor.getDtnodir());
		}
		if (consumidor != null && consumidor.getDtcolo() != null) {
			where.append(" AND t1.DTCOLO = ?");
			params.add(consumidor.getDtcolo());
		}
		if (consumidor != null && consumidor.getDtnrcopo() != null) {
			where.append(" AND t1.DTNRCOPO = ?");
			params.add(consumidor.getDtnrcopo());
		}
		if (consumidor != null && consumidor.getDtnrtel() != null) {
			where.append(" AND t1.DTNRTEL = ?");
			params.add(consumidor.getDtnrtel());
		}
		if (consumidor != null && consumidor.getDtnrfax() != null) {
			where.append(" AND t1.DTNRFAX = ?");
			params.add(consumidor.getDtnrfax());
		}
		if (consumidor != null && consumidor.getDtcopa() != null) {
			where.append(" AND t1.DTCOPA = ?");
			params.add(consumidor.getDtcopa());
		}
		if (consumidor != null && consumidor.getDtnrdimu() != null) {
			where.append(" AND t1.DTNRDIMU = ?");
			params.add(consumidor.getDtnrdimu());
		}
		if (consumidor != null && consumidor.getDttecoem() != null) {
			where.append(" AND t1.DTTECOEM = ?");
			params.add(consumidor.getDttecoem());
		}
		if (consumidor != null && consumidor.getDtnrtel2() != null) {
			where.append(" AND t1.DTNRTEL2 = ?");
			params.add(consumidor.getDtnrtel2());
		}
		if (consumidor != null && consumidor.getDtnrtel3() != null) {
			where.append(" AND t1.DTNRTEL3 = ?");
			params.add(consumidor.getDtnrtel3());
		}
		if (consumidor != null && consumidor.getDtcoidco() != null) {
			where.append(" AND t1.DTCOIDCO = ?");
			params.add(consumidor.getDtcoidco());
		}
		if (consumidor != null && consumidor.getDtinreco() != null) {
			where.append(" AND t1.DTINRECO = ?");
			params.add(consumidor.getDtinreco());
		}
		if (consumidor != null && consumidor.getDtcoorac() != null) {
			where.append(" AND t1.DTCOORAC = ?");
			params.add(consumidor.getDtcoorac());
		}
		if (consumidor != null && consumidor.getDtnoap1() != null) {
			where.append(" AND t1.DTNOAP1 = ?");
			params.add(consumidor.getDtnoap1());
		}
		if (consumidor != null && consumidor.getDtnoap2() != null) {
			where.append(" AND t1.DTNOAP2 = ?");
			params.add(consumidor.getDtnoap2());
		}
		if (consumidor != null && consumidor.getDtnrsoci() != null) {
			where.append(" AND t1.DTNRSOCI = ?");
			params.add(consumidor.getDtnrsoci());
		}
		if (consumidor != null && consumidor.getDtnran() != null) {
			where.append(" AND t1.DTNRAN = ?");
			params.add(consumidor.getDtnran());
		}
		if (consumidor != null && consumidor.getDtcosx() != null) {
			where.append(" AND t1.DTCOSX = ?");
			params.add(consumidor.getDtcosx());
		}
		if (consumidor != null && consumidor.getDtnorep() != null) {
			where.append(" AND t1.DTNOREP = ?");
			params.add(consumidor.getDtnorep());
		}
		if (consumidor != null && consumidor.getDtnifrep() != null) {
			where.append(" AND t1.DTNIFREP = ?");
			params.add(consumidor.getDtnifrep());
		}
		if (consumidor != null && consumidor.getDtfemod() != null) {
			where.append(" AND t1.DTFEMOD = ?");
			params.add(consumidor.getDtfemod());
		}
		if (consumidor != null && consumidor.getDtnolo() != null) {
			where.append(" AND t1.DTNOLO = ?");
			params.add(consumidor.getDtnolo());
		}
		if (consumidor != null && consumidor.getDtcopv() != null) {
			where.append(" AND t1.DTCOPV = ?");
			params.add(consumidor.getDtcopv());
		}
		if (consumidor != null && consumidor.getDtinrl() != null) {
			where.append(" AND t1.DTINRL = ?");
			params.add(consumidor.getDtinrl());
		}
		if (consumidor != null && consumidor.getDtnodirr() != null) {
			where.append(" AND t1.DTNODIRR = ?");
			params.add(consumidor.getDtnodirr());
		}
		if (consumidor != null && consumidor.getDtcolor() != null) {
			where.append(" AND t1.DTCOLOR = ?");
			params.add(consumidor.getDtcolor());
		}
		if (consumidor != null && consumidor.getDtnrcopor() != null) {
			where.append(" AND t1.DTNRCOPOR = ?");
			params.add(consumidor.getDtnrcopor());
		}
		if (consumidor != null && consumidor.getDtcopvr() != null) {
			where.append(" AND t1.DTCOPVR = ?");
			params.add(consumidor.getDtcopvr());
		}
		if (consumidor != null && consumidor.getDtnrtelr() != null) {
			where.append(" AND t1.DTNRTELR = ?");
			params.add(consumidor.getDtnrtelr());
		}
		if (consumidor != null && consumidor.getDtnrtel2r() != null) {
			where.append(" AND t1.DTNRTEL2R = ?");
			params.add(consumidor.getDtnrtel2r());
		}
		if (consumidor != null && consumidor.getDtnrfaxr() != null) {
			where.append(" AND t1.DTNRFAXR = ?");
			params.add(consumidor.getDtnrfaxr());
		}
		if (consumidor != null && consumidor.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(consumidor.getDtteemr());
		}
		if (consumidor != null && consumidor.getDtintipid() != null) {
			where.append(" AND t1.DTINTIPID = ?");
			params.add(consumidor.getDtintipid());
		}
		if (consumidor != null && consumidor.getDtnoraPaisId() != null) {
			where.append(" AND t1.DTNORA_PAIS_ID = ?");
			params.add(consumidor.getDtnoraPaisId());
		}
		if (consumidor != null && consumidor.getDtnoraPaisNombre() != null) {
			where.append(" AND t1.DTNORA_PAIS_NOMBRE = ?");
			params.add(consumidor.getDtnoraPaisNombre());
		}
		if (consumidor != null && consumidor.getDtnoraProvinciaId() != null) {
			where.append(" AND t1.DTNORA_PROVINCIA_ID = ?");
			params.add(consumidor.getDtnoraProvinciaId());
		}
		if (consumidor != null && consumidor.getDtnombreProvincia() != null) {
			where.append(" AND t1.DTNOMBRE_PROVINCIA = ?");
			params.add(consumidor.getDtnombreProvincia());
		}
		if (consumidor != null && consumidor.getDtnoraMunicipioId() != null) {
			where.append(" AND t1.DTNORA_MUNICIPIO_ID = ?");
			params.add(consumidor.getDtnoraMunicipioId());
		}
		if (consumidor != null && consumidor.getDtnombreMunicipio() != null) {
			where.append(" AND t1.DTNOMBRE_MUNICIPIO = ?");
			params.add(consumidor.getDtnombreMunicipio());
		}
		if (consumidor != null && consumidor.getDtnoraLocalidadId() != null) {
			where.append(" AND t1.DTNORA_LOCALIDAD_ID = ?");
			params.add(consumidor.getDtnoraLocalidadId());
		}
		if (consumidor != null && consumidor.getDtnombreLocalidad() != null) {
			where.append(" AND t1.DTNOMBRE_LOCALIDAD = ?");
			params.add(consumidor.getDtnombreLocalidad());
		}
		if (consumidor != null && consumidor.getDtnoraCalleId() != null) {
			where.append(" AND t1.DTNORA_CALLE_ID = ?");
			params.add(consumidor.getDtnoraCalleId());
		}
		if (consumidor != null && consumidor.getDtnombreCalle() != null) {
			where.append(" AND t1.DTNOMBRE_CALLE = ?");
			params.add(consumidor.getDtnombreCalle());
		}
		if (consumidor != null && consumidor.getDtnoraCpId() != null) {
			where.append(" AND t1.DTNORA_CP_ID = ?");
			params.add(consumidor.getDtnoraCpId());
		}
		if (consumidor != null && consumidor.getDtnombreCp() != null) {
			where.append(" AND t1.DTNOMBRE_CP = ?");
			params.add(consumidor.getDtnombreCp());
		}
		if (consumidor != null && consumidor.getDtnoraPortalId() != null) {
			where.append(" AND t1.DTNORA_PORTAL_ID = ?");
			params.add(consumidor.getDtnoraPortalId());
		}
		if (consumidor != null && consumidor.getDtnombrePortal() != null) {
			where.append(" AND t1.DTNOMBRE_PORTAL = ?");
			params.add(consumidor.getDtnombrePortal());
		}
		if (consumidor != null && consumidor.getDtnombrePiso() != null) {
			where.append(" AND UPPER(t1.DTNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + consumidor.getDtnombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTNOMBRE_PISO IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtdireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidor.getDtdireccion_nocapv().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ consumidor.getDtdireccion_nocapv().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DTDIRECCION_NOCAPV IS NOT NULL");
		}
		if (consumidor != null && consumidor.getDtextranjero() != null
				&& consumidor.getDtestado() == null) {
			where.append(" AND t1.DTEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (consumidor != null && consumidor.getDtestado() != null
				&& consumidor.getDtextranjero() == null) {
			where.append(" AND t1.DTEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
