package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.SolicitudDetalle;

/**
 * * ConsumidorDao  
 * 
 *  
 */

public interface ConsumidorDao {

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor add(Consumidor consumidor);

	/**
	 * Inserts a single row in the Consumidor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarConsumidorTelematico(SolicitudDetalle solicitudDetalle);

	/**
	 * Update a single row in the Consumidor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void actualizarConsumidorTelematico(SolicitudDetalle solicitudDetalle);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeConsumidorTelematico(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor update(Consumidor consumidor);

	/**
	 * Updates a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Pagination
	 * @return Consumidor
	 */
	public Consumidor updateNombreApellidos(Consumidor consumidor);

	/**
	 * Update a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 */
	public void updateConsumidorTelematico(Consumidor consumidor);

	/**
	 * Finds a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	Consumidor find(Consumidor consumidor);

	/**
	 * Deletes a single row in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return
	 */
	void remove(Consumidor consumidor);

	/**
	 * Finds a List of rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Consumidor> findAll(Consumidor consumidor, Pagination pagination);

	/**
	 * Counts rows in the Consumidor table.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return List
	 */
	Long findAllCount(Consumidor consumidor);

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consumidor> findAllLike(Consumidor consumidor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consumidor> findAllLikeConsumidor(Consumidor consumidor,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Consumidor table using like.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return List
	 */
	Long findAllLikeConsumidorCount(Consumidor consumidor, Boolean startsWith);

}
