package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ConsumidorArbitra;

/**
 * ConsumidorArbitraDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ConsumidorArbitraDaoImpl implements ConsumidorArbitraDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ConsumidorArbitra> rwMap = new RowMapper<ConsumidorArbitra>() {
		public ConsumidorArbitra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ConsumidorArbitra(resultSet.getString("M9CODT"),
					resultSet.getString("M9COSA"),
					resultSet.getString("M9INREDT"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            Pagination
	 * @return ConsumidorArbitra
	 */
	public ConsumidorArbitra add(ConsumidorArbitra consumidorarbitra) {
		String query = "INSERT INTO CONSUMIDOR_ARBITRA (M9CODT, M9COSA, M9INREDT) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, consumidorarbitra.getM9codt(),
				consumidorarbitra.getM9cosa(), consumidorarbitra.getM9inredt());
		return consumidorarbitra;
	}

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            Pagination
	 * @return ConsumidorArbitra
	 */
	public ConsumidorArbitra update(ConsumidorArbitra consumidorarbitra) {
		String query = "UPDATE CONSUMIDOR_ARBITRA SET  WHERE M9CODT=? AND M9COSA=? AND M9INREDT=?";
		this.jdbcTemplate.update(query, consumidorarbitra.getM9codt(),
				consumidorarbitra.getM9cosa(), consumidorarbitra.getM9inredt());
		return consumidorarbitra;
	}

	/**
	 * Finds a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            Pagination
	 * @return ConsumidorArbitra
	 */
	@Transactional(readOnly = true)
	public ConsumidorArbitra find(ConsumidorArbitra consumidorarbitra) {
		String query = "SELECT t1.M9CODT M9CODT, t1.M9COSA M9COSA, t1.M9INREDT M9INREDT FROM CONSUMIDOR_ARBITRA t1  WHERE t1.M9CODT = ?   AND t1.M9COSA = ?   AND t1.M9INREDT = ?  ";

		List<ConsumidorArbitra> consumidorarbitraList = this.jdbcTemplate
				.query(query, this.rwMap, consumidorarbitra.getM9codt(),
						consumidorarbitra.getM9cosa(),
						consumidorarbitra.getM9inredt());
		return (ConsumidorArbitra) DataAccessUtils
				.uniqueResult(consumidorarbitraList);
	}

	/**
	 * Removes a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            Pagination
	 * @return
	 */
	public void remove(ConsumidorArbitra consumidorarbitra) {
		String query = "DELETE FROM CONSUMIDOR_ARBITRA WHERE M9CODT=? AND M9COSA=? AND M9INREDT=?";
		this.jdbcTemplate.update(query, consumidorarbitra.getM9codt(),
				consumidorarbitra.getM9cosa(), consumidorarbitra.getM9inredt());
	}

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 * 
	 * @param escodigoBueno
	 *            String
	 * @param escodigoAfusionar
	 *            String
	 * @return
	 */
	public void updateConsumidor(String escodigoBueno, String escodigoAfusionar) {
		try {
			String query = "UPDATE CONSUMIDOR_ARBITRA SET M9CODT=? WHERE M9CODT=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Finds a List of rows in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsumidorArbitra> findAll(ConsumidorArbitra consumidorarbitra,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M9CODT M9CODT,t1.M9COSA M9COSA,t1.M9INREDT M9INREDT ");
		query.append("FROM CONSUMIDOR_ARBITRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(consumidorarbitra);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ConsumidorArbitra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ConsumidorArbitra consumidorarbitra) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CONSUMIDOR_ARBITRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(consumidorarbitra);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ConsumidorArbitra table using like.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsumidorArbitra> findAllLike(
			ConsumidorArbitra consumidorarbitra, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M9CODT M9CODT,t1.M9COSA M9COSA,t1.M9INREDT M9INREDT ");
		query.append("FROM CONSUMIDOR_ARBITRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(consumidorarbitra,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ConsumidorArbitra>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ConsumidorArbitra table using like.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ConsumidorArbitra consumidorarbitra,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CONSUMIDOR_ARBITRA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(consumidorarbitra,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ConsumidorArbitra entity
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ConsumidorArbitra consumidorarbitra) {

		StringBuilder where = new StringBuilder(
				ConsumidorArbitraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (consumidorarbitra != null && consumidorarbitra.getM9codt() != null) {
			where.append(" AND t1.M9CODT = ?");
			params.add(consumidorarbitra.getM9codt());
		}
		if (consumidorarbitra != null && consumidorarbitra.getM9cosa() != null) {
			where.append(" AND t1.M9COSA = ?");
			params.add(consumidorarbitra.getM9cosa());
		}
		if (consumidorarbitra != null
				&& consumidorarbitra.getM9inredt() != null) {
			where.append(" AND t1.M9INREDT = ?");
			params.add(consumidorarbitra.getM9inredt());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ConsumidorArbitra entity
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(ConsumidorArbitra consumidorarbitra,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ConsumidorArbitraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (consumidorarbitra != null && consumidorarbitra.getM9codt() != null) {
			where.append(" AND UPPER(t1.M9CODT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidorarbitra.getM9codt().toUpperCase() + "%");
			} else {
				params.add("%" + consumidorarbitra.getM9codt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M9CODT IS NOT NULL");
		}
		if (consumidorarbitra != null && consumidorarbitra.getM9cosa() != null) {
			where.append(" AND UPPER(t1.M9COSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidorarbitra.getM9cosa().toUpperCase() + "%");
			} else {
				params.add("%" + consumidorarbitra.getM9cosa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M9COSA IS NOT NULL");
		}
		if (consumidorarbitra != null
				&& consumidorarbitra.getM9inredt() != null) {
			where.append(" AND UPPER(t1.M9INREDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consumidorarbitra.getM9inredt().toUpperCase() + "%");
			} else {
				params.add("%" + consumidorarbitra.getM9inredt().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M9INREDT IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
