package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ConsumidorArbitra;

/**
 * ConsumidorArbitraDao  
 * 
 *  
 */

public interface ConsumidorArbitraDao {

	/**
	 * Inserts a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	ConsumidorArbitra add(ConsumidorArbitra consumidorarbitra);

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	ConsumidorArbitra update(ConsumidorArbitra consumidorarbitra);

	/**
	 * Updates a single row in the ConsumidorArbitra table.
	 * 
	 * @param escodigoBueno
	 *            String
	 * @param escodigoAfusionar
	 *            String * @return
	 */
	void updateConsumidor(String escodigoBueno, String escodigoAfusionar);

	/**
	 * Finds a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return ConsumidorArbitra
	 */
	ConsumidorArbitra find(ConsumidorArbitra consumidorarbitra);

	/**
	 * Deletes a single row in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return
	 */
	void remove(ConsumidorArbitra consumidorarbitra);

	/**
	 * Finds a List of rows in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsumidorArbitra> findAll(ConsumidorArbitra consumidorarbitra,
			Pagination pagination);

	/**
	 * Counts rows in the ConsumidorArbitra table.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @return Long
	 */
	Long findAllCount(ConsumidorArbitra consumidorarbitra);

	/**
	 * Finds rows in the ConsumidorArbitra table using like.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ConsumidorArbitra> findAllLike(ConsumidorArbitra consumidorarbitra,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the ConsumidorArbitra table using like.
	 * 
	 * @param consumidorarbitra
	 *            ConsumidorArbitra
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ConsumidorArbitra consumidorarbitra,
			Boolean startsWith);
}
