package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.ConsultaFile;

/**
 * * ConsultaFileDao  
 * 
 *  
 */

public interface ConsultaFileDao {

	/**
	 * Inserts a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile add(ConsultaFile consultafile);

	/**
	 * Updates a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile update(ConsultaFile consultafile);

	/**
	 * Finds a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return ConsultaFile
	 */
	ConsultaFile find(ConsultaFile consultafile);

	/**
	 * Deletes a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return
	 */
	void remove(ConsultaFile consultafile);

	/**
	 * Removes a single row in the ConsultaFile table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void removeConsultaFileConsulta(Consulta consulta);

	/**
	 * Finds a List of rows in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsultaFile> findAll(ConsultaFile consultafile, Pagination pagination);

	/**
	 * Counts rows in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return List
	 */
	Long findAllCount(ConsultaFile consultafile);

	/**
	 * Finds rows in the ConsultaFile table using like.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ConsultaFile> findAllLike(ConsultaFile consultafile,
			Pagination pagination, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();
}
