// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.DocumentoConsultaDetalle;
import com.ejie.y41b.model.EstadisticasConsultasResultado;
import com.ejie.y41b.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41b.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41b.model.EstadisticasKontsumonetResultado;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.ListadoConsultaResultado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.RangoEdad;

/**
 * * ConsultaDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class ConsultaDaoImpl implements ConsultaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Consulta> rwMap = new RowMapper<Consulta>() {
		public Consulta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Consulta(resultSet.getString("COCODIGO"),
					new Motivo(resultSet.getString("MotivoTIRCODIGO"), resultSet.getString("MotivoTIRNOMBRE"), null),
					new Producto(resultSet.getString("ProductoPSCODIGO"), resultSet.getString("ProductoPSNOMBRE"),
							resultSet.getString("ProductoPSNOCO"), resultSet.getString("ProductoPSDESCRI"),
							resultSet.getString("ProductoPSCOSE"), resultSet.getString("ProductoPSNOMBREE"),
							resultSet.getString("ProductoPSNOMBREI"), resultSet.getString("ProductoPSNOMBREF"),
							resultSet.getString("ProductoPSNOMBREA"), resultSet.getString("ProductoPSNOCOE"),
							resultSet.getString("ProductoPSNOCOI"), resultSet.getString("ProductoPSNOCOF"),
							resultSet.getString("ProductoPSNOCOA"), resultSet.getString("ProductoPSDESCRIE"),
							resultSet.getString("ProductoPSDESCRII"), resultSet.getString("ProductoPSDESCRIF"),
							resultSet.getString("ProductoPSDESCRIA"), resultSet.getString("ProductoPSSEL1"),
							resultSet.getString("ProductoPSCOINC"),
							new ProdAgrupado(resultSet.getString("ProductoPSCOE8"), null, null)),
					new RangoEdad(resultSet.getString("RangoEdadRANCOD"), resultSet.getString("RangoEdadRANDESC")),
					new FormaPresentacion(resultSet.getString("FormaPresentacionTFPCODIGO"),
							resultSet.getString("FormaPresentacionTFPNOMBRE"),
							resultSet.getString("FormaPresentacionTFPNOMBREE"),
							resultSet.getString("FormaPresentacionTFPNOMBREI"),
							resultSet.getString("FormaPresentacionTFPNOMBREF"),
							resultSet.getString("FormaPresentacionTFPNOMBREA"),
							resultSet.getString("FormaPresenTFPCONSULTAS"),
							resultSet.getString("FormaPresenTFPSOLICITUDES"),
							resultSet.getString("FormaPresenTFPARBITRAJES")),
					new Organismo(resultSet.getString("OrganismoCODORG"), resultSet.getString("OrganismoENTIDADID"),
							resultSet.getString("OrganismoNOMBREES"), resultSet.getString("OrganismoNOMBREEU"),
							resultSet.getString("OrganismoACTIVA"), resultSet.getString("OrganismoISKONTSUMOGEST"),
							resultSet.getString("OrganismoISKONTSUMONET"), resultSet.getString("OrganismoISOFERTAFORM"),
							resultSet.getString("OrganismoISCONSULTASWEB"), resultSet.getString("OrganismoISNACIONAL"),
							resultSet.getString("OrganismoOBSERVACIONES"), resultSet.getString("OrganismoTELEFONO"),
							resultSet.getString("OrganismoFAX"), resultSet.getString("OrganismoEMAIL"),
							resultSet.getString("OrganismoURL"), resultSet.getString("OrganismoUSUARIO"),
							resultSet.getString("OrganismoPASSWORD"), resultSet.getString("OrganismoNORAPAISID"),
							resultSet.getString("OrganismoNOMBREPAIS"), resultSet.getString("OrganismoNORAPROVINCIAID"),
							resultSet.getString("OrganismoNOMBREPROVINCIA"),
							resultSet.getString("OrganismoNORAMUNICIPIOID"),
							resultSet.getString("OrganismoNOMBREMUNICIPIO"),
							resultSet.getString("OrganismoNORALOCALIDADID"),
							resultSet.getString("OrganismoNOMBRELOCALIDAD"),
							resultSet.getString("OrganismoNORACALLEID"), resultSet.getString("OrganismoNOMBRECALLE"),
							resultSet.getString("OrganismoNORACPID"), resultSet.getString("OrganismoNOMBRECP"),
							resultSet.getString("OrganismoNORAPORTALID"), resultSet.getString("OrganismoNOMBREPORTAL"),
							resultSet.getString("OrganismoUSUULTMOD"), resultSet.getDate("OrganismoFECULTMOD")),
					new CensoMonitor(resultSet.getString("CensoMonitorMOCODIGO"),
							resultSet.getString("CensoMonitorMONOMBRE"), resultSet.getString("CensoMonitorMOCOEM"),
							resultSet.getString("CensoMonitorMODNI"), resultSet.getString("CensoMonitorUSUARIOXLNET"),
							resultSet.getString("CensoMonitorPUESTOXLNET"), resultSet.getDate("CensoMonitorMOFECBAJA"),
							new Organismo(resultSet.getString("CensoMonitorMOCOOR")), null, null, null, null, null,
							null, null, null, null, null, null, null, null, null),
					resultSet.getDate("COFECHA"), resultSet.getString("COCOSX"), resultSet.getString("CONRAN"),
					resultSet.getString("COCOSE"), resultSet.getString("COTEXTO"), resultSet.getInt("CONRREG"),
					resultSet.getString("CONOCO"), resultSet.getString("CONODIRCO"), resultSet.getString("CONRCPCO"),
					resultSet.getString("COCOLOCO"), resultSet.getString("CONOLOCO"), resultSet.getString("CONOMUCO"),
					resultSet.getString("COCOPVCO"), resultSet.getString("COCOPACO"), resultSet.getString("CONRTELCO"),
					resultSet.getString("CONRFAXCO"), resultSet.getString("COCOEMCO"), resultSet.getDate("COFERES"),
					resultSet.getString("COINREENV"), resultSet.getString("COTERESP"), resultSet.getString("COCOTFPR"),
					resultSet.getString("COINL37"), resultSet.getLong("CONRANRG"), resultSet.getString("COCOPRO"),
					resultSet.getString("COHDCODIGO"), resultSet.getString("COHORA"),
					resultSet.getTimestamp("COFECHACONSUMIDOR"), resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"), resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"), resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"), resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"), resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"), resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"), resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"), resultSet.getString("COINL21"),
					resultSet.getString("COSITUACION"), resultSet.getString("NOMBREPISO"),
					resultSet.getString("DIRECCION_NOCAPV"), resultSet.getString("COEXTRANJERO"), null,
					resultSet.getString("COCONSULTAAACCEMPRESAS"), resultSet.getString("COCIF"),
					resultSet.getString("CORAZONSOCIAL"), resultSet.getString("CONOMBRECOMERCIAL"), null, null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	public Consulta add(Consulta consulta) {

		String query = "INSERT INTO CONSULTA( COCODIGO,COCOTIR,COCOPS,CORANCOD,COCOTFP,COCOOR,COCOMO,COFECHA,COCOSX,CONRAN,COCOSE,COTEXTO,CONRREG,CONOCO,CONODIRCO,CONRCPCO,COCOLOCO,CONOLOCO,CONOMUCO,COCOPVCO,COCOPACO,CONRTELCO,CONRFAXCO,COCOEMCO,COFERES,COINREENV,COTERESP,COCOTFPR,COINL37,CONRANRG,COCOPRO,COHDCODIGO,COHORA,COFECHACONSUMIDOR,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,COINL21,COSITUACION,NOMBRE_PISO,DIRECCION_NOCAPV,COEXTRANJERO,COCONSULTAAACCEMPRESAS, COCIF, CORAZONSOCIAL, CONOMBRECOMERCIAL)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getMotivoTircodigoAux = null;
		if (consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = consulta.getMotivo().getTircodigo();
		}
		Object getProductoPscodigoAux = null;
		if (consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = consulta.getProducto().getPscodigo();
		}
		Object getRangoEdadRancodAux = null;
		if (consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			getRangoEdadRancodAux = consulta.getRangoEdad().getRancod();
		}
		Object getFormaPresentacionTfpcodigoAux = null;
		if (consulta.getFormaPresentacion() != null && consulta.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = consulta.getFormaPresentacion().getTfpcodigo();
		}
		Object getOrganismoCodOrgAux = null;
		if (consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = consulta.getOrganismo().getCodOrg();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consulta.getCensoMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, consulta.getCocodigo(), getMotivoTircodigoAux, getProductoPscodigoAux,
				getRangoEdadRancodAux, getFormaPresentacionTfpcodigoAux, getOrganismoCodOrgAux,
				getCensoMonitorMocodigoAux, consulta.getCofecha(), consulta.getCocosx(), consulta.getConran(),
				consulta.getCocose(), consulta.getCotexto(), consulta.getConrreg(), consulta.getConoco(),
				consulta.getConodirco(), consulta.getConrcpco(), consulta.getCocoloco(), consulta.getConoloco(),
				consulta.getConomuco(), consulta.getCocopvco(), consulta.getCocopaco(), consulta.getConrtelco(),
				consulta.getConrfaxco(), consulta.getCocoemco(), consulta.getCoferes(), consulta.getCoinreenv(),
				consulta.getCoteresp(), consulta.getCocotfpr(), consulta.getCoinl37(), consulta.getConranrg(),
				consulta.getCocopro(), consulta.getCohdcodigo(), consulta.getCohora(), consulta.getCofechaconsumidor(),
				consulta.getNoraPaisId(), consulta.getNombrePais(), consulta.getNoraProvinciaId(),
				consulta.getNombreProvincia(), consulta.getNoraMunicipioId(), consulta.getNombreMunicipio(),
				consulta.getNoraLocalidadId(), consulta.getNombreLocalidad(), consulta.getNoraCalleId(),
				consulta.getNombreCalle(), consulta.getNoraCpId(), consulta.getNombreCp(), consulta.getNoraPortalId(),
				consulta.getNombrePortal(), consulta.getCoinl21(), consulta.getCosituacion(), consulta.getNombrePiso(),
				consulta.getDireccion_nocapv(), consulta.getCoextranjero(), consulta.getCoconsultaaaccempresas(),
				consulta.getCocif(), consulta.getCorazonsocial(), consulta.getConombrecomercial());
		return consulta;
	}

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	public Consulta addConsulta(Consulta consulta) {

		String query = "INSERT INTO CONSULTA( COCODIGO,COCOTIR,COCOPS,CORANCOD,COCOTFP,COCOOR,COCOMO,COFECHA,COCOSX,CONRAN,COCOSE,COTEXTO,CONRREG,CONOCO,CONODIRCO,CONRCPCO,COCOLOCO,CONOLOCO,CONOMUCO,COCOPVCO,COCOPACO,CONRTELCO,CONRFAXCO,COCOEMCO,COFERES,COINREENV,COTERESP,COCOTFPR,COINL37,CONRANRG,COCOPRO,COHDCODIGO,COHORA,COFECHACONSUMIDOR,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,COINL21,COSITUACION,NOMBRE_PISO,DIRECCION_NOCAPV,COEXTRANJERO,COCONSULTAAACCEMPRESAS, COCIF, CORAZONSOCIAL, CONOMBRECOMERCIAL)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getMotivoTircodigoAux = null;
		if (consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = consulta.getMotivo().getTircodigo();
		}
		Object getProductoPscodigoAux = null;
		if (consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = consulta.getProducto().getPscodigo();
		}
		Object getRangoEdadRancodAux = null;
		if (consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			getRangoEdadRancodAux = consulta.getRangoEdad().getRancod();
		}
		Object getFormaPresentacionTfpcodigoAux = null;
		if (consulta.getFormaPresentacion() != null && consulta.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = consulta.getFormaPresentacion().getTfpcodigo();
		}
		Object getOrganismoCodOrgAux = null;
		if (consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = consulta.getOrganismo().getCodOrg();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consulta.getCensoMonitor().getMocodigo();
		}
		// Fecha consulta
		Object insertarHora = null;
		if (consulta.getCofechaconsumidor() != null) {
			insertarHora = new java.sql.Timestamp(consulta.getCofechaconsumidor().getTime());
		}
		this.jdbcTemplate.update(query, consulta.getCocodigo(), getMotivoTircodigoAux, getProductoPscodigoAux,
				getRangoEdadRancodAux, getFormaPresentacionTfpcodigoAux, getOrganismoCodOrgAux,
				getCensoMonitorMocodigoAux, consulta.getCofecha(), consulta.getCocosx(), consulta.getConran(),
				consulta.getCocose(), consulta.getCotexto(), consulta.getConrreg(), consulta.getConoco(),
				consulta.getConodirco(), consulta.getConrcpco(), consulta.getCocoloco(), consulta.getConoloco(),
				consulta.getConomuco(), consulta.getCocopvco(), consulta.getCocopaco(), consulta.getConrtelco(),
				consulta.getConrfaxco(), consulta.getCocoemco(), consulta.getCoferes(), consulta.getCoinreenv(),
				consulta.getCoteresp(), consulta.getCocotfpr(), consulta.getCoinl37(), consulta.getConranrg(),
				consulta.getCocopro(), consulta.getCohdcodigo(), consulta.getCohora(), insertarHora,
				consulta.getNoraPaisId(), consulta.getNombrePais(), consulta.getNoraProvinciaId(),
				consulta.getNombreProvincia(), consulta.getNoraMunicipioId(), consulta.getNombreMunicipio(),
				consulta.getNoraLocalidadId(), consulta.getNombreLocalidad(), consulta.getNoraCalleId(),
				consulta.getNombreCalle(), consulta.getNoraCpId(), consulta.getNombreCp(), consulta.getNoraPortalId(),
				consulta.getNombrePortal(), consulta.getCoinl21(), consulta.getCosituacion(), consulta.getNombrePiso(),
				consulta.getDireccion_nocapv(), consulta.getCoextranjero(), consulta.getCoconsultaaaccempresas(),
				consulta.getCocif(), consulta.getCorazonsocial(), consulta.getConombrecomercial());
		return consulta;
	}

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	public Consulta update(Consulta consulta) {
		String query = "UPDATE CONSULTA SET COCOTIR=?,COCOPS=?,CORANCOD=?,COCOTFP=?,COCOOR=?,COCOMO=?,COFECHA=?,CONOCO=?,COCOSX=?,CONRAN=?,COCOSE=?,COTEXTO=?,CONRREG=?,CONRTELCO=?,CONRFAXCO=?,COCOEMCO=?,COFERES=?,COINREENV=?,COTERESP=?,COCOTFPR=?,CONRANRG=?,COCOPRO=?,COHDCODIGO=?,COHORA=?,COFECHACONSUMIDOR=?,NORA_PAIS_ID=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,COSITUACION=?,NOMBRE_PISO=?,DIRECCION_NOCAPV=?,COEXTRANJERO=?,COCONSULTAAACCEMPRESAS=?, COCIF=?, CORAZONSOCIAL=?, CONOMBRECOMERCIAL=? WHERE COCODIGO=?";
		Object getMotivoTircodigoAux = null;
		if (consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = consulta.getMotivo().getTircodigo();
		}
		Object getProductoPscodigoAux = null;
		if (consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = consulta.getProducto().getPscodigo();
		}
		Object getRangoEdadRancodAux = null;
		if (consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			getRangoEdadRancodAux = consulta.getRangoEdad().getRancod();
		}
		Object getFormaPresentacionTfpcodigoAux = null;
		if (consulta.getFormaPresentacion() != null && consulta.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = consulta.getFormaPresentacion().getTfpcodigo();
		}
		Object getOrganismoCodOrgAux = null;
		if (consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = consulta.getOrganismo().getCodOrg();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consulta.getCensoMonitor().getMocodigo();
		}
		// Fecha consulta
		Object insertarHora = null;
		if (consulta.getCofechaconsumidor() != null) {
			insertarHora = new java.sql.Timestamp(consulta.getCofechaconsumidor().getTime());
		}

		this.jdbcTemplate.update(query, getMotivoTircodigoAux, getProductoPscodigoAux, getRangoEdadRancodAux,
				getFormaPresentacionTfpcodigoAux, getOrganismoCodOrgAux, getCensoMonitorMocodigoAux,
				consulta.getCofecha(), consulta.getConoco(), consulta.getCocosx(), consulta.getConran(),
				consulta.getCocose(), consulta.getCotexto(), consulta.getConrreg(), consulta.getConrtelco(),
				consulta.getConrfaxco(), consulta.getCocoemco(), consulta.getCoferes(), consulta.getCoinreenv(),
				consulta.getCoteresp(), consulta.getCocotfpr(), consulta.getConranrg(), consulta.getCocopro(),
				consulta.getCohdcodigo(), consulta.getCohora(), insertarHora, consulta.getNoraPaisId(),
				consulta.getNombrePais(), consulta.getNoraProvinciaId(), consulta.getNombreProvincia(),
				consulta.getNoraMunicipioId(), consulta.getNombreMunicipio(), consulta.getNoraLocalidadId(),
				consulta.getNombreLocalidad(), consulta.getNoraCalleId(), consulta.getNombreCalle(),
				consulta.getNoraCpId(), consulta.getNombreCp(), consulta.getNoraPortalId(), consulta.getNombrePortal(),
				consulta.getCosituacion(), consulta.getNombrePiso(), consulta.getDireccion_nocapv(),
				consulta.getCoextranjero(), consulta.getCoconsultaaaccempresas(), consulta.getCocif(),
				consulta.getCorazonsocial(), consulta.getConombrecomercial(), consulta.getCocodigo());
		return consulta;
	}

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	public Consulta updateRespuesta(Consulta consulta) {
		String query = "UPDATE CONSULTA SET COCOMO=?, COFERES=?,COSITUACION=? WHERE COCODIGO=?";

		Object getCensoMonitorMocodigoAux = null;
		if (consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consulta.getCensoMonitor().getMocodigo();
		}

		this.jdbcTemplate.update(query, getCensoMonitorMocodigoAux, consulta.getCoferes(), consulta.getCosituacion(),
				consulta.getCocodigo());
		return consulta;
	}

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	public Consulta updateRespuestaMail(Consulta consulta) {
		String query = "UPDATE CONSULTA SET COCOMO=?, COCOEMCO=?,COFERES=?,COSITUACION=? WHERE COCODIGO=?";

		Object getCensoMonitorMocodigoAux = null;
		if (consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = consulta.getCensoMonitor().getMocodigo();
		}

		this.jdbcTemplate.update(query, getCensoMonitorMocodigoAux, consulta.getCocoemco(), consulta.getCoferes(),
				consulta.getCosituacion(), consulta.getCocodigo());
		return consulta;
	}

	/**
	 * Finds a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	@Transactional(readOnly = true)
	public Consulta find(Consulta consulta) {
		String query = "SELECT t1.COCODIGO COCODIGO, t1.COFECHA COFECHA, t1.COCOSX COCOSX, t1.CONRAN CONRAN, t1.COCOSE COCOSE, t1.COTEXTO COTEXTO, t1.CONRREG CONRREG, t1.CONOCO CONOCO, t1.CONODIRCO CONODIRCO, t1.CONRCPCO CONRCPCO, t1.COCOLOCO COCOLOCO, t1.CONOLOCO CONOLOCO, t1.CONOMUCO CONOMUCO, t1.COCOPVCO COCOPVCO, t1.COCOPACO COCOPACO, t1.CONRTELCO CONRTELCO, t1.CONRFAXCO CONRFAXCO, t1.COCOEMCO COCOEMCO, t1.COFERES COFERES, t1.COINREENV COINREENV, t1.COTERESP COTERESP, t1.COCOTFPR COCOTFPR, t1.COINL37 COINL37, t1.CONRANRG CONRANRG, t1.COCOPRO COCOPRO, t1.COHDCODIGO COHDCODIGO, t1.COHORA COHORA, t1.COFECHACONSUMIDOR COFECHACONSUMIDOR, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.COINL21 COINL21, t1.COSITUACION COSITUACION, t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCION_NOCAPV, t1.COEXTRANJERO COEXTRANJERO, t1.COCONSULTAAACCEMPRESAS COCONSULTAAACCEMPRESAS, t1.COCIF COCIF, t1.CORAZONSOCIAL CORAZONSOCIAL, t1.CONOMBRECOMERCIAL CONOMBRECOMERCIAL, t2.TIRCODIGO MOTIVOTIRCODIGO, t2.TIRNOMBRE MOTIVOTIRNOMBRE, t3.PSCODIGO PRODUCTOPSCODIGO, t3.PSNOMBRE PRODUCTOPSNOMBRE, t3.PSNOCO PRODUCTOPSNOCO, t3.PSDESCRI PRODUCTOPSDESCRI, t3.PSCOSE PRODUCTOPSCOSE, t3.PSNOMBREE PRODUCTOPSNOMBREE, t3.PSNOMBREI PRODUCTOPSNOMBREI, t3.PSNOMBREF PRODUCTOPSNOMBREF, t3.PSNOMBREA PRODUCTOPSNOMBREA, t3.PSNOCOE PRODUCTOPSNOCOE, t3.PSNOCOI PRODUCTOPSNOCOI, t3.PSNOCOF PRODUCTOPSNOCOF, t3.PSNOCOA PRODUCTOPSNOCOA, t3.PSDESCRIE PRODUCTOPSDESCRIE, t3.PSDESCRII PRODUCTOPSDESCRII, t3.PSDESCRIF PRODUCTOPSDESCRIF, t3.PSDESCRIA PRODUCTOPSDESCRIA, t3.PSSEL1 PRODUCTOPSSEL1, t3.PSCOINC PRODUCTOPSCOINC, t4.RANCOD RANGOEDADRANCOD, t4.RANDESC RANGOEDADRANDESC, t5.TFPCODIGO FORMAPRESENTACIONTFPCODIGO, t5.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE, t5.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE, t5.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI, t5.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF, t5.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA,t5.TFPCONSULTAS FORMAPRESENTFPCONSULTAS,t5.TFPSOLICITUDES FORMAPRESENTFPSOLICITUDES,t5.TFPARBITRAJES FORMAPRESENTFPARBITRAJES,t6.COD_ORG ORGANISMOCODORG, t6.ENTIDAD_ID ORGANISMOENTIDADID, t6.NOMBRE_ES ORGANISMONOMBREES, t6.NOMBRE_EU ORGANISMONOMBREEU, t6.ACTIVA ORGANISMOACTIVA, t6.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t6.ISKONTSUMONET ORGANISMOISKONTSUMONET, t6.ISOFERTAFORM ORGANISMOISOFERTAFORM, t6.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t6.ISNACIONAL ORGANISMOISNACIONAL, t6.OBSERVACIONES ORGANISMOOBSERVACIONES, t6.TELEFONO ORGANISMOTELEFONO, t6.FAX ORGANISMOFAX, t6.EMAIL ORGANISMOEMAIL, t6.URL ORGANISMOURL, t6.USUARIO ORGANISMOUSUARIO, t6.PASSWORD ORGANISMOPASSWORD, t6.NORA_PAIS_ID ORGANISMONORAPAISID, t6.NOMBRE_PAIS ORGANISMONOMBREPAIS, t6.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t6.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t6.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t6.NORA_CALLE_ID ORGANISMONORACALLEID, t6.NOMBRE_CALLE ORGANISMONOMBRECALLE, t6.NORA_CP_ID ORGANISMONORACPID, t6.NOMBRE_CP ORGANISMONOMBRECP, t6.NORA_PORTAL_ID ORGANISMONORAPORTALID, t6.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t6.USUULTMOD ORGANISMOUSUULTMOD, t6.FECULTMOD ORGANISMOFECULTMOD, t7.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t7.PUESTOXLNET CENSOMONITORPUESTOXLNET, t7.MOCODIGO CENSOMONITORMOCODIGO, t7.MONOMBRE CENSOMONITORMONOMBRE, t7.MOCOEM CENSOMONITORMOCOEM, t7.MODNI CENSOMONITORMODNI, t7.MOFECBAJA CENSOMONITORMOFECBAJA, t3.PSCOE8 PRODUCTOPSCOE8, t7.MOCOOR CENSOMONITORMOCOOR "
				+ "FROM CONSULTA t1 , MOTIVO t2 , PRODUCTO t3 , RANGO_EDAD t4 , FORMA_PRESENTACION t5 , ORGANISMO t6 , CENSO_MONITOR t7  "
				+ "WHERE t1.COCODIGO = ?   AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOOR= t6.COD_ORG(+) AND t1.COCOMO= t7.MOCODIGO(+)  ";
		return (Consulta) this.jdbcTemplate.queryForObject(query, rwMap, consulta.getCocodigo());
	}

	/**
	 * Removes a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return
	 */
	public void remove(Consulta consulta) {
		String query = "DELETE  FROM CONSULTA WHERE COCODIGO=?";
		this.jdbcTemplate.update(query, consulta.getCocodigo());
	}

	/**
	 * Finds a List of rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Consulta> findAll(Consulta consulta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOOR= t6.COD_ORG(+) AND t1.COCOMO= t7.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COCODIGO COCODIGO,t1.COFECHA COFECHA,t1.COCOSX COCOSX,t1.CONRAN CONRAN,t1.COCOSE COCOSE,t1.COTEXTO COTEXTO,t1.CONRREG CONRREG,t1.CONOCO CONOCO,t1.CONODIRCO CONODIRCO,t1.CONRCPCO CONRCPCO,t1.COCOLOCO COCOLOCO,t1.CONOLOCO CONOLOCO,t1.CONOMUCO CONOMUCO,t1.COCOPVCO COCOPVCO,t1.COCOPACO COCOPACO,t1.CONRTELCO CONRTELCO,t1.CONRFAXCO CONRFAXCO,t1.COCOEMCO COCOEMCO,t1.COFERES COFERES,t1.COINREENV COINREENV,t1.COTERESP COTERESP,t1.COCOTFPR COCOTFPR,t1.COINL37 COINL37,t1.CONRANRG CONRANRG,t1.COCOPRO COCOPRO,t1.COHDCODIGO COHDCODIGO,t1.COHORA COHORA,t1.COFECHACONSUMIDOR COFECHACONSUMIDOR,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.COINL21 COINL21,t1.COSITUACION COSITUACION,t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCION_NOCAPV, t1.COEXTRANJERO COEXTRANJERO, t1.COCONSULTAAACCEMPRESAS COCONSULTAAACCEMPRESAS, t1.COCIF COCIF, t1.CORAZONSOCIAL CORAZONSOCIAL, t1.CONOMBRECOMERCIAL CONOMBRECOMERCIAL, t2.TIRCODIGO MOTIVOTIRCODIGO,t2.TIRNOMBRE MOTIVOTIRNOMBRE,t3.PSCODIGO PRODUCTOPSCODIGO,t3.PSNOMBRE PRODUCTOPSNOMBRE,t3.PSNOCO PRODUCTOPSNOCO,t3.PSDESCRI PRODUCTOPSDESCRI,t3.PSCOSE PRODUCTOPSCOSE,t3.PSNOMBREE PRODUCTOPSNOMBREE,t3.PSNOMBREI PRODUCTOPSNOMBREI,t3.PSNOMBREF PRODUCTOPSNOMBREF,t3.PSNOMBREA PRODUCTOPSNOMBREA,t3.PSNOCOE PRODUCTOPSNOCOE,t3.PSNOCOI PRODUCTOPSNOCOI,t3.PSNOCOF PRODUCTOPSNOCOF,t3.PSNOCOA PRODUCTOPSNOCOA,t3.PSDESCRIE PRODUCTOPSDESCRIE,t3.PSDESCRII PRODUCTOPSDESCRII,t3.PSDESCRIF PRODUCTOPSDESCRIF,t3.PSDESCRIA PRODUCTOPSDESCRIA,t3.PSSEL1 PRODUCTOPSSEL1,t3.PSCOINC PRODUCTOPSCOINC,t4.RANCOD RANGOEDADRANCOD,t4.RANDESC RANGOEDADRANDESC,t5.TFPCODIGO FORMAPRESENTACIONTFPCODIGO,t5.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE,t5.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE,t5.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI,t5.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF,t5.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA,t6.COD_ORG ORGANISMOCODORG,t6.ENTIDAD_ID ORGANISMOENTIDADID,t6.NOMBRE_ES ORGANISMONOMBREES,t6.NOMBRE_EU ORGANISMONOMBREEU,t6.ACTIVA ORGANISMOACTIVA,t6.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t6.ISKONTSUMONET ORGANISMOISKONTSUMONET,t6.ISOFERTAFORM ORGANISMOISOFERTAFORM,t6.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t6.ISNACIONAL ORGANISMOISNACIONAL,t6.OBSERVACIONES ORGANISMOOBSERVACIONES,t6.TELEFONO ORGANISMOTELEFONO,t6.FAX ORGANISMOFAX,t6.EMAIL ORGANISMOEMAIL,t6.URL ORGANISMOURL,t6.USUARIO ORGANISMOUSUARIO,t6.PASSWORD ORGANISMOPASSWORD,t6.NORA_PAIS_ID ORGANISMONORAPAISID,t6.NOMBRE_PAIS ORGANISMONOMBREPAIS,t6.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t6.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t6.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t6.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t6.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t6.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t6.NORA_CALLE_ID ORGANISMONORACALLEID,t6.NOMBRE_CALLE ORGANISMONOMBRECALLE,t6.NORA_CP_ID ORGANISMONORACPID,t6.NOMBRE_CP ORGANISMONOMBRECP,t6.NORA_PORTAL_ID ORGANISMONORAPORTALID,t6.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t6.USUULTMOD ORGANISMOUSUULTMOD,t6.FECULTMOD ORGANISMOFECULTMOD,t7.USUARIOXLNET CENSOMONITORUSUARIOXLNET ,t7.PUESTOXLNET CENSOMONITORPUESTOXLNET, t7.MOCODIGO CENSOMONITORMOCODIGO,t7.MONOMBRE CENSOMONITORMONOMBRE,t7.MOCOEM CENSOMONITORMOCOEM, t7.MODNI CENSOMONITORMODNI,t7.MOFECBAJA CENSOMONITORMOFECBAJA,t3.PSCOE8 PRODUCTOPSCOE8,t7.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5 ,ORGANISMO t6 ,CENSO_MONITOR t7 ");

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTirnombre() != null) {
			where.append(" AND t2.TIRNOMBRE = ?");
			params.add(consulta.getMotivo().getTirnombre());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombre() != null) {
			where.append(" AND t3.PSNOMBRE = ?");
			params.add(consulta.getProducto().getPsnombre());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombree() != null) {
			where.append(" AND t3.PSNOMBREE = ?");
			params.add(consulta.getProducto().getPsnombree());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRandesc() != null) {
			where.append(" AND t4.RANDESC = ?");
			params.add(consulta.getRangoEdad().getRandesc());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND t5.TFPNOMBRE = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombre());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND t5.TFPNOMBREE = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombree());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t6.COD_ORG = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEntidadId() != null) {
			where.append(" AND t6.ENTIDAD_ID = ?");
			params.add(consulta.getOrganismo().getEntidadId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEs() != null) {
			where.append(" AND t6.NOMBRE_ES = ?");
			params.add(consulta.getOrganismo().getNombreEs());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEu() != null) {
			where.append(" AND t6.NOMBRE_EU = ?");
			params.add(consulta.getOrganismo().getNombreEu());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getActiva() != null) {
			where.append(" AND t6.ACTIVA = ?");
			params.add(consulta.getOrganismo().getActiva());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND t6.ISKONTSUMOGEST = ?");
			params.add(consulta.getOrganismo().getIskontsumogest());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND t6.ISKONTSUMONET = ?");
			params.add(consulta.getOrganismo().getIskontsumonet());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsofertaform() != null) {
			where.append(" AND t6.ISOFERTAFORM = ?");
			params.add(consulta.getOrganismo().getIsofertaform());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND t6.ISCONSULTASWEB = ?");
			params.add(consulta.getOrganismo().getIsconsultasweb());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsnacional() != null) {
			where.append(" AND t6.ISNACIONAL = ?");
			params.add(consulta.getOrganismo().getIsnacional());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getObservaciones() != null) {
			where.append(" AND t6.OBSERVACIONES = ?");
			params.add(consulta.getOrganismo().getObservaciones());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getTelefono() != null) {
			where.append(" AND t6.TELEFONO = ?");
			params.add(consulta.getOrganismo().getTelefono());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFax() != null) {
			where.append(" AND t6.FAX = ?");
			params.add(consulta.getOrganismo().getFax());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEmail() != null) {
			where.append(" AND t6.EMAIL = ?");
			params.add(consulta.getOrganismo().getEmail());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUrl() != null) {
			where.append(" AND t6.URL = ?");
			params.add(consulta.getOrganismo().getUrl());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuario() != null) {
			where.append(" AND t6.USUARIO = ?");
			params.add(consulta.getOrganismo().getUsuario());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getPassword() != null) {
			where.append(" AND t6.PASSWORD = ?");
			params.add(consulta.getOrganismo().getPassword());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND t6.NORA_PAIS_ID = ?");
			params.add(consulta.getOrganismo().getNoraPaisId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePais() != null) {
			where.append(" AND t6.NOMBRE_PAIS = ?");
			params.add(consulta.getOrganismo().getNombrePais());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND t6.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getOrganismo().getNoraProvinciaId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND t6.NOMBRE_PROVINCIA = ?");
			params.add(consulta.getOrganismo().getNombreProvincia());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND t6.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getOrganismo().getNoraMunicipioId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND t6.NOMBRE_MUNICIPIO = ?");
			params.add(consulta.getOrganismo().getNombreMunicipio());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND t6.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getOrganismo().getNoraLocalidadId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND t6.NOMBRE_LOCALIDAD = ?");
			params.add(consulta.getOrganismo().getNombreLocalidad());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND t6.NORA_CALLE_ID = ?");
			params.add(consulta.getOrganismo().getNoraCalleId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCalle() != null) {
			where.append(" AND t6.NOMBRE_CALLE = ?");
			params.add(consulta.getOrganismo().getNombreCalle());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCpId() != null) {
			where.append(" AND t6.NORA_CP_ID = ?");
			params.add(consulta.getOrganismo().getNoraCpId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCp() != null) {
			where.append(" AND t6.NOMBRE_CP = ?");
			params.add(consulta.getOrganismo().getNombreCp());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND t6.NORA_PORTAL_ID = ?");
			params.add(consulta.getOrganismo().getNoraPortalId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePortal() != null) {
			where.append(" AND t6.NOMBRE_PORTAL = ?");
			params.add(consulta.getOrganismo().getNombrePortal());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuultmod() != null) {
			where.append(" AND t6.USUULTMOD = ?");
			params.add(consulta.getOrganismo().getUsuultmod());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFecultmod() != null) {
			where.append(" AND t6.FECULTMOD = ?");
			params.add(consulta.getOrganismo().getFecultmod());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t7.MONOMBRE = ?");
			params.add(consulta.getCensoMonitor().getMonombre());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND t1.COTEXTO = ?");
			params.add(consulta.getCotexto());
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND t1.CONOCO = ?");
			params.add(consulta.getConoco());
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND t1.COINL37 = ?");
			params.add(consulta.getCoinl37());
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(consulta.getNombreProvincia());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(consulta.getNombreMunicipio());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(consulta.getNombreLocalidad());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}
		if (consulta != null && consulta.getCoinl21() != null) {
			where.append(" AND t1.COINL21 = ?");
			params.add(consulta.getCoinl21());
		}
		if (consulta != null && consulta.getCosituacion() != null) {
			where.append(" AND t1.COSITUACION = ?");
			params.add(consulta.getCosituacion());
		}
		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Consulta>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Consulta consulta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  and t1.COCOTIR= t2.TIRCODIGO(+) and t1.COCOPS= t3.PSCODIGO(+) and t1.CORANCOD= t4.RANCOD(+) and t1.COCOTFP= t5.TFPCODIGO(+) and t1.COCOOR= t6.COD_ORG(+) and t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CONSULTA t1   ,  MOTIVO t2   ,  PRODUCTO t3   ,  RANGO_EDAD t4   ,  FORMA_PRESENTACION t5   ,  ORGANISMO t6   ,  CENSO_MONITOR t7  ");
		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTirnombre() != null) {
			where.append(" AND t2.TIRNOMBRE = ?");
			params.add(consulta.getMotivo().getTirnombre());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombre() != null) {
			where.append(" AND t3.PSNOMBRE = ?");
			params.add(consulta.getProducto().getPsnombre());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombree() != null) {
			where.append(" AND t3.PSNOMBREE = ?");
			params.add(consulta.getProducto().getPsnombree());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRandesc() != null) {
			where.append(" AND t4.RANDESC = ?");
			params.add(consulta.getRangoEdad().getRandesc());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND t5.TFPNOMBRE = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombre());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND t5.TFPNOMBREE = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombree());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t6.COD_ORG = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEntidadId() != null) {
			where.append(" AND t6.ENTIDAD_ID = ?");
			params.add(consulta.getOrganismo().getEntidadId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEs() != null) {
			where.append(" AND t6.NOMBRE_ES = ?");
			params.add(consulta.getOrganismo().getNombreEs());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEu() != null) {
			where.append(" AND t6.NOMBRE_EU = ?");
			params.add(consulta.getOrganismo().getNombreEu());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getActiva() != null) {
			where.append(" AND t6.ACTIVA = ?");
			params.add(consulta.getOrganismo().getActiva());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND t6.ISKONTSUMOGEST = ?");
			params.add(consulta.getOrganismo().getIskontsumogest());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND t6.ISKONTSUMONET = ?");
			params.add(consulta.getOrganismo().getIskontsumonet());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsofertaform() != null) {
			where.append(" AND t6.ISOFERTAFORM = ?");
			params.add(consulta.getOrganismo().getIsofertaform());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND t6.ISCONSULTASWEB = ?");
			params.add(consulta.getOrganismo().getIsconsultasweb());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsnacional() != null) {
			where.append(" AND t6.ISNACIONAL = ?");
			params.add(consulta.getOrganismo().getIsnacional());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getObservaciones() != null) {
			where.append(" AND t6.OBSERVACIONES = ?");
			params.add(consulta.getOrganismo().getObservaciones());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getTelefono() != null) {
			where.append(" AND t6.TELEFONO = ?");
			params.add(consulta.getOrganismo().getTelefono());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFax() != null) {
			where.append(" AND t6.FAX = ?");
			params.add(consulta.getOrganismo().getFax());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEmail() != null) {
			where.append(" AND t6.EMAIL = ?");
			params.add(consulta.getOrganismo().getEmail());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUrl() != null) {
			where.append(" AND t6.URL = ?");
			params.add(consulta.getOrganismo().getUrl());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuario() != null) {
			where.append(" AND t6.USUARIO = ?");
			params.add(consulta.getOrganismo().getUsuario());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getPassword() != null) {
			where.append(" AND t6.PASSWORD = ?");
			params.add(consulta.getOrganismo().getPassword());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND t6.NORA_PAIS_ID = ?");
			params.add(consulta.getOrganismo().getNoraPaisId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePais() != null) {
			where.append(" AND t6.NOMBRE_PAIS = ?");
			params.add(consulta.getOrganismo().getNombrePais());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND t6.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getOrganismo().getNoraProvinciaId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND t6.NOMBRE_PROVINCIA = ?");
			params.add(consulta.getOrganismo().getNombreProvincia());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND t6.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getOrganismo().getNoraMunicipioId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND t6.NOMBRE_MUNICIPIO = ?");
			params.add(consulta.getOrganismo().getNombreMunicipio());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND t6.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getOrganismo().getNoraLocalidadId());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND t6.NOMBRE_LOCALIDAD = ?");
			params.add(consulta.getOrganismo().getNombreLocalidad());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND t6.NORA_CALLE_ID = ?");
			params.add(consulta.getOrganismo().getNoraCalleId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCalle() != null) {
			where.append(" AND t6.NOMBRE_CALLE = ?");
			params.add(consulta.getOrganismo().getNombreCalle());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCpId() != null) {
			where.append(" AND t6.NORA_CP_ID = ?");
			params.add(consulta.getOrganismo().getNoraCpId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCp() != null) {
			where.append(" AND t6.NOMBRE_CP = ?");
			params.add(consulta.getOrganismo().getNombreCp());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND t6.NORA_PORTAL_ID = ?");
			params.add(consulta.getOrganismo().getNoraPortalId());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePortal() != null) {
			where.append(" AND t6.NOMBRE_PORTAL = ?");
			params.add(consulta.getOrganismo().getNombrePortal());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuultmod() != null) {
			where.append(" AND t6.USUULTMOD = ?");
			params.add(consulta.getOrganismo().getUsuultmod());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFecultmod() != null) {
			where.append(" AND t6.FECULTMOD = ?");
			params.add(consulta.getOrganismo().getFecultmod());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t7.MONOMBRE = ?");
			params.add(consulta.getCensoMonitor().getMonombre());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND t1.COTEXTO = ?");
			params.add(consulta.getCotexto());
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND t1.CONOCO = ?");
			params.add(consulta.getConoco());
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND t1.COINL37 = ?");
			params.add(consulta.getCoinl37());
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(consulta.getNombreProvincia());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(consulta.getNombreMunicipio());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(consulta.getNombreLocalidad());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}
		if (consulta != null && consulta.getCoinl21() != null) {
			where.append(" AND t1.COINL21 = ?");
			params.add(consulta.getCoinl21());
		}
		if (consulta != null && consulta.getCosituacion() != null) {
			where.append(" AND t1.COSITUACION = ?");
			params.add(consulta.getCosituacion());
		}
		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Consulta> findAllLike(Consulta consulta, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOOR= t6.COD_ORG(+) AND t1.COCOMO= t7.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COCODIGO COCODIGO,t1.COFECHA COFECHA,t1.COCOSX COCOSX,t1.CONRAN CONRAN,t1.COCOSE COCOSE,t1.COTEXTO COTEXTO,t1.CONRREG CONRREG,t1.CONOCO CONOCO,t1.CONODIRCO CONODIRCO,t1.CONRCPCO CONRCPCO,t1.COCOLOCO COCOLOCO,t1.CONOLOCO CONOLOCO,t1.CONOMUCO CONOMUCO,t1.COCOPVCO COCOPVCO,t1.COCOPACO COCOPACO,t1.CONRTELCO CONRTELCO,t1.CONRFAXCO CONRFAXCO,t1.COCOEMCO COCOEMCO,t1.COFERES COFERES,t1.COINREENV COINREENV,t1.COTERESP COTERESP,t1.COCOTFPR COCOTFPR,t1.COINL37 COINL37,t1.CONRANRG CONRANRG,t1.COCOPRO COCOPRO,t1.COHDCODIGO COHDCODIGO,t1.COHORA COHORA,t1.COFECHACONSUMIDOR COFECHACONSUMIDOR,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.COINL21 COINL21,t1.COSITUACION COSITUACION,t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCION_NOCAPV, t1.COEXTRANJERO COEXTRANJERO, t1.COCONSULTAAACCEMPRESAS COCONSULTAAACCEMPRESAS, t1.COCIF COCIF, t1.CORAZONSOCIAL CORAZONSOCIAL, t1.CONOMBRECOMERCIAL CONOMBRECOMERCIAL, t2.TIRCODIGO MOTIVOTIRCODIGO,t2.TIRNOMBRE MOTIVOTIRNOMBRE,t3.PSCODIGO PRODUCTOPSCODIGO,t3.PSNOMBRE PRODUCTOPSNOMBRE,t3.PSNOCO PRODUCTOPSNOCO,t3.PSDESCRI PRODUCTOPSDESCRI,t3.PSCOSE PRODUCTOPSCOSE,t3.PSNOMBREE PRODUCTOPSNOMBREE,t3.PSNOMBREI PRODUCTOPSNOMBREI,t3.PSNOMBREF PRODUCTOPSNOMBREF,t3.PSNOMBREA PRODUCTOPSNOMBREA,t3.PSNOCOE PRODUCTOPSNOCOE,t3.PSNOCOI PRODUCTOPSNOCOI,t3.PSNOCOF PRODUCTOPSNOCOF,t3.PSNOCOA PRODUCTOPSNOCOA,t3.PSDESCRIE PRODUCTOPSDESCRIE,t3.PSDESCRII PRODUCTOPSDESCRII,t3.PSDESCRIF PRODUCTOPSDESCRIF,t3.PSDESCRIA PRODUCTOPSDESCRIA,t3.PSSEL1 PRODUCTOPSSEL1,t3.PSCOINC PRODUCTOPSCOINC,t4.RANCOD RANGOEDADRANCOD,t4.RANDESC RANGOEDADRANDESC,t5.TFPCODIGO FORMAPRESENTACIONTFPCODIGO,t5.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE,t5.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE,t5.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI,t5.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF,t5.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA,t6.COD_ORG ORGANISMOCODORG,t6.ENTIDAD_ID ORGANISMOENTIDADID,t6.NOMBRE_ES ORGANISMONOMBREES,t6.NOMBRE_EU ORGANISMONOMBREEU,t6.ACTIVA ORGANISMOACTIVA,t6.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t6.ISKONTSUMONET ORGANISMOISKONTSUMONET,t6.ISOFERTAFORM ORGANISMOISOFERTAFORM,t6.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t6.ISNACIONAL ORGANISMOISNACIONAL,t6.OBSERVACIONES ORGANISMOOBSERVACIONES,t6.TELEFONO ORGANISMOTELEFONO,t6.FAX ORGANISMOFAX,t6.EMAIL ORGANISMOEMAIL,t6.URL ORGANISMOURL,t6.USUARIO ORGANISMOUSUARIO,t6.PASSWORD ORGANISMOPASSWORD,t6.NORA_PAIS_ID ORGANISMONORAPAISID,t6.NOMBRE_PAIS ORGANISMONOMBREPAIS,t6.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t6.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t6.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t6.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t6.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t6.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t6.NORA_CALLE_ID ORGANISMONORACALLEID,t6.NOMBRE_CALLE ORGANISMONOMBRECALLE,t6.NORA_CP_ID ORGANISMONORACPID,t6.NOMBRE_CP ORGANISMONOMBRECP,t6.NORA_PORTAL_ID ORGANISMONORAPORTALID,t6.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t6.USUULTMOD ORGANISMOUSUULTMOD,t6.FECULTMOD ORGANISMOFECULTMOD,t7.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t7.PUESTOXLNET CENSOMONITORPUESTOXLNET,t7.MOCODIGO CENSOMONITORMOCODIGO,t7.MONOMBRE CENSOMONITORMONOMBRE,t7.MOCOEM CENSOMONITORMOCOEM, t7.MODNI CENSOMONITORMODNI,t7.MOFECBAJA CENSOMONITORMOFECBAJA,t3.PSCOE8 PRODUCTOPSCOE8,t7.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5 ,ORGANISMO t6 ,CENSO_MONITOR t7 ");

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND UPPER(t1.COCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.COCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getMotivo().getTircodigo() + "%");
			} else {
				params.add("%" + consulta.getMotivo().getTircodigo() + "%");
			}
			where.append(" AND t2.TIRCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTirnombre() != null) {
			where.append(" AND UPPER(t2.TIRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getMotivo().getTirnombre().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getMotivo().getTirnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.TIRNOMBRE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPscodigo() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPscodigo() + "%");
			}
			where.append(" AND t3.PSCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND UPPER(t3.PSCOE8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getProdAgrupado().getE8codigo().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getProdAgrupado().getE8codigo().toUpperCase() + "%");
			}
			where.append(" AND t3.PSCOE8 IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombre() != null) {
			where.append(" AND UPPER(t3.PSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnombre().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOMBRE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND UPPER(t3.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnoco().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND UPPER(t3.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsdescri().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsdescri().toUpperCase() + "%");
			}
			where.append(" AND t3.PSDESCRI IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND UPPER(t3.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPscose().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPscose().toUpperCase() + "%");
			}
			where.append(" AND t3.PSCOSE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombree() != null) {
			where.append(" AND UPPER(t3.PSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnombree().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnombree().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOMBREE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND UPPER(t3.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOMBREI IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND UPPER(t3.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOMBREF IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND UPPER(t3.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOMBREA IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND UPPER(t3.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnocoe().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnocoe().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND UPPER(t3.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnocoi().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnocoi().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOI IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND UPPER(t3.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnocof().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnocof().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOF IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND UPPER(t3.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsnocoa().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsnocoa().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOA IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND UPPER(t3.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsdescrie().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsdescrie().toUpperCase() + "%");
			}
			where.append(" AND t3.PSDESCRIE IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND UPPER(t3.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsdescrii().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsdescrii().toUpperCase() + "%");
			}
			where.append(" AND t3.PSDESCRII IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND UPPER(t3.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsdescrif().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsdescrif().toUpperCase() + "%");
			}
			where.append(" AND t3.PSDESCRIF IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND UPPER(t3.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPsdescria().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPsdescria().toUpperCase() + "%");
			}
			where.append(" AND t3.PSDESCRIA IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND UPPER(t3.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPssel1().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPssel1().toUpperCase() + "%");
			}
			where.append(" AND t3.PSSEL1 IS NOT NULL");
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND UPPER(t3.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getProducto().getPscoinc().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getProducto().getPscoinc().toUpperCase() + "%");
			}
			where.append(" AND t3.PSCOINC IS NOT NULL");
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getRangoEdad().getRancod() + "%");
			} else {
				params.add("%" + consulta.getRangoEdad().getRancod() + "%");
			}
			where.append(" AND t4.RANCOD IS NOT NULL");
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRandesc() != null) {
			where.append(" AND UPPER(t4.RANDESC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getRangoEdad().getRandesc().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getRangoEdad().getRandesc().toUpperCase() + "%");
			}
			where.append(" AND t4.RANDESC IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpcodigo() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpcodigo() + "%");
			}
			where.append(" AND t5.TFPCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND UPPER(t5.TFPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpnombre().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpnombre().toUpperCase() + "%");
			}
			where.append(" AND t5.TFPNOMBRE IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND UPPER(t5.TFPNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpnombree().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpnombree().toUpperCase() + "%");
			}
			where.append(" AND t5.TFPNOMBREE IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND UPPER(t5.TFPNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpnombrei().toUpperCase() + "%");
			}
			where.append(" AND t5.TFPNOMBREI IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND UPPER(t5.TFPNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpnombref().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpnombref().toUpperCase() + "%");
			}
			where.append(" AND t5.TFPNOMBREF IS NOT NULL");
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND UPPER(t5.TFPNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getFormaPresentacion().getTfpnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getFormaPresentacion().getTfpnombrea().toUpperCase() + "%");
			}
			where.append(" AND t5.TFPNOMBREA IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t6.COD_ORG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getCodOrg() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getCodOrg() + "%");
			}
			where.append(" AND t6.COD_ORG IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEntidadId() != null) {
			where.append(" AND UPPER(t6.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t6.ENTIDAD_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEs() != null) {
			where.append(" AND UPPER(t6.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_ES IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreEu() != null) {
			where.append(" AND UPPER(t6.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_EU IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getActiva() != null) {
			where.append(" AND UPPER(t6.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getActiva().toUpperCase() + "%");
			}
			where.append(" AND t6.ACTIVA IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND UPPER(t6.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getIskontsumogest().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getIskontsumogest().toUpperCase() + "%");
			}
			where.append(" AND t6.ISKONTSUMOGEST IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND UPPER(t6.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" AND t6.ISKONTSUMONET IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsofertaform() != null) {
			where.append(" AND UPPER(t6.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getIsofertaform().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getIsofertaform().toUpperCase() + "%");
			}
			where.append(" AND t6.ISOFERTAFORM IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND UPPER(t6.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getIsconsultasweb().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getIsconsultasweb().toUpperCase() + "%");
			}
			where.append(" AND t6.ISCONSULTASWEB IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getIsnacional() != null) {
			where.append(" AND UPPER(t6.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t6.ISNACIONAL IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getObservaciones() != null) {
			where.append(" AND UPPER(t6.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t6.OBSERVACIONES IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getTelefono() != null) {
			where.append(" AND UPPER(t6.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t6.TELEFONO IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFax() != null) {
			where.append(" AND UPPER(t6.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getFax().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getFax().toUpperCase() + "%");
			}
			where.append(" AND t6.FAX IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getEmail() != null) {
			where.append(" AND UPPER(t6.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getEmail().toUpperCase() + "%");
			}
			where.append(" AND t6.EMAIL IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUrl() != null) {
			where.append(" AND UPPER(t6.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getUrl().toUpperCase() + "%");
			}
			where.append(" AND t6.URL IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuario() != null) {
			where.append(" AND UPPER(t6.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t6.USUARIO IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getPassword() != null) {
			where.append(" AND UPPER(t6.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getPassword().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getPassword().toUpperCase() + "%");
			}
			where.append(" AND t6.PASSWORD IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND UPPER(t6.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_PAIS_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePais() != null) {
			where.append(" AND UPPER(t6.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_PAIS IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t6.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND UPPER(t6.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t6.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t6.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t6.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t6.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND UPPER(t6.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_CALLE_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCalle() != null) {
			where.append(" AND UPPER(t6.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_CALLE IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraCpId() != null) {
			where.append(" AND UPPER(t6.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_CP_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombreCp() != null) {
			where.append(" AND UPPER(t6.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_CP IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND UPPER(t6.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t6.NORA_PORTAL_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getNombrePortal() != null) {
			where.append(" AND UPPER(t6.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t6.NOMBRE_PORTAL IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getUsuultmod() != null) {
			where.append(" AND UPPER(t6.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t6.USUULTMOD IS NOT NULL");
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getFecultmod() != null) {
			where.append(" AND t6.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getOrganismo().getFecultmod() + "%");
			} else {
				params.add("%" + consulta.getOrganismo().getFecultmod() + "%");
			}
			where.append(" AND t6.FECULTMOD IS NOT NULL");
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCensoMonitor().getMocodigo() + "%");
			} else {
				params.add("%" + consulta.getCensoMonitor().getMocodigo() + "%");
			}
			where.append(" AND t7.MOCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t7.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t7.MOCOOR IS NOT NULL");
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t7.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCensoMonitor().getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCensoMonitor().getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t7.MONOMBRE IS NOT NULL");
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t7.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCensoMonitor().getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCensoMonitor().getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t7.MOCOEM IS NOT NULL");
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCensoMonitor().getMofecbaja() + "%");
			} else {
				params.add("%" + consulta.getCensoMonitor().getMofecbaja() + "%");
			}
			where.append(" AND t7.MOFECBAJA IS NOT NULL");
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCofecha() + "%");
			} else {
				params.add("%" + consulta.getCofecha() + "%");
			}
			where.append(" AND t1.COFECHA IS NOT NULL");
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND UPPER(t1.COCOSX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocosx().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocosx().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOSX IS NOT NULL");
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND UPPER(t1.CONRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConran().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConran().toUpperCase() + "%");
			}
			where.append(" AND t1.CONRAN IS NOT NULL");
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND UPPER(t1.COCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocose().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocose().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOSE IS NOT NULL");
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND UPPER(t1.COTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCotexto().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCotexto().toUpperCase() + "%");
			}
			where.append(" AND t1.COTEXTO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConrreg() + "%");
			} else {
				params.add("%" + consulta.getConrreg() + "%");
			}
			where.append(" AND t1.CONRREG IS NOT NULL");
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND UPPER(t1.CONOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConoco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND UPPER(t1.CONODIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConodirco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConodirco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONODIRCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND UPPER(t1.CONRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConrcpco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConrcpco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONRCPCO IS NOT NULL");
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND UPPER(t1.COCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocoloco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocoloco().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOLOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND UPPER(t1.CONOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoloco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConoloco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONOLOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND UPPER(t1.CONOMUCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConomuco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConomuco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONOMUCO IS NOT NULL");
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND UPPER(t1.COCOPVCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocopvco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocopvco().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOPVCO IS NOT NULL");
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND UPPER(t1.COCOPACO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocopaco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocopaco().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOPACO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND UPPER(t1.CONRTELCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConrtelco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConrtelco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONRTELCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND UPPER(t1.CONRFAXCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConrfaxco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConrfaxco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONRFAXCO IS NOT NULL");
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND UPPER(t1.COCOEMCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocoemco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocoemco().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOEMCO IS NOT NULL");
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCoferes() + "%");
			} else {
				params.add("%" + consulta.getCoferes() + "%");
			}
			where.append(" AND t1.COFERES IS NOT NULL");
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND UPPER(t1.COINREENV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCoinreenv().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCoinreenv().toUpperCase() + "%");
			}
			where.append(" AND t1.COINREENV IS NOT NULL");
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND UPPER(t1.COTERESP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCoteresp().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCoteresp().toUpperCase() + "%");
			}
			where.append(" AND t1.COTERESP IS NOT NULL");
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND UPPER(t1.COCOTFPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocotfpr().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocotfpr().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOTFPR IS NOT NULL");
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND UPPER(t1.COINL37) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCoinl37().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCoinl37().toUpperCase() + "%");
			}
			where.append(" AND t1.COINL37 IS NOT NULL");
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConranrg() + "%");
			} else {
				params.add("%" + consulta.getConranrg() + "%");
			}
			where.append(" AND t1.CONRANRG IS NOT NULL");
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND UPPER(t1.COCOPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocopro().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocopro().toUpperCase() + "%");
			}
			where.append(" AND t1.COCOPRO IS NOT NULL");
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND UPPER(t1.COHDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCohdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCohdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.COHDCODIGO IS NOT NULL");
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND UPPER(t1.COHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCohora().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCohora().toUpperCase() + "%");
			}
			where.append(" AND t1.COHORA IS NOT NULL");
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCofechaconsumidor() + "%");
			} else {
				params.add("%" + consulta.getCofechaconsumidor() + "%");
			}
			where.append(" AND t1.COFECHACONSUMIDOR IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (consulta != null && consulta.getCoinl21() != null) {
			where.append(" AND UPPER(t1.COINL21) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCoinl21().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCoinl21().toUpperCase() + "%");
			}
			where.append(" AND t1.COINL21 IS NOT NULL");
		}
		if (consulta != null && consulta.getCosituacion() != null) {
			where.append(" AND UPPER(t1.COSITUACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCosituacion().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCosituacion().toUpperCase() + "%");
			}
			where.append(" AND t1.COSITUACION IS NOT NULL");
		}
		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getNombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getNombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PISO IS NOT NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Consulta>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Consulta> findAllLikeConsulta(Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.COCODIGO COCODIGO,t1.CONOMBRECOMERCIAL CONOMBRECOMERCIAL,t1.COFECHA COFECHA, t1.CONRANRG CONRANRG, t1.CONRREG CONRREG, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.COINL37 COINL37, t1.COSITUACION COSITUACION, t3.PSCODIGO PRODUCTOPSCODIGO, t3.PSNOMBRE PRODUCTOPSNOMBRE,t3.PSNOMBREE PRODUCTOPSNOMBREE, t1.COCOOR ORGANISMOCODORG,t7.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t7.PUESTOXLNET CENSOMONITORPUESTOXLNET,t7.MOCODIGO CENSOMONITORMOCODIGO,t7.MONOMBRE CENSOMONITORMONOMBRE,t5.TFPCODIGO FORMAPRESENTACIONTFPCODIGO, t5.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE,t5.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE,t5.TFPCONSULTAS FORMAPRESENTFPCONSULTAS,t5.TFPSOLICITUDES FORMAPRESENTFPSOLICITUDES,t5.TFPARBITRAJES FORMAPRESENTFPARBITRAJES "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		// COCONSULTAAACCEMPRESAS
		if (consulta != null && consulta.getCoconsultaaaccempresas() != null
				&& Y41bConstantes.VALOR_SI.equals(consulta.getCoconsultaaaccempresas())) {
			where.append(" AND UPPER(t1.COCONSULTAAACCEMPRESAS) = ?");
			params.add(Y41bConstantes.VALOR_SI);
			where.append(" AND t1.COCONSULTAAACCEMPRESAS IS NOT NULL");
		} else if (consulta != null && consulta.getCoconsultaaaccempresas() != null
				&& Y41bConstantes.CONSULTAS_ACCESO_DESDE_TODOS.equals(consulta.getCoconsultaaaccempresas())) {
			// Se muestran todas las consultas de consumidor y empresa
		} else {
			where.append(" AND t1.COCONSULTAAACCEMPRESAS IS NULL");
		}

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		// if (consulta != null && consulta.getRangoEdad() != null
		// && consulta.getRangoEdad().getRandesc() != null) {
		// where.append(" AND t4.RANDESC = ?");
		// params.add(consulta.getRangoEdad().getRandesc());
		// }
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}

		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.COCOOR = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.COTEXTO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCotexto().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCotexto().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.COTEXTO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.CONOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CONOCO IS NOT NULL");
		}

		// NIF
		if (consulta != null && consulta.getCocif() != null) {
			where.append(" AND UPPER(t1.COCIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocif().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocif().toUpperCase() + "%");
			}
			where.append(" AND t1.COCIF IS NOT NULL ");
		}

		// Razn social/nombre comercial
		if (consulta != null && consulta.getCorazonsocial() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.CORAZONSOCIAL),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CORAZONSOCIAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.CONOMBRECOMERCIAL),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CONOMBRECOMERCIAL IS NOT NULL)) ");
		}

		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND (t1.COINL37 = ?");
			params.add(consulta.getCoinl37());

			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" OR t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
			where.append(" ) ");
		}
		if (consulta != null && consulta.getCoinl37() == null) {
			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" AND t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		// Extranjero
		if (consulta != null && consulta.getCoextranjero() != null && consulta.getCoestado() == null) {
			where.append(" AND t1.COEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}

		// Estado
		if (consulta != null && consulta.getCoestado() != null && consulta.getCoextranjero() == null) {
			where.append(" AND t1.COEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}

		if (consulta != null && consulta.getCosituacion() != null) {
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_PENDIENTES)) {
				where.append(" AND t1.COSITUACION = ?");
				params.add(consulta.getCosituacion());
			}
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_RESUELTAS)) {
				where.append(" AND t1.COSITUACION = ?");
				params.add(consulta.getCosituacion());
			}
		}

		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}

		// Direccion extranjera
		if (consulta != null && consulta.getDireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getDireccion_nocapv().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getDireccion_nocapv().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null && fechaDesde instanceof Date) {
			where.append(" AND t1.COFECHA >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null && fechaHasta instanceof Date) {
			where.append(" AND t1.COFECHA <= ?");
			params.add(fechaHasta);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Consulta>) this.jdbcTemplate.query(query.toString(), new RowMapper<Consulta>() {
			public Consulta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Consulta(resultSet.getString("COCODIGO"), null,
						new Producto(resultSet.getString("ProductoPSCODIGO"), resultSet.getString("ProductoPSNOMBRE"),
								null, null, null, resultSet.getString("ProductoPSNOMBREE"), null, null, null, null,
								null, null, null, null, null, null, null, null, null, null),
						null,
						new FormaPresentacion(resultSet.getString("FormaPresentacionTFPCODIGO"),
								resultSet.getString("FormaPresentacionTFPNOMBRE"),
								resultSet.getString("FormaPresentacionTFPNOMBREE"), null, null, null,
								resultSet.getString("FormaPresenTFPCONSULTAS"),
								resultSet.getString("FormaPresenTFPSOLICITUDES"),
								resultSet.getString("FormaPresenTFPARBITRAJES")),
						new Organismo(resultSet.getString("OrganismoCODORG"), null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null, null, null, null),
						new CensoMonitor(resultSet.getString("CensoMonitorMOCODIGO"),
								resultSet.getString("CensoMonitorMONOMBRE"), null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null, null, null, null, null, null),
						resultSet.getDate("COFECHA"), null, null, null, null, resultSet.getInt("CONRREG"), null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null,
						resultSet.getString("COINL37"), resultSet.getLong("CONRANRG"), null, null, null, null, null,
						null, null, null, resultSet.getString("NORAMUNICIPIOID"),
						resultSet.getString("NOMBREMUNICIPIO"), null, null, null, null, null, null, null, null, null,
						resultSet.getString("COSITUACION"), null, null, null, null, null, null, null,
						resultSet.getString("CONOMBRECOMERCIAL"), null, null);
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeConsultaCount(Consulta consulta, Boolean startsWith, Date fechaDesde, Date fechaHasta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,FORMA_PRESENTACION t5  ,CENSO_MONITOR t7 ");

		// COCONSULTAAACCEMPRESAS
		if (consulta != null && consulta.getCoconsultaaaccempresas() != null
				&& Y41bConstantes.VALOR_SI.equals(consulta.getCoconsultaaaccempresas())) {
			where.append(" AND UPPER(t1.COCONSULTAAACCEMPRESAS) = ?");
			params.add(Y41bConstantes.VALOR_SI);
			where.append(" AND t1.COCONSULTAAACCEMPRESAS IS NOT NULL");
		} else if (consulta != null && consulta.getCoconsultaaaccempresas() != null
				&& Y41bConstantes.CONSULTAS_ACCESO_DESDE_TODOS.equals(consulta.getCoconsultaaaccempresas())) {
			// Se muestran todas las consultas de consumidor y empresa
		} else {
			where.append(" AND t1.COCONSULTAAACCEMPRESAS IS NULL");
		}

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		// if (consulta != null && consulta.getRangoEdad() != null
		// && consulta.getRangoEdad().getRandesc() != null) {
		// where.append(" AND t4.RANDESC = ?");
		// params.add(consulta.getRangoEdad().getRandesc());
		// }
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}

		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.COCOOR = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.COTEXTO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCotexto().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCotexto().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.COTEXTO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.CONOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getConoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CONOCO IS NOT NULL");
		}

		// NIF
		if (consulta != null && consulta.getCocif() != null) {
			where.append(" AND UPPER(t1.COCIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCocif().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCocif().toUpperCase() + "%");
			}
			where.append(" AND t1.COCIF IS NOT NULL ");
		}

		// Razn social/nombre comercial
		if (consulta != null && consulta.getCorazonsocial() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.CORAZONSOCIAL),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CORAZONSOCIAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.CONOMBRECOMERCIAL),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getCorazonsocial().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.CONOMBRECOMERCIAL IS NOT NULL)) ");
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND (t1.COINL37 = ?");
			params.add(consulta.getCoinl37());

			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" OR t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
			where.append(" ) ");
		}
		if (consulta != null && consulta.getCoinl37() == null) {
			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" AND t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		// Extranjero
		if (consulta != null && consulta.getCoextranjero() != null && consulta.getCoestado() == null) {
			where.append(" AND t1.COEXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}

		// Estado
		if (consulta != null && consulta.getCoestado() != null && consulta.getCoextranjero() == null) {
			where.append(" AND t1.COEXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}

		if (consulta != null && consulta.getCosituacion() != null) {
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_PENDIENTES)) {
				where.append(" AND t1.COSITUACION = ?");
				params.add(consulta.getCosituacion());
			}
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_RESUELTAS)) {
				where.append(" AND t1.COSITUACION = ?");
				params.add(consulta.getCosituacion());
			}
		}

		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}

		// Direccion extranjera
		if (consulta != null && consulta.getDireccion_nocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getDireccion_nocapv().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + consulta.getDireccion_nocapv().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null && fechaDesde instanceof Date) {
			where.append(" AND t1.COFECHA >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null && fechaHasta instanceof Date) {
			where.append(" AND t1.COFECHA <= ?");
			params.add(fechaHasta);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoConsultaDetalle> findAllDocumentosConsulta(Consulta consulta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.COFILE COFILE, t1.COCODIGO COCODIGO, t1.TIPOFILE TIPOFILE, t1.FECHA FECHA, t1.NOFILE NOFILE, t1.SIZEFILE SIZEFILE, t1.TEDESFILE TEDESFILE, t1.CONTENTTYPEFILE CONTENTTYPEFILE, t1.ORIGEN ORIGEN, t1.INEMLUSU INEMLUSU, t1.P9CODIGO P9CODIGO "
						+ "FROM Y41b01V00 t1 ");

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<DocumentoConsultaDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoConsultaDetalle>() {
					public DocumentoConsultaDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new DocumentoConsultaDetalle(resultSet.getLong("COFILE"),
								resultSet.getString("COCODIGO"), resultSet.getString("P9CODIGO"),
								resultSet.getString("TIPOFILE"), resultSet.getDate("FECHA"),
								resultSet.getString("NOFILE"), null, resultSet.getInt("SIZEFILE"),
								resultSet.getString("TEDESFILE"), resultSet.getString("CONTENTTYPEFILE"),
								resultSet.getString("ORIGEN"), resultSet.getString("INEMLUSU"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosConsultaCount(Consulta consulta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM Y41b01V00 t1 ");

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasKontsumonetResultado> findAllConsultaEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.COCOOR = t2.COD_ORG ");

		StringBuffer query = new StringBuffer(
				"SELECT COD_ORG, NOMBRE_ES, NOMBRE_EU, COUNT(*) NUMRECLAMACIONES " + "FROM CONSULTA t1, ORGANISMO t2 ");

		where.append(" AND t1.CONRANRG = ? ");
		params.add(estadisticasKontsumonetBusqueda.getAnyo());

		where.append(" GROUP BY COD_ORG, NOMBRE_ES, NOMBRE_EU ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY NOMBRE_ES, NOMBRE_EU ");
			query.append(order);
		}

		return (List<EstadisticasKontsumonetResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasKontsumonetResultado>() {
					public EstadisticasKontsumonetResultado mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new EstadisticasKontsumonetResultado(null, resultSet.getString("COD_ORG"),
								resultSet.getString("NOMBRE_ES"), resultSet.getString("NOMBRE_EU"),
								resultSet.getBigDecimal("NUMRECLAMACIONES"), null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaFormaPresentacion(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT NVL(t1.NOMBRE_MUNICIPIO,'INDEF') AS COLUMNAS, count(*)  AS TOTAL, NVL(t5.TFPNOMBRE,'INDEF') AS FILAS, NVL(t5.TFPNOMBREE,'INDEF') AS FILASE "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(
				" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,'INDEF'), NVL(t5.TFPNOMBRE,'INDEF'), NVL(t5.TFPNOMBREE,'INDEF') ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(
					" ORDER BY  NVL(t5.TFPNOMBRE,'INDEF'), NVL(t5.TFPNOMBREE,'INDEF'),NVL(t1.NOMBRE_MUNICIPIO,'INDEF') ");
			query.append(order);
		}

		return (List<EstadisticasConsultasResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasResultado>() {
					public EstadisticasConsultasResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstadisticasConsultasResultado(resultSet.getString("FILAS"),
								resultSet.getString("FILASE"), null, null, resultSet.getString("COLUMNAS"),
								resultSet.getBigDecimal("TOTAL"));
					}
				}, params.toArray());
	}

	/**
	 * Obtain the where in estadisticas consultas.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param params
	 *            List
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return String
	 */

	private static String getWhereEstadisticasConsultas(Consulta consulta, List<Object> params, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {

		StringBuffer where = new StringBuffer(3000);

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null && consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}

		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null && consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null && consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		// if (consulta != null && consulta.getRangoEdad() != null
		// && consulta.getRangoEdad().getRandesc() != null) {
		// where.append(" AND t4.RANDESC = ?");
		// params.add(consulta.getRangoEdad().getRandesc());
		// }
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}

		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null && consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.COCOOR = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null && consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND UPPER(t1.COTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCotexto().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getCotexto().toUpperCase() + "%");
			}
			where.append(" AND t1.COTEXTO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND UPPER(t1.CONOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoco().toUpperCase() + "%");
			} else {
				params.add("%" + consulta.getConoco().toUpperCase() + "%");
			}
			where.append(" AND t1.CONOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND (t1.COINL37 = ?");
			params.add(consulta.getCoinl37());

			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" OR t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
			where.append(" ) ");
		}
		if (consulta != null && consulta.getCoinl37() == null) {
			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" AND t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}

		if (consulta != null && consulta.getCosituacion() != null) {
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_PENDIENTES)) {
				where.append(" AND COFERES IS NULL ");
			}
			if (consulta.getCosituacion().equals(Y41bConstantes.SITUACION_RESUELTAS)) {
				where.append(" AND COFERES IS NOT NULL ");
			}
		}

		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null && fechaDesde instanceof Date) {
			where.append(" AND t1.COFECHA >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null && fechaHasta instanceof Date) {
			where.append(" AND t1.COFECHA <= ?");
			params.add(fechaHasta);
		}

		return where.toString();
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaMotivosProductos(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT NVL(t1.NOMBRE_MUNICIPIO,'INDEF') AS COLUMNAS, count(*)  AS TOTAL, NVL(t2.TIRNOMBRE,'INDEF') AS FILAS2, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(
				" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,'INDEF'), NVL(t2.TIRNOMBRE,'INDEF'),NVL(t3.PSNOMBRE,'INDEF'),NVL(t3.PSNOMBREE,'INDEF') ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(
					" ORDER BY NVL(t3.PSNOMBRE,'INDEF'),NVL(t3.PSNOMBREE,'INDEF'),NVL(t2.TIRNOMBRE,'INDEF'),NVL(t1.NOMBRE_MUNICIPIO,'INDEF') ");
			query.append(order);
		}

		return (List<EstadisticasConsultasResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasResultado>() {
					public EstadisticasConsultasResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstadisticasConsultasResultado(resultSet.getString("FILAS"),
								resultSet.getString("FILASE"), resultSet.getString("FILAS2"), null,
								resultSet.getString("COLUMNAS"), resultSet.getBigDecimal("TOTAL"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaProductoServicio(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT NVL(t1.NOMBRE_MUNICIPIO,'INDEF') AS COLUMNAS, count(*)  AS TOTAL, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(
				" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,'INDEF'), NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF') ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(
					" ORDER BY NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF'),NVL(t1.NOMBRE_MUNICIPIO,'INDEF') ");
			query.append(order);
		}

		return (List<EstadisticasConsultasResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasResultado>() {
					public EstadisticasConsultasResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstadisticasConsultasResultado(resultSet.getString("FILAS"),
								resultSet.getString("FILASE"), null, null, resultSet.getString("COLUMNAS"),
								resultSet.getBigDecimal("TOTAL"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaSexoEdad(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT NVL(RANDESC,'Indefinido') AS FILAS,  decode(cocosx,'H','H',decode(cocosx,'M','M','Indefinido')) AS COLUMNAS,  count(*) AS TOTAL "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(" GROUP BY RANDESC,cocosx ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY NVL(RANDESC,'Indefinido') ");
			query.append(order);
		}

		return (List<EstadisticasConsultasResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasResultado>() {
					public EstadisticasConsultasResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstadisticasConsultasResultado(resultSet.getString("FILAS"), null, null, null,
								resultSet.getString("COLUMNAS"), resultSet.getBigDecimal("TOTAL"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT NVL(t1.NOMBRE_MUNICIPIO,'INDEF') AS COLUMNAS, NVL(ROUND(AVG(COFERES - COFECHA), 0),0) AS TOTAL, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE "
						+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(
				" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,'INDEF'), NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF') ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(
					" ORDER BY NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF'), NVL(t1.NOMBRE_MUNICIPIO,'INDEF') ");
			query.append(order);
		}

		return (List<EstadisticasConsultasResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasResultado>() {
					public EstadisticasConsultasResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstadisticasConsultasResultado(resultSet.getString("FILAS"),
								resultSet.getString("FILASE"), null, null, resultSet.getString("COLUMNAS"),
								resultSet.getBigDecimal("TOTAL"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
			Consulta consulta, Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, FECHACONSULTA, HORA_CONSULTA, HORACONSUMIDOR, SEXO, PRODUCTO, PRODUCTOE, NVL(ROUND(DEMORA,0),0) AS DEMORA, NVL(TRUNC(DEMORA/60),0) AS HORAS, NVL(ROUND(DEMORA-((TRUNC(DEMORA/60))*60),0),0) AS MINUTOS ");
		query.append(
				" FROM (SELECT COCOOR, CONRREG, CONRANRG, COFECHA AS FECHACONSULTA, COHORA AS HORA_CONSULTA, TO_CHAR(COFECHACONSUMIDOR, 'hh24:mi') AS HORACONSUMIDOR, COCOSX AS SEXO, t3.PSNOMBRE AS PRODUCTO, t3.PSNOMBREE AS PRODUCTOE, (TO_DATE(TO_CHAR(COFECHA, 'DD/MM/YYYY') || ' ' || COHORA,'DD/MM/YYYY hh24:mi')-COFECHACONSUMIDOR)*24*60 AS DEMORA");
		query.append(
				" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(" AND COCOTFP= ?");
		params.add(Y41bConstantes.FORMA_PRESENTACION_PRESENCIAL);

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		where.append(" ) ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
			query.append(order);
		}

		return (List<EstadisticasConsultasTiempoAtencion>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasTiempoAtencion>() {
					public EstadisticasConsultasTiempoAtencion mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new EstadisticasConsultasTiempoAtencion(resultSet.getString("NUMERO_CONSULTA"),
								resultSet.getDate("FECHACONSULTA"), resultSet.getString("HORA_CONSULTA"),
								resultSet.getString("HORACONSUMIDOR"), null, resultSet.getString("SEXO"),
								resultSet.getString("PRODUCTO"), resultSet.getString("PRODUCTOE"),
								resultSet.getBigDecimal("DEMORA"), resultSet.getBigDecimal("HORAS"),
								resultSet.getBigDecimal("MINUTOS"), null);
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
			Consulta consulta, Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, COFECHA AS FECHA_CONSULTA, COFERES AS FECHA_RESPUESTA, COCOSX AS SEXO, PSNOMBRE AS PRODUCTO, PSNOMBREE AS PRODUCTOE, TO_DATE(DECODE(TO_CHAR(COFERES,'DD/MM/YYYY'),'',NULL,COFERES))-COFECHA AS DIAS ");
		query.append(
				" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(" AND COCOTFP IN (?,?) ");
		params.add(Y41bConstantes.FORMA_PRESENTACION_WEB);
		params.add(Y41bConstantes.FORMA_PRESENTACION_FAX);

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
			query.append(order);
		}

		return (List<EstadisticasConsultasTiempoAtencion>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstadisticasConsultasTiempoAtencion>() {
					public EstadisticasConsultasTiempoAtencion mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new EstadisticasConsultasTiempoAtencion(resultSet.getString("NUMERO_CONSULTA"),
								resultSet.getDate("FECHA_CONSULTA"), null, null, resultSet.getDate("FECHA_RESPUESTA"),
								resultSet.getString("SEXO"), resultSet.getString("PRODUCTO"),
								resultSet.getString("PRODUCTOE"), null, null, null, resultSet.getBigDecimal("DIAS"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultas(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COCOOR, CONRREG, CONRANRG, MONOMBRE, COFECHA, COCOSX, RANDESC, TIRNOMBRE, PSNOMBRE, PSNOMBREE, COTEXTO ");
		query.append(
				" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
			query.append(order);
		}

		return (List<ListadoConsultaResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<ListadoConsultaResultado>() {
					public ListadoConsultaResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new ListadoConsultaResultado(null, resultSet.getString("COCOOR"),
								resultSet.getInt("CONRREG"), resultSet.getLong("CONRANRG"),
								resultSet.getString("MONOMBRE"), resultSet.getDate("COFECHA"),
								resultSet.getString("COCOSX"), resultSet.getString("RANDESC"),
								resultSet.getString("PSNOMBRE"), resultSet.getString("PSNOMBREE"),
								resultSet.getString("TIRNOMBRE"), resultSet.getString("COTEXTO"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasAbreviada(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, MONOMBRE, COFECHA, PSNOMBRE, PSNOMBREE, TIRNOMBRE, COTEXTO ");
		query.append(
				" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

		where.append(getWhereEstadisticasConsultas(consulta, params, startsWith, fechaDesde, fechaHasta));

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
			query.append(order);
		}

		return (List<ListadoConsultaResultado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<ListadoConsultaResultado>() {
					public ListadoConsultaResultado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new ListadoConsultaResultado(resultSet.getString("NUMERO_CONSULTA"), null, null, null,
								resultSet.getString("MONOMBRE"), resultSet.getDate("COFECHA"), null, null,
								resultSet.getString("PSNOMBRE"), resultSet.getString("PSNOMBREE"),
								resultSet.getString("TIRNOMBRE"), resultSet.getString("COTEXTO"));
					}
				}, params.toArray());
	}
}