package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.DocumentoConsultaDetalle;
import com.ejie.y41b.model.EstadisticasConsultasResultado;
import com.ejie.y41b.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41b.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41b.model.EstadisticasKontsumonetResultado;
import com.ejie.y41b.model.ListadoConsultaResultado;

/**
 * * ConsultaDao  
 * 
 *  
 */

public interface ConsultaDao {

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta add(Consulta consulta);

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta addConsulta(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta update(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	Consulta updateRespuesta(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	Consulta updateRespuestaMail(Consulta consulta);

	/**
	 * Finds a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta find(Consulta consulta);

	/**
	 * Deletes a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void remove(Consulta consulta);

	/**
	 * Finds a List of rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Consulta> findAll(Consulta consulta, Pagination pagination);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return List
	 */
	Long findAllCount(Consulta consulta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consulta> findAllLike(Consulta consulta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<Consulta> findAllLikeConsulta(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde,
			Date fechaHasta);

	/**
	 * Counts rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	Long findAllLikeConsultaCount(Consulta consulta, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoConsultaDetalle> findAllDocumentosConsulta(Consulta consulta,
			Pagination pagination);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	Long findAllDocumentosConsultaCount(Consulta consulta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstadisticasKontsumonetResultado> findAllConsultaEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaFormaPresentacion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaMotivosProductos(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaProductoServicio(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaSexoEdad(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultas(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasAbreviada(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);
}
