package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.model.Tipoconceptopago;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * ConceptopagoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ConceptopagoDaoImpl implements ConceptopagoDao {

	/**
	 * StringBuilder initialization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private JdbcTemplate jdbcTemplate;
	private RowMapper<Conceptopago> rwMap = new RowMapper<Conceptopago>() {
		@Override()
		public Conceptopago mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Conceptopago(resultSet.getString("SDCODIGO"), resultSet.getString("SDDESCES"),
					resultSet.getString("SDDESDEU"), resultSet.getBigDecimal("SDTASAPRES"),
					resultSet.getBigDecimal("SDTASATELE"), resultSet.getInt("SDDIASLIMITE"),
					resultSet.getString("SDAPLICPRESUP"), resultSet.getString("SDAPLICPRESUP01"),
					resultSet.getString("SDAPLICPRESUP20"), resultSet.getString("SDAPLICPRESUP48"),
					resultSet.getString("SDAPLICPRESUPFRAC"), resultSet.getString("SDELEMENTOPEP"),
					resultSet.getString("SDELEMENTOPEP01"), resultSet.getString("SDELEMENTOPEP20"),
					resultSet.getString("SDELEMENTOPEP48"), resultSet.getInt("SDCONCEPTOING"),
					resultSet.getInt("SDCONCEPTOINGFRAC"), resultSet.getString("SDENTEMISORA"),
					resultSet.getString("SDENTEMISORASIPCA"), resultSet.getLong("SDSUFIJO"),
					resultSet.getLong("SDEJERCICIO"), resultSet.getDate("SDFECHABAJA"),
					new Tipoconceptopago(resultSet.getString("TipoconceptopagoSCCODIGO"),
							resultSet.getString("TipoconceptopagoSCDESCES"), resultSet
									.getString("TipoconceptopagoSCDESCEU"),
							new Claseingreso(resultSet.getString("TipoconceptopagoSCCLASE"), null, null)));
		}
	};

	private RowMapper<Conceptopago> rwMapEjercicio = new RowMapper<Conceptopago>() {
		@Override()
		public Conceptopago mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Conceptopago cp = new Conceptopago();
			cp.setSdejercicio(resultSet.getLong("SDEJERCICIO"));
			return cp;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Pagination
	 * @return Conceptopago
	 */
	@Override()
	public Conceptopago add(Conceptopago conceptopago) {
		String query = "INSERT INTO CONCEPTOPAGO (SDCODIGO, SDTIPOCONCEPT, SDDESCES, SDDESDEU, SDTASAPRES, SDTASATELE, SDDIASLIMITE, SDAPLICPRESUP, SDAPLICPRESUP01, SDAPLICPRESUP20, SDAPLICPRESUP48, SDAPLICPRESUPFRAC, SDELEMENTOPEP, SDELEMENTOPEP01, SDELEMENTOPEP20, SDELEMENTOPEP48, SDCONCEPTOING, SDCONCEPTOINGFRAC, SDENTEMISORA, SDENTEMISORASIPCA, SDSUFIJO, SDEJERCICIO, SDFECHABAJA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTipoconceptopagoSccodigoAux = null;
		if (conceptopago.getTipoconceptopago() != null && conceptopago.getTipoconceptopago().getSccodigo() != null) {
			getTipoconceptopagoSccodigoAux = conceptopago.getTipoconceptopago().getSccodigo();
		}
		boolean soloUnaPartida = Y41bModuloUtils.getInstance().mostrarADOEIKA()
				&& conceptopago.getSdejercicio() >= Y41bModuloUtils.getInstance().anyoFechaADOEIKA();
		this.jdbcTemplate.update(query, conceptopago.getSdcodigo(), getTipoconceptopagoSccodigoAux,
				conceptopago.getSddesces(), conceptopago.getSddesdeu(), conceptopago.getSdtasapres(),
				conceptopago.getSdtasatele(), conceptopago.getSddiaslimite(), conceptopago.getSdaplicpresup(),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup01()),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup20()),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup48()),
				conceptopago.getSdaplicpresupfrac(), conceptopago.getSdelementoPEP(),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP01()),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP20()),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP48()),
				conceptopago.getSdconceptoing(), conceptopago.getSdconceptoingfrac(), conceptopago.getSdentemisora(),
				conceptopago.getSdentemisorasipca(), conceptopago.getSdsufijo(), conceptopago.getSdejercicio(),
				conceptopago.getSdfechabaja());
		return conceptopago;
	}

	/**
	 * Updates a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Pagination
	 * @return Conceptopago
	 */
	@Override()
	public Conceptopago update(Conceptopago conceptopago) {
		String query = "UPDATE CONCEPTOPAGO SET SDTIPOCONCEPT=?, SDDESCES=?, SDDESDEU=?, SDTASAPRES=?, SDTASATELE=?, SDDIASLIMITE=?, SDAPLICPRESUP=?, SDAPLICPRESUP01=?, SDAPLICPRESUP20=?, SDAPLICPRESUP48=?, SDAPLICPRESUPFRAC=?, SDELEMENTOPEP=?, SDELEMENTOPEP01=?, SDELEMENTOPEP20=?, SDELEMENTOPEP48=?, SDCONCEPTOING=?, SDCONCEPTOINGFRAC=?, SDENTEMISORA=?, SDENTEMISORASIPCA=?, SDSUFIJO=?, SDEJERCICIO=?, SDFECHABAJA=? WHERE SDCODIGO=?";
		Object getTipoconceptopagoSccodigoAux = null;
		if (conceptopago.getTipoconceptopago() != null && conceptopago.getTipoconceptopago().getSccodigo() != null) {
			getTipoconceptopagoSccodigoAux = conceptopago.getTipoconceptopago().getSccodigo();
		}
		boolean soloUnaPartida = Y41bModuloUtils.getInstance().mostrarADOEIKA()
				&& conceptopago.getSdejercicio() >= Y41bModuloUtils.getInstance().anyoFechaADOEIKA();
		this.jdbcTemplate.update(query, getTipoconceptopagoSccodigoAux, conceptopago.getSddesces(),
				conceptopago.getSddesdeu(), conceptopago.getSdtasapres(), conceptopago.getSdtasatele(),
				conceptopago.getSddiaslimite(), conceptopago.getSdaplicpresup(),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup01()),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup20()),
				(soloUnaPartida ? conceptopago.getSdaplicpresup() : conceptopago.getSdaplicpresup48()),
				conceptopago.getSdaplicpresupfrac(), conceptopago.getSdelementoPEP(),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP01()),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP20()),
				(soloUnaPartida ? conceptopago.getSdelementoPEP() : conceptopago.getSdelementoPEP48()),
				conceptopago.getSdconceptoing(), conceptopago.getSdconceptoingfrac(), conceptopago.getSdentemisora(),
				conceptopago.getSdentemisorasipca(), conceptopago.getSdsufijo(), conceptopago.getSdejercicio(),
				conceptopago.getSdfechabaja(), conceptopago.getSdcodigo());
		return conceptopago;
	}

	/**
	 * Finds a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Pagination
	 * @return Conceptopago
	 */
	@Transactional(readOnly = true)
	@Override()
	public Conceptopago find(Conceptopago conceptopago) {
		String query = "SELECT t1.SDCODIGO SDCODIGO, t1.SDDESCES SDDESCES, t1.SDDESDEU SDDESDEU, t1.SDTASAPRES SDTASAPRES, t1.SDTASATELE SDTASATELE, t1.SDDIASLIMITE SDDIASLIMITE, t1.SDAPLICPRESUP SDAPLICPRESUP, t1.SDAPLICPRESUP01 SDAPLICPRESUP01, t1.SDAPLICPRESUP20 SDAPLICPRESUP20, t1.SDAPLICPRESUP48 SDAPLICPRESUP48, t1.SDAPLICPRESUPFRAC SDAPLICPRESUPFRAC, t1.SDELEMENTOPEP SDELEMENTOPEP, t1.SDELEMENTOPEP01 SDELEMENTOPEP01, t1.SDELEMENTOPEP20 SDELEMENTOPEP20, t1.SDELEMENTOPEP48 SDELEMENTOPEP48, t1.SDCONCEPTOING SDCONCEPTOING, t1.SDCONCEPTOINGFRAC SDCONCEPTOINGFRAC, t1.SDENTEMISORA SDENTEMISORA, t1.SDENTEMISORASIPCA SDENTEMISORASIPCA, t1.SDSUFIJO SDSUFIJO, t1.SDEJERCICIO SDEJERCICIO, t1.SDFECHABAJA SDFECHABAJA, t2.SCCODIGO TIPOCONCEPTOPAGOSCCODIGO, t2.SCDESCES TIPOCONCEPTOPAGOSCDESCES, t2.SCDESCEU TIPOCONCEPTOPAGOSCDESCEU, t2.SCCLASE TIPOCONCEPTOPAGOSCCLASE FROM CONCEPTOPAGO t1 , TIPOCONCEPTOPAGO t2 ";

		query += " WHERE t1.SDCODIGO = ? AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+)";
		String where = conceptopago.getSdcodigo();

		List<Conceptopago> conceptopagoList = this.jdbcTemplate.query(query, this.rwMap, where);
		return DataAccessUtils.uniqueResult(conceptopagoList);
	}

	/**
	 * Removes a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Pagination
	 * @return
	 */
	@Override()
	public void remove(Conceptopago conceptopago) {
		String query = "DELETE FROM CONCEPTOPAGO WHERE SDCODIGO=?";
		this.jdbcTemplate.update(query, conceptopago.getSdcodigo());
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Conceptopago> findAll(Conceptopago conceptopago, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SDCODIGO SDCODIGO,t1.SDDESCES SDDESCES,NVL(t1.SDDESDEU,t1.SDDESCES) SDDESDEU,t1.SDTASAPRES SDTASAPRES,t1.SDTASATELE SDTASATELE,t1.SDDIASLIMITE SDDIASLIMITE,t1.SDAPLICPRESUP SDAPLICPRESUP,t1.SDAPLICPRESUP01 SDAPLICPRESUP01,t1.SDAPLICPRESUP20 SDAPLICPRESUP20,t1.SDAPLICPRESUP48 SDAPLICPRESUP48,t1.SDAPLICPRESUPFRAC SDAPLICPRESUPFRAC,t1.SDELEMENTOPEP SDELEMENTOPEP,t1.SDELEMENTOPEP01 SDELEMENTOPEP01,t1.SDELEMENTOPEP20 SDELEMENTOPEP20,t1.SDELEMENTOPEP48 SDELEMENTOPEP48,t1.SDCONCEPTOING SDCONCEPTOING,t1.SDCONCEPTOINGFRAC SDCONCEPTOINGFRAC,t1.SDENTEMISORA SDENTEMISORA,t1.SDENTEMISORASIPCA SDENTEMISORASIPCA,t1.SDSUFIJO SDSUFIJO,t1.SDEJERCICIO SDEJERCICIO,t1.SDFECHABAJA SDFECHABAJA,t2.SCCODIGO TIPOCONCEPTOPAGOSCCODIGO,t2.SCDESCES TIPOCONCEPTOPAGOSCDESCES,t2.SCDESCEU TIPOCONCEPTOPAGOSCDESCEU, t2.SCCLASE TIPOCONCEPTOPAGOSCCLASE  ");
		query.append("FROM CONCEPTOPAGO t1 ,TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(conceptopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@Override()
	public Long findAllCount(Conceptopago conceptopago) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CONCEPTOPAGO t1 , TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(conceptopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Conceptopago> findAllLike(Conceptopago conceptopago, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SDCODIGO SDCODIGO,t1.SDDESCES SDDESCES,NVL(t1.SDDESDEU,t1.SDDESCES) SDDESDEU,t1.SDTASAPRES SDTASAPRES,t1.SDTASATELE SDTASATELE,t1.SDDIASLIMITE SDDIASLIMITE,t1.SDAPLICPRESUP SDAPLICPRESUP,t1.SDAPLICPRESUP01 SDAPLICPRESUP01,t1.SDAPLICPRESUP20 SDAPLICPRESUP20,t1.SDAPLICPRESUP48 SDAPLICPRESUP48,t1.SDAPLICPRESUPFRAC SDAPLICPRESUPFRAC,t1.SDELEMENTOPEP SDELEMENTOPEP,t1.SDELEMENTOPEP01 SDELEMENTOPEP01,t1.SDELEMENTOPEP20 SDELEMENTOPEP20,t1.SDELEMENTOPEP48 SDELEMENTOPEP48,t1.SDCONCEPTOING SDCONCEPTOING,t1.SDCONCEPTOINGFRAC SDCONCEPTOINGFRAC,t1.SDENTEMISORA SDENTEMISORA,t1.SDENTEMISORASIPCA SDENTEMISORASIPCA,t1.SDSUFIJO SDSUFIJO,t1.SDEJERCICIO SDEJERCICIO,t1.SDFECHABAJA SDFECHABAJA,t2.SCCODIGO TIPOCONCEPTOPAGOSCCODIGO,t2.SCDESCES TIPOCONCEPTOPAGOSCDESCES,t2.SCDESCEU TIPOCONCEPTOPAGOSCDESCEU, t2.SCCLASE TIPOCONCEPTOPAGOSCCLASE  ");
		query.append("FROM CONCEPTOPAGO t1 ,TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(conceptopago, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Conceptopago table using like.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@Override()
	public Long findAllLikeCount(Conceptopago conceptopago, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CONCEPTOPAGO t1 ,TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(conceptopago, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Conceptopago entity
	 * 
	 * @param conceptopago
	 *            Conceptopago Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	private Map<String, ?> getWhereMap(Conceptopago conceptopago) {

		StringBuilder where = new StringBuilder(ConceptopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (conceptopago != null && conceptopago.getSdcodigo() != null) {
			where.append(" AND t1.SDCODIGO = ?");
			params.add(conceptopago.getSdcodigo());
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getSccodigo() != null) {
			where.append(" AND t2.SCCODIGO = ?");
			params.add(conceptopago.getTipoconceptopago().getSccodigo());
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getScdesces() != null) {
			where.append(" AND t2.SCDESCES = ?");
			params.add(conceptopago.getTipoconceptopago().getScdesces());
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getScdesceu() != null) {
			where.append(" AND t2.SCDESCEU = ?");
			params.add(conceptopago.getTipoconceptopago().getScdesceu());
		}
		if (conceptopago != null && conceptopago.getSddesces() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.SDDESCES),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + conceptopago.getSddesces().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.SDDESCES IS NOT NULL ");
		}
		if (conceptopago != null && conceptopago.getSddesdeu() != null) {
			where.append(" AND t1.SDDESDEU = ?");
			params.add(conceptopago.getSddesdeu());

			where.append(" AND UPPER(t1.SDDESDEU) like ? ESCAPE  '\\'");
			params.add("%" + conceptopago.getTipoconceptopago().getScdesceu().toUpperCase() + "%");
			where.append(" AND t1.SDDESDEU IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdtasapres() != null) {
			where.append(" AND t1.SDTASAPRES = ?");
			params.add(conceptopago.getSdtasapres());
		}
		if (conceptopago != null && conceptopago.getSdtasatele() != null) {
			where.append(" AND t1.SDTASATELE = ?");
			params.add(conceptopago.getSdtasatele());
		}
		if (conceptopago != null && conceptopago.getSddiaslimite() != null) {
			where.append(" AND t1.SDDIASLIMITE = ?");
			params.add(conceptopago.getSddiaslimite());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup() != null) {
			where.append(" AND t1.SDAPLICPRESUP = ?");
			params.add(conceptopago.getSdaplicpresup());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup01() != null) {
			where.append(" AND t1.SDAPLICPRESUP01 = ?");
			params.add(conceptopago.getSdaplicpresup01());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup20() != null) {
			where.append(" AND t1.SDAPLICPRESUP20 = ?");
			params.add(conceptopago.getSdaplicpresup20());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup48() != null) {
			where.append(" AND t1.SDAPLICPRESUP48 = ?");
			params.add(conceptopago.getSdaplicpresup48());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresupfrac() != null) {
			where.append(" AND t1.SDAPLICPRESUPFRAC = ?");
			params.add(conceptopago.getSdaplicpresupfrac());
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP() != null) {
			where.append(" AND t1.SDELEMENTOPEP = ?");
			params.add(conceptopago.getSdelementoPEP());
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP01() != null) {
			where.append(" AND t1.SDELEMENTOPEP01 = ?");
			params.add(conceptopago.getSdelementoPEP01());
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP20() != null) {
			where.append(" AND t1.SDELEMENTOPEP20 = ?");
			params.add(conceptopago.getSdelementoPEP20());
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP48() != null) {
			where.append(" AND t1.SDELEMENTOPEP48 = ?");
			params.add(conceptopago.getSdelementoPEP48());
		}
		if (conceptopago != null && conceptopago.getSdconceptoing() != null) {
			where.append(" AND t1.SDCONCEPTOING = ?");
			params.add(conceptopago.getSdconceptoing());
		}
		if (conceptopago != null && conceptopago.getSdconceptoingfrac() != null) {
			where.append(" AND t1.SDCONCEPTOINGFRAC = ?");
			params.add(conceptopago.getSdconceptoingfrac());
		}
		if (conceptopago != null && conceptopago.getSdentemisora() != null) {
			where.append(" AND t1.SDENTEMISORA = ?");
			params.add(conceptopago.getSdentemisora());
		}
		if (conceptopago != null && conceptopago.getSdentemisorasipca() != null) {
			where.append(" AND t1.SDENTEMISORASIPCA = ?");
			params.add(conceptopago.getSdentemisorasipca());
		}
		if (conceptopago != null && conceptopago.getSdsufijo() != null) {
			where.append(" AND t1.SDSUFIJO = ?");
			params.add(conceptopago.getSdsufijo());
		}
		if (conceptopago != null && conceptopago.getSdejercicio() != null) {
			where.append(" AND t1.SDEJERCICIO = ?");
			params.add(conceptopago.getSdejercicio());
		}
		if (conceptopago != null && conceptopago.getSdfechabaja() != null) {
			where.append(" AND t1.SDFECHABAJA = ?");
			params.add(conceptopago.getSdfechabaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Conceptopago entity
	 * 
	 * @param conceptopago
	 *            Conceptopago Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Conceptopago conceptopago, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ConceptopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (conceptopago != null && conceptopago.getSdcodigo() != null) {
			where.append(" AND UPPER(t1.SDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SDCODIGO IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getSccodigo() != null) {
			where.append(" AND t2.SCCODIGO = ?");
			params.add(conceptopago.getTipoconceptopago().getSccodigo());
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getScdesces() != null) {
			where.append(" AND UPPER(t2.SCDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getTipoconceptopago().getScdesces().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getTipoconceptopago().getScdesces().toUpperCase() + "%");
			}
			where.append(" AND t2.SCDESCES IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getTipoconceptopago() != null
				&& conceptopago.getTipoconceptopago().getScdesceu() != null) {
			where.append(" AND UPPER(t2.SCDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getTipoconceptopago().getScdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getTipoconceptopago().getScdesceu().toUpperCase() + "%");
			}
			where.append(" AND t2.SCDESCEU IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSddesces() != null) {
			where.append(" AND UPPER(t1.SDDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSddesces().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSddesces().toUpperCase() + "%");
			}
			where.append(" AND t1.SDDESCES IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSddesdeu() != null) {
			where.append(" AND UPPER(t1.SDDESDEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSddesdeu().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSddesdeu().toUpperCase() + "%");
			}
			where.append(" AND t1.SDDESDEU IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdtasapres() != null) {
			where.append(" AND t1.SDTASAPRES = ?");
			params.add(conceptopago.getSdtasapres());
		}
		if (conceptopago != null && conceptopago.getSdtasatele() != null) {
			where.append(" AND t1.SDTASATELE = ?");
			params.add(conceptopago.getSdtasatele());
		}
		if (conceptopago != null && conceptopago.getSddiaslimite() != null) {
			where.append(" AND t1.SDDIASLIMITE = ?");
			params.add(conceptopago.getSddiaslimite());
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup() != null) {
			where.append(" AND UPPER(t1.SDAPLICPRESUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdaplicpresup().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdaplicpresup().toUpperCase() + "%");
			}
			where.append(" AND t1.SDAPLICPRESUP IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup01() != null) {
			where.append(" AND UPPER(t1.SDAPLICPRESUP01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdaplicpresup01().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdaplicpresup01().toUpperCase() + "%");
			}
			where.append(" AND t1.SDAPLICPRESUP01 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup20() != null) {
			where.append(" AND UPPER(t1.SDAPLICPRESUP20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdaplicpresup20().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdaplicpresup20().toUpperCase() + "%");
			}
			where.append(" AND t1.SDAPLICPRESUP20 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdaplicpresup48() != null) {
			where.append(" AND UPPER(t1.SDAPLICPRESUP48) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdaplicpresup48().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdaplicpresup48().toUpperCase() + "%");
			}
			where.append(" AND t1.SDAPLICPRESUP48 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdaplicpresupfrac() != null) {
			where.append(" AND UPPER(t1.SDAPLICPRESUPFRAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdaplicpresupfrac().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdaplicpresupfrac().toUpperCase() + "%");
			}
			where.append(" AND t1.SDAPLICPRESUPFRAC IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP() != null) {
			where.append(" AND UPPER(t1.SDELEMENTOPEP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdelementoPEP().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdelementoPEP().toUpperCase() + "%");
			}
			where.append(" AND t1.SDELEMENTOPEP IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP01() != null) {
			where.append(" AND UPPER(t1.SDELEMENTOPEP01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdelementoPEP01().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdelementoPEP01().toUpperCase() + "%");
			}
			where.append(" AND t1.SDELEMENTOPEP01 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP20() != null) {
			where.append(" AND UPPER(t1.SDELEMENTOPEP20) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdelementoPEP20().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdelementoPEP20().toUpperCase() + "%");
			}
			where.append(" AND t1.SDELEMENTOPEP20 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdelementoPEP48() != null) {
			where.append(" AND UPPER(t1.SDELEMENTOPEP48) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdelementoPEP48().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdelementoPEP48().toUpperCase() + "%");
			}
			where.append(" AND t1.SDELEMENTOPEP48 IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdconceptoing() != null) {
			where.append(" AND t1.SDCONCEPTOING = ?");
			params.add(conceptopago.getSdconceptoing());
		}
		if (conceptopago != null && conceptopago.getSdconceptoingfrac() != null) {
			where.append(" AND t1.SDCONCEPTOINGFRAC = ?");
			params.add(conceptopago.getSdconceptoingfrac());
		}
		if (conceptopago != null && conceptopago.getSdentemisora() != null) {
			where.append(" AND UPPER(t1.SDENTEMISORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdentemisora().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdentemisora().toUpperCase() + "%");
			}
			where.append(" AND t1.SDENTEMISORA IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdentemisorasipca() != null) {
			where.append(" AND UPPER(t1.SDENTEMISORASIPCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(conceptopago.getSdentemisorasipca().toUpperCase() + "%");
			} else {
				params.add("%" + conceptopago.getSdentemisorasipca().toUpperCase() + "%");
			}
			where.append(" AND t1.SDENTEMISORASIPCA IS NOT NULL");
		}
		if (conceptopago != null && conceptopago.getSdsufijo() != null) {
			where.append(" AND t1.SDSUFIJO = ?");
			params.add(conceptopago.getSdsufijo());
		}
		if (conceptopago != null && conceptopago.getSdejercicio() != null) {
			where.append(" AND t1.SDEJERCICIO = ?");
			params.add(conceptopago.getSdejercicio());
		}
		if (conceptopago != null && conceptopago.getSdfechabaja() != null) {
			where.append(" AND t1.SDFECHABAJA = ?");
			params.add(conceptopago.getSdfechabaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Conceptopago> findAllVigentes(Conceptopago conceptopago, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SDCODIGO SDCODIGO,t1.SDDESCES SDDESCES,NVL(t1.SDDESDEU,t1.SDDESCES) SDDESDEU,t1.SDTASAPRES SDTASAPRES,t1.SDTASATELE SDTASATELE,t1.SDDIASLIMITE SDDIASLIMITE,t1.SDAPLICPRESUP SDAPLICPRESUP,t1.SDAPLICPRESUP01 SDAPLICPRESUP01,t1.SDAPLICPRESUP20 SDAPLICPRESUP20,t1.SDAPLICPRESUP48 SDAPLICPRESUP48,t1.SDAPLICPRESUPFRAC SDAPLICPRESUPFRAC,t1.SDELEMENTOPEP SDELEMENTOPEP,t1.SDELEMENTOPEP01 SDELEMENTOPEP01,t1.SDELEMENTOPEP20 SDELEMENTOPEP20,t1.SDELEMENTOPEP48 SDELEMENTOPEP48,t1.SDCONCEPTOING SDCONCEPTOING,t1.SDCONCEPTOINGFRAC SDCONCEPTOINGFRAC,t1.SDENTEMISORA SDENTEMISORA,t1.SDENTEMISORASIPCA SDENTEMISORASIPCA,t1.SDSUFIJO SDSUFIJO,t1.SDEJERCICIO SDEJERCICIO,t1.SDFECHABAJA SDFECHABAJA,t2.SCCODIGO TIPOCONCEPTOPAGOSCCODIGO,t2.SCDESCES TIPOCONCEPTOPAGOSCDESCES,t2.SCDESCEU TIPOCONCEPTOPAGOSCDESCEU,t2.SCCLASE TIPOCONCEPTOPAGOSCCLASE ");
		query.append("FROM CONCEPTOPAGO t1 ,TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(conceptopago);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) AND (t1.SDFECHABAJA IS NULL OR t1.SDFECHABAJA > SYSDATE)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Conceptopago> findAllEjerciciosVigentes(Conceptopago conceptopago, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT t1.SDEJERCICIO ");
		query.append("FROM CONCEPTOPAGO t1, TIPOCONCEPTOPAGO t2 ");

		// Where clause
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) AND (t1.SDFECHABAJA IS NULL OR t1.SDFECHABAJA > SYSDATE) AND t1.SDTIPOCONCEPT<>'"
						+ Y41bConstantes.SANCIONES + "'");
		query.append(where);

		// Order by
		StringBuilder order = new StringBuilder(" ORDER BY t1.SDEJERCICIO DESC");
		query.append(order);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Object> params = new ArrayList<Object>();
		return this.jdbcTemplate.query(query.toString(), this.rwMapEjercicio, params.toArray());
	}

	/**
	 * Finds a List of rows in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 * @param vigente
	 *            boolean
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Conceptopago> findAllEjercicio(Conceptopago conceptopago, Pagination pagination, boolean vigente) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct '' SDCODIGO,'' SDDESCES,'' SDDESDEU,'' SDTASAPRES,'' SDTASATELE,'' SDDIASLIMITE,'' SDAPLICPRESUP,'' SDAPLICPRESUP01,'' SDAPLICPRESUP20,'' SDAPLICPRESUP48,'' SDAPLICPRESUPFRAC,'' SDELEMENTOPEP,'' SDELEMENTOPEP01,'' SDELEMENTOPEP20,'' SDELEMENTOPEP48,'' SDCONCEPTOING,'' SDCONCEPTOINGFRAC,'' SDENTEMISORA,'' SDENTEMISORASIPCA,'' SDSUFIJO,t1.SDEJERCICIO SDEJERCICIO,'' SDFECHABAJA,'' TIPOCONCEPTOPAGOSCCODIGO,'' TIPOCONCEPTOPAGOSCDESCES,'' TIPOCONCEPTOPAGOSCDESCEU, '' TIPOCONCEPTOPAGOSCCLASE  ");
		query.append("FROM CONCEPTOPAGO t1 ,TIPOCONCEPTOPAGO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(conceptopago);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.SDTIPOCONCEPT= t2.SCCODIGO(+) ");

		if (vigente) {
			where.append(" AND (t1.SDFECHABAJA IS NULL OR t1.SDFECHABAJA > SYSDATE) ");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	@Override()
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuilder query = new StringBuilder("SELECT L21SDQ00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Conceptopago table.
	 * 
	 * @param conceptopago
	 *            Conceptopago
	 */
	@Override()
	public void baja(Conceptopago conceptopago) {
		String query = "UPDATE CONCEPTOPAGO SET SDFECHABAJA=SYSDATE WHERE SDEJERCICIO=? AND SDFECHABAJA IS NULL ";

		this.jdbcTemplate.update(query, conceptopago.getSdejercicio());

	}
}
