package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.ComunicacionSoivreRel;

/**
 * ComunicacionSoivreRelDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionSoivreRelDaoImpl implements ComunicacionSoivreRelDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ComunicacionSoivreRel> rwMap = new RowMapper<ComunicacionSoivreRel>() {
		public ComunicacionSoivreRel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionSoivreRel(resultSet.getString("V7CODIGO"),
					new ComunicacionSoivre(resultSet
							.getString("ComIDCOMUNICACIONSOIVRE"), resultSet
							.getString("ComV6CODIGO"), resultSet
							.getString("ComV6TIPO"), resultSet
							.getDate("ComV6FECHAENTRADA"), resultSet
							.getDate("ComV6FECHAFININSPECCION"), resultSet
							.getDate("ComV6FECHARESPUESTA"), resultSet
							.getString("ComV6IMPORTADOR"), null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, resultSet
									.getString("ComV6ESTABLECIMIENTOVISITA"),
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, resultSet
									.getString("ComV6COPS"), null, null,
							resultSet.getString("ComV6NOMPS"), resultSet
									.getString("ComV6MARCAPS"), resultSet
									.getString("ComV6MODELOPS"), resultSet
									.getString("ComV6LOTEPS"), resultSet
									.getDate("ComV6FEDUMI"), resultSet
									.getString("ComV6CODIGOBARRAS"), resultSet
									.getInt("ComV6NUMUNIDADES"), resultSet
									.getString("ComV6MOTIVO"), resultSet
									.getString("ComV6COOR"), resultSet
									.getString("ComV6INSPECCIONSOLICITADA"),
							resultSet.getDate("ComV6FECHASOLINSPECCION"),
							resultSet.getString("ComV6COACTUA"), null,
							resultSet.getString("ComV6NUMSOLICITUD")),
					new ComunicacionSoivre(resultSet
							.getString("RELIDCOMUNICACIONSOIVRE"), resultSet
							.getString("RELV6CODIGO"), resultSet
							.getString("RELV6TIPO"), resultSet
							.getDate("RELV6FECHAENTRADA"), resultSet
							.getDate("RELV6FECHAFININSPECCION"), resultSet
							.getDate("RELV6FECHARESPUESTA"), resultSet
							.getString("RELV6IMPORTADOR"), null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, resultSet
									.getString("RELV6ESTABLECIMIENTOVISITA"),
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, resultSet
									.getString("RELV6COPS"), null, null,
							resultSet.getString("RELV6NOMPS"), resultSet
									.getString("RELV6MARCAPS"), resultSet
									.getString("RELV6MODELOPS"), resultSet
									.getString("RELV6LOTEPS"), resultSet
									.getDate("RELV6FEDUMI"), resultSet
									.getString("RELV6CODIGOBARRAS"), resultSet
									.getInt("RELV6NUMUNIDADES"), resultSet
									.getString("RELV6MOTIVO"), resultSet
									.getString("RELV6COOR"), resultSet
									.getString("RELV6INSPECCIONSOLICITADA"),
							resultSet.getDate("RELV6FECHASOLINSPECCION"),
							resultSet.getString("RELV6COACTUA"), null,
							resultSet.getString("RELV6NUMSOLICITUD")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            Pagination
	 * @return ComunicacionSoivreRel
	 */
	public ComunicacionSoivreRel add(ComunicacionSoivreRel comunicacionsoivrerel) {
		String query = "INSERT INTO COMUNICACION_SOIVRE_REL (V7CODIGO, IDCOMUNICACIONSOIVREREL, IDCOMUNICACIONSOIVRE) VALUES (?,?,?)";
		Object getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux = null;
		if (comunicacionsoivrerel
				.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getIdcomunicacionsoivre() != null) {
			getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux = comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getIdcomunicacionsoivre();
		}
		Object getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux = null;
		if (comunicacionsoivrerel.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getIdcomunicacionsoivre() != null) {
			getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux = comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getIdcomunicacionsoivre();
		}
		this.jdbcTemplate
				.update(query,
						comunicacionsoivrerel.getV7codigo(),
						getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux,
						getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux);
		return comunicacionsoivrerel;
	}

	/**
	 * Updates a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            Pagination
	 * @return ComunicacionSoivreRel
	 */
	public ComunicacionSoivreRel update(
			ComunicacionSoivreRel comunicacionsoivrerel) {
		String query = "UPDATE COMUNICACION_SOIVRE_REL SET IDCOMUNICACIONSOIVREREL=?, IDCOMUNICACIONSOIVRE=? WHERE V7CODIGO=?";
		Object getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux = null;
		if (comunicacionsoivrerel
				.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getIdcomunicacionsoivre() != null) {
			getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux = comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getIdcomunicacionsoivre();
		}
		Object getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux = null;
		if (comunicacionsoivrerel.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getIdcomunicacionsoivre() != null) {
			getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux = comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getIdcomunicacionsoivre();
		}
		this.jdbcTemplate
				.update(query,
						getComunicacionSoivreByIdcomunicacionsoivrerelIdcomunicacionsoivreAux,
						getComunicacionSoivreByIdcomunicacionsoivreIdcomunicacionsoivreAux,
						comunicacionsoivrerel.getV7codigo());
		return comunicacionsoivrerel;
	}

	/**
	 * Finds a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            Pagination
	 * @return ComunicacionSoivreRel
	 */
	@Transactional(readOnly = true)
	public ComunicacionSoivreRel find(
			ComunicacionSoivreRel comunicacionsoivrerel) {
		String query = "SELECT  t1.V7CODIGO V7CODIGO,t2.IDCOMUNICACIONSOIVRE COMIDCOMUNICACIONSOIVRE,t2.V6CODIGO COMV6CODIGO,t2.V6TIPO COMV6TIPO,t2.V6FECHAENTRADA COMV6FECHAENTRADA,t2.V6FECHAFININSPECCION COMV6FECHAFININSPECCION,t2.V6FECHARESPUESTA COMV6FECHARESPUESTA,t2.V6IMPORTADOR COMV6IMPORTADOR,t2.V6ESTABLECIMIENTOVISITA COMV6ESTABLECIMIENTOVISITA,t2.V6COPS COMV6COPS,t2.V6NOMPS COMV6NOMPS,t2.V6MARCAPS COMV6MARCAPS,t2.V6MODELOPS COMV6MODELOPS,t2.V6LOTEPS COMV6LOTEPS,t2.V6FEDUMI COMV6FEDUMI,t2.V6CODIGOBARRAS COMV6CODIGOBARRAS,t2.V6NUMUNIDADES COMV6NUMUNIDADES,t2.V6MOTIVO COMV6MOTIVO,t2.V6COOR COMV6COOR,t2.V6INSPECCIONSOLICITADA COMV6INSPECCIONSOLICITADA,t2.V6FECHASOLINSPECCION COMV6FECHASOLINSPECCION,t2.V6COACTUA COMV6COACTUA,t2.V6NUMSOLICITUD COMV6NUMSOLICITUD,t3.IDCOMUNICACIONSOIVRE RELIDCOMUNICACIONSOIVRE,t3.V6CODIGO RELV6CODIGO,t3.V6TIPO RELV6TIPO,t3.V6FECHAENTRADA RELV6FECHAENTRADA,t3.V6FECHAFININSPECCION RELV6FECHAFININSPECCION,t3.V6FECHARESPUESTA RELV6FECHARESPUESTA,t3.V6IMPORTADOR RELV6IMPORTADOR,t3.V6ESTABLECIMIENTOVISITA RELV6ESTABLECIMIENTOVISITA,t3.V6COPS RELV6COPS,t3.V6NOMPS RELV6NOMPS,t3.V6MARCAPS RELV6MARCAPS,t3.V6MODELOPS RELV6MODELOPS,t3.V6LOTEPS RELV6LOTEPS,t3.V6FEDUMI RELV6FEDUMI,t3.V6CODIGOBARRAS RELV6CODIGOBARRAS,t3.V6NUMUNIDADES RELV6NUMUNIDADES,t3.V6MOTIVO RELV6MOTIVO,t3.V6COOR RELV6COOR,t3.V6INSPECCIONSOLICITADA RELV6INSPECCIONSOLICITADA,t3.V6FECHASOLINSPECCION RELV6FECHASOLINSPECCION,t3.V6COACTUA RELV6COACTUA,t3.V6NUMSOLICITUD RELV6NUMSOLICITUD FROM COMUNICACION_SOIVRE_REL t1 , COMUNICACION_SOIVRE t2 , COMUNICACION_SOIVRE t3  WHERE t1.V7CODIGO = ?   AND t1.IDCOMUNICACIONSOIVREREL= t2.IDCOMUNICACIONSOIVRE(+) AND t1.IDCOMUNICACIONSOIVRE= t3.IDCOMUNICACIONSOIVRE(+)";

		List<ComunicacionSoivreRel> comunicacionsoivrerelList = this.jdbcTemplate
				.query(query, this.rwMap, comunicacionsoivrerel.getV7codigo());
		return (ComunicacionSoivreRel) DataAccessUtils
				.uniqueResult(comunicacionsoivrerelList);
	}

	/**
	 * Removes a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            Pagination
	 * @return
	 */
	public void remove(ComunicacionSoivreRel comunicacionsoivrerel) {
		String query = "DELETE FROM COMUNICACION_SOIVRE_REL WHERE V7CODIGO=?";
		this.jdbcTemplate.update(query, comunicacionsoivrerel.getV7codigo());
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionSoivreRel> findAll(
			ComunicacionSoivreRel comunicacionsoivrerel, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.V7CODIGO V7CODIGO,t2.IDCOMUNICACIONSOIVRE COMIDCOMUNICACIONSOIVRE,t2.V6CODIGO COMV6CODIGO,t2.V6TIPO COMV6TIPO,t2.V6FECHAENTRADA COMV6FECHAENTRADA,t2.V6FECHAFININSPECCION COMV6FECHAFININSPECCION,t2.V6FECHARESPUESTA COMV6FECHARESPUESTA,t2.V6IMPORTADOR COMV6IMPORTADOR,t2.V6ESTABLECIMIENTOVISITA COMV6ESTABLECIMIENTOVISITA,t2.V6COPS COMV6COPS,t2.V6NOMPS COMV6NOMPS,t2.V6MARCAPS COMV6MARCAPS,t2.V6MODELOPS COMV6MODELOPS,t2.V6LOTEPS COMV6LOTEPS,t2.V6FEDUMI COMV6FEDUMI,t2.V6CODIGOBARRAS COMV6CODIGOBARRAS,t2.V6NUMUNIDADES COMV6NUMUNIDADES,t2.V6MOTIVO COMV6MOTIVO,t2.V6COOR COMV6COOR,t2.V6INSPECCIONSOLICITADA COMV6INSPECCIONSOLICITADA,t2.V6FECHASOLINSPECCION COMV6FECHASOLINSPECCION,t2.V6COACTUA COMV6COACTUA,t2.V6NUMSOLICITUD COMV6NUMSOLICITUD,t3.IDCOMUNICACIONSOIVRE RELIDCOMUNICACIONSOIVRE,t3.V6CODIGO RELV6CODIGO,t3.V6TIPO RELV6TIPO,t3.V6FECHAENTRADA RELV6FECHAENTRADA,t3.V6FECHAFININSPECCION RELV6FECHAFININSPECCION,t3.V6FECHARESPUESTA RELV6FECHARESPUESTA,t3.V6IMPORTADOR RELV6IMPORTADOR,t3.V6ESTABLECIMIENTOVISITA RELV6ESTABLECIMIENTOVISITA,t3.V6COPS RELV6COPS,t3.V6NOMPS RELV6NOMPS,t3.V6MARCAPS RELV6MARCAPS,t3.V6MODELOPS RELV6MODELOPS,t3.V6LOTEPS RELV6LOTEPS,t3.V6FEDUMI RELV6FEDUMI,t3.V6CODIGOBARRAS RELV6CODIGOBARRAS,t3.V6NUMUNIDADES RELV6NUMUNIDADES,t3.V6MOTIVO RELV6MOTIVO,t3.V6COOR RELV6COOR,t3.V6INSPECCIONSOLICITADA RELV6INSPECCIONSOLICITADA,t3.V6FECHASOLINSPECCION RELV6FECHASOLINSPECCION,t3.V6COACTUA RELV6COACTUA,t3.V6NUMSOLICITUD RELV6NUMSOLICITUD ");
		query.append("FROM COMUNICACION_SOIVRE_REL t1 ,COMUNICACION_SOIVRE t2 ,COMUNICACION_SOIVRE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionsoivrerel);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVREREL= t2.IDCOMUNICACIONSOIVRE(+) AND t1.IDCOMUNICACIONSOIVRE= t3.IDCOMUNICACIONSOIVRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ComunicacionSoivreRel>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ComunicacionSoivreRel comunicacionsoivrerel) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM COMUNICACION_SOIVRE_REL t1 , COMUNICACION_SOIVRE t2 , COMUNICACION_SOIVRE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionsoivrerel);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVREREL= t2.IDCOMUNICACIONSOIVRE(+) AND t1.IDCOMUNICACIONSOIVRE= t3.IDCOMUNICACIONSOIVRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ComunicacionSoivreRel table using like.
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionSoivreRel> findAllLike(
			ComunicacionSoivreRel comunicacionsoivrerel, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.V7CODIGO V7CODIGO,t2.IDCOMUNICACIONSOIVRE COMIDCOMUNICACIONSOIVRE,t2.V6CODIGO COMV6CODIGO,t2.V6TIPO COMV6TIPO,t2.V6FECHAENTRADA COMV6FECHAENTRADA,t2.V6FECHAFININSPECCION COMV6FECHAFININSPECCION,t2.V6FECHARESPUESTA COMV6FECHARESPUESTA,t2.V6IMPORTADOR COMV6IMPORTADOR,t2.V6ESTABLECIMIENTOVISITA COMV6ESTABLECIMIENTOVISITA,t2.V6COPS COMV6COPS,t2.V6NOMPS COMV6NOMPS,t2.V6MARCAPS COMV6MARCAPS,t2.V6MODELOPS COMV6MODELOPS,t2.V6LOTEPS COMV6LOTEPS,t2.V6FEDUMI COMV6FEDUMI,t2.V6CODIGOBARRAS COMV6CODIGOBARRAS,t2.V6NUMUNIDADES COMV6NUMUNIDADES,t2.V6MOTIVO COMV6MOTIVO,t2.V6COOR COMV6COOR,t2.V6INSPECCIONSOLICITADA COMV6INSPECCIONSOLICITADA,t2.V6FECHASOLINSPECCION COMV6FECHASOLINSPECCION,t2.V6COACTUA COMV6COACTUA,t2.V6NUMSOLICITUD COMV6NUMSOLICITUD,t3.IDCOMUNICACIONSOIVRE RELIDCOMUNICACIONSOIVRE,t3.V6CODIGO RELV6CODIGO,t3.V6TIPO RELV6TIPO,t3.V6FECHAENTRADA RELV6FECHAENTRADA,t3.V6FECHAFININSPECCION RELV6FECHAFININSPECCION,t3.V6FECHARESPUESTA RELV6FECHARESPUESTA,t3.V6IMPORTADOR RELV6IMPORTADOR,t3.V6ESTABLECIMIENTOVISITA RELV6ESTABLECIMIENTOVISITA,t3.V6COPS RELV6COPS,t3.V6NOMPS RELV6NOMPS,t3.V6MARCAPS RELV6MARCAPS,t3.V6MODELOPS RELV6MODELOPS,t3.V6LOTEPS RELV6LOTEPS,t3.V6FEDUMI RELV6FEDUMI,t3.V6CODIGOBARRAS RELV6CODIGOBARRAS,t3.V6NUMUNIDADES RELV6NUMUNIDADES,t3.V6MOTIVO RELV6MOTIVO,t3.V6COOR RELV6COOR,t3.V6INSPECCIONSOLICITADA RELV6INSPECCIONSOLICITADA,t3.V6FECHASOLINSPECCION RELV6FECHASOLINSPECCION,t3.V6COACTUA RELV6COACTUA,t3.V6NUMSOLICITUD RELV6NUMSOLICITUD ");
		query.append("FROM COMUNICACION_SOIVRE_REL t1 ,COMUNICACION_SOIVRE t2 ,COMUNICACION_SOIVRE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionsoivrerel,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVREREL= t2.IDCOMUNICACIONSOIVRE(+) AND t1.IDCOMUNICACIONSOIVRE= t3.IDCOMUNICACIONSOIVRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ComunicacionSoivreRel>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionSoivreRel table using like.
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ComunicacionSoivreRel comunicacionsoivrerel,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM COMUNICACION_SOIVRE_REL t1 ,COMUNICACION_SOIVRE t2 ,COMUNICACION_SOIVRE t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionsoivrerel,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVREREL= t2.IDCOMUNICACIONSOIVRE(+) AND t1.IDCOMUNICACIONSOIVRE= t3.IDCOMUNICACIONSOIVRE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionSoivreRel entity
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			ComunicacionSoivreRel comunicacionsoivrerel) {

		StringBuilder where = new StringBuilder(
				ComunicacionSoivreRelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel.getV7codigo() != null) {
			where.append(" AND t1.V7CODIGO = ?");
			params.add(comunicacionsoivrerel.getV7codigo());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getIdcomunicacionsoivre() != null) {
			where.append(" AND t2.IDCOMUNICACIONSOIVRE = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getIdcomunicacionsoivre());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigo() != null) {
			where.append(" AND t2.V6CODIGO = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6codigo());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6tipo() != null) {
			where.append(" AND t2.V6TIPO = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6tipo());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechaentrada() != null) {
			where.append(" AND t2.V6FECHAENTRADA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechaentrada());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechafininspeccion() != null) {
			where.append(" AND t2.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechafininspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fecharespuesta() != null) {
			where.append(" AND t2.V6FECHARESPUESTA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fecharespuesta());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6importador() != null) {
			where.append(" AND t2.V6IMPORTADOR = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6importador());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6establecimientovisita() != null) {
			where.append(" AND t2.V6ESTABLECIMIENTOVISITA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6establecimientovisita());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6cops() != null) {
			where.append(" AND t2.V6COPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6cops());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6nomps() != null) {
			where.append(" AND t2.V6NOMPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6nomps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6marcaps() != null) {
			where.append(" AND t2.V6MARCAPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6marcaps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6modelops() != null) {
			where.append(" AND t2.V6MODELOPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6modelops());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6loteps() != null) {
			where.append(" AND t2.V6LOTEPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6loteps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fedumi() != null) {
			where.append(" AND t2.V6FEDUMI = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fedumi());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigobarras() != null) {
			where.append(" AND t2.V6CODIGOBARRAS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6codigobarras());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6numunidades() != null) {
			where.append(" AND t2.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6numunidades());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coor() != null) {
			where.append(" AND t2.V6COOR = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6coor());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechasolinspeccion() != null) {
			where.append(" AND t2.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechasolinspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coactua() != null) {
			where.append(" AND t2.V6COACTUA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6coactua());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getIdcomunicacionsoivre() != null) {
			where.append(" AND t3.IDCOMUNICACIONSOIVRE = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getIdcomunicacionsoivre());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigo() != null) {
			where.append(" AND t3.V6CODIGO = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6codigo());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6tipo() != null) {
			where.append(" AND t3.V6TIPO = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre().getV6tipo());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechaentrada() != null) {
			where.append(" AND t3.V6FECHAENTRADA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechaentrada());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechafininspeccion() != null) {
			where.append(" AND t3.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechafininspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fecharespuesta() != null) {
			where.append(" AND t3.V6FECHARESPUESTA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fecharespuesta());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6importador() != null) {
			where.append(" AND t3.V6IMPORTADOR = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6importador());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6establecimientovisita() != null) {
			where.append(" AND t3.V6ESTABLECIMIENTOVISITA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6establecimientovisita());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6cops() != null) {
			where.append(" AND t3.V6COPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre().getV6cops());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6nomps() != null) {
			where.append(" AND t3.V6NOMPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre().getV6nomps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6marcaps() != null) {
			where.append(" AND t3.V6MARCAPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6marcaps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6modelops() != null) {
			where.append(" AND t3.V6MODELOPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6modelops());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6loteps() != null) {
			where.append(" AND t3.V6LOTEPS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6loteps());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fedumi() != null) {
			where.append(" AND t3.V6FEDUMI = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fedumi());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigobarras() != null) {
			where.append(" AND t3.V6CODIGOBARRAS = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6codigobarras());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6numunidades() != null) {
			where.append(" AND t3.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6numunidades());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coor() != null) {
			where.append(" AND t3.V6COOR = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre().getV6coor());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechasolinspeccion() != null) {
			where.append(" AND t3.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechasolinspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coactua() != null) {
			where.append(" AND t3.V6COACTUA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6coactua());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionSoivreRel entity
	 * 
	 * @param comunicacionsoivrerel
	 *            ComunicacionSoivreRel Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			ComunicacionSoivreRel comunicacionsoivrerel, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ComunicacionSoivreRelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel.getV7codigo() != null) {
			where.append(" AND UPPER(t1.V7CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel.getV7codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel.getV7codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V7CODIGO IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getIdcomunicacionsoivre() != null) {
			where.append(" AND t2.IDCOMUNICACIONSOIVRE = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getIdcomunicacionsoivre());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigo() != null) {
			where.append(" AND UPPER(t2.V6CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6codigo().toUpperCase() + "%");
			}
			where.append(" AND t2.V6CODIGO IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6tipo() != null) {
			where.append(" AND UPPER(t2.V6TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6tipo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6tipo().toUpperCase() + "%");
			}
			where.append(" AND t2.V6TIPO IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechaentrada() != null) {
			where.append(" AND t2.V6FECHAENTRADA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechaentrada());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechafininspeccion() != null) {
			where.append(" AND t2.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechafininspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fecharespuesta() != null) {
			where.append(" AND t2.V6FECHARESPUESTA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fecharespuesta());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6importador() != null) {
			where.append(" AND UPPER(t2.V6IMPORTADOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6importador().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6importador().toUpperCase() + "%");
			}
			where.append(" AND t2.V6IMPORTADOR IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6establecimientovisita() != null) {
			where.append(" AND UPPER(t2.V6ESTABLECIMIENTOVISITA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6establecimientovisita().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6establecimientovisita().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.V6ESTABLECIMIENTOVISITA IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6cops() != null) {
			where.append(" AND UPPER(t2.V6COPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6cops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6cops().toUpperCase() + "%");
			}
			where.append(" AND t2.V6COPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6nomps() != null) {
			where.append(" AND UPPER(t2.V6NOMPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6nomps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6nomps().toUpperCase() + "%");
			}
			where.append(" AND t2.V6NOMPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6marcaps() != null) {
			where.append(" AND UPPER(t2.V6MARCAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6marcaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6marcaps().toUpperCase() + "%");
			}
			where.append(" AND t2.V6MARCAPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6modelops() != null) {
			where.append(" AND UPPER(t2.V6MODELOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6modelops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6modelops().toUpperCase() + "%");
			}
			where.append(" AND t2.V6MODELOPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6loteps() != null) {
			where.append(" AND UPPER(t2.V6LOTEPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6loteps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6loteps().toUpperCase() + "%");
			}
			where.append(" AND t2.V6LOTEPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fedumi() != null) {
			where.append(" AND t2.V6FEDUMI = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fedumi());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigobarras() != null) {
			where.append(" AND UPPER(t2.V6CODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6codigobarras().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6codigobarras().toUpperCase() + "%");
			}
			where.append(" AND t2.V6CODIGOBARRAS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6numunidades() != null) {
			where.append(" AND t2.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6numunidades());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coor() != null) {
			where.append(" AND UPPER(t2.V6COOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6coor().toUpperCase() + "%");
			}
			where.append(" AND t2.V6COOR IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6fechasolinspeccion() != null) {
			where.append(" AND t2.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivrerel()
					.getV6fechasolinspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coactua() != null) {
			where.append(" AND UPPER(t2.V6COACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivrerel()
						.getV6coactua().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivrerel()
								.getV6coactua().toUpperCase() + "%");
			}
			where.append(" AND t2.V6COACTUA IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getIdcomunicacionsoivre() != null) {
			where.append(" AND t3.IDCOMUNICACIONSOIVRE = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getIdcomunicacionsoivre());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigo() != null) {
			where.append(" AND UPPER(t3.V6CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6codigo().toUpperCase() + "%");
			}
			where.append(" AND t3.V6CODIGO IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6tipo() != null) {
			where.append(" AND UPPER(t3.V6TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6tipo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6tipo().toUpperCase() + "%");
			}
			where.append(" AND t3.V6TIPO IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechaentrada() != null) {
			where.append(" AND t3.V6FECHAENTRADA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechaentrada());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechafininspeccion() != null) {
			where.append(" AND t3.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechafininspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fecharespuesta() != null) {
			where.append(" AND t3.V6FECHARESPUESTA = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fecharespuesta());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6importador() != null) {
			where.append(" AND UPPER(t3.V6IMPORTADOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6importador().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6importador().toUpperCase() + "%");
			}
			where.append(" AND t3.V6IMPORTADOR IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6establecimientovisita() != null) {
			where.append(" AND UPPER(t3.V6ESTABLECIMIENTOVISITA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6establecimientovisita().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6establecimientovisita().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.V6ESTABLECIMIENTOVISITA IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6cops() != null) {
			where.append(" AND UPPER(t3.V6COPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6cops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6cops().toUpperCase() + "%");
			}
			where.append(" AND t3.V6COPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6nomps() != null) {
			where.append(" AND UPPER(t3.V6NOMPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6nomps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6nomps().toUpperCase() + "%");
			}
			where.append(" AND t3.V6NOMPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6marcaps() != null) {
			where.append(" AND UPPER(t3.V6MARCAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6marcaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6marcaps().toUpperCase() + "%");
			}
			where.append(" AND t3.V6MARCAPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6modelops() != null) {
			where.append(" AND UPPER(t3.V6MODELOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6modelops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6modelops().toUpperCase() + "%");
			}
			where.append(" AND t3.V6MODELOPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6loteps() != null) {
			where.append(" AND UPPER(t3.V6LOTEPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6loteps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6loteps().toUpperCase() + "%");
			}
			where.append(" AND t3.V6LOTEPS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fedumi() != null) {
			where.append(" AND t3.V6FEDUMI = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fedumi());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigobarras() != null) {
			where.append(" AND UPPER(t3.V6CODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6codigobarras().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6codigobarras().toUpperCase() + "%");
			}
			where.append(" AND t3.V6CODIGOBARRAS IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6numunidades() != null) {
			where.append(" AND t3.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6numunidades());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coor() != null) {
			where.append(" AND UPPER(t3.V6COOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6coor().toUpperCase() + "%");
			}
			where.append(" AND t3.V6COOR IS NOT NULL");
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6fechasolinspeccion() != null) {
			where.append(" AND t3.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivrerel
					.getComunicacionSoivreByIdcomunicacionsoivre()
					.getV6fechasolinspeccion());
		}
		if (comunicacionsoivrerel != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre() != null
				&& comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coactua() != null) {
			where.append(" AND UPPER(t3.V6COACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivrerel
						.getComunicacionSoivreByIdcomunicacionsoivre()
						.getV6coactua().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivrerel
								.getComunicacionSoivreByIdcomunicacionsoivre()
								.getV6coactua().toUpperCase() + "%");
			}
			where.append(" AND t3.V6COACTUA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Deletes a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	public void removeAllComunicacionesSoivreRel(
			ComunicacionSoivre comunicacionSoivre) {
		String query = "DELETE  FROM COMUNICACION_SOIVRE_REL "
				+ " WHERE IDCOMUNICACIONSOIVRE=? OR IDCOMUNICACIONSOIVREREL=?";

		this.jdbcTemplate.update(query,
				comunicacionSoivre.getIdcomunicacionsoivre(),
				comunicacionSoivre.getIdcomunicacionsoivre());
	}

	/**
	 * Inserts a single row in the ComunicacionSoivreRel table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 */
	public void addAllComunicacionesSoivreRelAdjuntarComsoivreRel(
			ComunicacionSoivre comunicacionSoivre) {

		String query = "INSERT INTO COMUNICACION_SOIVRE_REL (V7CODIGO, IDCOMUNICACIONSOIVREREL, IDCOMUNICACIONSOIVRE) SELECT V7CODIGO, IDCOMUNICACIONSOIVREREL, IDCOMUNICACIONSOIVRE FROM ADJUNTAR_COMUSOIVREREL WHERE IDCOMUNICACIONSOIVRE = ? ";
		this.jdbcTemplate.update(query,
				comunicacionSoivre.getIdcomunicacionsoivre());
	}
}
