package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;

/**
 * ComunicacionSoivreDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionSoivreDaoImpl implements ComunicacionSoivreDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<ComunicacionSoivre> rwMap = new RowMapper<ComunicacionSoivre>() {
		public ComunicacionSoivre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionSoivre(
					resultSet.getString("IDCOMUNICACIONSOIVRE"),
					resultSet.getString("V6CODIGO"),
					resultSet.getString("V6TIPO"),
					resultSet.getDate("V6FECHAENTRADA"),
					resultSet.getDate("V6FECHAFININSPECCION"),
					resultSet.getDate("V6FECHARESPUESTA"),
					resultSet.getString("V6IMPORTADOR"),
					resultSet.getString("IMPESID"),
					resultSet.getString("IMPESNOMBRE"),
					resultSet.getString("IMPESNIF"),
					resultSet.getString("IMPESNOCO"),
					resultSet.getString("IMPESCOEM"),
					resultSet.getString("IMPESINADAR"),
					resultSet.getString("IMPESNOMBRE_PROVINCIA"),
					resultSet.getString("IMPESNOMBRE_MUNICIPIO"),
					resultSet.getString("IMPESNOMBRE_LOCALIDAD"),
					resultSet.getString("IMPESEXTRANJERO"),
					resultSet.getString("IMPESNOMBRE_PAIS"),
					resultSet.getString("IMPESDIRECCION_NOCAPV"),
					resultSet.getString("IMPSECODIGO"),
					resultSet.getString("IMPSENOMBRE"),
					resultSet.getString("IMPSENOMBREE"),
					resultSet.getString("V6ESTABLECIMIENTOVISITA"),
					resultSet.getString("ESID"),
					resultSet.getString("ESNOMBRE"),
					resultSet.getString("ESNIF"),
					resultSet.getString("ESNOCO"),
					resultSet.getString("ESCOEM"),
					resultSet.getString("ESINADAR"),
					resultSet.getString("ESNOMBRE_PROVINCIA"),
					resultSet.getString("ESNOMBRE_MUNICIPIO"),
					resultSet.getString("ESNOMBRE_LOCALIDAD"),
					resultSet.getString("ESEXTRANJERO"),
					resultSet.getString("ESNOMBRE_PAIS"),
					resultSet.getString("ESDIRECCION_NOCAPV"),
					resultSet.getString("SECODIGO"),
					resultSet.getString("SENOMBRE"),
					resultSet.getString("SENOMBREE"),
					resultSet.getString("V6COPS"),
					resultSet.getString("PSNOMBRE"),
					resultSet.getString("PSNOMBREE"),
					resultSet.getString("V6NOMPS"),
					resultSet.getString("V6MARCAPS"),
					resultSet.getString("V6MODELOPS"),
					resultSet.getString("V6LOTEPS"),
					resultSet.getDate("V6FEDUMI"),
					resultSet.getString("V6CODIGOBARRAS"),
					resultSet.getInt("V6NUMUNIDADES"),
					resultSet.getString("V6MOTIVO"),
					resultSet.getString("V6COOR"),
					resultSet.getString("V6INSPECCIONSOLICITADA"),
					resultSet.getDate("V6FECHASOLINSPECCION"),
					resultSet.getString("V6COACTUA"),
					resultSet.getString("CODEXP"),
					resultSet.getString("V6NUMSOLICITUD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre add(ComunicacionSoivre comunicacionsoivre) {
		String query = "INSERT INTO COMUNICACION_SOIVRE (IDCOMUNICACIONSOIVRE, V6CODIGO, V6TIPO, V6FECHAENTRADA, V6FECHAFININSPECCION, V6FECHARESPUESTA, V6IMPORTADOR, V6ESTABLECIMIENTOVISITA, V6COPS, V6NOMPS, V6MARCAPS, V6MODELOPS, V6LOTEPS, V6FEDUMI, V6CODIGOBARRAS, V6NUMUNIDADES, V6MOTIVO, V6COOR, V6INSPECCIONSOLICITADA, V6FECHASOLINSPECCION, V6COACTUA, V6NUMSOLICITUD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query,
				comunicacionsoivre.getIdcomunicacionsoivre(),
				comunicacionsoivre.getV6codigo(),
				comunicacionsoivre.getV6tipo(),
				comunicacionsoivre.getV6fechaentrada(),
				comunicacionsoivre.getV6fechafininspeccion(),
				comunicacionsoivre.getV6fecharespuesta(),
				comunicacionsoivre.getV6importador(),
				comunicacionsoivre.getV6establecimientovisita(),
				comunicacionsoivre.getV6cops(),
				comunicacionsoivre.getV6nomps(),
				comunicacionsoivre.getV6marcaps(),
				comunicacionsoivre.getV6modelops(),
				comunicacionsoivre.getV6loteps(),
				comunicacionsoivre.getV6fedumi(),
				comunicacionsoivre.getV6codigobarras(),
				comunicacionsoivre.getV6numunidades(),
				comunicacionsoivre.getV6motivo(),
				comunicacionsoivre.getV6coor(),
				comunicacionsoivre.getV6inspeccionsolicitada(),
				comunicacionsoivre.getV6fechasolinspeccion(),
				comunicacionsoivre.getV6coactua(),
				comunicacionsoivre.getV6numsolicitud());
		return comunicacionsoivre;
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre update(ComunicacionSoivre comunicacionsoivre) {
		String query = "UPDATE COMUNICACION_SOIVRE SET V6CODIGO=?, V6TIPO=?, V6FECHAENTRADA=?, V6FECHAFININSPECCION=?, V6FECHARESPUESTA=?, V6IMPORTADOR=?, V6ESTABLECIMIENTOVISITA=?, V6COPS=?, V6NOMPS=?, V6MARCAPS=?, V6MODELOPS=?, V6LOTEPS=?, V6FEDUMI=?, V6CODIGOBARRAS=?, V6NUMUNIDADES=?, V6MOTIVO=?, V6COOR=?, V6INSPECCIONSOLICITADA=?, V6FECHASOLINSPECCION=?, V6NUMSOLICITUD=? WHERE IDCOMUNICACIONSOIVRE=?";
		this.jdbcTemplate.update(query, comunicacionsoivre.getV6codigo(),
				comunicacionsoivre.getV6tipo(),
				comunicacionsoivre.getV6fechaentrada(),
				comunicacionsoivre.getV6fechafininspeccion(),
				comunicacionsoivre.getV6fecharespuesta(),
				comunicacionsoivre.getV6importador(),
				comunicacionsoivre.getV6establecimientovisita(),
				comunicacionsoivre.getV6cops(),
				comunicacionsoivre.getV6nomps(),
				comunicacionsoivre.getV6marcaps(),
				comunicacionsoivre.getV6modelops(),
				comunicacionsoivre.getV6loteps(),
				comunicacionsoivre.getV6fedumi(),
				comunicacionsoivre.getV6codigobarras(),
				comunicacionsoivre.getV6numunidades(),
				comunicacionsoivre.getV6motivo(),
				comunicacionsoivre.getV6coor(),
				comunicacionsoivre.getV6inspeccionsolicitada(),
				comunicacionsoivre.getV6fechasolinspeccion(),
				comunicacionsoivre.getV6numsolicitud(),
				comunicacionsoivre.getIdcomunicacionsoivre());
		return comunicacionsoivre;
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateFechaSolInspeccion(
			ComunicacionSoivre comunicacionsoivre) {
		String query = "UPDATE COMUNICACION_SOIVRE SET V6FECHASOLINSPECCION=?,V6COACTUA=? WHERE IDCOMUNICACIONSOIVRE=?";
		this.jdbcTemplate.update(query,
				comunicacionsoivre.getV6fechasolinspeccion(),
				comunicacionsoivre.getV6coactua(),
				comunicacionsoivre.getIdcomunicacionsoivre());
		return comunicacionsoivre;
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateFechaFinInspeccion(
			ComunicacionSoivre comunicacionsoivre) {
		String query = "UPDATE COMUNICACION_SOIVRE SET V6FECHAFININSPECCION=? WHERE V6COACTUA=?";
		this.jdbcTemplate.update(query,
				comunicacionsoivre.getV6fechafininspeccion(),
				comunicacionsoivre.getV6coactua());
		return comunicacionsoivre;
	}

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateCodInspeccion(
			ComunicacionSoivre comunicacionsoivre) {
		String query = "UPDATE COMUNICACION_SOIVRE SET V6COACTUA=null WHERE IDCOMUNICACIONSOIVRE=?";
		this.jdbcTemplate.update(query,
				comunicacionsoivre.getIdcomunicacionsoivre());
		return comunicacionsoivre;
	}

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	@Transactional(readOnly = true)
	public ComunicacionSoivre find(ComunicacionSoivre comunicacionsoivre) {
		String query = "SELECT t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.V6CODIGO V6CODIGO, t1.V6TIPO V6TIPO, t1.V6FECHAENTRADA V6FECHAENTRADA, t1.V6FECHAFININSPECCION V6FECHAFININSPECCION, t1.V6FECHARESPUESTA V6FECHARESPUESTA, t1.V6IMPORTADOR V6IMPORTADOR, t1.V6NUMSOLICITUD V6NUMSOLICITUD,t2IMPORTADOR.IDINTERVINIENTE IMPESID, t2IMPORTADOR.NOMBRE IMPESNOMBRE, t2IMPORTADOR.NIF IMPESNIF, t2IMPORTADOR.ESNOCO IMPESNOCO, t2IMPORTADOR.COEM IMPESCOEM, t2IMPORTADOR.INADAR IMPESINADAR, t2IMPORTADOR.NOMBRE_PROVINCIA IMPESNOMBRE_PROVINCIA, t2IMPORTADOR.NOMBRE_MUNICIPIO IMPESNOMBRE_MUNICIPIO, t2IMPORTADOR.NOMBRE_LOCALIDAD IMPESNOMBRE_LOCALIDAD, t2IMPORTADOR.EXTRANJERO IMPESEXTRANJERO, t2IMPORTADOR.NOMBRE_PAIS IMPESNOMBRE_PAIS, t2IMPORTADOR.DIRECCION_NOCAPV IMPESDIRECCION_NOCAPV, t2IMPORTADOR.SECODIGO IMPSECODIGO, t2IMPORTADOR.SENOMBRE IMPSENOMBRE, t2IMPORTADOR.SENOMBREE IMPSENOMBREE, t1.V6ESTABLECIMIENTOVISITA V6ESTABLECIMIENTOVISITA, t3ESTABLECIMIENTO.IDINTERVINIENTE ESID, t3ESTABLECIMIENTO.NOMBRE ESNOMBRE, t3ESTABLECIMIENTO.NIF ESNIF, t3ESTABLECIMIENTO.ESNOCO ESNOCO, t3ESTABLECIMIENTO.COEM ESCOEM, t3ESTABLECIMIENTO.INADAR ESINADAR, t3ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t3ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t3ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t3ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO, t3ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS, t3ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3ESTABLECIMIENTO.SECODIGO SECODIGO, t3ESTABLECIMIENTO.SENOMBRE SENOMBRE, t3ESTABLECIMIENTO.SENOMBREE SENOMBREE, t1.V6COPS V6COPS, t4.PSNOMBRE PSNOMBRE, t4.PSNOMBREE PSNOMBREE, t1.V6NOMPS V6NOMPS, t1.V6MARCAPS V6MARCAPS, t1.V6MODELOPS V6MODELOPS, t1.V6LOTEPS V6LOTEPS, t1.V6FEDUMI V6FEDUMI, t1.V6CODIGOBARRAS V6CODIGOBARRAS, t1.V6NUMUNIDADES V6NUMUNIDADES, t1.V6MOTIVO V6MOTIVO, t1.V6COOR V6COOR, t1.V6INSPECCIONSOLICITADA V6INSPECCIONSOLICITADA, t1.V6FECHASOLINSPECCION V6FECHASOLINSPECCION, t1.V6COACTUA V6COACTUA, t6.ACCOOR||'-'||t6.ACNROR||'-'||t6.ACNRAN||'-'||t5.ATNROR CODEXP FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4, ACTUACION t5, ACTA t6  WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COACTUA = t5.ATCODIGO (+) AND t5.ATCOAC = t6.ACCODIGO (+) AND t1.V6COPS = t4.PSCODIGO(+) AND t1.IDCOMUNICACIONSOIVRE = ?  ";

		List<ComunicacionSoivre> comunicacionsoivreList = this.jdbcTemplate
				.query(query, this.rwMap,
						comunicacionsoivre.getIdcomunicacionsoivre());
		return (ComunicacionSoivre) DataAccessUtils
				.uniqueResult(comunicacionsoivreList);
	}

	/**
	 * Finds a single row in the ComunicacionSoivre table based on its V6COIDGO
	 * value.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	@Transactional(readOnly = true)
	public ComunicacionSoivre findByV6Codigo(
			ComunicacionSoivre comunicacionsoivre) {
		String query = "SELECT t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.V6CODIGO V6CODIGO, t1.V6TIPO V6TIPO, t1.V6FECHAENTRADA V6FECHAENTRADA, t1.V6FECHAFININSPECCION V6FECHAFININSPECCION, t1.V6FECHARESPUESTA V6FECHARESPUESTA, t1.V6IMPORTADOR V6IMPORTADOR, t1.V6NUMSOLICITUD V6NUMSOLICITUD,  t2IMPORTADOR.IDINTERVINIENTE IMPESID, t2IMPORTADOR.NOMBRE IMPESNOMBRE, t2IMPORTADOR.NIF IMPESNIF, t2IMPORTADOR.ESNOCO IMPESNOCO, t2IMPORTADOR.COEM IMPESCOEM, t2IMPORTADOR.INADAR IMPESINADAR, t2IMPORTADOR.NOMBRE_PROVINCIA IMPESNOMBRE_PROVINCIA, t2IMPORTADOR.NOMBRE_MUNICIPIO IMPESNOMBRE_MUNICIPIO, t2IMPORTADOR.NOMBRE_LOCALIDAD IMPESNOMBRE_LOCALIDAD, t2IMPORTADOR.EXTRANJERO IMPESEXTRANJERO, t2IMPORTADOR.NOMBRE_PAIS IMPESNOMBRE_PAIS, t2IMPORTADOR.DIRECCION_NOCAPV IMPESDIRECCION_NOCAPV, t2IMPORTADOR.SECODIGO IMPSECODIGO, t2IMPORTADOR.SENOMBRE IMPSENOMBRE, t2IMPORTADOR.SENOMBREE IMPSENOMBREE, t1.V6ESTABLECIMIENTOVISITA V6ESTABLECIMIENTOVISITA, t3ESTABLECIMIENTO.IDINTERVINIENTE ESID, t3ESTABLECIMIENTO.NOMBRE ESNOMBRE, t3ESTABLECIMIENTO.NIF ESNIF, t3ESTABLECIMIENTO.ESNOCO ESNOCO, t3ESTABLECIMIENTO.COEM ESCOEM, t3ESTABLECIMIENTO.INADAR ESINADAR, t3ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t3ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t3ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t3ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO, t3ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS, t3ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3ESTABLECIMIENTO.SECODIGO SECODIGO, t3ESTABLECIMIENTO.SENOMBRE SENOMBRE, t3ESTABLECIMIENTO.SENOMBREE SENOMBREE, t1.V6COPS V6COPS, t4.PSNOMBRE PSNOMBRE, t4.PSNOMBREE PSNOMBREE, t1.V6NOMPS V6NOMPS, t1.V6MARCAPS V6MARCAPS, t1.V6MODELOPS V6MODELOPS, t1.V6LOTEPS V6LOTEPS, t1.V6FEDUMI V6FEDUMI, t1.V6CODIGOBARRAS V6CODIGOBARRAS, t1.V6NUMUNIDADES V6NUMUNIDADES, t1.V6MOTIVO V6MOTIVO, t1.V6COOR V6COOR, t1.V6INSPECCIONSOLICITADA V6INSPECCIONSOLICITADA, t1.V6FECHASOLINSPECCION V6FECHASOLINSPECCION, t1.V6COACTUA V6COACTUA, t6.ACCOOR||'-'||t6.ACNROR||'-'||t6.ACNRAN||'-'||t5.ATNROR CODEXP FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4, ACTUACION t5, ACTA t6 WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) AND t1.V6COACTUA = t5.ATCODIGO (+) AND t5.ATCOAC = t6.ACCODIGO (+) AND t1.V6CODIGO = ?  ";

		List<ComunicacionSoivre> comunicacionsoivreList = this.jdbcTemplate
				.query(query, this.rwMap, comunicacionsoivre.getV6codigo());
		return (ComunicacionSoivre) DataAccessUtils
				.uniqueResult(comunicacionsoivreList);
	}

	/**
	 * Removes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return
	 */
	public void remove(ComunicacionSoivre comunicacionsoivre) {
		String query = "DELETE FROM COMUNICACION_SOIVRE WHERE IDCOMUNICACIONSOIVRE=?";
		this.jdbcTemplate.update(query,
				comunicacionsoivre.getIdcomunicacionsoivre());
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionSoivre> findAll(
			ComunicacionSoivre comunicacionsoivre, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.V6CODIGO V6CODIGO, t1.V6TIPO V6TIPO, t1.V6FECHAENTRADA V6FECHAENTRADA, t1.V6FECHAFININSPECCION V6FECHAFININSPECCION, t1.V6FECHARESPUESTA V6FECHARESPUESTA, t1.V6IMPORTADOR V6IMPORTADOR, t1.V6NUMSOLICITUD V6NUMSOLICITUD, t2IMPORTADOR.IDINTERVINIENTE IMPESID, t2IMPORTADOR.NOMBRE IMPESNOMBRE, t2IMPORTADOR.NIF IMPESNIF, t2IMPORTADOR.ESNOCO IMPESNOCO, t2IMPORTADOR.COEM IMPESCOEM, t2IMPORTADOR.INADAR IMPESINADAR, t2IMPORTADOR.NOMBRE_PROVINCIA IMPESNOMBRE_PROVINCIA, t2IMPORTADOR.NOMBRE_MUNICIPIO IMPESNOMBRE_MUNICIPIO, t2IMPORTADOR.NOMBRE_LOCALIDAD IMPESNOMBRE_LOCALIDAD, t2IMPORTADOR.EXTRANJERO IMPESEXTRANJERO, t2IMPORTADOR.NOMBRE_PAIS IMPESNOMBRE_PAIS, t2IMPORTADOR.DIRECCION_NOCAPV IMPESDIRECCION_NOCAPV, t2IMPORTADOR.SECODIGO IMPSECODIGO, t2IMPORTADOR.SENOMBRE IMPSENOMBRE, t2IMPORTADOR.SENOMBREE IMPSENOMBREE, t1.V6ESTABLECIMIENTOVISITA V6ESTABLECIMIENTOVISITA, t3ESTABLECIMIENTO.IDINTERVINIENTE ESID, t3ESTABLECIMIENTO.NOMBRE ESNOMBRE, t3ESTABLECIMIENTO.NIF ESNIF, t3ESTABLECIMIENTO.ESNOCO ESNOCO, t3ESTABLECIMIENTO.COEM ESCOEM, t3ESTABLECIMIENTO.INADAR ESINADAR, t3ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t3ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t3ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t3ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO, t3ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS, t3ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3ESTABLECIMIENTO.SECODIGO SECODIGO, t3ESTABLECIMIENTO.SENOMBRE SENOMBRE, t3ESTABLECIMIENTO.SENOMBREE SENOMBREE, t1.V6COPS V6COPS, t4.PSNOMBRE PSNOMBRE, t4.PSNOMBREE PSNOMBREE, t1.V6NOMPS V6NOMPS, t1.V6MARCAPS V6MARCAPS, t1.V6MODELOPS V6MODELOPS, t1.V6LOTEPS V6LOTEPS, t1.V6FEDUMI V6FEDUMI, t1.V6CODIGOBARRAS V6CODIGOBARRAS, t1.V6NUMUNIDADES V6NUMUNIDADES, t1.V6MOTIVO V6MOTIVO, t1.V6COOR V6COOR, t1.V6INSPECCIONSOLICITADA V6INSPECCIONSOLICITADA, t1.V6FECHASOLINSPECCION V6FECHASOLINSPECCION, t1.V6COACTUA V6COACTUA, t6.ACCOOR||'-'||t6.ACNROR||'-'||t6.ACNRAN||'-'||t5.ATNROR CODEXP ");
		query.append("FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4, ACTUACION t5, ACTA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionsoivre);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COACTUA = t5.ATCODIGO (+) AND t5.ATCOAC = t6.ACCODIGO (+) AND t1.V6COPS = t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ComunicacionSoivre>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ComunicacionSoivre comunicacionsoivre) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionsoivre);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionSoivre> findAllBandejaComunicacionSoivre(
			ComunicacionSoivre comunicacionsoivre, CensoMonitor censoMonitor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.V6CODIGO V6CODIGO, t1.V6TIPO V6TIPO, t1.V6FECHAENTRADA V6FECHAENTRADA, t1.V6FECHAFININSPECCION V6FECHAFININSPECCION, t1.V6FECHARESPUESTA V6FECHARESPUESTA, t1.V6IMPORTADOR V6IMPORTADOR, t2IMPORTADOR.IDINTERVINIENTE IMPESID, t2IMPORTADOR.NOMBRE IMPESNOMBRE, t2IMPORTADOR.NIF IMPESNIF, t2IMPORTADOR.ESNOCO IMPESNOCO, t2IMPORTADOR.COEM IMPESCOEM, t2IMPORTADOR.INADAR IMPESINADAR, t2IMPORTADOR.NOMBRE_PROVINCIA IMPESNOMBRE_PROVINCIA, t2IMPORTADOR.NOMBRE_MUNICIPIO IMPESNOMBRE_MUNICIPIO, t2IMPORTADOR.NOMBRE_LOCALIDAD IMPESNOMBRE_LOCALIDAD, t2IMPORTADOR.EXTRANJERO IMPESEXTRANJERO, t2IMPORTADOR.NOMBRE_PAIS IMPESNOMBRE_PAIS, t2IMPORTADOR.DIRECCION_NOCAPV IMPESDIRECCION_NOCAPV, t2IMPORTADOR.SECODIGO IMPSECODIGO, t2IMPORTADOR.SENOMBRE IMPSENOMBRE, t2IMPORTADOR.SENOMBREE IMPSENOMBREE, t1.V6ESTABLECIMIENTOVISITA V6ESTABLECIMIENTOVISITA, t3ESTABLECIMIENTO.IDINTERVINIENTE ESID, t3ESTABLECIMIENTO.NOMBRE ESNOMBRE, t3ESTABLECIMIENTO.NIF ESNIF, t3ESTABLECIMIENTO.ESNOCO ESNOCO, t3ESTABLECIMIENTO.COEM ESCOEM, t3ESTABLECIMIENTO.INADAR ESINADAR, t3ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t3ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t3ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t3ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO, t3ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS, t3ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3ESTABLECIMIENTO.SECODIGO SECODIGO, t3ESTABLECIMIENTO.SENOMBRE SENOMBRE, t3ESTABLECIMIENTO.SENOMBREE SENOMBREE, t1.V6COPS V6COPS, t4.PSNOMBRE PSNOMBRE, t4.PSNOMBREE PSNOMBREE, t1.V6NOMPS V6NOMPS, t1.V6MARCAPS V6MARCAPS, t1.V6MODELOPS V6MODELOPS, t1.V6LOTEPS V6LOTEPS, t1.V6FEDUMI V6FEDUMI, t1.V6CODIGOBARRAS V6CODIGOBARRAS, t1.V6NUMUNIDADES V6NUMUNIDADES, t1.V6MOTIVO V6MOTIVO, t1.V6COOR V6COOR, t1.V6INSPECCIONSOLICITADA V6INSPECCIONSOLICITADA, t1.V6FECHASOLINSPECCION V6FECHASOLINSPECCION, t1.V6COACTUA V6COACTUA, t6.ACCOOR||'-'||t6.ACNROR||'-'||t6.ACNRAN||'-'||t5.ATNROR CODEXP,t1.V6NUMSOLICITUD V6NUMSOLICITUD ");
		query.append("FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4, ACTUACION t5, ACTA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapBandejaComunicacionSoivre(
				comunicacionsoivre, censoMonitor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) AND t1.V6COACTUA = t5.ATCODIGO(+) AND t5.ATCOAC = t6.ACCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ComunicacionSoivre>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaComunicacionSoivreCount(
			ComunicacionSoivre comunicacionsoivre, CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapBandejaComunicacionSoivre(
				comunicacionsoivre, censoMonitor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionSoivre> findAllLike(
			ComunicacionSoivre comunicacionsoivre, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.V6CODIGO V6CODIGO, t1.V6TIPO V6TIPO, t1.V6FECHAENTRADA V6FECHAENTRADA, t1.V6FECHAFININSPECCION V6FECHAFININSPECCION, t1.V6FECHARESPUESTA V6FECHARESPUESTA, t1.V6IMPORTADOR V6IMPORTADOR, t1.V6NUMSOLICITUD V6NUMSOLICITUD, t2IMPORTADOR.IDINTERVINIENTE IMPESID, t2IMPORTADOR.NOMBRE IMPESNOMBRE, t2IMPORTADOR.NIF IMPESNIF, t2IMPORTADOR.ESNOCO IMPESNOCO, t2IMPORTADOR.COEM IMPESCOEM, t2IMPORTADOR.INADAR IMPESINADAR, t2IMPORTADOR.NOMBRE_PROVINCIA IMPESNOMBRE_PROVINCIA, t2IMPORTADOR.NOMBRE_MUNICIPIO IMPESNOMBRE_MUNICIPIO, t2IMPORTADOR.NOMBRE_LOCALIDAD IMPESNOMBRE_LOCALIDAD, t2IMPORTADOR.EXTRANJERO IMPESEXTRANJERO, t2IMPORTADOR.NOMBRE_PAIS IMPESNOMBRE_PAIS, t2IMPORTADOR.DIRECCION_NOCAPV IMPESDIRECCION_NOCAPV, t2IMPORTADOR.SECODIGO IMPSECODIGO, t2IMPORTADOR.SENOMBRE IMPSENOMBRE, t2IMPORTADOR.SENOMBREE IMPSENOMBREE, t1.V6ESTABLECIMIENTOVISITA V6ESTABLECIMIENTOVISITA, t3ESTABLECIMIENTO.IDINTERVINIENTE ESID, t3ESTABLECIMIENTO.NOMBRE ESNOMBRE, t3ESTABLECIMIENTO.NIF ESNIF, t3ESTABLECIMIENTO.ESNOCO ESNOCO, t3ESTABLECIMIENTO.COEM ESCOEM, t3ESTABLECIMIENTO.INADAR ESINADAR, t3ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t3ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t3ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t3ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO, t3ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS, t3ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3ESTABLECIMIENTO.SECODIGO SECODIGO, t3ESTABLECIMIENTO.SENOMBRE SENOMBRE, t3ESTABLECIMIENTO.SENOMBREE SENOMBREE, t1.V6COPS V6COPS, t4.PSNOMBRE PSNOMBRE, t4.PSNOMBREE PSNOMBREE, t1.V6NOMPS V6NOMPS, t1.V6MARCAPS V6MARCAPS, t1.V6MODELOPS V6MODELOPS, t1.V6LOTEPS V6LOTEPS, t1.V6FEDUMI V6FEDUMI, t1.V6CODIGOBARRAS V6CODIGOBARRAS, NVL(t1.V6NUMUNIDADES,0) V6NUMUNIDADES, t1.V6MOTIVO V6MOTIVO, t1.V6COOR V6COOR, t1.V6INSPECCIONSOLICITADA V6INSPECCIONSOLICITADA, t1.V6FECHASOLINSPECCION V6FECHASOLINSPECCION, t1.V6COACTUA V6COACTUA, t6.ACCOOR||'-'||t6.ACNROR||'-'||t6.ACNRAN||'-'||t5.ATNROR CODEXP ");
		query.append("FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4, ACTUACION t5, ACTA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionsoivre,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) AND t1.V6COACTUA = t5.ATCODIGO (+) AND t5.ATCOAC = t6.ACCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ComunicacionSoivre>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ComunicacionSoivre comunicacionsoivre,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM COMUNICACION_SOIVRE t1,INTERVINIENTES t2IMPORTADOR, INTERVINIENTES t3ESTABLECIMIENTO, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionsoivre,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.IDCOMUNICACIONSOIVRE= t2IMPORTADOR.HDCODIGO(+) AND t2IMPORTADOR.TIPO_INTERVINIENTE(+)='M' AND t1.IDCOMUNICACIONSOIVRE= t3ESTABLECIMIENTO.HDCODIGO(+) AND t3ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='V' AND t1.V6COPS = t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionSoivre entity
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ComunicacionSoivre comunicacionsoivre) {

		StringBuilder where = new StringBuilder(
				ComunicacionSoivreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionsoivre != null
				&& comunicacionsoivre.getIdcomunicacionsoivre() != null) {
			where.append(" AND t1.IDCOMUNICACIONSOIVRE = ?");
			params.add(comunicacionsoivre.getIdcomunicacionsoivre());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6codigo() != null) {
			where.append(" AND t1.V6CODIGO = ?");
			params.add(comunicacionsoivre.getV6codigo());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6tipo() != null) {
			where.append(" AND t1.V6TIPO = ?");
			params.add(comunicacionsoivre.getV6tipo());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechaentrada() != null) {
			where.append(" AND t1.V6FECHAENTRADA = ?");
			params.add(comunicacionsoivre.getV6fechaentrada());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechafininspeccion() != null) {
			where.append(" AND t1.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivre.getV6fechafininspeccion());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fecharespuesta() != null) {
			where.append(" AND t1.V6FECHARESPUESTA = ?");
			params.add(comunicacionsoivre.getV6fecharespuesta());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6importador() != null) {
			where.append(" AND t1.V6IMPORTADOR = ?");
			params.add(comunicacionsoivre.getV6importador());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6establecimientovisita() != null) {
			where.append(" AND t1.V6ESTABLECIMIENTOVISITA = ?");
			params.add(comunicacionsoivre.getV6establecimientovisita());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6cops() != null) {
			where.append(" AND t1.V6COPS = ?");
			params.add(comunicacionsoivre.getV6cops());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6nomps() != null) {
			where.append(" AND t1.V6NOMPS = ?");
			params.add(comunicacionsoivre.getV6nomps());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6marcaps() != null) {
			where.append(" AND t1.V6MARCAPS = ?");
			params.add(comunicacionsoivre.getV6marcaps());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6modelops() != null) {
			where.append(" AND t1.V6MODELOPS = ?");
			params.add(comunicacionsoivre.getV6modelops());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6loteps() != null) {
			where.append(" AND t1.V6LOTEPS = ?");
			params.add(comunicacionsoivre.getV6loteps());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fedumi() != null) {
			where.append(" AND t1.V6FEDUMI = ?");
			params.add(comunicacionsoivre.getV6fedumi());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6codigobarras() != null) {
			where.append(" AND t1.V6CODIGOBARRAS = ?");
			params.add(comunicacionsoivre.getV6codigobarras());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6numunidades() != null) {
			where.append(" AND t1.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivre.getV6numunidades());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6coor() != null) {
			where.append(" AND t1.V6COOR = ?");
			params.add(comunicacionsoivre.getV6coor());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechasolinspeccion() != null) {
			where.append(" AND t1.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivre.getV6fechasolinspeccion());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6coactua() != null) {
			where.append(" AND t1.V6COACTUA = ?");
			params.add(comunicacionsoivre.getV6coactua());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionSoivre entity
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre Bean with the criteria values to filter by.
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapBandejaComunicacionSoivre(
			ComunicacionSoivre comunicacionsoivre, CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(
				ComunicacionSoivreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.V6FECHARESPUESTA IS NULL ");

		if (censoMonitor != null
				&& censoMonitor.getPerfilOrganizacion() != null
				&& !censoMonitor
						.getPerfilOrganizacion()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			where.append(" AND t1.V6FECHASOLINSPECCION IS NOT NULL ");
			where.append(" AND t1.V6COOR = ?");
			params.add(censoMonitor.getOrganismo().getCodOrg());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionSoivre entity
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			ComunicacionSoivre comunicacionsoivre, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ComunicacionSoivreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionsoivre != null
				&& comunicacionsoivre.getIdcomunicacionsoivre() != null) {
			where.append(" AND UPPER(t1.IDCOMUNICACIONSOIVRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getIdcomunicacionsoivre()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getIdcomunicacionsoivre()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDCOMUNICACIONSOIVRE IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6codigo() != null) {
			where.append(" AND UPPER(t1.V6CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6codigo().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6CODIGO IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6tipo() != null) {
			where.append(" AND UPPER(t1.V6TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6tipo().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6tipo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6TIPO IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6numsolicitud() != null) {
			where.append(" AND UPPER(t1.V6NUMSOLICITUD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6numsolicitud().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6numsolicitud().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6NUMSOLICITUD IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechaentradaDesde() != null) {
			where.append(" AND t1.V6FECHAENTRADA >= ?");
			params.add(comunicacionsoivre.getV6fechaentradaDesde());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechaentradaHasta() != null) {
			where.append(" AND t1.V6FECHAENTRADA <= ?");
			params.add(comunicacionsoivre.getV6fechaentradaHasta());
		}

		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechafininspeccion() != null) {
			where.append(" AND t1.V6FECHAFININSPECCION = ?");
			params.add(comunicacionsoivre.getV6fechafininspeccion());
		}

		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fecharespuestaDesde() != null) {
			where.append(" AND t1.V6FECHARESPUESTA >= ?");
			params.add(comunicacionsoivre.getV6fecharespuestaDesde());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fecharespuestaHasta() != null) {
			where.append(" AND t1.V6FECHARESPUESTA <= ?");
			params.add(comunicacionsoivre.getV6fecharespuestaHasta());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6importador() != null) {
			where.append(" AND UPPER(t1.V6IMPORTADOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6importador().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6importador().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6IMPORTADOR IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6establecimientovisita() != null) {
			where.append(" AND UPPER(t1.V6ESTABLECIMIENTOVISITA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6establecimientovisita()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6establecimientovisita()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.V6ESTABLECIMIENTOVISITA IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6cops() != null) {
			where.append(" AND UPPER(t1.V6COPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6cops().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6cops().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6COPS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6nomps() != null) {
			where.append(" AND UPPER(t1.V6NOMPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6nomps().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6nomps().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6NOMPS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6marcaps() != null) {
			where.append(" AND UPPER(t1.V6MARCAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6marcaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6marcaps().toUpperCase() + "%");
			}
			where.append(" AND t1.V6MARCAPS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6modelops() != null) {
			where.append(" AND UPPER(t1.V6MODELOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6modelops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6modelops().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6MODELOPS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6loteps() != null) {
			where.append(" AND UPPER(t1.V6LOTEPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6loteps().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6loteps().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6LOTEPS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fedumi() != null) {
			where.append(" AND t1.V6FEDUMI = ?");
			params.add(comunicacionsoivre.getV6fedumi());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6codigobarras() != null) {
			where.append(" AND UPPER(t1.V6CODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6codigobarras().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6codigobarras().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6CODIGOBARRAS IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6numunidades() != null) {
			where.append(" AND t1.V6NUMUNIDADES = ?");
			params.add(comunicacionsoivre.getV6numunidades());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6coor() != null) {
			where.append(" AND UPPER(t1.V6COOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6coor().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionsoivre.getV6coor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V6COOR IS NOT NULL");
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6fechasolinspeccion() != null) {
			where.append(" AND t1.V6FECHASOLINSPECCION = ?");
			params.add(comunicacionsoivre.getV6fechasolinspeccion());
		}
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getV6coactua() != null) {
			where.append(" AND UPPER(t1.V6COACTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionsoivre.getV6coactua().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionsoivre.getV6coactua().toUpperCase() + "%");
			}
			where.append(" AND t1.V6COACTUA IS NOT NULL");
		}

		// codigo de infraccin
		if (comunicacionsoivre != null
				&& comunicacionsoivre.getCodInfraccion() != null) {
			where.append(" AND (SELECT COUNT(1) FROM ACTA_INFRACCION t11 WHERE 1=1 AND t11.AICOAT=t1.IDCOMUNICACIONSOIVRE AND t11.AICOTTI=?)>0 ");
			params.add(comunicacionsoivre.getCodInfraccion());
		}

		if (comunicacionsoivre != null
				&& (comunicacionsoivre.getV6incluirrespondidas() == null || comunicacionsoivre
						.getV6incluirrespondidas().equals(
								Y41bConstantes.VALOR_NO))) {
			where.append(" AND t1.V6FECHARESPUESTA IS NULL ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
