package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;

/**
 * ComunicacionSoivreDao  
 * 
 *  
 */

public interface ComunicacionSoivreDao {

	/**
	 * Inserts a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre add(ComunicacionSoivre comunicacionsoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre update(ComunicacionSoivre comunicacionsoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateFechaSolInspeccion(
			ComunicacionSoivre comunicacionsoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateFechaFinInspeccion(
			ComunicacionSoivre comunicacionsoivre);

	/**
	 * Updates a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre updateCodInspeccion(
			ComunicacionSoivre comunicacionsoivre);

	/**
	 * Finds a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return ComunicacionSoivre
	 */
	ComunicacionSoivre find(ComunicacionSoivre comunicacionsoivre);

	/**
	 * Finds a single row in the ComunicacionSoivre table based on its V6COIDGO
	 * value.
	 * 
	 * @param comunicacionsoivre
	 *            Pagination
	 * @return ComunicacionSoivre
	 */
	public ComunicacionSoivre findByV6Codigo(
			ComunicacionSoivre comunicacionsoivre);

	/**
	 * Deletes a single row in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	void remove(ComunicacionSoivre comunicacionsoivre);

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ComunicacionSoivre> findAll(ComunicacionSoivre comunicacionsoivre,
			Pagination pagination);

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @return Long
	 */
	Long findAllCount(ComunicacionSoivre comunicacionsoivre);

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ComunicacionSoivre> findAllBandejaComunicacionSoivre(
			ComunicacionSoivre comunicacionsoivre, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the ComunicacionSoivre table.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaComunicacionSoivreCount(
			ComunicacionSoivre comunicacionsoivre, CensoMonitor censoMonitor);

	/**
	 * Finds rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ComunicacionSoivre> findAllLike(ComunicacionSoivre comunicacionsoivre,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the ComunicacionSoivre table using like.
	 * 
	 * @param comunicacionsoivre
	 *            ComunicacionSoivre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(ComunicacionSoivre comunicacionsoivre,
			Boolean startsWith);
}
