package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Comunicacion;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.TipoComunicacion;

/**
 * * ComunicacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionDaoImpl implements ComunicacionDao {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionDaoImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Comunicacion> rwMap = new RowMapper<Comunicacion>() {
		public Comunicacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Comunicacion(resultSet.getLong("M4COCOMU"),
					new Organismo(resultSet.getString("OrganismoCODORG"),
							resultSet.getString("OrganismoENTIDADID"),
							resultSet.getString("OrganismoNOMBREES"), resultSet
									.getString("OrganismoNOMBREEU"), resultSet
									.getString("OrganismoACTIVA"), resultSet
									.getString("OrganismoISKONTSUMOGEST"),
							resultSet.getString("OrganismoISKONTSUMONET"),
							resultSet.getString("OrganismoISOFERTAFORM"),
							resultSet.getString("OrganismoISCONSULTASWEB"),
							resultSet.getString("OrganismoISNACIONAL"),
							resultSet.getString("OrganismoOBSERVACIONES"),
							resultSet.getString("OrganismoTELEFONO"), resultSet
									.getString("OrganismoFAX"), resultSet
									.getString("OrganismoEMAIL"), resultSet
									.getString("OrganismoURL"), resultSet
									.getString("OrganismoUSUARIO"), resultSet
									.getString("OrganismoPASSWORD"), resultSet
									.getString("OrganismoNORAPAISID"),
							resultSet.getString("OrganismoNOMBREPAIS"),
							resultSet.getString("OrganismoNORAPROVINCIAID"),
							resultSet.getString("OrganismoNOMBREPROVINCIA"),
							resultSet.getString("OrganismoNORAMUNICIPIOID"),
							resultSet.getString("OrganismoNOMBREMUNICIPIO"),
							resultSet.getString("OrganismoNORALOCALIDADID"),
							resultSet.getString("OrganismoNOMBRELOCALIDAD"),
							resultSet.getString("OrganismoNORACALLEID"),
							resultSet.getString("OrganismoNOMBRECALLE"),
							resultSet.getString("OrganismoNORACPID"), resultSet
									.getString("OrganismoNOMBRECP"), resultSet
									.getString("OrganismoNORAPORTALID"),
							resultSet.getString("OrganismoNOMBREPORTAL"),
							resultSet.getString("OrganismoUSUULTMOD"),
							resultSet.getDate("OrganismoFECULTMOD")),
					resultSet.getDate("M4FEENV"), resultSet.getDate("M4FECAD"),
					resultSet.getString("M4NOREMI"),
					resultSet.getString("M4TESUBJECT"),
					resultSet.getString("M4TECOMU"),
					resultSet.getLong("M4NUDEST"),
					resultSet.getLong("M4NUFILADJ"),
					resultSet.getInt("M4INCOMACT"),
					resultSet.getInt("M4INCOMBL"), new TipoComunicacion(
							resultSet.getInt("TipoComunicacionM6CODIGO"),
							resultSet.getString("TipoComunicacionM6NOTIPO"),
							resultSet.getString("TipoComunicacionM6TETIPO"),
							resultSet.getString("TipoComunicacionM6NOTIPOE"),
							resultSet.getString("TipoComunicacionM6NOTIPOI"),
							resultSet.getString("TipoComunicacionM6NOTIPOF"),
							resultSet.getString("TipoComunicacionM6NOTIPOA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return Comunicacion
	 */
	public Comunicacion add(Comunicacion comunicacion) {

		String query = "INSERT INTO COMUNICACION( M4COCOMU,M4COTIPO,M4COCOOR,M4FEENV,M4FECAD,M4NOREMI,M4TESUBJECT,M4TECOMU,M4NUDEST,M4NUFILADJ,M4INCOMACT,M4INCOMBL)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTipoComunicacionM6codigoAux = null;
		if (comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			getTipoComunicacionM6codigoAux = comunicacion.getTipoComunicacion()
					.getM6codigo();
		}

		Object getOrganismoCodOrgAux = null;
		if (comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = comunicacion.getOrganismo().getCodOrg();
		}

		this.jdbcTemplate.update(query, comunicacion.getM4cocomu(),
				getTipoComunicacionM6codigoAux, getOrganismoCodOrgAux,
				comunicacion.getM4feenv(), comunicacion.getM4fecad(),
				comunicacion.getM4noremi(), comunicacion.getM4tesubject(),
				comunicacion.getM4tecomu(), comunicacion.getM4nudest(),
				comunicacion.getM4nufiladj(), comunicacion.getM4incomact(),
				comunicacion.getM4incombl());

		return comunicacion;
	}

	/**
	 * Updates a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return Comunicacion
	 */
	public Comunicacion update(Comunicacion comunicacion) {
		String query = "UPDATE COMUNICACION SET M4COTIPO=?,M4COCOOR=?,M4FEENV=?,M4FECAD=?,M4NOREMI=?,M4TESUBJECT=?,M4TECOMU=?,M4NUDEST=?,M4NUFILADJ=?,M4INCOMACT=?,M4INCOMBL=? WHERE M4COCOMU=?";
		Object getTipoComunicacionM6codigoAux = null;
		if (comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			getTipoComunicacionM6codigoAux = comunicacion.getTipoComunicacion()
					.getM6codigo();
		}
		Object getOrganismoCodOrgAux = null;
		if (comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = comunicacion.getOrganismo().getCodOrg();
		}

		this.jdbcTemplate.update(query, getTipoComunicacionM6codigoAux,
				getOrganismoCodOrgAux, comunicacion.getM4feenv(),
				comunicacion.getM4fecad(), comunicacion.getM4noremi(),
				comunicacion.getM4tesubject(), comunicacion.getM4tecomu(),
				comunicacion.getM4nudest(), comunicacion.getM4nufiladj(),
				comunicacion.getM4incomact(), comunicacion.getM4incombl(),
				comunicacion.getM4cocomu());
		return comunicacion;
	}

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return Comunicacion
	 */
	@Transactional(readOnly = true)
	public Comunicacion find(Comunicacion comunicacion) {
		String query = "SELECT t1.M4COCOMU M4COCOMU, t1.M4COCOOR M4COCOOR, t1.M4FEENV M4FEENV, t1.M4FECAD M4FECAD, t1.M4NOREMI M4NOREMI, t1.M4TESUBJECT M4TESUBJECT, t1.M4TECOMU M4TECOMU, t1.M4NUDEST M4NUDEST, t1.M4NUFILADJ M4NUFILADJ, t1.M4INCOMACT M4INCOMACT, t1.M4INCOMBL M4INCOMBL, t2.M6CODIGO TIPOCOMUNICACIONM6CODIGO, t2.M6NOTIPO TIPOCOMUNICACIONM6NOTIPO, t2.M6TETIPO TIPOCOMUNICACIONM6TETIPO, t2.M6NOTIPOE TIPOCOMUNICACIONM6NOTIPOE, t2.M6NOTIPOI TIPOCOMUNICACIONM6NOTIPOI, t2.M6NOTIPOF TIPOCOMUNICACIONM6NOTIPOF, t2.M6NOTIPOA TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG ORGANISMOCODORG, t3.ENTIDAD_ID ORGANISMOENTIDADID, t3.NOMBRE_ES ORGANISMONOMBREES, t3.NOMBRE_EU ORGANISMONOMBREEU, t3.ACTIVA ORGANISMOACTIVA, t3.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET ORGANISMOISKONTSUMONET, t3.ISOFERTAFORM ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t3.ISNACIONAL ORGANISMOISNACIONAL, t3.OBSERVACIONES ORGANISMOOBSERVACIONES, t3.TELEFONO ORGANISMOTELEFONO, t3.FAX ORGANISMOFAX, t3.EMAIL ORGANISMOEMAIL, t3.URL ORGANISMOURL, t3.USUARIO ORGANISMOUSUARIO, t3.PASSWORD ORGANISMOPASSWORD, t3.NORA_PAIS_ID ORGANISMONORAPAISID, t3.NOMBRE_PAIS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t3.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t3.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID ORGANISMONORACALLEID, t3.NOMBRE_CALLE ORGANISMONOMBRECALLE, t3.NORA_CP_ID ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, t3.NORA_PORTAL_ID ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t3.USUULTMOD ORGANISMOUSUULTMOD, t3.FECULTMOD ORGANISMOFECULTMOD "
				+ "FROM COMUNICACION t1 , TIPO_COMUNICACION t2, ORGANISMO t3  "
				+ "WHERE t1.M4COCOMU = ?   AND t1.M4COTIPO= t2.M6CODIGO(+)  AND t1.M4COCOOR= t3.COD_ORG(+)  ";
		return (Comunicacion) this.jdbcTemplate.queryForObject(query, rwMap,
				comunicacion.getM4cocomu());
	}

	/**
	 * Removes a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return
	 */
	public void remove(Comunicacion comunicacion) {
		String query = "DELETE  FROM COMUNICACION WHERE M4COCOMU=?";
		this.jdbcTemplate.update(query, comunicacion.getM4cocomu());
	}

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Comunicacion> findAll(Comunicacion comunicacion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M4COTIPO= t2.M6CODIGO(+)  AND t1.M4COCOOR= t3.COD_ORG(+)  ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M4COCOMU M4COCOMU,t1.M4COCOOR M4COCOOR,t1.M4FEENV M4FEENV,t1.M4FECAD M4FECAD,t1.M4NOREMI M4NOREMI,t1.M4TESUBJECT M4TESUBJECT,t1.M4TECOMU M4TECOMU,t1.M4NUDEST M4NUDEST,t1.M4NUFILADJ M4NUFILADJ,t1.M4INCOMACT M4INCOMACT,t1.M4INCOMBL M4INCOMBL,t2.M6CODIGO TIPOCOMUNICACIONM6CODIGO,t2.M6NOTIPO TIPOCOMUNICACIONM6NOTIPO,t2.M6TETIPO TIPOCOMUNICACIONM6TETIPO,t2.M6NOTIPOE TIPOCOMUNICACIONM6NOTIPOE,t2.M6NOTIPOI TIPOCOMUNICACIONM6NOTIPOI,t2.M6NOTIPOF TIPOCOMUNICACIONM6NOTIPOF,t2.M6NOTIPOA TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG ORGANISMOCODORG, t3.ENTIDAD_ID ORGANISMOENTIDADID, t3.NOMBRE_ES ORGANISMONOMBREES, t3.NOMBRE_EU ORGANISMONOMBREEU, t3.ACTIVA ORGANISMOACTIVA, t3.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET ORGANISMOISKONTSUMONET, t3.ISOFERTAFORM ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t3.ISNACIONAL ORGANISMOISNACIONAL, t3.OBSERVACIONES ORGANISMOOBSERVACIONES, t3.TELEFONO ORGANISMOTELEFONO, t3.FAX ORGANISMOFAX, t3.EMAIL ORGANISMOEMAIL, t3.URL ORGANISMOURL, t3.USUARIO ORGANISMOUSUARIO, t3.PASSWORD ORGANISMOPASSWORD, t3.NORA_PAIS_ID ORGANISMONORAPAISID, t3.NOMBRE_PAIS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t3.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t3.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID ORGANISMONORACALLEID, t3.NOMBRE_CALLE ORGANISMONOMBRECALLE, t3.NORA_CP_ID ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, t3.NORA_PORTAL_ID ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t3.USUULTMOD ORGANISMOUSUULTMOD, t3.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM COMUNICACION t1 ,TIPO_COMUNICACION t2, ORGANISMO t3 ");

		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}
		if (comunicacion != null && comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.M4COCOOR = ?");
			params.add(comunicacion.getOrganismo().getCodOrg());
		}
		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND t1.M4NOREMI = ?");
			params.add(comunicacion.getM4noremi());
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND t1.M4TESUBJECT = ?");
			params.add(comunicacion.getM4tesubject());
		}
		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Comunicacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Comunicacion comunicacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.M4COTIPO= t2.M6CODIGO(+) AND t1.M4COCOOR= t3.COD_ORG(+)  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  COMUNICACION t1   ,  TIPO_COMUNICACION t2, ORGANISMO t3 ");
		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}
		if (comunicacion != null && comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.M4COCOOR = ?");
			params.add(comunicacion.getOrganismo().getCodOrg());
		}
		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND t1.M4NOREMI = ?");
			params.add(comunicacion.getM4noremi());
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND t1.M4TESUBJECT = ?");
			params.add(comunicacion.getM4tesubject());
		}
		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Comunicacion> findAllLike(Comunicacion comunicacion,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M4COTIPO= t2.M6CODIGO(+)  AND t1.M4COCOOR= t3.COD_ORG(+)  ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M4COCOMU M4COCOMU,t1.M4COCOOR M4COCOOR,t1.M4FEENV M4FEENV,t1.M4FECAD M4FECAD,t1.M4NOREMI M4NOREMI,t1.M4TESUBJECT M4TESUBJECT,t1.M4TECOMU M4TECOMU,t1.M4NUDEST M4NUDEST,t1.M4NUFILADJ M4NUFILADJ,t1.M4INCOMACT M4INCOMACT,t1.M4INCOMBL M4INCOMBL,t2.M6CODIGO TIPOCOMUNICACIONM6CODIGO,t2.M6NOTIPO TIPOCOMUNICACIONM6NOTIPO,t2.M6TETIPO TIPOCOMUNICACIONM6TETIPO,t2.M6NOTIPOE TIPOCOMUNICACIONM6NOTIPOE,t2.M6NOTIPOI TIPOCOMUNICACIONM6NOTIPOI,t2.M6NOTIPOF TIPOCOMUNICACIONM6NOTIPOF,t2.M6NOTIPOA TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG ORGANISMOCODORG, t3.ENTIDAD_ID ORGANISMOENTIDADID, t3.NOMBRE_ES ORGANISMONOMBREES, t3.NOMBRE_EU ORGANISMONOMBREEU, t3.ACTIVA ORGANISMOACTIVA, t3.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET ORGANISMOISKONTSUMONET, t3.ISOFERTAFORM ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t3.ISNACIONAL ORGANISMOISNACIONAL, t3.OBSERVACIONES ORGANISMOOBSERVACIONES, t3.TELEFONO ORGANISMOTELEFONO, t3.FAX ORGANISMOFAX, t3.EMAIL ORGANISMOEMAIL, t3.URL ORGANISMOURL, t3.USUARIO ORGANISMOUSUARIO, t3.PASSWORD ORGANISMOPASSWORD, t3.NORA_PAIS_ID ORGANISMONORAPAISID, t3.NOMBRE_PAIS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t3.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t3.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID ORGANISMONORACALLEID, t3.NOMBRE_CALLE ORGANISMONOMBRECALLE, t3.NORA_CP_ID ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, t3.NORA_PORTAL_ID ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t3.USUULTMOD ORGANISMOUSUULTMOD, t3.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM COMUNICACION t1 ,TIPO_COMUNICACION t2, ORGANISMO t3 ");

		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4cocomu() + "%");
			} else {
				params.add("%" + comunicacion.getM4cocomu() + "%");
			}
			where.append(" AND t1.M4COCOMU IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6codigo()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6codigo()
						+ "%");
			}
			where.append(" AND t2.M6CODIGO IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND UPPER(t2.M6NOTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6notipo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6notipo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6NOTIPO IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND UPPER(t2.M6TETIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6tetipo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6tetipo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6TETIPO IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND UPPER(t2.M6NOTIPOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6notipoe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6notipoe()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6NOTIPOE IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND UPPER(t2.M6NOTIPOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6notipoi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6notipoi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6NOTIPOI IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND UPPER(t2.M6NOTIPOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6notipof()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6notipof()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6NOTIPOF IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND UPPER(t2.M6NOTIPOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getTipoComunicacion().getM6notipoa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getTipoComunicacion().getM6notipoa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M6NOTIPOA IS NOT NULL");
		}

		if (comunicacion != null && comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t1.M4COCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getOrganismo().getCodOrg()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacion.getOrganismo().getCodOrg().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4COCOOR IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4feenv() + "%");
			} else {
				params.add("%" + comunicacion.getM4feenv() + "%");
			}
			where.append(" AND t1.M4FEENV IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4fecad() + "%");
			} else {
				params.add("%" + comunicacion.getM4fecad() + "%");
			}
			where.append(" AND t1.M4FECAD IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND UPPER(t1.M4NOREMI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4noremi().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4noremi().toUpperCase() + "%");
			}
			where.append(" AND t1.M4NOREMI IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND UPPER(t1.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tesubject().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tesubject().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4TESUBJECT IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND UPPER(t1.M4TECOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tecomu().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tecomu().toUpperCase() + "%");
			}
			where.append(" AND t1.M4TECOMU IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4nudest() + "%");
			} else {
				params.add("%" + comunicacion.getM4nudest() + "%");
			}
			where.append(" AND t1.M4NUDEST IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4nufiladj() + "%");
			} else {
				params.add("%" + comunicacion.getM4nufiladj() + "%");
			}
			where.append(" AND t1.M4NUFILADJ IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4incomact() + "%");
			} else {
				params.add("%" + comunicacion.getM4incomact() + "%");
			}
			where.append(" AND t1.M4INCOMACT IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4incombl() + "%");
			} else {
				params.add("%" + comunicacion.getM4incombl() + "%");
			}
			where.append(" AND t1.M4INCOMBL IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Comunicacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Comunicacion> findAllLikeComunicacionEnvio(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M4COTIPO= t2.M6CODIGO(+) AND t1.M4COCOOR= t3.COD_ORG(+)  AND t1.M4COCOMU = t4.M5COCOMU(+) ");

		StringBuffer query = new StringBuffer();
		query.append("SELECT  DISTINCT t1.M4COCOMU AS M4COCOMU, t1.M4COCOOR AS M4COCOOR,t1.M4FEENV AS M4FEENV,t1.M4FECAD AS M4FECAD, ");
		query.append("t1.M4NOREMI AS M4NOREMI, t1.M4TESUBJECT AS M4TESUBJECT,t1.M4TECOMU AS M4TECOMU,t1.M4NUDEST M4NUDEST, ");
		query.append("t1.M4NUFILADJ AS M4NUFILADJ, t1.M4INCOMACT AS M4INCOMACT, t1.M4INCOMBL AS M4INCOMBL, ");
		query.append("t2.M6CODIGO AS TIPOCOMUNICACIONM6CODIGO, t2.M6NOTIPO AS TIPOCOMUNICACIONM6NOTIPO, ");
		query.append("t2.M6TETIPO AS TIPOCOMUNICACIONM6TETIPO, t2.M6NOTIPOE AS TIPOCOMUNICACIONM6NOTIPOE, ");
		query.append("t2.M6NOTIPOI AS TIPOCOMUNICACIONM6NOTIPOI, t2.M6NOTIPOF AS TIPOCOMUNICACIONM6NOTIPOF, ");
		query.append("t2.M6NOTIPOA AS TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG AS ORGANISMOCODORG, t3.ENTIDAD_ID AS ORGANISMOENTIDADID, ");
		query.append("t3.NOMBRE_ES AS ORGANISMONOMBREES, t3.NOMBRE_EU AS ORGANISMONOMBREEU, t3.ACTIVA AS ORGANISMOACTIVA, ");
		query.append("t3.ISKONTSUMOGEST AS ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET AS ORGANISMOISKONTSUMONET, ");
		query.append("t3.ISOFERTAFORM AS ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB AS ORGANISMOISCONSULTASWEB, ");
		query.append("t3.ISNACIONAL AS ORGANISMOISNACIONAL, t3.OBSERVACIONES AS ORGANISMOOBSERVACIONES, t3.TELEFONO AS ORGANISMOTELEFONO, ");
		query.append("t3.FAX AS ORGANISMOFAX, t3.EMAIL AS ORGANISMOEMAIL, t3.URL AS ORGANISMOURL, ");
		query.append("t3.USUARIO AS ORGANISMOUSUARIO, t3.PASSWORD AS ORGANISMOPASSWORD, t3.NORA_PAIS_ID AS ORGANISMONORAPAISID, ");
		query.append("t3.NOMBRE_PAIS AS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID AS ORGANISMONORAPROVINCIAID, ");
		query.append("t3.NOMBRE_PROVINCIA AS ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID AS ORGANISMONORAMUNICIPIOID, ");
		query.append("t3.NOMBRE_MUNICIPIO AS ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID AS ORGANISMONORALOCALIDADID, ");
		query.append("t3.NOMBRE_LOCALIDAD AS ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID AS ORGANISMONORACALLEID, ");
		query.append("t3.NOMBRE_CALLE AS ORGANISMONOMBRECALLE, t3.NORA_CP_ID AS ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, ");
		query.append("t3.NORA_PORTAL_ID AS ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL AS ORGANISMONOMBREPORTAL, ");
		query.append("t3.USUULTMOD AS ORGANISMOUSUULTMOD, t3.FECULTMOD AS ORGANISMOFECULTMOD ");
		query.append("FROM COMUNICACION t1 ,TIPO_COMUNICACION t2, ORGANISMO t3,DEST_COMUNICACION t4 ");

		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}

		where.append(" AND t1.M4COCOOR = ?");
		params.add(comunicacion.getOrganismo().getCodOrg());

		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND t1.M4NOREMI = ?");
			params.add(comunicacion.getM4noremi());
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND UPPER(t1.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tesubject().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tesubject().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4TESUBJECT IS NOT NULL");
		}

		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaEnvioDesde != null && fechaEnvioDesde instanceof Date) {
			where.append(" AND t1.M4FEENV >= ?");
			params.add(fechaEnvioDesde);
		}
		if (fechaEnvioHasta != null && fechaEnvioHasta instanceof Date) {
			where.append(" AND t1.M4FEENV <= ?");
			params.add(fechaEnvioHasta);
		}

		if (codOrgDestino != null) {
			where.append(" AND t4.M5COOR = ? ");
			params.add(codOrgDestino);
		}

		query.append(where);

		logger.warn("Query: " + query.toString());

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<Comunicacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());

	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeComunicacionEnvioCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.M4COTIPO= t2.M6CODIGO(+)  AND t1.M4COCOOR= t3.COD_ORG(+) AND t1.M4COCOMU = t4.M5COCOMU(+)   ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(DISTINCT t1.M4COCOMU) FROM  COMUNICACION t1   ,  TIPO_COMUNICACION t2, ORGANISMO t3,DEST_COMUNICACION t4 ");
		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}

		where.append(" AND t1.M4COCOOR = ?");
		params.add(comunicacion.getOrganismo().getCodOrg());

		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND t1.M4NOREMI = ?");
			params.add(comunicacion.getM4noremi());
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND UPPER(t1.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tesubject().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tesubject().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4TESUBJECT IS NOT NULL");
		}

		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaEnvioDesde != null && fechaEnvioDesde instanceof Date) {
			where.append(" AND t1.M4FEENV >= ?");
			params.add(fechaEnvioDesde);
		}
		if (fechaEnvioHasta != null && fechaEnvioHasta instanceof Date) {
			where.append(" AND t1.M4FEENV <= ?");
			params.add(fechaEnvioHasta);
		}
		if (codOrgDestino != null) {
			where.append(" AND t4.M5COOR = ? ");
			params.add(codOrgDestino);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	// @Transactional(readOnly = true)
	public List<Comunicacion> findAllLikeComunicacionRecepcion(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M4COTIPO= t2.M6CODIGO(+) AND t1.M4COCOOR= t3.COD_ORG(+) AND t1.M4COCOMU = t4.M5COCOMU ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M4COCOMU M4COCOMU,t1.M4COCOOR M4COCOOR,t1.M4FEENV M4FEENV,t1.M4FECAD M4FECAD,t1.M4NOREMI M4NOREMI,t1.M4TESUBJECT M4TESUBJECT,t1.M4TECOMU M4TECOMU,t1.M4NUDEST M4NUDEST,t1.M4NUFILADJ M4NUFILADJ,t1.M4INCOMACT M4INCOMACT,t1.M4INCOMBL M4INCOMBL,t2.M6CODIGO TIPOCOMUNICACIONM6CODIGO,t2.M6NOTIPO TIPOCOMUNICACIONM6NOTIPO,t2.M6TETIPO TIPOCOMUNICACIONM6TETIPO,t2.M6NOTIPOE TIPOCOMUNICACIONM6NOTIPOE,t2.M6NOTIPOI TIPOCOMUNICACIONM6NOTIPOI,t2.M6NOTIPOF TIPOCOMUNICACIONM6NOTIPOF,t2.M6NOTIPOA TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG ORGANISMOCODORG, t3.ENTIDAD_ID ORGANISMOENTIDADID, t3.NOMBRE_ES ORGANISMONOMBREES, t3.NOMBRE_EU ORGANISMONOMBREEU, t3.ACTIVA ORGANISMOACTIVA, t3.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET ORGANISMOISKONTSUMONET, t3.ISOFERTAFORM ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t3.ISNACIONAL ORGANISMOISNACIONAL, t3.OBSERVACIONES ORGANISMOOBSERVACIONES, t3.TELEFONO ORGANISMOTELEFONO, t3.FAX ORGANISMOFAX, t3.EMAIL ORGANISMOEMAIL, t3.URL ORGANISMOURL, t3.USUARIO ORGANISMOUSUARIO, t3.PASSWORD ORGANISMOPASSWORD, t3.NORA_PAIS_ID ORGANISMONORAPAISID, t3.NOMBRE_PAIS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t3.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t3.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID ORGANISMONORACALLEID, t3.NOMBRE_CALLE ORGANISMONOMBRECALLE, t3.NORA_CP_ID ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, t3.NORA_PORTAL_ID ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t3.USUULTMOD ORGANISMOUSUULTMOD, t3.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM COMUNICACION t1 ,TIPO_COMUNICACION t2, ORGANISMO t3,DEST_COMUNICACION t4 ");

		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}
		if (comunicacion != null && comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.M4COCOOR = ?");
			params.add(comunicacion.getOrganismo().getCodOrg());
		}
		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND UPPER(t1.M4NOREMI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4noremi().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4noremi().toUpperCase() + "%");
			}
			where.append(" AND t1.M4NOREMI IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND UPPER(t1.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tesubject().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tesubject().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4TESUBJECT IS NOT NULL");
		}

		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaEnvioDesde != null && fechaEnvioDesde instanceof Date) {
			where.append(" AND t1.M4FEENV >= ?");
			params.add(fechaEnvioDesde);
		}
		if (fechaEnvioHasta != null && fechaEnvioHasta instanceof Date) {
			where.append(" AND t1.M4FEENV <= ?");
			params.add(fechaEnvioHasta);
		}

		if (comunicacion != null
				&& comunicacion.getIndicadorLeidos() != null
				&& comunicacion.getIndicadorLeidos().equals(
						Y41bConstantes.COMUNICACION_LEIDA)) {
			where.append(" AND t4.M5FELEIDO IS NOT NULL ");
		}

		if (comunicacion != null
				&& comunicacion.getIndicadorLeidos() != null
				&& comunicacion.getIndicadorLeidos().equals(
						Y41bConstantes.COMUNICACION_NO_LEIDA)) {
			where.append(" AND t4.M5FELEIDO IS NULL ");
		}

		where.append(" AND t4.M5COOR = ? ");
		params.add(codOrgDestino);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		logger.warn("Query: " + query);

		return (List<Comunicacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());

	}

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeComunicacionRecepcionCount(
			Comunicacion comunicacion, Boolean startsWith,
			String codOrgDestino, Date fechaEnvioDesde, Date fechaEnvioHasta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 AND t1.M4COTIPO= t2.M6CODIGO(+) AND t1.M4COCOOR= t3.COD_ORG(+) AND t1.M4COCOMU = t4.M5COCOMU ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  COMUNICACION t1   ,  TIPO_COMUNICACION t2, ORGANISMO t3 ,DEST_COMUNICACION t4 ");
		if (comunicacion != null && comunicacion.getM4cocomu() != null) {
			where.append(" AND t1.M4COCOMU = ?");
			params.add(comunicacion.getM4cocomu());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			where.append(" AND t2.M6CODIGO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6codigo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipo() != null) {
			where.append(" AND t2.M6NOTIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6tetipo() != null) {
			where.append(" AND t2.M6TETIPO = ?");
			params.add(comunicacion.getTipoComunicacion().getM6tetipo());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoe() != null) {
			where.append(" AND t2.M6NOTIPOE = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoe());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoi() != null) {
			where.append(" AND t2.M6NOTIPOI = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoi());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipof() != null) {
			where.append(" AND t2.M6NOTIPOF = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipof());
		}
		if (comunicacion != null && comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6notipoa() != null) {
			where.append(" AND t2.M6NOTIPOA = ?");
			params.add(comunicacion.getTipoComunicacion().getM6notipoa());
		}
		if (comunicacion != null && comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.M4COCOOR = ?");
			params.add(comunicacion.getOrganismo().getCodOrg());
		}
		if (comunicacion != null && comunicacion.getM4feenv() != null) {
			where.append(" AND t1.M4FEENV = ?");
			params.add(comunicacion.getM4feenv());
		}
		if (comunicacion != null && comunicacion.getM4fecad() != null) {
			where.append(" AND t1.M4FECAD = ?");
			params.add(comunicacion.getM4fecad());
		}
		if (comunicacion != null && comunicacion.getM4noremi() != null) {
			where.append(" AND UPPER(t1.M4NOREMI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4noremi().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4noremi().toUpperCase() + "%");
			}
			where.append(" AND t1.M4NOREMI IS NOT NULL");
		}
		if (comunicacion != null && comunicacion.getM4tesubject() != null) {
			where.append(" AND UPPER(t1.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacion.getM4tesubject().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacion.getM4tesubject().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4TESUBJECT IS NOT NULL");
		}

		if (comunicacion != null && comunicacion.getM4tecomu() != null) {
			where.append(" AND t1.M4TECOMU = ?");
			params.add(comunicacion.getM4tecomu());
		}
		if (comunicacion != null && comunicacion.getM4nudest() != null) {
			where.append(" AND t1.M4NUDEST = ?");
			params.add(comunicacion.getM4nudest());
		}
		if (comunicacion != null && comunicacion.getM4nufiladj() != null) {
			where.append(" AND t1.M4NUFILADJ = ?");
			params.add(comunicacion.getM4nufiladj());
		}
		if (comunicacion != null && comunicacion.getM4incomact() != null) {
			where.append(" AND t1.M4INCOMACT = ?");
			params.add(comunicacion.getM4incomact());
		}
		if (comunicacion != null && comunicacion.getM4incombl() != null) {
			where.append(" AND t1.M4INCOMBL = ?");
			params.add(comunicacion.getM4incombl());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaEnvioDesde != null && fechaEnvioDesde instanceof Date) {
			where.append(" AND t1.M4FEENV >= ?");
			params.add(fechaEnvioDesde);
		}
		if (fechaEnvioHasta != null && fechaEnvioHasta instanceof Date) {
			where.append(" AND t1.M4FEENV <= ?");
			params.add(fechaEnvioHasta);
		}

		where.append(" AND t4.M5COOR = ? ");
		params.add(codOrgDestino);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21M4T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
