package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Comunicacion;

/**
 * * ComunicacionDao  
 * 
 *  
 */

public interface ComunicacionDao {

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion add(Comunicacion comunicacion);

	/**
	 * Updates a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion update(Comunicacion comunicacion);

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	Comunicacion find(Comunicacion comunicacion);

	/**
	 * Deletes a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return
	 */
	void remove(Comunicacion comunicacion);

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Comunicacion> findAll(Comunicacion comunicacion, Pagination pagination);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return List
	 */
	Long findAllCount(Comunicacion comunicacion);

	/**
	 * Finds rows in the Comunicacion table using like.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Comunicacion> findAllLike(Comunicacion comunicacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	List<Comunicacion> findAllLikeComunicacionEnvio(Comunicacion comunicacion,
			Pagination pagination, Boolean startsWith, String codOrgDestino,
			Date fechaEnvioDesde, Date fechaEnvioHasta);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeComunicacionEnvioCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Finds a List of rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return List
	 */
	List<Comunicacion> findAllLikeComunicacionRecepcion(
			Comunicacion comunicacion, Pagination pagination,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Counts rows in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param startsWith
	 *            Boolean
	 * @param codOrgDestino
	 *            String
	 * @param fechaEnvioDesde
	 *            Date
	 * @param fechaEnvioHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeComunicacionRecepcionCount(Comunicacion comunicacion,
			Boolean startsWith, String codOrgDestino, Date fechaEnvioDesde,
			Date fechaEnvioHasta);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();
}
