package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ClaseingresoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ClaseIngresoDaoImpl implements ClaseingresoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Claseingreso> rwMap = new RowMapper<Claseingreso>() {
		public Claseingreso mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Claseingreso(resultSet.getString("SLCODIGO"),
					resultSet.getString("SLDESCES"),
					resultSet.getString("SLDESCEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return claseingreso
	 */
	public Claseingreso add(Claseingreso claseingreso) {
		String query = "INSERT INTO Claseingreso (SLCODIGO, SLDESCES, SLDESCEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, claseingreso.getSlcodigo(),
				claseingreso.getSldesces(), claseingreso.getSldesceu());
		return claseingreso;
	}

	/**
	 * Updates a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Pagination
	 * @return claseingreso
	 */
	public Claseingreso update(Claseingreso claseingreso) {
		String query = "UPDATE Claseingreso SET SLDESCES=?, SLDESCEU=? WHERE SLCODIGO=?";
		this.jdbcTemplate.update(query, claseingreso.getSldesces(),
				claseingreso.getSldesceu(), claseingreso.getSlcodigo());
		return claseingreso;
	}

	/**
	 * Finds a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Pagination
	 * @return claseingreso
	 */
	@Transactional(readOnly = true)
	public Claseingreso find(Claseingreso claseingreso) {
		String query = "SELECT t1.SLCODIGO SLCODIGO, t1.SLDESCES SLDESCES, t1.SLDESCEU SLDESCEU FROM CLASEINGRESO t1  WHERE t1.SLCODIGO = ?  ";

		List<Claseingreso> ClaseingresoList = this.jdbcTemplate.query(query,
				this.rwMap, claseingreso.getSlcodigo());
		return (Claseingreso) DataAccessUtils.uniqueResult(ClaseingresoList);
	}

	/**
	 * Removes a single row in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Pagination
	 * @return
	 */
	public void remove(Claseingreso claseingreso) {
		String query = "DELETE FROM CLASEINGRESO WHERE SLCODIGO=?";
		this.jdbcTemplate.update(query, claseingreso.getSlcodigo());
	}

	/**
	 * Finds a List of rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Claseingreso> findAll(Claseingreso claseingreso,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SLCODIGO SLCODIGO,t1.SLDESCES SLDESCES,t1.SLDESCEU SLDESCEU ");
		query.append("FROM CLASEINGRESO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(claseingreso);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Claseingreso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Claseingreso table.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Claseingreso claseingreso) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CLASEINGRESO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(claseingreso);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Claseingreso> findAllLike(Claseingreso claseingreso,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SLCODIGO SLCODIGO,t1.SLDESCES SLDESCES,t1.SLDESCEU SLDESCEU ");
		query.append("FROM CLASEINGRESO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(claseingreso,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Claseingreso>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Claseingreso table using like.
	 * 
	 * @param claseingreso
	 *            Claseingreso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Claseingreso claseingreso, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CLASEINGRESO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(claseingreso,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Claseingreso entity
	 * 
	 * @param claseingreso
	 *            Claseingreso Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Claseingreso claseingreso) {

		StringBuilder where = new StringBuilder(
				ClaseIngresoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (claseingreso != null && claseingreso.getSlcodigo() != null) {
			where.append(" AND t1.SLCODIGO = ?");
			params.add(claseingreso.getSlcodigo());
		}
		if (claseingreso != null && claseingreso.getSldesces() != null) {
			where.append(" AND t1.SLDESCES = ?");
			params.add(claseingreso.getSldesces());
		}
		if (claseingreso != null && claseingreso.getSldesceu() != null) {
			where.append(" AND t1.SLDESCEU = ?");
			params.add(claseingreso.getSldesceu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Claseingreso entity
	 * 
	 * @param claseingreso
	 *            Claseingreso Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Claseingreso claseingreso,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ClaseIngresoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (claseingreso != null && claseingreso.getSlcodigo() != null) {
			where.append(" AND UPPER(t1.SLCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseingreso.getSlcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + claseingreso.getSlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SLCODIGO IS NOT NULL");
		}
		if (claseingreso != null && claseingreso.getSldesces() != null) {
			where.append(" AND UPPER(t1.SLDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseingreso.getSldesces().toUpperCase() + "%");
			} else {
				params.add("%" + claseingreso.getSldesces().toUpperCase() + "%");
			}
			where.append(" AND t1.SLDESCES IS NOT NULL");
		}
		if (claseingreso != null && claseingreso.getSldesceu() != null) {
			where.append(" AND UPPER(t1.SLDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseingreso.getSldesceu().toUpperCase() + "%");
			} else {
				params.add("%" + claseingreso.getSldesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.SLDESCEU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer(
					"SELECT L21SLQ00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
