package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;

/**
 * * CensoMonitorDao  
 * 
 *  
 */

public interface CensoMonitorDao {

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor add(CensoMonitor censomonitor);

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor update(CensoMonitor censomonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	CensoMonitor find(CensoMonitor censomonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findCensoMonitorUser(CensoMonitor censomonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findCensoMonitorUsuarioXLNET(CensoMonitor censomonitor);

	/**
	 * Deletes a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return
	 */
	void remove(CensoMonitor censomonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CensoMonitor> findAll(CensoMonitor censomonitor, Pagination pagination);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	Long findAllCount(CensoMonitor censomonitor);

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censomonitor, Pagination pagination);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaCount(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLike(CensoMonitor censomonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllLikeFilter(CensoMonitor censomonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllFilterModif(CensoMonitor censomonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CensoMonitor> findAllFilterModifArb(CensoMonitor censomonitor, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountFilter(CensoMonitor censomonitor, Boolean startsWith);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaAsignacionInstructor(CensoMonitor censomonitor);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaDirectorCount(CensoMonitor censomonitor);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaCoordinadorSolicitudesCount(CensoMonitor censomonitor);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaCoordinadorSancionesCount(CensoMonitor censomonitor);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaCoordinadorInspeccionesCount(CensoMonitor censomonitor);

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCensoMonitorAltaCoordinadorArbitrajeCount(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor findCoordinadorSolicitudes(CensoMonitor censomonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	public CensoMonitor findCoordinadorInspecciones(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor
	 * 
	 * @return CensoMonitor
	 */
	public CensoMonitor findDirectorSolicitudes();

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @return CensoMonitor
	 */
	public CensoMonitor findDirectorInspecciones();

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @return CensoMonitor
	 */
	@Transactional(readOnly = true)
	public CensoMonitor findDirectorSanciones();

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaSolicitudInspeccion(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSolicitudInspeccion(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorSanciones(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param responsableExpediente
	 *            boolean
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorArbitrajes(CensoMonitor censomonitor, boolean responsableExpediente);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultas(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaConsultasEmpresas(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultas(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaConsultasEmpresas(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSolicitudes(CensoMonitor censomonitor);

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaSanciones(CensoMonitor censomonitor);

	// EVOLUTIVO 0135083 2.10
	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorAltaBusquedaInspecciones(CensoMonitor censomonitor);

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @return CensoMonitor
	 */
	public CensoMonitor findDirectorArbitraje();

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @return CensoMonitor
	 */
	CensoMonitor findCoordinadorArbitraje();

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	public CensoMonitor findCoordinadorSanciones(CensoMonitor censomonitor);

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	public List<CensoMonitor> findAllCensoMonitorDenunciaEmpresas(CensoMonitor censomonitor);
}
