package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Ccta1;

/**
 * Ccta1DaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class Ccta1DaoImpl implements Ccta1Dao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Ccta1> rwMap = new RowMapper<Ccta1>() {
		public Ccta1 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ccta1(new Aacc(resultSet.getString("M7COCC"), null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null),
					resultSet.getString("M7COTA1"),
					resultSet.getDate("M7FECALTA"),
					resultSet.getString("M7USUALTA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Pagination
	 * @return Ccta1
	 */
	public Ccta1 add(Ccta1 ccta1) {
		String query = "INSERT INTO CCTA1 (M7COCC, M7COTA1, M7FECALTA, M7USUALTA) VALUES (?,?,?,?)";
		Object AaccCccodigoAux = null;
		if (ccta1.getAacc() != null && ccta1.getAacc().getCccodigo() != null) {
			AaccCccodigoAux = ccta1.getAacc().getCccodigo();
		}
		this.jdbcTemplate.update(query, AaccCccodigoAux, ccta1.getM7cota1(),
				ccta1.getM7fecalta(), ccta1.getM7usualta());
		return ccta1;
	}

	/**
	 * Updates a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Pagination
	 * @return Ccta1
	 */
	public Ccta1 update(Ccta1 ccta1) {
		String query = "UPDATE CCTA1 SET  WHERE M7COCC=? AND M7COTA1=? AND M7FECALTA=? AND M7USUALTA=?";
		Object AaccCccodigoAux = null;
		if (ccta1.getAacc() != null && ccta1.getAacc().getCccodigo() != null) {
			AaccCccodigoAux = ccta1.getAacc().getCccodigo();
		}
		this.jdbcTemplate.update(query, AaccCccodigoAux, ccta1.getM7cota1(),
				ccta1.getM7fecalta(), ccta1.getM7usualta());
		return ccta1;
	}

	/**
	 * Finds a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Pagination
	 * @return Ccta1
	 */
	@Transactional(readOnly = true)
	public Ccta1 find(Ccta1 ccta1) {
		String query = "SELECT t1.M7COCC M7COCC, t1.M7COTA1 M7COTA1, t1.M7FECALTA M7FECALTA, t1.M7USUALTA M7USUALTA FROM CCTA1 t1  WHERE t1.M7COCC = ?   AND t1.M7COTA1 = ?   AND t1.M7FECALTA = ?   AND t1.M7USUALTA = ?  ";

		List<Ccta1> ccta1List = this.jdbcTemplate.query(query, this.rwMap,
				ccta1.getAacc().getCccodigo(), ccta1.getM7cota1(),
				ccta1.getM7fecalta(), ccta1.getM7usualta());
		return (Ccta1) DataAccessUtils.uniqueResult(ccta1List);
	}

	/**
	 * Removes a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Pagination
	 * @return
	 */
	public void remove(Ccta1 ccta1) {
		String query = "DELETE FROM CCTA1 WHERE M7COCC=? AND M7COTA1 IN ('01','20','48') ";
		this.jdbcTemplate.update(query, ccta1.getAacc().getCccodigo() /*
																	 * , ccta1.
																	 * getM7cota1
																	 * () ,
																	 * ccta1
																	 * .getM7fecalta
																	 * () ,
																	 * ccta1
																	 * .getM7usualta
																	 * ()
																	 */);
	}

	/**
	 * Finds a List of rows in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ccta1> findAll(Ccta1 ccta1, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M7COCC M7COCC,t1.M7COTA1 M7COTA1,t1.M7FECALTA M7FECALTA,t1.M7USUALTA M7USUALTA ");
		query.append("FROM CCTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ccta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ccta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ccta1 ccta1) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CCTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ccta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ccta1 table using like.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ccta1> findAllLike(Ccta1 ccta1, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M7COCC M7COCC,t1.M7COTA1 M7COTA1,t1.M7FECALTA M7FECALTA,t1.M7USUALTA M7USUALTA ");
		query.append("FROM CCTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ccta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ccta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ccta1 table using like.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ccta1 ccta1, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CCTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ccta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ccta1 entity
	 * 
	 * @param ccta1
	 *            Ccta1 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Ccta1 ccta1) {

		StringBuilder where = new StringBuilder(
				Ccta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ccta1 != null && ccta1.getAacc().getCccodigo() != null) {
			where.append(" AND t1.M7COCC = ?");
			params.add(ccta1.getAacc().getCccodigo());
		}
		if (ccta1 != null && ccta1.getM7cota1() != null) {
			where.append(" AND t1.M7COTA1 = ?");
			params.add(ccta1.getM7cota1());
		}
		if (ccta1 != null && ccta1.getM7fecalta() != null) {
			where.append(" AND t1.M7FECALTA = ?");
			params.add(ccta1.getM7fecalta());
		}
		if (ccta1 != null && ccta1.getM7usualta() != null) {
			where.append(" AND t1.M7USUALTA = ?");
			params.add(ccta1.getM7usualta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ccta1 entity
	 * 
	 * @param ccta1
	 *            Ccta1 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Ccta1 ccta1, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ccta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ccta1 != null && ccta1.getAacc().getCccodigo() != null) {
			where.append(" AND UPPER(t1.M7COCC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccta1.getAacc().getCccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ccta1.getAacc().getCccodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M7COCC IS NOT NULL");
		}
		if (ccta1 != null && ccta1.getM7cota1() != null) {
			where.append(" AND UPPER(t1.M7COTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccta1.getM7cota1().toUpperCase() + "%");
			} else {
				params.add("%" + ccta1.getM7cota1().toUpperCase() + "%");
			}
			where.append(" AND t1.M7COTA1 IS NOT NULL");
		}
		if (ccta1 != null && ccta1.getM7fecalta() != null) {
			where.append(" AND t1.M7FECALTA = ?");
			params.add(ccta1.getM7fecalta());
		}
		if (ccta1 != null && ccta1.getM7usualta() != null) {
			where.append(" AND UPPER(t1.M7USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccta1.getM7usualta().toUpperCase() + "%");
			} else {
				params.add("%" + ccta1.getM7usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.M7USUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
