package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Ccta1;

/**
 * Ccta1Dao  
 *  
 */

public interface Ccta1Dao {
    
    /**
     * Inserts a single row in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @return Ccta1
     */
    Ccta1 add(Ccta1 ccta1);

    /**
     * Updates a single row in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @return Ccta1
     */
    Ccta1 update(Ccta1 ccta1);

    /**
     * Finds a single row in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @return Ccta1
     */
    Ccta1 find(Ccta1 ccta1);

    /**
     * Deletes a single row in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @return 
     */
    void remove(Ccta1 ccta1);

    /**
     * Finds a List of rows in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @param pagination Pagination
     * @return List
     */
    List<Ccta1> findAll(Ccta1 ccta1, Pagination pagination);

    /**
     * Counts rows in the Ccta1 table.
     *
     * @param ccta1 Ccta1
     * @return Long
     */
    Long findAllCount(Ccta1 ccta1);
	
	/**
     * Finds rows in the Ccta1 table using like.
     *
     * @param ccta1 Ccta1
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Ccta1> findAllLike(Ccta1 ccta1, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Ccta1 table using like.
     *
     * @param ccta1 Ccta1
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Ccta1 ccta1, Boolean startsWith);
}

