package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Ccar;
import com.ejie.y41b.model.Organismo;

/**
 * CcarDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class CcarDaoImpl implements CcarDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Ccar> rwMap = new RowMapper<Ccar>() {
		public Ccar mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Aacc aacc = new Aacc(resultSet.getString("M1COCC"), null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null);
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			aacc.setOrganismo(organismo);
			return new Ccar(aacc, new Arbitro(resultSet.getString("M1COAR"),
					null, resultSet.getString("ArbitroARNIF"),
					resultSet.getString("ArbitroARNOMBRE"), null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null),
					resultSet.getString("M1CENTROAR"), null, null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Pagination
	 * @return Ccar
	 */
	public Ccar add(Ccar ccar) {
		String query = "INSERT INTO Y41BC4T00 (M1COCC, M1COAR, M1CENTROAR) VALUES (?,?,?)";
		Object AaccCccodigoAux = null;
		if (ccar.getAacc() != null && ccar.getAacc().getCccodigo() != null) {
			AaccCccodigoAux = ccar.getAacc().getCccodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (ccar.getArbitro() != null
				&& ccar.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = ccar.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, AaccCccodigoAux, ArbitroArcodigoAux,
				ccar.getM1centroar());
		return ccar;
	}

	/**
	 * Updates a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Pagination
	 * @return Ccar
	 */
	public Ccar update(Ccar ccar) {
		String query = "UPDATE CCAR SET M1CENTROAR=? WHERE M1COCC=? AND M1COAR=?";
		Object AaccCccodigoAux = null;
		if (ccar.getAacc() != null && ccar.getAacc().getCccodigo() != null) {
			AaccCccodigoAux = ccar.getAacc().getCccodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (ccar.getArbitro() != null
				&& ccar.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = ccar.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ccar.getM1centroar(), AaccCccodigoAux,
				ArbitroArcodigoAux);
		return ccar;
	}

	/**
	 * Finds a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Pagination
	 * @return Ccar
	 */
	@Transactional(readOnly = true)
	public Ccar find(Ccar ccar) {
		String query = "SELECT t1.M1COCC M1COCC, t1.M1COAR M1COAR, t1.M1CENTROAR M1CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE, t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU  FROM Y41BC4T00 t1, ARBITRO t2, ORGANISMO t3 WHERE t1.M1COAR=t2.ARCODIGO(+) AND t1.M1COCC=t3.COD_ORG(+) AND t1.M1COCC = ? AND t1.M1COAR = ? ";

		List<Ccar> ccarList = this.jdbcTemplate.query(query, this.rwMap, ccar
				.getAacc().getCccodigo(), ccar.getArbitro().getArcodigo());
		return (Ccar) DataAccessUtils.uniqueResult(ccarList);
	}

	/**
	 * Removes a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Pagination
	 * @return
	 */
	public void remove(Ccar ccar) {
		String query = "DELETE FROM Y41BC4T00 WHERE M1COCC=? AND M1COAR=? ";
		this.jdbcTemplate.update(query, ccar.getAacc().getCccodigo(), ccar
				.getArbitro().getArcodigo());
	}

	/**
	 * Finds a List of rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ccar> findAll(Ccar ccar, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M1COCC M1COCC,t1.M1COAR M1COAR,t1.M1CENTROAR M1CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE, t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU ");
		query.append("FROM Y41BC4T00 t1 , ARBITRO t2, ORGANISMO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ccar);
		StringBuilder where = new StringBuilder(
				" WHERE t1.M1COAR=t2.ARCODIGO(+) AND t1.M1COCC=t3.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ccar>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ccar ccar) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BC4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ccar);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ccar> findAllLike(Ccar ccar, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M1COCC M1COCC,t1.M1COAR M1COAR,t1.M1CENTROAR M1CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE, t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU ");
		query.append("FROM Y41BC4T00 t1 , ARBITRO t2, ORGANISMO t3  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ccar, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.M1COAR=t2.ARCODIGO(+) AND t1.M1COCC=t3.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Ccar>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ccar ccar, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BC4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ccar, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ccar entity
	 * 
	 * @param ccar
	 *            Ccar Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Ccar ccar) {

		StringBuilder where = new StringBuilder(CcarDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ccar != null && ccar.getAacc() != null
				&& ccar.getAacc().getCccodigo() != null) {
			where.append(" AND t1.M1COCC = ?");
			params.add(ccar.getAacc().getCccodigo());
		}
		if (ccar != null && ccar.getArbitro() != null
				&& ccar.getArbitro().getArcodigo() != null) {
			where.append(" AND t1.M1COAR = ?");
			params.add(ccar.getArbitro().getArcodigo());
		}
		if (ccar != null && ccar.getM1centroar() != null) {
			where.append(" AND t1.M1CENTROAR = ?");
			params.add(ccar.getM1centroar());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ccar entity
	 * 
	 * @param ccar
	 *            Ccar Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Ccar ccar, Boolean startsWith) {

		StringBuilder where = new StringBuilder(CcarDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ccar != null && ccar.getAacc().getCccodigo() != null) {
			where.append(" AND UPPER(t1.CCCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccar.getAacc().getCccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ccar.getAacc().getCccodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CCCODIGO IS NOT NULL");
		}
		if (ccar != null && ccar.getArbitro().getArcodigo() != null) {
			where.append(" AND UPPER(t1.ARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccar.getArbitro().getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ccar.getArbitro().getArcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARCODIGO IS NOT NULL");
		}
		if (ccar != null && ccar.getM1centroar() != null) {
			where.append(" AND UPPER(t1.M1CENTROAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccar.getM1centroar().toUpperCase() + "%");
			} else {
				params.add("%" + ccar.getM1centroar().toUpperCase() + "%");
			}
			where.append(" AND t1.M1CENTROAR IS NOT NULL");
		}
		if (ccar != null && ccar.getM1fecalta() != null) {
			where.append(" AND t1.M1FECALTA = ?");
			params.add(ccar.getM1fecalta());
		}
		if (ccar != null && ccar.getM1usualta() != null) {
			where.append(" AND UPPER(t1.M1USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ccar.getM1usualta().toUpperCase() + "%");
			} else {
				params.add("%" + ccar.getM1usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.M1USUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param aacc
	 *            Aacc
	 */
	public void volcarAaccArbitros(Aacc aacc) {
		String query = "DELETE FROM Y41BC4T00 WHERE M1COCC = ? ";
		this.jdbcTemplate.update(query, aacc.getCccodigo());
		query = "INSERT INTO Y41BC4T00 SELECT M1COCC, M1COAR, M1CENTROAR FROM CCAR WHERE M1COCC = ? ";
		this.jdbcTemplate.update(query, aacc.getCccodigo());
	}

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	public void volcarArbitroAaccs(Arbitro arbitro) {
		String query = "DELETE FROM Y41BC4T00 WHERE M1COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
		query = "INSERT INTO Y41BC4T00 SELECT M1COCC, M1COAR, M1CENTROAR FROM CCAR WHERE M1COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
	}

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param ccar
	 *            Ccar
	 */
	public void removeCcarAacc(Ccar ccar) {
		String query = "DELETE FROM CCAR WHERE M1COCC = ?  ";
		this.jdbcTemplate.update(query, ccar.getAacc().getCccodigo());
	}

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param ccar
	 *            Ccar
	 */
	public void removeCcarArbitro(Ccar ccar) {
		String query = "DELETE FROM CCAR WHERE M1COAR = ?  ";
		this.jdbcTemplate.update(query, ccar.getArbitro().getArcodigo());
	}

	/**
	 * Aadir sobre la tabla temporal
	 * 
	 * @param ccar
	 *            Ccar
	 */
	public void addCcar(Ccar ccar) {
		String query = "INSERT INTO CCAR (M1COCC, M1COAR, M1CENTROAR) VALUES (?,?,?)";
		Object AaccOecodigoAux = null;
		if (ccar.getAacc() != null && ccar.getAacc().getCccodigo() != null) {
			AaccOecodigoAux = ccar.getAacc().getCccodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (ccar.getArbitro() != null
				&& ccar.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = ccar.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, AaccOecodigoAux, ArbitroArcodigoAux,
				ccar.getM1centroar());
	}
}
