package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CargaTrabajo;

/**
 * CargaTrabajoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CargaTrabajoDaoImpl implements CargaTrabajoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CargaTrabajo> rwMap = new RowMapper<CargaTrabajo>() {
		public CargaTrabajo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new CargaTrabajo(resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
					resultSet.getString("MOCOOR"), resultSet.getBigDecimal("EXPEDIENTESABIERTOSINS"),
					resultSet.getBigDecimal("EXPEDIENTESABIERTOSDENUNCIAS"),
					resultSet.getBigDecimal("EXPEDIENTESABIERTOSSOLICITUDES"),
					resultSet.getBigDecimal("EXPEDIENTESABIERTOSARBITRAJE"),
					resultSet.getBigDecimal("EXPEDIENTESABIERTOSSANCIONES"), resultSet.getBigDecimal("TOTAL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the CargaTrabajo table.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CargaTrabajo> findAll(CargaTrabajo cargaTrabajo, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"		SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, t1.MOCOOR MOCOOR, ");
		query.append("NVL(t2.EXPEDIENTESABIERTOSSOLICITUDES,0) EXPEDIENTESABIERTOSSOLICITUDES, ");
		query.append("NVL(t3.EXPEDIENTESABIERTOSDENUNCIAS,0) EXPEDIENTESABIERTOSDENUNCIAS, ");
		query.append("NVL(t4.EXPEDIENTESABIERTOSINS,0) EXPEDIENTESABIERTOSINS, ");
		query.append("NVL(t5.EXPEDIENTESABIERTOSARBITRAJE,0) EXPEDIENTESABIERTOSARBITRAJE, ");
		query.append("NVL(t6.EXPEDIENTESABIERTOSSANCIONES,0) EXPEDIENTESABIERTOSSANCIONES, ");
		query.append(
				"(NVL(t2.EXPEDIENTESABIERTOSSOLICITUDES,0) + NVL(t3.EXPEDIENTESABIERTOSDENUNCIAS,0) + NVL(t4.EXPEDIENTESABIERTOSINS,0) + NVL(t5.EXPEDIENTESABIERTOSARBITRAJE,0) + NVL(t6.EXPEDIENTESABIERTOSSANCIONES,0)) TOTAL ");

		query.append(getFromWhereQuery());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(cargaTrabajo);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CargaTrabajo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CargaTrabajo table.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CargaTrabajo cargaTrabajo) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		query.append(getFromWhereQuery());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(cargaTrabajo);
		StringBuilder where = new StringBuilder(" ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	private StringBuilder getFromWhereQuery() {

		StringBuilder query = new StringBuilder();

		query.append("FROM CENSO_MONITOR t1, ");

		// Expedientes solicitudes
		query.append(
				"(SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, MOCOOR, COUNT(*) EXPEDIENTESABIERTOSSOLICITUDES ");
		query.append("FROM CENSO_MONITOR t1, HECHO_DENUNCIADO t2, DENUNCIA t3, DECISION_HECHO t4 ");
		query.append("WHERE t1.MOCODIGO = t2.HDCOMO AND t2.HDCODE= t3.DECODIGO ");
		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append(
				"AND t2.HDCODIGO = t4.HCCOHD  AND t4.HCCOOR IN ('01A001', '20A001','48A001', '01A101', '01J001') ");
		query.append("AND t2.HDDENUNCIAAACCEMPRESAS IS NULL ");
		query.append("AND t2.HDFECHACIERRE IS NULL ");
		query.append("AND T2.ISKONTSUMOBIDE = 'S' ");
		query.append("GROUP BY MOCODIGO, MONOMBRE,MOCOOR) t2, ");

		// Expedientes denuncias
		query.append(
				"(SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, MOCOOR, COUNT(*) EXPEDIENTESABIERTOSDENUNCIAS ");
		query.append("FROM CENSO_MONITOR t1, HECHO_DENUNCIADO t2, DENUNCIA t3, DECISION_HECHO t4 ");
		query.append("WHERE t1.MOCODIGO = t2.HDCOMO AND t2.HDCODE= t3.DECODIGO ");
		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append(
				"AND t2.HDCODIGO = t4.HCCOHD  AND t4.HCCOOR IN ('01A001', '20A001','48A001', '01A101', '01J001') ");
		query.append("AND t2.HDDENUNCIAAACCEMPRESAS = 'S' ");
		query.append("AND t2.HDFECHACIERRE IS NULL ");
		query.append("AND T2.ISKONTSUMOBIDE = 'S' ");
		query.append("GROUP BY MOCODIGO, MONOMBRE,MOCOOR) t3, ");

		// Expedientes inspecciones
		query.append("(SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE,MOCOOR , COUNT(*) EXPEDIENTESABIERTOSINS ");
		query.append("FROM CENSO_MONITOR t1, ACTA t2, ACTUACION t3, ACTDEC t4 ");
		query.append("WHERE t1.MOCODIGO = t2.ACCOMO AND t2.ACCODIGO= t3.ATCOAC ");
		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append(
				"AND t3.ATCODIGO = t4.ADCOAT  AND t4.ADCOOR IN ('01A001', '20A001','48A001', '01A101', '01J001') ");
		query.append("AND t3.ATFECHACIERRE IS NULL ");
		query.append("AND t4.ADCOTTD IS NULL ");
		query.append("AND T3.ISKONTSUMOBIDE = 'S' ");
		query.append("GROUP BY MOCODIGO, MONOMBRE, MOCOOR) t4, ");

		// Expedientes arbitraje
		query.append(
				"(SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE,MOCOOR, COUNT(*) EXPEDIENTESABIERTOSARBITRAJE ");
		query.append("FROM CENSO_MONITOR t1, SOLARB t2, ARBEXP t3 ");
		query.append("WHERE t1.MOCODIGO = t3.EXMOCODIGO AND T2.SACODIGO= T3.EXCODIGO ");
		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append("AND t3.EXCOORG IN ('01A001', '20A001','48A001', '01A101', '01J001') ");
		query.append("AND t3.EXFECFIN IS NULL ");
		query.append("GROUP BY MOCODIGO, MONOMBRE, MOCOOR) t5, ");

		// Expedientes sanciones
		query.append(
				"(SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, MOCOOR, COUNT(*) EXPEDIENTESABIERTOSSANCIONES ");
		query.append("FROM CENSO_MONITOR t1, EXPEDIEN t2 , SANEXP t3 ");
		query.append("WHERE t1.MOCODIGO = t3.EXMOCODIGO AND t2.EXCODIGO= t3.EXCODIGO ");
		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append("AND t3.EXCOORACTUAL IN ('01A001', '20A001','48A001', '01A101', '01J001') ");
		query.append("AND t3.EXFECFIN IS NULL ");
		query.append("GROUP BY MOCODIGO, MONOMBRE, MOCOOR) t6 ");

		query.append("WHERE 1=1 ");
		query.append("AND t1.MOCODIGO = t2.MOCODIGO(+) ");
		query.append("AND t1.MOCODIGO = t3.MOCODIGO(+) ");
		query.append("AND t1.MOCODIGO = t4.MOCODIGO(+) ");
		query.append("AND t1.MOCODIGO = t5.MOCODIGO(+) ");
		query.append("AND t1.MOCODIGO = t6.MOCODIGO(+) ");
		query.append("AND t1.MOCOOR IN ('01A001', '20A001','48A001', '01A101', '01J001') ");

		query.append("AND t1.MOFECBAJA IS NULL ");
		query.append(
				"AND (NVL(t2.EXPEDIENTESABIERTOSSOLICITUDES,0) + NVL(t3.EXPEDIENTESABIERTOSDENUNCIAS,0) + NVL(t4.EXPEDIENTESABIERTOSINS,0) + NVL(t5.EXPEDIENTESABIERTOSARBITRAJE,0) + NVL(t6.EXPEDIENTESABIERTOSSANCIONES,0))>0 ");

		return query;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CargaTrabajo entity
	 * 
	 * @param provinc
	 *            CargaTrabajo
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CargaTrabajo cargaTrabajo) {

		StringBuilder where = new StringBuilder(CargaTrabajoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (cargaTrabajo != null && cargaTrabajo.getMocoor() != null) {
			where.append(" AND t1.MOCOOR = ?");
			params.add(cargaTrabajo.getMocoor());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
