package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaTipoprotocolo;

/**
 * CampanhaTipoprotocoloDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaTipoprotocoloDaoImpl implements CampanhaTipoprotocoloDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaTipoprotocolo> rwMap = new RowMapper<CampanhaTipoprotocolo>() {
		public CampanhaTipoprotocolo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CampanhaTipoprotocolo(resultSet.getString("TPCODIGO"),
					resultSet.getString("CMCODIGO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            Pagination
	 * @return CampanhaTipoprotocolo
	 */
	public CampanhaTipoprotocolo add(CampanhaTipoprotocolo campanhatipoprotocolo) {
		String query = "INSERT INTO CAMPANHA_TIPOPROTOCOLO (TPCODIGO, CMCODIGO) VALUES (?,?)";
		this.jdbcTemplate.update(query, campanhatipoprotocolo.getTpcodigo(),
				campanhatipoprotocolo.getCmcodigo());
		return campanhatipoprotocolo;
	}

	/**
	 * Updates a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            Pagination
	 * @return CampanhaTipoprotocolo
	 */
	public CampanhaTipoprotocolo update(
			CampanhaTipoprotocolo campanhatipoprotocolo) {
		String query = "UPDATE CAMPANHA_TIPOPROTOCOLO SET WHERE TPCODIGO=? AND CMCODIGO=?";
		this.jdbcTemplate.update(query, campanhatipoprotocolo.getTpcodigo(),
				campanhatipoprotocolo.getCmcodigo());
		return campanhatipoprotocolo;
	}

	/**
	 * Finds a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            Pagination
	 * @return CampanhaTipoprotocolo
	 */
	@Transactional(readOnly = true)
	public CampanhaTipoprotocolo find(
			CampanhaTipoprotocolo campanhatipoprotocolo) {
		String query = "SELECT t1.TPCODIGO TPCODIGO, t1.CMCODIGO CMCODIGO FROM CAMPANHA_TIPOPROTOCOLO t1  WHERE t1.TPCODIGO = ?   AND t1.CMCODIGO = ?  ";

		List<CampanhaTipoprotocolo> campanhatipoprotocoloList = this.jdbcTemplate
				.query(query, this.rwMap, campanhatipoprotocolo.getTpcodigo(),
						campanhatipoprotocolo.getCmcodigo());
		return (CampanhaTipoprotocolo) DataAccessUtils
				.uniqueResult(campanhatipoprotocoloList);
	}

	/**
	 * Removes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            Pagination
	 * @return
	 */
	public void remove(CampanhaTipoprotocolo campanhatipoprotocolo) {
		String query = "DELETE FROM CAMPANHA_TIPOPROTOCOLO WHERE TPCODIGO=? AND CMCODIGO=?";
		this.jdbcTemplate.update(query, campanhatipoprotocolo.getTpcodigo(),
				campanhatipoprotocolo.getCmcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaTipoprotocolo> findAll(
			CampanhaTipoprotocolo campanhatipoprotocolo, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TPCODIGO TPCODIGO,t1.CMCODIGO CMCODIGO ");
		query.append("FROM CAMPANHA_TIPOPROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhatipoprotocolo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaTipoprotocolo>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampanhaTipoprotocolo campanhatipoprotocolo) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_TIPOPROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhatipoprotocolo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CampanhaTipoprotocolo table using like.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaTipoprotocolo> findAllLike(
			CampanhaTipoprotocolo campanhatipoprotocolo, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TPCODIGO TPCODIGO,t1.CMCODIGO CMCODIGO ");
		query.append("FROM CAMPANHA_TIPOPROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhatipoprotocolo,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaTipoprotocolo>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table using like.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CampanhaTipoprotocolo campanhatipoprotocolo,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_TIPOPROTOCOLO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhatipoprotocolo,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaTipoprotocolo entity
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			CampanhaTipoprotocolo campanhatipoprotocolo) {

		StringBuilder where = new StringBuilder(
				CampanhaTipoprotocoloDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhatipoprotocolo != null
				&& campanhatipoprotocolo.getTpcodigo() != null) {
			where.append(" AND t1.TPCODIGO = ?");
			params.add(campanhatipoprotocolo.getTpcodigo());
		}
		if (campanhatipoprotocolo != null
				&& campanhatipoprotocolo.getCmcodigo() != null) {
			where.append(" AND t1.CMCODIGO = ?");
			params.add(campanhatipoprotocolo.getCmcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaTipoprotocolo entity
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			CampanhaTipoprotocolo campanhatipoprotocolo, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CampanhaTipoprotocoloDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhatipoprotocolo != null
				&& campanhatipoprotocolo.getTpcodigo() != null) {
			where.append(" AND UPPER(t1.TPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhatipoprotocolo.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhatipoprotocolo.getTpcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TPCODIGO IS NOT NULL");
		}
		if (campanhatipoprotocolo != null
				&& campanhatipoprotocolo.getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhatipoprotocolo.getCmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhatipoprotocolo.getCmcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaTipoprotocolo(Campanha campanha,
			String codCampanhaAlta) {

		String query = "INSERT INTO CAMPANHA_TIPOPROTOCOLO( TPCODIGO, CMCODIGO) SELECT TPCODIGO, ? FROM ADJUNTAR_CAMPANHATIPOPROT WHERE CMCODIGO = ? ";
		this.jdbcTemplate
				.update(query, campanha.getCmcodigo(), codCampanhaAlta);
	}

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaTipoprotocolo(Campanha campanha) {
		String query = "DELETE  FROM CAMPANHA_TIPOPROTOCOLO "
				+ " WHERE CMCODIGO=?";

		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}
}
