package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaTipoprotocolo;

/**
 * CampanhaTipoprotocoloDao  
 * 
 *  
 */

public interface CampanhaTipoprotocoloDao {

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return CampanhaTipoprotocolo
	 */
	CampanhaTipoprotocolo add(CampanhaTipoprotocolo campanhatipoprotocolo);

	/**
	 * Updates a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return CampanhaTipoprotocolo
	 */
	CampanhaTipoprotocolo update(CampanhaTipoprotocolo campanhatipoprotocolo);

	/**
	 * Finds a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return CampanhaTipoprotocolo
	 */
	CampanhaTipoprotocolo find(CampanhaTipoprotocolo campanhatipoprotocolo);

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return
	 */
	void remove(CampanhaTipoprotocolo campanhatipoprotocolo);

	/**
	 * Finds a List of rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampanhaTipoprotocolo> findAll(
			CampanhaTipoprotocolo campanhatipoprotocolo, Pagination pagination);

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @return Long
	 */
	Long findAllCount(CampanhaTipoprotocolo campanhatipoprotocolo);

	/**
	 * Finds rows in the CampanhaTipoprotocolo table using like.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CampanhaTipoprotocolo> findAllLike(
			CampanhaTipoprotocolo campanhatipoprotocolo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the CampanhaTipoprotocolo table using like.
	 * 
	 * @param campanhatipoprotocolo
	 *            CampanhaTipoprotocolo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(CampanhaTipoprotocolo campanhatipoprotocolo,
			Boolean startsWith);

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaTipoprotocolo(Campanha campanha,
			String codCampanhaAlta);

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaTipoprotocolo(Campanha campanha);
}
