package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;

/**
 * CampanhaProgramacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaProgramacionDaoImpl implements CampanhaProgramacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaProgramacion> rwMap = new RowMapper<CampanhaProgramacion>() {
		public CampanhaProgramacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new CampanhaProgramacion(resultSet.getString("PGCODIGO"), resultSet.getString("PGNOMBRE"),
					resultSet.getString("PGCOTPG"), resultSet.getDate("PGFEDESD"), resultSet.getDate("PGFEHAST"),
					resultSet.getString("PGCOOR"), resultSet.getString("PGINSESE"),
					resultSet.getInt("PGNUMTOMASMUESTRASSOL"), resultSet.getInt("PGNUMCONTROLESESTANDARSOL"),
					resultSet.getInt("PGNUMCONTROLESOTROSSOL"), resultSet.getInt("PGNUMINSPECADICIONALESSOL"),
					new Campanha(resultSet.getString("CampanhaCMCODIGO"), resultSet.getString("CampanhaCMNOMBRE"),
							resultSet.getString("CampanhaCMCOPS"), resultSet.getString("CampanhaCMNOAR"),
							resultSet.getString("CampanhaCMNOPS"), resultSet.getString("CampanhaCMCOTMO"),
							resultSet.getString("CampanhaCMORIGEN"), resultSet.getString("CampanhaCMTIPO"),
							resultSet.getString("CampanhaCMCARACTER"), resultSet.getDate("CampanhaCMFECHAINICIO"),
							resultSet.getDate("CampanhaCMFECHACIERRE"), resultSet.getString("CampanhaCMACTIVA"),
							resultSet.getString("CAMPANHACMONLINE"), resultSet.getDate("CampanhaCMFECINIBORRADOR"),
							resultSet.getDate("CampanhaCMFECFINBORRADOR"),
							resultSet.getDate("CampanhaCMFECINIVALIDACION"),
							resultSet.getDate("CampanhaCMFECFINVALIDACION")

					));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion add(CampanhaProgramacion campanhaprogramacion) {
		String query = "INSERT INTO CAMPANHA_PROGRAMACION (PGCODIGO, PGCOCM, PGNOMBRE, PGCOTPG, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getCampanhaCmcodigoAux = null;
		if (campanhaprogramacion.getCampanha() != null && campanhaprogramacion.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campanhaprogramacion.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo(), getCampanhaCmcodigoAux,
				campanhaprogramacion.getPgnombre(), campanhaprogramacion.getPgcotpg(),
				campanhaprogramacion.getPgfedesd(), campanhaprogramacion.getPgfehast(),
				campanhaprogramacion.getPgcoor(), campanhaprogramacion.getPginsese(),
				campanhaprogramacion.getPgnumTomasMuestrasSol(), campanhaprogramacion.getPgnumControlesEstandarSol(),
				campanhaprogramacion.getPgnumControlesOtrosSol(), campanhaprogramacion.getPgnumInspecAdicionalesSol());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion update(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGCOCM=?, PGNOMBRE=?, PGCOTPG=?, PGFEDESD=?, PGFEHAST=?, PGCOOR=?, PGINSESE=?, PGNUM_TOMAS_MUESTRAS_SOL=?, PGNUM_CONTROLES_ESTANDAR_SOL=?, PGNUM_CONTROLES_OTROS_SOL=?, PGNUM_INSPEC_ADICIONALES_SOL=? WHERE PGCODIGO=?";
		Object getCampanhaCmcodigoAux = null;
		if (campanhaprogramacion.getCampanha() != null && campanhaprogramacion.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campanhaprogramacion.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, getCampanhaCmcodigoAux, campanhaprogramacion.getPgnombre(),
				campanhaprogramacion.getPgcotpg(), campanhaprogramacion.getPgfedesd(),
				campanhaprogramacion.getPgfehast(), campanhaprogramacion.getPgcoor(),
				campanhaprogramacion.getPginsese(), campanhaprogramacion.getPgnumTomasMuestrasSol(),
				campanhaprogramacion.getPgnumControlesEstandarSol(), campanhaprogramacion.getPgnumControlesOtrosSol(),
				campanhaprogramacion.getPgnumInspecAdicionalesSol(), campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateInspeccionAdicional(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGNUM_INSPEC_ADICIONALES_SOL= NVL(PGNUM_INSPEC_ADICIONALES_SOL,0) + ? WHERE PGCODIGO=?";

		this.jdbcTemplate.update(query, campanhaprogramacion.getPgnumInspecAdicionalesSol(),
				campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionTomaMuestras(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGNUM_TOMAS_MUESTRAS_SOL=NVL(PGNUM_TOMAS_MUESTRAS_SOL,0) - 1 WHERE PGCODIGO=?";

		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionControlEstandar(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGNUM_CONTROLES_ESTANDAR_SOL=NVL(PGNUM_CONTROLES_ESTANDAR_SOL,0) - 1 WHERE PGCODIGO=?";

		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionControlOtros(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGNUM_CONTROLES_OTROS_SOL=NVL(PGNUM_CONTROLES_OTROS_SOL,0) - 1 WHERE PGCODIGO=?";

		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionAdicional(CampanhaProgramacion campanhaprogramacion) {
		String query = "UPDATE CAMPANHA_PROGRAMACION SET PGNUM_INSPEC_ADICIONALES_SOL= NVL(PGNUM_INSPEC_ADICIONALES_SOL,0) - 1 WHERE PGCODIGO=?";

		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo());
		return campanhaprogramacion;
	}

	/**
	 * Finds a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@Transactional(readOnly = true)
	public CampanhaProgramacion findLimitesCampanhaFase(CampanhaProgramacion campanhaprogramacion) {
		String query = "SELECT MIN(t1.PGFEDESD) FECHAINICIO, MAX(t1.PGFEHAST) FECHAFIN FROM CAMPANHA_PROGRAMACION t1  WHERE t1.PGCOCM= ? ";

		List<CampanhaProgramacion> campanhaprogramacionList = this.jdbcTemplate.query(query,
				new RowMapper<CampanhaProgramacion>() {
					public CampanhaProgramacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new CampanhaProgramacion(resultSet.getDate("FECHAINICIO"),
								resultSet.getDate("FECHAFIN"));
					}
				}, campanhaprogramacion.getCampanha().getCmcodigo());
		return (CampanhaProgramacion) DataAccessUtils.uniqueResult(campanhaprogramacionList);
	}

	/**
	 * Finds a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	@Transactional(readOnly = true)
	public CampanhaProgramacion find(CampanhaProgramacion campanhaprogramacion) {
		String query = "SELECT t1.PGCODIGO PGCODIGO, t1.PGNOMBRE PGNOMBRE, t1.PGCOTPG PGCOTPG, t1.PGFEDESD PGFEDESD, t1.PGFEHAST PGFEHAST, t1.PGCOOR PGCOOR, t1.PGINSESE PGINSESE, t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL, t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL, t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL, t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL, t2.CMCODIGO CAMPANHACMCODIGO, t2.CMNOMBRE CAMPANHACMNOMBRE, t2.CMCOPS CAMPANHACMCOPS, t2.CMNOAR CAMPANHACMNOAR, t2.CMNOPS CAMPANHACMNOPS, t2.CMCOTMO CAMPANHACMCOTMO, t2.CMORIGEN CAMPANHACMORIGEN, t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER, t2.CMFECHAINICIO CAMPANHACMFECHAINICIO, t2.CMFECHACIERRE CAMPANHACMFECHACIERRE, t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION FROM CAMPANHA_PROGRAMACION t1 , CAMPANHA t2  WHERE t1.PGCODIGO = ?   AND t1.PGCOCM= t2.CMCODIGO(+)";

		List<CampanhaProgramacion> campanhaprogramacionList = this.jdbcTemplate.query(query, this.rwMap,
				campanhaprogramacion.getPgcodigo());
		return (CampanhaProgramacion) DataAccessUtils.uniqueResult(campanhaprogramacionList);
	}

	/**
	 * Removes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return
	 */
	public void remove(CampanhaProgramacion campanhaprogramacion) {
		String query = "DELETE FROM CAMPANHA_PROGRAMACION WHERE PGCODIGO=?";
		this.jdbcTemplate.update(query, campanhaprogramacion.getPgcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaProgramacion> findAll(CampanhaProgramacion campanhaprogramacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PGCODIGO PGCODIGO,t1.PGNOMBRE PGNOMBRE,t1.PGCOTPG PGCOTPG,t1.PGFEDESD PGFEDESD,t1.PGFEHAST PGFEHAST,t1.PGCOOR PGCOOR,t1.PGINSESE PGINSESE,t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL,t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL,t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL,t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO,t2.CMORIGEN CAMPANHACMORIGEN,t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER,t2.CMFECHAINICIO CAMPANHACMFECHAINICIO,t2.CMFECHACIERRE CAMPANHACMFECHACIERRE,t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION ");
		query.append("FROM CAMPANHA_PROGRAMACION t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhaprogramacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PGCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaProgramacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampanhaProgramacion campanhaprogramacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA_PROGRAMACION t1 , CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhaprogramacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PGCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllOrganismoCount(CampanhaProgramacion campanhaprogramacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT PGCOOR) FROM CAMPANHA_PROGRAMACION t1 , CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhaprogramacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PGCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the CampanhaProgramacion table using like.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaProgramacion> findAllLike(CampanhaProgramacion campanhaprogramacion, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PGCODIGO PGCODIGO,t1.PGNOMBRE PGNOMBRE,t1.PGCOTPG PGCOTPG,t1.PGFEDESD PGFEDESD,t1.PGFEHAST PGFEHAST,t1.PGCOOR PGCOOR,t1.PGINSESE PGINSESE,t1.PGNUM_TOMAS_MUESTRAS_SOL PGNUMTOMASMUESTRASSOL,t1.PGNUM_CONTROLES_ESTANDAR_SOL PGNUMCONTROLESESTANDARSOL,t1.PGNUM_CONTROLES_OTROS_SOL PGNUMCONTROLESOTROSSOL,t1.PGNUM_INSPEC_ADICIONALES_SOL PGNUMINSPECADICIONALESSOL,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO,t2.CMORIGEN CAMPANHACMORIGEN,t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER,t2.CMFECHAINICIO CAMPANHACMFECHAINICIO,t2.CMFECHACIERRE CAMPANHACMFECHACIERRE,t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION ");
		query.append("FROM CAMPANHA_PROGRAMACION t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhaprogramacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PGCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaProgramacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaProgramacion table using like.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CampanhaProgramacion campanhaprogramacion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA_PROGRAMACION t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhaprogramacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.PGCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaProgramacion entity
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CampanhaProgramacion campanhaprogramacion) {

		StringBuilder where = new StringBuilder(CampanhaProgramacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhaprogramacion != null && campanhaprogramacion.getPgcodigo() != null) {
			where.append(" AND t1.PGCODIGO = ?");
			params.add(campanhaprogramacion.getPgcodigo());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmcodigo());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campanhaprogramacion.getCampanha().getCmnombre());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campanhaprogramacion.getCampanha().getCmcops());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campanhaprogramacion.getCampanha().getCmnoar());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campanhaprogramacion.getCampanha().getCmnops());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmcotmo());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmorigen() != null) {
			where.append(" AND t2.CMORIGEN = ?");
			params.add(campanhaprogramacion.getCampanha().getCmorigen());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmtipo() != null) {
			where.append(" AND t2.CMTIPO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmtipo());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmfechainicio());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanhaprogramacion.getCampanha().getCmfechacierre());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmactiva() != null) {
			where.append(" AND t2.CMACTIVA = ?");
			params.add(campanhaprogramacion.getCampanha().getCmactiva());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnombre() != null) {
			where.append(" AND t1.PGNOMBRE = ?");
			params.add(campanhaprogramacion.getPgnombre());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgcotpg() != null) {
			where.append(" AND t1.PGCOTPG = ?");
			params.add(campanhaprogramacion.getPgcotpg());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgfedesd() != null) {
			where.append(" AND t1.PGFEDESD = ?");
			params.add(campanhaprogramacion.getPgfedesd());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgfehast() != null) {
			where.append(" AND t1.PGFEHAST = ?");
			params.add(campanhaprogramacion.getPgfehast());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgcoor() != null) {
			where.append(" AND t1.PGCOOR = ?");
			params.add(campanhaprogramacion.getPgcoor());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPginsese() != null) {
			where.append(" AND t1.PGINSESE = ?");
			params.add(campanhaprogramacion.getPginsese());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumTomasMuestrasSol() != null) {
			where.append(" AND t1.PGNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(campanhaprogramacion.getPgnumTomasMuestrasSol());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumControlesEstandarSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(campanhaprogramacion.getPgnumControlesEstandarSol());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumControlesOtrosSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_OTROS_SOL = ?");
			params.add(campanhaprogramacion.getPgnumControlesOtrosSol());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumInspecAdicionalesSol() != null) {
			where.append(" AND t1.PGNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(campanhaprogramacion.getPgnumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaProgramacion entity
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(CampanhaProgramacion campanhaprogramacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(CampanhaProgramacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhaprogramacion != null && campanhaprogramacion.getPgcodigo() != null) {
			where.append(" AND UPPER(t1.PGCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getPgcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getPgcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PGCODIGO IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmcodigo());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnombre() != null) {
			where.append(" AND UPPER(t2.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOMBRE IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcops() != null) {
			where.append(" AND UPPER(t2.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmcops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmcops().toUpperCase() + "%");
			}
			where.append(" AND t2.CMCOPS IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnoar() != null) {
			where.append(" AND UPPER(t2.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmnoar().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmnoar().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOAR IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmnops() != null) {
			where.append(" AND UPPER(t2.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmnops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmnops().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOPS IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmcotmo() != null) {
			where.append(" AND UPPER(t2.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmcotmo().toUpperCase() + "%");
			}
			where.append(" AND t2.CMCOTMO IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmorigen() != null) {
			where.append(" AND UPPER(t2.CMORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmorigen().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmorigen().toUpperCase() + "%");
			}
			where.append(" AND t2.CMORIGEN IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmtipo() != null) {
			where.append(" AND UPPER(t2.CMTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmtipo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmtipo().toUpperCase() + "%");
			}
			where.append(" AND t2.CMTIPO IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanhaprogramacion.getCampanha().getCmfechainicio());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanhaprogramacion.getCampanha().getCmfechacierre());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getCampanha() != null
				&& campanhaprogramacion.getCampanha().getCmactiva() != null) {
			where.append(" AND UPPER(t2.CMACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getCampanha().getCmactiva().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getCampanha().getCmactiva().toUpperCase() + "%");
			}
			where.append(" AND t2.CMACTIVA IS NOT NULL");
		}

		if (campanhaprogramacion != null && campanhaprogramacion.getPgnombre() != null) {
			where.append(" AND UPPER(t1.PGNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getPgnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getPgnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.PGNOMBRE IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgcotpg() != null) {
			where.append(" AND UPPER(t1.PGCOTPG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getPgcotpg().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getPgcotpg().toUpperCase() + "%");
			}
			where.append(" AND t1.PGCOTPG IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgfedesd() != null) {
			where.append(" AND t1.PGFEDESD = ?");
			params.add(campanhaprogramacion.getPgfedesd());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgfehast() != null) {
			where.append(" AND t1.PGFEHAST = ?");
			params.add(campanhaprogramacion.getPgfehast());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgcoor() != null) {
			where.append(" AND UPPER(t1.PGCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getPgcoor().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getPgcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.PGCOOR IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPginsese() != null) {
			where.append(" AND UPPER(t1.PGINSESE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprogramacion.getPginsese().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprogramacion.getPginsese().toUpperCase() + "%");
			}
			where.append(" AND t1.PGINSESE IS NOT NULL");
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumTomasMuestrasSol() != null) {
			where.append(" AND t1.PGNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(campanhaprogramacion.getPgnumTomasMuestrasSol());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumControlesEstandarSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(campanhaprogramacion.getPgnumControlesEstandarSol());
		}
		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumControlesOtrosSol() != null) {
			where.append(" AND t1.PGNUM_CONTROLES_OTROS_SOL = ?");
			params.add(campanhaprogramacion.getPgnumControlesOtrosSol());
		}

		if (campanhaprogramacion != null && campanhaprogramacion.getPgnumInspecAdicionalesSol() != null) {
			where.append(" AND t1.PGNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(campanhaprogramacion.getPgnumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaProgramacion(Campanha campanha, String codCampanhaAlta) {

		String query = "INSERT INTO CAMPANHA_PROGRAMACION (PGCODIGO, PGCOCM, PGNOMBRE, PGCOTPG, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL) SELECT PGCODIGO, ?, PGNOMBRE, PGCOTPG, PGFEDESD, PGFEHAST, PGCOOR, PGINSESE, PGNUM_TOMAS_MUESTRAS_SOL, PGNUM_CONTROLES_ESTANDAR_SOL, PGNUM_CONTROLES_OTROS_SOL, PGNUM_INSPEC_ADICIONALES_SOL FROM ADJUNTAR_CAMPANHAPROGRA WHERE 1=1 AND PGCODIGO NOT IN (SELECT PGCODIGO FROM CAMPANHA_PROGRAMACION) AND PGCOCM = ? ";
		this.jdbcTemplate.update(query, campanha.getCmcodigo(), codCampanhaAlta);
	}

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeCampanhaProgramacion(Campanha campanha) {
		String query = "DELETE  FROM CAMPANHA_PROGRAMACION "
				+ " WHERE 1=1 AND PGCODIGO NOT IN (SELECT PGCODIGO FROM ADJUNTAR_CAMPANHAPROGRA) AND PGCOCM=?";

		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaProgramacion(Campanha campanha) {
		String query = "DELETE  FROM CAMPANHA_PROGRAMACION " + " WHERE PGCOCM=?";

		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaProgramacion> findAllCampanhaProgramacionEliminadas(Campanha campanha, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT t1.PGCODIGO PGCODIGO ");
		query.append("FROM CAMPANHA_PROGRAMACION t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.PGCOCM = ? ");
		params.add(campanha.getCmcodigo());

		where.append(
				" AND t1.PGCODIGO NOT IN (SELECT  tt1.PGCODIGO FROM ADJUNTAR_CAMPANHAPROGRA tt1 WHERE tt1.PGCOCM = ?)");
		params.add(campanha.getCmcodigo());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaProgramacion>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<CampanhaProgramacion>() {
					public CampanhaProgramacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new CampanhaProgramacion(resultSet.getString("PGCODIGO"));
					}
				}, params.toArray());
	}
}
