package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;

/**
 * CampanhaProgramacionDao  
 * 
 *  
 */

public interface CampanhaProgramacionDao {

	/**
	 * Inserts a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	CampanhaProgramacion add(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	CampanhaProgramacion update(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateInspeccionAdicional(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionTomaMuestras(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionControlEstandar(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionControlOtros(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion updateEliminarInspeccionAdicional(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Finds a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	CampanhaProgramacion find(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Finds a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            Pagination
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion findLimitesCampanhaFase(
			CampanhaProgramacion campanhaprogramacion);

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return
	 */
	void remove(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Finds a List of rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampanhaProgramacion> findAll(
			CampanhaProgramacion campanhaprogramacion, Pagination pagination);

	/**
	 * Counts rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return Long
	 */
	Long findAllCount(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Counts rows in the CampanhaProgramacion table.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @return Long
	 */
	public Long findAllOrganismoCount(CampanhaProgramacion campanhaprogramacion);

	/**
	 * Finds rows in the CampanhaProgramacion table using like.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CampanhaProgramacion> findAllLike(
			CampanhaProgramacion campanhaprogramacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the CampanhaProgramacion table using like.
	 * 
	 * @param campanhaprogramacion
	 *            CampanhaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(CampanhaProgramacion campanhaprogramacion,
			Boolean startsWith);

	/**
	 * Inserts a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaProgramacion(Campanha campanha,
			String codCampanhaAlta);

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeCampanhaProgramacion(Campanha campanha);

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaProgramacion(Campanha campanha);

	/**
	 * Finds a List of rows in the CampanhaProgramacion table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaProgramacion> findAllCampanhaProgramacionEliminadas(
			Campanha campanha, Pagination pagination);
}
