package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.Campanha;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.CampanhaProd;

/**
 * CampanhaProdDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaProdDaoImpl implements CampanhaProdDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaProd> rwMap = new RowMapper<CampanhaProd>() {
		public CampanhaProd mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new CampanhaProd(resultSet.getString("CPCODIGO"), resultSet.getString("CPCOPS"),
					resultSet.getString("CPNOPS"),
					new Campanha(resultSet.getString("CampanhaCMCODIGO"), resultSet.getString("CampanhaCMNOMBRE"),
							resultSet.getString("CampanhaCMCOPS"), resultSet.getString("CampanhaCMNOAR"),
							resultSet.getString("CampanhaCMNOPS"), resultSet.getString("CampanhaCMCOTMO"),
							resultSet.getString("CampanhaCMORIGEN"), resultSet.getString("CampanhaCMTIPO"),
							resultSet.getString("CampanhaCMCARACTER"), resultSet.getDate("CampanhaCMFECHAINICIO"),
							resultSet.getDate("CampanhaCMFECHACIERRE"), resultSet.getString("CampanhaCMACTIVA"),
							resultSet.getString("CAMPANHACMONLINE"), resultSet.getDate("CampanhaCMFECINIBORRADOR"),
							resultSet.getDate("CampanhaCMFECFINBORRADOR"),
							resultSet.getDate("CampanhaCMFECINIVALIDACION"),
							resultSet.getDate("CampanhaCMFECFINVALIDACION")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            Pagination
	 * @return CampanhaProd
	 */
	public CampanhaProd add(CampanhaProd campanhaprod) {
		String query = "INSERT INTO CAMPANHA_PROD (CPCODIGO, CPCOCM, CPCOPS, CPNOPS) VALUES (?,?,?,?)";
		Object getCampanhaCmcodigoAux = null;
		if (campanhaprod.getCampanha() != null && campanhaprod.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campanhaprod.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, campanhaprod.getCpcodigo(), getCampanhaCmcodigoAux, campanhaprod.getCpcops(),
				campanhaprod.getCpnops());
		return campanhaprod;
	}

	/**
	 * Updates a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            Pagination
	 * @return CampanhaProd
	 */
	public CampanhaProd update(CampanhaProd campanhaprod) {
		String query = "UPDATE CAMPANHA_PROD SET CPCOCM=?, CPCOPS=?, CPNOPS=? WHERE CPCODIGO=?";
		Object getCampanhaCmcodigoAux = null;
		if (campanhaprod.getCampanha() != null && campanhaprod.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campanhaprod.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, getCampanhaCmcodigoAux, campanhaprod.getCpcops(), campanhaprod.getCpnops(),
				campanhaprod.getCpcodigo());
		return campanhaprod;
	}

	/**
	 * Finds a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            Pagination
	 * @return CampanhaProd
	 */
	@Transactional(readOnly = true)
	public CampanhaProd find(CampanhaProd campanhaprod) {
		String query = "SELECT t1.CPCODIGO CPCODIGO, t1.CPCOPS CPCOPS, t1.CPNOPS CPNOPS, t2.CMCODIGO CAMPANHACMCODIGO, t2.CMNOMBRE CAMPANHACMNOMBRE, t2.CMCOPS CAMPANHACMCOPS, t2.CMNOAR CAMPANHACMNOAR, t2.CMNOPS CAMPANHACMNOPS, t2.CMCOTMO CAMPANHACMCOTMO, t2.CMORIGEN CAMPANHACMORIGEN, t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER, t2.CMFECHAINICIO CAMPANHACMFECHAINICIO, t2.CMFECHACIERRE CAMPANHACMFECHACIERRE, t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION FROM CAMPANHA_PROD t1 , CAMPANHA t2  WHERE t1.CPCODIGO = ?   AND t1.CPCOCM= t2.CMCODIGO(+)";

		List<CampanhaProd> campanhaprodList = this.jdbcTemplate.query(query, this.rwMap, campanhaprod.getCpcodigo());
		return (CampanhaProd) DataAccessUtils.uniqueResult(campanhaprodList);
	}

	/**
	 * Removes a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            Pagination
	 * @return
	 */
	public void remove(CampanhaProd campanhaprod) {
		String query = "DELETE FROM CAMPANHA_PROD WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, campanhaprod.getCpcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaProd> findAll(CampanhaProd campanhaprod, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPCOPS CPCOPS,t1.CPNOPS CPNOPS,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO,t2.CMORIGEN CAMPANHACMORIGEN,t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER,t2.CMFECHAINICIO CAMPANHACMFECHAINICIO,t2.CMFECHACIERRE CAMPANHACMFECHACIERRE,t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION ");
		query.append("FROM CAMPANHA_PROD t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhaprod);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaProd>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampanhaProd campanhaprod) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA_PROD t1 , CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhaprod);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the CampanhaProd table using like.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaProd> findAllLike(CampanhaProd campanhaprod, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CPCODIGO CPCODIGO,t1.CPCOPS CPCOPS,t1.CPNOPS CPNOPS,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO,t2.CMORIGEN CAMPANHACMORIGEN,t2.CMTIPO CAMPANHACMTIPO, t2.CMCARACTER CAMPANHACMCARACTER,t2.CMFECHAINICIO CAMPANHACMFECHAINICIO,t2.CMFECHACIERRE CAMPANHACMFECHACIERRE,t2.CMACTIVA CAMPANHACMACTIVA, t2.CMONLINE CAMPANHACMONLINE, t2.CMFECINIBORRADOR CAMPANHACMFECINIBORRADOR, t2.CMFECFINBORRADOR CAMPANHACMFECFINBORRADOR, t2.CMFECINIVALIDACION CAMPANHACMFECINIVALIDACION, t2.CMFECFINVALIDACION CAMPANHACMFECFINVALIDACION ");
		query.append("FROM CAMPANHA_PROD t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhaprod, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaProd>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaProd table using like.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CampanhaProd campanhaprod, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA_PROD t1 ,CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhaprod, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.CPCOCM= t2.CMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaProd entity
	 * 
	 * @param campanhaprod
	 *            CampanhaProd Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CampanhaProd campanhaprod) {

		StringBuilder where = new StringBuilder(CampanhaProdDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhaprod != null && campanhaprod.getCpcodigo() != null) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(campanhaprod.getCpcodigo());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanhaprod.getCampanha().getCmcodigo());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campanhaprod.getCampanha().getCmnombre());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campanhaprod.getCampanha().getCmcops());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campanhaprod.getCampanha().getCmnoar());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campanhaprod.getCampanha().getCmnops());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campanhaprod.getCampanha().getCmcotmo());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmorigen() != null) {
			where.append(" AND t2.CMORIGEN = ?");
			params.add(campanhaprod.getCampanha().getCmorigen());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmtipo() != null) {
			where.append(" AND t2.CMTIPO = ?");
			params.add(campanhaprod.getCampanha().getCmtipo());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanhaprod.getCampanha().getCmfechainicio());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanhaprod.getCampanha().getCmfechacierre());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmactiva() != null) {
			where.append(" AND t2.CMACTIVA = ?");
			params.add(campanhaprod.getCampanha().getCmactiva());
		}
		if (campanhaprod != null && campanhaprod.getCpcops() != null) {
			where.append(" AND t1.CPCOPS = ?");
			params.add(campanhaprod.getCpcops());
		}
		if (campanhaprod != null && campanhaprod.getCpnops() != null) {
			where.append(" AND t1.CPNOPS = ?");
			params.add(campanhaprod.getCpnops());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaProd entity
	 * 
	 * @param campanhaprod
	 *            CampanhaProd Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(CampanhaProd campanhaprod, Boolean startsWith) {

		StringBuilder where = new StringBuilder(CampanhaProdDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhaprod != null && campanhaprod.getCpcodigo() != null) {
			where.append(" AND UPPER(t1.CPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CPCODIGO IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campanhaprod.getCampanha().getCmcodigo());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnombre() != null) {
			where.append(" AND UPPER(t2.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOMBRE IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcops() != null) {
			where.append(" AND UPPER(t2.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmcops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmcops().toUpperCase() + "%");
			}
			where.append(" AND t2.CMCOPS IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnoar() != null) {
			where.append(" AND UPPER(t2.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmnoar().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmnoar().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOAR IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmnops() != null) {
			where.append(" AND UPPER(t2.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmnops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmnops().toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOPS IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmcotmo() != null) {
			where.append(" AND UPPER(t2.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmcotmo().toUpperCase() + "%");
			}
			where.append(" AND t2.CMCOTMO IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmorigen() != null) {
			where.append(" AND UPPER(t2.CMORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmorigen().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmorigen().toUpperCase() + "%");
			}
			where.append(" AND t2.CMORIGEN IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmtipo() != null) {
			where.append(" AND UPPER(t2.CMTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmtipo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmtipo().toUpperCase() + "%");
			}
			where.append(" AND t2.CMTIPO IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmfechainicio() != null) {
			where.append(" AND t2.CMFECHAINICIO = ?");
			params.add(campanhaprod.getCampanha().getCmfechainicio());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmfechacierre() != null) {
			where.append(" AND t2.CMFECHACIERRE = ?");
			params.add(campanhaprod.getCampanha().getCmfechacierre());
		}
		if (campanhaprod != null && campanhaprod.getCampanha() != null
				&& campanhaprod.getCampanha().getCmactiva() != null) {
			where.append(" AND UPPER(t2.CMACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCampanha().getCmactiva().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCampanha().getCmactiva().toUpperCase() + "%");
			}
			where.append(" AND t2.CMACTIVA IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCpcops() != null) {
			where.append(" AND UPPER(t1.CPCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCpcops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCpcops().toUpperCase() + "%");
			}
			where.append(" AND t1.CPCOPS IS NOT NULL");
		}
		if (campanhaprod != null && campanhaprod.getCpnops() != null) {
			where.append(" AND UPPER(t1.CPNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhaprod.getCpnops().toUpperCase() + "%");
			} else {
				params.add("%" + campanhaprod.getCpnops().toUpperCase() + "%");
			}
			where.append(" AND t1.CPNOPS IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the CampanhaProd table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaProd(Campanha campanha, String codCampanhaAlta) {

		String query = "INSERT INTO CAMPANHA_PROD( CPCODIGO, CPCOCM, CPCOPS, CPNOPS) SELECT CPCODIGO, ?, CPCOPS, CPNOPS FROM ADJUNTAR_CAMPANHAPRODUCTO WHERE CPCOCM = ? ";
		this.jdbcTemplate.update(query, campanha.getCmcodigo(), codCampanhaAlta);
	}

	/**
	 * Deletes a single row in the CampanhaProd table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaProd(Campanha campanha) {
		String query = "DELETE  FROM CAMPANHA_PROD " + " WHERE CPCOCM=?";

		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllProdCount(AdjuntarCampanhaproducto adjuntarcampanhaproducto) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ADJUNTAR_CAMPANHAPRODUCTO t1 WHERE CPCOCM = ?");

		return this.jdbcTemplate.queryForLong(query.toString(), adjuntarcampanhaproducto.getCpcocm());
	}
}
