package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProd;

/**
 * CampanhaProdDao  
 * 
 *  
 */

public interface CampanhaProdDao {

	/**
	 * Inserts a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	CampanhaProd add(CampanhaProd campanhaprod);

	/**
	 * Updates a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	CampanhaProd update(CampanhaProd campanhaprod);

	/**
	 * Finds a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	CampanhaProd find(CampanhaProd campanhaprod);

	/**
	 * Deletes a single row in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return
	 */
	void remove(CampanhaProd campanhaprod);

	/**
	 * Finds a List of rows in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampanhaProd> findAll(CampanhaProd campanhaprod, Pagination pagination);

	/**
	 * Counts rows in the CampanhaProd table.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @return Long
	 */
	Long findAllCount(CampanhaProd campanhaprod);

	/**
	 * Finds rows in the CampanhaProd table using like.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CampanhaProd> findAllLike(CampanhaProd campanhaprod,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CampanhaProd table using like.
	 * 
	 * @param campanhaprod
	 *            CampanhaProd
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(CampanhaProd campanhaprod, Boolean startsWith);

	/**
	 * Inserts a single row in the CampanhaProd table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllCampanhaProd(Campanha campanha, String codCampanhaAlta);

	/**
	 * Deletes a single row in the CampanhaProd table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeAllCampanhaProd(Campanha campanha);

	/**
	 * Counts rows in the AdjuntarCampanhaproducto table.
	 * 
	 * @param adjuntarcampanhaproducto
	 *            AdjuntarCampanhaproducto
	 * @return Long
	 */
	public Long findAllProdCount(
			AdjuntarCampanhaproducto adjuntarcampanhaproducto);
}
