package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.TipProtocolo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Campanha;

/**
 * CampanhaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaDaoImpl implements CampanhaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Campanha> rwMap = new RowMapper<Campanha>() {
		public Campanha mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Campanha(resultSet.getString("CMCODIGO"), resultSet.getString("CMNOMBRE"),
					resultSet.getString("CMCOPS"), resultSet.getString("CMNOAR"), resultSet.getString("CMNOPS"),
					resultSet.getString("CMCOTMO"), resultSet.getString("CMORIGEN"), resultSet.getString("CMTIPO"),
					resultSet.getString("CMCARACTER"), resultSet.getDate("CMFECHAINICIO"),
					resultSet.getDate("CMFECHACIERRE"), resultSet.getString("CMACTIVA"),
					resultSet.getString("CMONLINE"), resultSet.getDate("CMFECINIBORRADOR"),
					resultSet.getDate("CMFECFINBORRADOR"), resultSet.getDate("CMFECINIVALIDACION"),
					resultSet.getDate("CMFECFINVALIDACION"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Pagination
	 * @return Campanha
	 */
	public Campanha add(Campanha campanha) {
		String query = "INSERT INTO CAMPANHA (CMCODIGO, CMNOMBRE, CMCOPS, CMNOAR, CMNOPS, CMCOTMO, CMORIGEN, CMTIPO, CMCARACTER, CMFECHAINICIO, CMFECHACIERRE, CMACTIVA, CMONLINE, CMFECINIBORRADOR, CMFECFINBORRADOR, CMFECINIVALIDACION, CMFECFINVALIDACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, campanha.getCmcodigo(), campanha.getCmnombre(), campanha.getCmcops(),
				campanha.getCmnoar(), campanha.getCmnops(), campanha.getCmcotmo(), campanha.getCmorigen(),
				campanha.getCmtipo(), campanha.getCmcaracter(), campanha.getCmfechainicio(),
				campanha.getCmfechacierre(), campanha.getCmactiva(), campanha.getCmonline(),
				campanha.getCmfeciniborrador(), campanha.getCmfecfinborrador(), campanha.getCmfecinivalidacion(),
				campanha.getCmfecfinvalidacion());
		return campanha;
	}

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Pagination
	 * @return Campanha
	 */
	public Campanha update(Campanha campanha) {
		String query = "UPDATE CAMPANHA SET CMNOMBRE=?, CMCOPS=?, CMNOAR=?, CMNOPS=?, CMCOTMO=?, CMORIGEN=?, CMTIPO=?, CMCARACTER=?, CMFECHAINICIO=?, CMFECHACIERRE=?, CMACTIVA=?, CMONLINE=?, CMFECINIBORRADOR=?, CMFECFINBORRADOR=?, CMFECINIVALIDACION=?, CMFECFINVALIDACION=? WHERE CMCODIGO=?";
		this.jdbcTemplate.update(query, campanha.getCmnombre(), campanha.getCmcops(), campanha.getCmnoar(),
				campanha.getCmnops(), campanha.getCmcotmo(), campanha.getCmorigen(), campanha.getCmtipo(),
				campanha.getCmcaracter(), campanha.getCmfechainicio(), campanha.getCmfechacierre(),
				campanha.getCmactiva(), campanha.getCmonline(), campanha.getCmfeciniborrador(),
				campanha.getCmfecfinborrador(), campanha.getCmfecinivalidacion(), campanha.getCmfecfinvalidacion(),
				campanha.getCmcodigo());
		return campanha;
	}

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	public Campanha updateFechacierre(Campanha campanha) {
		String query = "UPDATE CAMPANHA SET CMFECHACIERRE=? WHERE CMCODIGO=?";
		this.jdbcTemplate.update(query, campanha.getCmfechacierre(), campanha.getCmcodigo());
		return campanha;
	}

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Pagination
	 * @return Campanha
	 */
	@Transactional(readOnly = true)
	public Campanha find(Campanha campanha) {
		String query = "SELECT t1.CMCODIGO CMCODIGO, t1.CMNOMBRE CMNOMBRE, t1.CMCOPS CMCOPS, t1.CMNOAR CMNOAR, t1.CMNOPS CMNOPS, t1.CMCOTMO CMCOTMO, t1.CMORIGEN CMORIGEN, t1.CMTIPO CMTIPO, t1.CMCARACTER CMCARACTER, t1.CMFECHAINICIO CMFECHAINICIO, t1.CMFECHACIERRE CMFECHACIERRE, t1.CMACTIVA CMACTIVA, t1.CMONLINE CMONLINE, t1.CMFECINIBORRADOR CMFECINIBORRADOR, t1.CMFECFINBORRADOR CMFECFINBORRADOR, t1.CMFECINIVALIDACION CMFECINIVALIDACION, t1.CMFECFINVALIDACION CMFECFINVALIDACION FROM CAMPANHA t1  WHERE t1.CMCODIGO = ?  ";

		List<Campanha> campanhaList = this.jdbcTemplate.query(query, this.rwMap, campanha.getCmcodigo());
		return (Campanha) DataAccessUtils.uniqueResult(campanhaList);
	}

	/**
	 * Removes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Pagination
	 * @return
	 */
	public void remove(Campanha campanha) {
		String query = "DELETE FROM CAMPANHA WHERE CMCODIGO=?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
	}

	/**
	 * Finds a List of rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Campanha> findAll(Campanha campanha, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CMCODIGO CMCODIGO,t1.CMNOMBRE CMNOMBRE,t1.CMCOPS CMCOPS,t1.CMNOAR CMNOAR,t1.CMNOPS CMNOPS,t1.CMCOTMO CMCOTMO,t1.CMORIGEN CMORIGEN,t1.CMTIPO CMTIPO, t1.CMCARACTER CMCARACTER,t1.CMFECHAINICIO CMFECHAINICIO,t1.CMFECHACIERRE CMFECHACIERRE,t1.CMACTIVA CMACTIVA, t1.CMONLINE CMONLINE, t1.CMFECINIBORRADOR CMFECINIBORRADOR, t1.CMFECFINBORRADOR CMFECFINBORRADOR, t1.CMFECINIVALIDACION CMFECINIVALIDACION, t1.CMFECFINVALIDACION CMFECFINVALIDACION ");
		query.append("FROM CAMPANHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanha);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Campanha>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Campanha campanha) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanha);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Campanha> findAllLike(Campanha campanha, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CMCODIGO CMCODIGO,t1.CMNOMBRE CMNOMBRE,t1.CMCOPS CMCOPS,t1.CMNOAR CMNOAR,t1.CMNOPS CMNOPS,t1.CMCOTMO CMCOTMO,t1.CMORIGEN CMORIGEN,t1.CMTIPO CMTIPO, t1.CMCARACTER CMCARACTER,t1.CMFECHAINICIO CMFECHAINICIO,t1.CMFECHACIERRE CMFECHACIERRE,t1.CMACTIVA CMACTIVA, t1.CMONLINE CMONLINE, t1.CMFECINIBORRADOR CMFECINIBORRADOR, t1.CMFECFINBORRADOR CMFECFINBORRADOR, t1.CMFECINIVALIDACION CMFECINIVALIDACION, t1.CMFECFINVALIDACION CMFECFINVALIDACION ");
		query.append("FROM CAMPANHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Campanha>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Campanha campanha, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM CAMPANHA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Campanha entity
	 * 
	 * @param campanha
	 *            Campanha Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Campanha campanha) {

		StringBuilder where = new StringBuilder(CampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanha != null && campanha.getCmcodigo() != null) {
			where.append(" AND t1.CMCODIGO = ?");
			params.add(campanha.getCmcodigo());
		}
		if (campanha != null && campanha.getCmnombre() != null) {
			where.append(" AND t1.CMNOMBRE = ?");
			params.add(campanha.getCmnombre());
		}
		if (campanha != null && campanha.getCmcops() != null) {
			where.append(" AND t1.CMCOPS = ?");
			params.add(campanha.getCmcops());
		}
		if (campanha != null && campanha.getCmnoar() != null) {
			where.append(" AND t1.CMNOAR = ?");
			params.add(campanha.getCmnoar());
		}
		if (campanha != null && campanha.getCmnops() != null) {
			where.append(" AND t1.CMNOPS = ?");
			params.add(campanha.getCmnops());
		}
		if (campanha != null && campanha.getCmcotmo() != null) {
			where.append(" AND t1.CMCOTMO = ?");
			params.add(campanha.getCmcotmo());
		}
		if (campanha != null && campanha.getCmorigen() != null) {
			where.append(" AND t1.CMORIGEN = ?");
			params.add(campanha.getCmorigen());
		}
		if (campanha != null && campanha.getCmtipo() != null) {
			where.append(" AND t1.CMTIPO = ?");
			params.add(campanha.getCmtipo());
		}
		if (campanha != null && campanha.getCmfechainicio() != null) {
			where.append(" AND t1.CMFECHAINICIO = ?");
			params.add(campanha.getCmfechainicio());
		}
		if (campanha != null && campanha.getCmfechacierre() != null) {
			where.append(" AND t1.CMFECHACIERRE = ?");
			params.add(campanha.getCmfechacierre());
		}
		if (campanha != null && campanha.getCmactiva() != null) {
			where.append(" AND t1.CMACTIVA = ?");
			params.add(campanha.getCmactiva());
		}
		if (campanha != null && campanha.getCmfeciniborrador() != null) {
			where.append(" AND t1.CMFECINIBORRADOR = ?");
			params.add(campanha.getCmfeciniborrador());
		}
		if (campanha != null && campanha.getCmfecfinborrador() != null) {
			where.append(" AND t1.CMFECFINBORRADOR = ?");
			params.add(campanha.getCmfecfinborrador());
		}
		if (campanha != null && campanha.getCmfecinivalidacion() != null) {
			where.append(" AND t1.CMFECINIVALIDACION = ?");
			params.add(campanha.getCmfecinivalidacion());
		}
		if (campanha != null && campanha.getCmfecfinvalidacion() != null) {
			where.append(" AND t1.CMFECFINVALIDACION = ?");
			params.add(campanha.getCmfecfinvalidacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Campanha entity
	 * 
	 * @param campanha
	 *            Campanha Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Campanha campanha, Boolean startsWith) {

		StringBuilder where = new StringBuilder(CampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanha != null && campanha.getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}
		if (campanha != null && campanha.getCmnombre() != null) {
			where.append(" AND UPPER(t1.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.CMNOMBRE IS NOT NULL");
		}
		if (campanha != null && campanha.getCmcops() != null) {
			where.append(" AND UPPER(t1.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmcops().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmcops().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCOPS IS NOT NULL");
		}
		if (campanha != null && campanha.getCmnoar() != null) {
			where.append(" AND UPPER(t1.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmnoar().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmnoar().toUpperCase() + "%");
			}
			where.append(" AND t1.CMNOAR IS NOT NULL");
		}
		if (campanha != null && campanha.getCmnops() != null) {
			where.append(" AND UPPER(t1.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmnops().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmnops().toUpperCase() + "%");
			}
			where.append(" AND t1.CMNOPS IS NOT NULL");
		}
		if (campanha != null && campanha.getCmcotmo() != null) {
			where.append(" AND UPPER(t1.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmcotmo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCOTMO IS NOT NULL");
		}
		if (campanha != null && campanha.getCmorigen() != null) {
			where.append(" AND UPPER(t1.CMORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmorigen().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.CMORIGEN IS NOT NULL");
		}
		if (campanha != null && campanha.getCmtipo() != null) {
			where.append(" AND UPPER(t1.CMTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmtipo().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmtipo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMTIPO IS NOT NULL");
		}
		if (campanha != null && campanha.getCmfechainicio() != null) {
			where.append(" AND t1.CMFECHAINICIO = ?");
			params.add(campanha.getCmfechainicio());
		}
		if (campanha != null && campanha.getCmfechacierre() != null) {
			where.append(" AND t1.CMFECHACIERRE = ?");
			params.add(campanha.getCmfechacierre());
		}
		if (campanha != null && campanha.getCmactiva() != null) {
			where.append(" AND UPPER(t1.CMACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmactiva().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmactiva().toUpperCase() + "%");
			}
			where.append(" AND t1.CMACTIVA IS NOT NULL");
		}
		if (campanha != null && campanha.getCmfeciniborrador() != null) {
			where.append(" AND t1.CMFECINIBORRADOR = ?");
			params.add(campanha.getCmfeciniborrador());
		}
		if (campanha != null && campanha.getCmfecfinborrador() != null) {
			where.append(" AND t1.CMFECFINBORRADOR = ?");
			params.add(campanha.getCmfecfinborrador());
		}
		if (campanha != null && campanha.getCmfecinivalidacion() != null) {
			where.append(" AND t1.CMFECINIVALIDACION = ?");
			params.add(campanha.getCmfecinivalidacion());
		}
		if (campanha != null && campanha.getCmfecfinvalidacion() != null) {
			where.append(" AND t1.CMFECFINVALIDACION = ?");
			params.add(campanha.getCmfecfinvalidacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	public Campanha addCampanhaTipoprotocolo(Campanha campanha) {
		String query = "INSERT INTO L21TTT00 " + "( CMCODIGO,TPCODIGO) " + " values (?, ?)";

		List<TipProtocolo> auxiliarTipprotocolo = campanha.getTipProtocolos_1();
		Iterator<TipProtocolo> it = auxiliarTipprotocolo.iterator();
		while (it.hasNext()) {
			TipProtocolo tipprotocolo = (TipProtocolo) it.next();
			this.jdbcTemplate.update(query, campanha.getCmcodigo(), tipprotocolo.getTpcodigo());
		}
		return campanha;
	}

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	public void removeCampanhaTipoprotocolo(Campanha campanha) {
		String query = "DELETE  FROM L21TTT00 " + " WHERE CMCODIGO=? AND TPCODIGO=?";
		List<TipProtocolo> auxiliarTipprotocolo = campanha.getTipProtocolos_1();
		Iterator<TipProtocolo> it = auxiliarTipprotocolo.iterator();
		while (it.hasNext()) {
			TipProtocolo tipprotocolo = (TipProtocolo) it.next();
			this.jdbcTemplate.update(query, campanha.getCmcodigo(), tipprotocolo.getTpcodigo());
		}
	}

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return Campanha
	 */
	@Transactional(readOnly = true)
	public Campanha findCampanhaTipoprotocolo(Campanha campanha, TipProtocolo tipprotocolo, Pagination pagination) {

		StringBuilder where = new StringBuilder(CampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.TPCODIGO = t2.TPCODIGO AND t1.CMCODIGO=?");

		params.add(campanha.getCmcodigo());

		if (tipprotocolo.getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tipprotocolo.getTpcodigo());
		}
		if (tipprotocolo.getCampanha() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tipprotocolo.getCampanha());
		}
		if (tipprotocolo.getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tipprotocolo.getTpnombre());
		}
		if (tipprotocolo.getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tipprotocolo.getTpcotmo());
		}
		if (tipprotocolo.getTpestandar() != null) {
			where.append(" AND t2.TPESTANDAR = ?");
			params.add(tipprotocolo.getTpestandar());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Tpcodigo TPCODIGO, t2.TPNOMBRE TPNOMBRE, t2.TPCOTMO TPCOTMO, t2.TPESTANDAR TPESTANDAR FROM L21ttt00 t1,L2174T00 t2  ");
		query.append(where);

		StringBuilder order = new StringBuilder(CampanhaDaoImpl.STRING_BUILDER_INIT);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		List<TipProtocolo> listaHijo = this.jdbcTemplate.query(query.toString(), new RowMapper<TipProtocolo>() {
			public TipProtocolo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TipProtocolo(resultSet.getString("TPCODIGO"), resultSet.getString("TPNOMBRE"),
						resultSet.getString("TPCOTMO"), resultSet.getString("TPESTANDAR"), null, null, null, null);
			}
		}, params.toArray());
		campanha.setTipProtocolos_1(listaHijo);
		return campanha;
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCampanhaTipoprotocoloCount(Campanha campanha, TipProtocolo tipprotocolo) {

		StringBuilder where = new StringBuilder(CampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.TPCODIGO = t2.TPCODIGO AND t1.CMCODIGO=?");

		params.add(campanha.getCmcodigo());

		if (tipprotocolo.getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tipprotocolo.getTpcodigo());
		}
		if (tipprotocolo.getCampanha() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tipprotocolo.getCampanha());
		}
		if (tipprotocolo.getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tipprotocolo.getTpnombre());
		}
		if (tipprotocolo.getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tipprotocolo.getTpcotmo());
		}
		if (tipprotocolo.getTpestandar() != null) {
			where.append(" AND t2.TPESTANDAR = ?");
			params.add(tipprotocolo.getTpestandar());
		}

		StringBuilder query = new StringBuilder("SELECT count(1) FROM L21ttt00 t1,L2174T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Campanha> findAllLikeCampanha(Campanha campanha, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CMCODIGO = t2.PGCOCM(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CMCODIGO CMCODIGO,t1.CMNOMBRE CMNOMBRE,t1.CMCOPS CMCOPS,t1.CMNOAR CMNOAR,t1.CMNOPS CMNOPS,t1.CMCOTMO CMCOTMO,t1.CMFECHAINICIO CMFECHAINICIO,t1.CMFECHACIERRE CMFECHACIERRE,t1.CMORIGEN CMORIGEN,t1.CMTIPO CMTIPO, t1.CMCARACTER CMCARACTER,t1.CMACTIVA CMACTIVA, t1.CMONLINE CMONLINE, t1.CMFECINIBORRADOR CMFECINIBORRADOR, t1.CMFECFINBORRADOR CMFECFINBORRADOR, t1.CMFECINIVALIDACION CMFECINIVALIDACION, t1.CMFECFINVALIDACION CMFECFINVALIDACION "
						+ "FROM CAMPANHA t1, (SELECT t1.PGCOCM, MIN(t1.PGFEDESD) FECHAINICIO, MAX(t1.PGFEHAST) FECHAFIN FROM CAMPANHA_PROGRAMACION t1  group by t1.PGCOCM) t2  ");

		if (campanha != null && campanha.getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}
		if (campanha != null && campanha.getCmnombre() != null) {
			where.append(" AND UPPER(t1.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.CMNOMBRE IS NOT NULL");
		}

		if (campanha != null && campanha.getCmorigen() != null) {
			where.append(" AND t1.CMORIGEN = ?");
			params.add(campanha.getCmorigen());
		}
		if (campanha != null && campanha.getCmtipo() != null) {
			where.append(" AND t1.CMTIPO = ?");
			params.add(campanha.getCmtipo());
		}

		if (campanha != null && campanha.getCmfechainicioDesde() != null) {
			where.append(" AND t1.CMFECHAINICIO >= ?");
			params.add(campanha.getCmfechainicioDesde());
		}
		if (campanha != null && campanha.getCmfechainicioHasta() != null) {
			where.append(" AND t1.CMFECHAINICIO <= ?");
			params.add(campanha.getCmfechainicioHasta());
		}

		if (campanha != null && campanha.getCmfechacierreDesde() != null) {
			where.append(" AND t1.CMFECHACIERRE >= ?");
			params.add(campanha.getCmfechacierreDesde());
		}
		if (campanha != null && campanha.getCmfechacierreHasta() != null) {
			where.append(" AND t1.CMFECHACIERRE <= ?");
			params.add(campanha.getCmfechacierreHasta());
		}

		if (campanha != null && campanha.getCmcops() != null) {
			where.append(
					" AND EXISTS (SELECT tt1.CPCOPS FROM CAMPANHA_PROD tt1 WHERE tt1.CPCOCM=t1.CMCODIGO AND tt1.CPCOPS = ?)");
			params.add(campanha.getCmcops());
		}

		if (campanha != null && campanha.getTpcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT tt1.TPCODIGO FROM CAMPANHA_TIPOPROTOCOLO tt1 WHERE tt1.CMCODIGO=t1.CMCODIGO AND tt1.TPCODIGO = ?)");
			params.add(campanha.getTpcodigo());
		}

		if (campanha != null && (campanha.getCmincluircerradas() == null
				|| campanha.getCmincluircerradas().equals(Y41bConstantes.VALOR_NO))) {
			where.append(" AND t1.CMFECHACIERRE IS NULL ");
		}

		if (campanha != null && campanha.getCmfase() != null) {
			if (Y41bConstantes.FASE_CAMPANHA_BORRADOR.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t1.CMFECINIBORRADOR AND t1.CMFECFINBORRADOR AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_VALIDACION.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t1.CMFECINIVALIDACION AND t1.CMFECFINVALIDACION AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_EJECUCION.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t2.FECHAINICIO AND t2.FECHAFIN AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_ANALISIS.equals(campanha.getCmfase())) {
				where.append(" AND TRUNC(SYSDATE)>t2.FECHAFIN AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_CIERRE.equals(campanha.getCmfase())) {
				where.append(" AND t1.CMFECHACIERRE IS NOT NULL ");
			} else if (Y41bConstantes.FASE_CAMPANHA_INACTIVA.equals(campanha.getCmfase())) {
				where.append(" AND (t1.CMACTIVA = ? OR t1.CMACTIVA IS NULL) AND t1.CMFECHACIERRE IS NULL ");
				params.add(Y41bConstantes.VALOR_NO);
			}
		}

		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Campanha>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCampanhaCount(Campanha campanha, Boolean startsWith) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  AND t1.CMCODIGO = t2.PGCOCM(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM CAMPANHA t1, (SELECT t1.PGCOCM, MIN(t1.PGFEDESD) FECHAINICIO, MAX(t1.PGFEHAST) FECHAFIN FROM CAMPANHA_PROGRAMACION t1  group by t1.PGCOCM) t2 ");

		if (campanha != null && campanha.getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}
		if (campanha != null && campanha.getCmnombre() != null) {
			where.append(" AND UPPER(t1.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanha.getCmnombre().toUpperCase() + "%");
			} else {
				params.add("%" + campanha.getCmnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.CMNOMBRE IS NOT NULL");
		}

		if (campanha != null && campanha.getCmorigen() != null) {
			where.append(" AND t1.CMORIGEN = ?");
			params.add(campanha.getCmorigen());
		}
		if (campanha != null && campanha.getCmtipo() != null) {
			where.append(" AND t1.CMTIPO = ?");
			params.add(campanha.getCmtipo());
		}

		if (campanha != null && campanha.getCmfechainicioDesde() != null) {
			where.append(" AND t1.CMFECHAINICIO >= ?");
			params.add(campanha.getCmfechainicioDesde());
		}
		if (campanha != null && campanha.getCmfechainicioHasta() != null) {
			where.append(" AND t1.CMFECHAINICIO <= ?");
			params.add(campanha.getCmfechainicioHasta());
		}

		if (campanha != null && campanha.getCmfechacierreDesde() != null) {
			where.append(" AND t1.CMFECHACIERRE >= ?");
			params.add(campanha.getCmfechacierreDesde());
		}
		if (campanha != null && campanha.getCmfechacierreHasta() != null) {
			where.append(" AND t1.CMFECHACIERRE <= ?");
			params.add(campanha.getCmfechacierreHasta());
		}

		if (campanha != null && campanha.getCmcops() != null) {
			where.append(
					" AND EXISTS (SELECT tt1.CPCOPS FROM CAMPANHA_PROD tt1 WHERE tt1.CPCOCM=t1.CMCODIGO AND tt1.CPCOPS = ?)");
			params.add(campanha.getCmcops());
		}

		if (campanha != null && campanha.getTpcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT tt1.TPCODIGO FROM CAMPANHA_TIPOPROTOCOLO tt1 WHERE tt1.CMCODIGO=t1.CMCODIGO AND tt1.TPCODIGO = ?)");
			params.add(campanha.getTpcodigo());
		}

		if (campanha != null && (campanha.getCmincluircerradas() == null
				|| campanha.getCmincluircerradas().equals(Y41bConstantes.VALOR_NO))) {
			where.append(" AND t1.CMFECHACIERRE IS NULL ");
		}

		if (campanha != null && campanha.getCmfase() != null) {
			if (Y41bConstantes.FASE_CAMPANHA_BORRADOR.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t1.CMFECINIBORRADOR AND t1.CMFECFINBORRADOR AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_VALIDACION.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t1.CMFECINIVALIDACION AND t1.CMFECFINVALIDACION AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_EJECUCION.equals(campanha.getCmfase())) {
				where.append(
						" AND TRUNC(SYSDATE) BETWEEN t2.FECHAINICIO AND t2.FECHAFIN AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_ANALISIS.equals(campanha.getCmfase())) {
				where.append(" AND TRUNC(SYSDATE)>t2.FECHAFIN AND t1.CMFECHACIERRE IS NULL AND t1.CMACTIVA = ? ");
				params.add(Y41bConstantes.VALOR_SI);
			} else if (Y41bConstantes.FASE_CAMPANHA_CIERRE.equals(campanha.getCmfase())) {
				where.append(" AND t1.CMFECHACIERRE IS NOT NULL ");
			} else if (Y41bConstantes.FASE_CAMPANHA_INACTIVA.equals(campanha.getCmfase())) {
				where.append(" AND (t1.CMACTIVA = ? OR t1.CMACTIVA IS NULL) AND t1.CMFECHACIERRE IS NULL ");
				params.add(Y41bConstantes.VALOR_NO);
			}
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
