package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.TipProtocolo;

/**
 * CampanhaDao  
 * 
 *  
 */

public interface CampanhaDao {

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha add(Campanha campanha);

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha update(Campanha campanha);

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	public Campanha updateFechacierre(Campanha campanha);

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha find(Campanha campanha);

	/**
	 * Deletes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	void remove(Campanha campanha);

	/**
	 * Finds a List of rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Campanha> findAll(Campanha campanha, Pagination pagination);

	/**
	 * Counts rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Long
	 */
	Long findAllCount(Campanha campanha);

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Campanha> findAllLike(Campanha campanha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Campanha campanha, Boolean startsWith);

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha addCampanhaTipoprotocolo(Campanha campanha);

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	void removeCampanhaTipoprotocolo(Campanha campanha);

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return Campanha
	 */
	Campanha findCampanhaTipoprotocolo(Campanha campanha,
			TipProtocolo tipprotocolo, Pagination pagination);

	/**
	 * Counts rows rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return Long
	 */
	Long findCampanhaTipoprotocoloCount(Campanha campanha,
			TipProtocolo tipprotocolo);

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Campanha> findAllLikeCampanha(Campanha campanha,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCampanhaCount(Campanha campanha, Boolean startsWith);

}
