package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CampanhaComentarios;

/**
 * CampanhaComentariosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaComentariosDaoImpl implements CampanhaComentariosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaComentarios> rwMap = new RowMapper<CampanhaComentarios>() {
		public CampanhaComentarios mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CampanhaComentarios(resultSet.getString("TXCODIGO"),
					resultSet.getString("TXCMCODIGO"),
					resultSet.getString("TXCOMENTARIOARABA"),
					resultSet.getString("TXCOMENTARIOBIZKAIA"),
					resultSet.getString("TXCOMENTARIOGIPUZKOA"),
					resultSet.getString("TXCOMENTARIOSSCC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            Pagination
	 * @return CampanhaComentarios
	 */
	public CampanhaComentarios add(CampanhaComentarios campanhacomentarios) {
		String query = "INSERT INTO CAMPANHA_COMENTARIOS (TXCODIGO, TXCMCODIGO, TXCOMENTARIOARABA, TXCOMENTARIOBIZKAIA, TXCOMENTARIOGIPUZKOA, TXCOMENTARIOSSCC) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, campanhacomentarios.getTxcodigo(),
				campanhacomentarios.getTxcmcodigo(),
				campanhacomentarios.getTxcomentarioaraba(),
				campanhacomentarios.getTxcomentariobizkaia(),
				campanhacomentarios.getTxcomentariogipuzkoa(),
				campanhacomentarios.getTxcomentariosscc());
		return campanhacomentarios;
	}

	/**
	 * Updates a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            Pagination
	 * @return CampanhaComentarios
	 */
	public CampanhaComentarios update(CampanhaComentarios campanhacomentarios) {
		String query = "UPDATE CAMPANHA_COMENTARIOS SET TXCOMENTARIOARABA=?, TXCOMENTARIOBIZKAIA=?, TXCOMENTARIOGIPUZKOA=?, TXCOMENTARIOSSCC=? WHERE TXCMCODIGO=? ";
		this.jdbcTemplate.update(query,
				campanhacomentarios.getTxcomentarioaraba(),
				campanhacomentarios.getTxcomentariobizkaia(),
				campanhacomentarios.getTxcomentariogipuzkoa(),
				campanhacomentarios.getTxcomentariosscc(),
				campanhacomentarios.getTxcmcodigo());
		return campanhacomentarios;
	}

	/**
	 * Finds a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            Pagination
	 * @return CampanhaComentarios
	 */
	@Transactional(readOnly = true)
	public CampanhaComentarios find(CampanhaComentarios campanhacomentarios) {
		String query = "SELECT t1.TXCODIGO TXCODIGO, t1.TXCMCODIGO TXCMCODIGO, t1.TXCOMENTARIOARABA TXCOMENTARIOARABA, t1.TXCOMENTARIOBIZKAIA TXCOMENTARIOBIZKAIA, t1.TXCOMENTARIOGIPUZKOA TXCOMENTARIOGIPUZKOA, t1.TXCOMENTARIOSSCC TXCOMENTARIOSSCC FROM CAMPANHA_COMENTARIOS t1  WHERE t1.TXCMCODIGO = ? ";

		List<CampanhaComentarios> campanhacomentariosList = this.jdbcTemplate
				.query(query, this.rwMap, campanhacomentarios.getTxcmcodigo());
		return (CampanhaComentarios) DataAccessUtils
				.uniqueResult(campanhacomentariosList);
	}

	/**
	 * Removes a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            Pagination
	 * @return
	 */
	public void remove(CampanhaComentarios campanhacomentarios) {
		String query = "DELETE FROM CAMPANHA_COMENTARIOS WHERE TXCMCODIGO=?";
		this.jdbcTemplate.update(query, campanhacomentarios.getTxcmcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaComentarios> findAll(
			CampanhaComentarios campanhacomentarios, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TXCODIGO TXCODIGO,t1.TXCMCODIGO TXCMCODIGO,t1.TXCOMENTARIOARABA TXCOMENTARIOARABA,t1.TXCOMENTARIOBIZKAIA TXCOMENTARIOBIZKAIA,t1.TXCOMENTARIOGIPUZKOA TXCOMENTARIOGIPUZKOA,t1.TXCOMENTARIOSSCC TXCOMENTARIOSSCC ");
		query.append("FROM CAMPANHA_COMENTARIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhacomentarios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaComentarios>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaComentarios table.
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampanhaComentarios campanhacomentarios) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_COMENTARIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhacomentarios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CampanhaComentarios table using like.
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaComentarios> findAllLike(
			CampanhaComentarios campanhacomentarios, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TXCODIGO TXCODIGO,t1.TXCMCODIGO TXCMCODIGO,t1.TXCOMENTARIOARABA TXCOMENTARIOARABA,t1.TXCOMENTARIOBIZKAIA TXCOMENTARIOBIZKAIA,t1.TXCOMENTARIOGIPUZKOA TXCOMENTARIOGIPUZKOA,t1.TXCOMENTARIOSSCC TXCOMENTARIOSSCC ");
		query.append("FROM CAMPANHA_COMENTARIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhacomentarios,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaComentarios>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaComentarios table using like.
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CampanhaComentarios campanhacomentarios,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_COMENTARIOS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhacomentarios,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaComentarios entity
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CampanhaComentarios campanhacomentarios) {

		StringBuilder where = new StringBuilder(
				CampanhaComentariosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhacomentarios != null
				&& campanhacomentarios.getTxcodigo() != null) {
			where.append(" AND t1.TXCODIGO = ?");
			params.add(campanhacomentarios.getTxcodigo());
		}
		if (campanhacomentarios != null
				&& campanhacomentarios.getTxcmcodigo() != null) {
			where.append(" AND t1.TXCMCODIGO = ?");
			params.add(campanhacomentarios.getTxcmcodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaComentarios entity
	 * 
	 * @param campanhacomentarios
	 *            CampanhaComentarios Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			CampanhaComentarios campanhacomentarios, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CampanhaComentariosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhacomentarios != null
				&& campanhacomentarios.getTxcodigo() != null) {
			where.append(" AND UPPER(t1.TXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacomentarios.getTxcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhacomentarios.getTxcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TXCODIGO IS NOT NULL");
		}
		if (campanhacomentarios != null
				&& campanhacomentarios.getTxcmcodigo() != null) {
			where.append(" AND UPPER(t1.TXCMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacomentarios.getTxcmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhacomentarios.getTxcmcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TXCMCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
