package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.CampanhaComentarios;

/**
 * CampanhaComentariosDao  
 *  
 */

public interface CampanhaComentariosDao {
    
    /**
     * Inserts a single row in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @return CampanhaComentarios
     */
    CampanhaComentarios add(CampanhaComentarios campanhacomentarios);

    /**
     * Updates a single row in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @return CampanhaComentarios
     */
    CampanhaComentarios update(CampanhaComentarios campanhacomentarios);

    /**
     * Finds a single row in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @return CampanhaComentarios
     */
    CampanhaComentarios find(CampanhaComentarios campanhacomentarios);

    /**
     * Deletes a single row in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @return 
     */
    void remove(CampanhaComentarios campanhacomentarios);

    /**
     * Finds a List of rows in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @param pagination Pagination
     * @return List
     */
    List<CampanhaComentarios> findAll(CampanhaComentarios campanhacomentarios, Pagination pagination);

    /**
     * Counts rows in the CampanhaComentarios table.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @return Long
     */
    Long findAllCount(CampanhaComentarios campanhacomentarios);
	
	/**
     * Finds rows in the CampanhaComentarios table using like.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<CampanhaComentarios> findAllLike(CampanhaComentarios campanhacomentarios, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the CampanhaComentarios table using like.
     *
     * @param campanhacomentarios CampanhaComentarios
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(CampanhaComentarios campanhacomentarios, Boolean startsWith);
}

