package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CampanhaCierre;

/**
 * CampanhaCierreDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CampanhaCierreDaoImpl implements CampanhaCierreDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaCierre> rwMap = new RowMapper<CampanhaCierre>() {
		public CampanhaCierre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CampanhaCierre(resultSet.getString("TYCODIGO"),
					resultSet.getString("TYCMCODIGO"),
					resultSet.getString("TYVALORACIONARABA"),
					resultSet.getString("TYPROPUESTAARABA"),
					resultSet.getString("TYFINALIZADOARABA"),
					resultSet.getString("TYVALORACIONBIZKAIA"),
					resultSet.getString("TYPROPUESTABIZKAIA"),
					resultSet.getString("TYFINALIZADOBIZKAIA"),
					resultSet.getString("TYVALORACIONGIPUZKOA"),
					resultSet.getString("TYPROPUESTAGIPUZKOA"),
					resultSet.getString("TYFINALIZADOGIPUZKOA"),
					resultSet.getString("TYVALORACIONSSCC"),
					resultSet.getString("TYPROPUESTASSCC"),
					resultSet.getString("TYFINALIZADOSSCC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return CampanhaCierre
	 */
	public CampanhaCierre add(CampanhaCierre campanhacierre) {
		String query = "INSERT INTO CAMPANHA_CIERRE (TYCODIGO, TYCMCODIGO, TYVALORACIONARABA, TYPROPUESTAARABA, TYFINALIZADOARABA, TYVALORACIONBIZKAIA, TYPROPUESTABIZKAIA, TYFINALIZADOBIZKAIA, TYVALORACIONGIPUZKOA, TYPROPUESTAGIPUZKOA, TYFINALIZADOGIPUZKOA, TYVALORACIONSSCC, TYPROPUESTASSCC, TYFINALIZADOSSCC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, campanhacierre.getTycodigo(),
				campanhacierre.getTycmcodigo(),
				campanhacierre.getTyvaloracionaraba(),
				campanhacierre.getTypropuestaaraba(),
				campanhacierre.getTyfinalizadoaraba(),
				campanhacierre.getTyvaloracionbizkaia(),
				campanhacierre.getTypropuestabizkaia(),
				campanhacierre.getTyfinalizadobizkaia(),
				campanhacierre.getTyvaloraciongipuzkoa(),
				campanhacierre.getTypropuestagipuzkoa(),
				campanhacierre.getTyfinalizadogipuzkoa(),
				campanhacierre.getTyvaloracionsscc(),
				campanhacierre.getTypropuestasscc(),
				campanhacierre.getTyfinalizadosscc());
		return campanhacierre;
	}

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return CampanhaCierre
	 */
	public CampanhaCierre update(CampanhaCierre campanhacierre) {
		String query = "UPDATE CAMPANHA_CIERRE SET  TYVALORACIONARABA=?, TYPROPUESTAARABA=?, TYFINALIZADOARABA=?, TYVALORACIONBIZKAIA=?, TYPROPUESTABIZKAIA=?, TYFINALIZADOBIZKAIA=?, TYVALORACIONGIPUZKOA=?, TYPROPUESTAGIPUZKOA=?, TYFINALIZADOGIPUZKOA=?, TYVALORACIONSSCC=?, TYPROPUESTASSCC=?, TYFINALIZADOSSCC=? WHERE TYCMCODIGO=? ";
		this.jdbcTemplate.update(query, campanhacierre.getTyvaloracionaraba(),
				campanhacierre.getTypropuestaaraba(),
				campanhacierre.getTyfinalizadoaraba(),
				campanhacierre.getTyvaloracionbizkaia(),
				campanhacierre.getTypropuestabizkaia(),
				campanhacierre.getTyfinalizadobizkaia(),
				campanhacierre.getTyvaloraciongipuzkoa(),
				campanhacierre.getTypropuestagipuzkoa(),
				campanhacierre.getTyfinalizadogipuzkoa(),
				campanhacierre.getTyvaloracionsscc(),
				campanhacierre.getTypropuestasscc(),
				campanhacierre.getTyfinalizadosscc(),
				campanhacierre.getTycmcodigo());
		return campanhacierre;
	}

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return CampanhaCierre
	 */
	public CampanhaCierre updateReabrirCampana(CampanhaCierre campanhacierre) {
		String query = "UPDATE CAMPANHA_CIERRE SET TYFINALIZADOSSCC=null WHERE TYCMCODIGO=? ";
		this.jdbcTemplate.update(query, campanhacierre.getTycmcodigo());
		return campanhacierre;
	}

	/**
	 * Finds a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return CampanhaCierre
	 */
	@Transactional(readOnly = true)
	public CampanhaCierre find(CampanhaCierre campanhacierre) {
		String query = "SELECT t1.TYCODIGO TYCODIGO, t1.TYCMCODIGO TYCMCODIGO, t1.TYVALORACIONARABA TYVALORACIONARABA, t1.TYPROPUESTAARABA TYPROPUESTAARABA, t1.TYFINALIZADOARABA TYFINALIZADOARABA, t1.TYVALORACIONBIZKAIA TYVALORACIONBIZKAIA, t1.TYPROPUESTABIZKAIA TYPROPUESTABIZKAIA, t1.TYFINALIZADOBIZKAIA TYFINALIZADOBIZKAIA, t1.TYVALORACIONGIPUZKOA TYVALORACIONGIPUZKOA, t1.TYPROPUESTAGIPUZKOA TYPROPUESTAGIPUZKOA, t1.TYFINALIZADOGIPUZKOA TYFINALIZADOGIPUZKOA, t1.TYVALORACIONSSCC TYVALORACIONSSCC, t1.TYPROPUESTASSCC TYPROPUESTASSCC, t1.TYFINALIZADOSSCC TYFINALIZADOSSCC FROM CAMPANHA_CIERRE t1  WHERE t1.TYCMCODIGO = ? ";

		List<CampanhaCierre> campanhacierreList = this.jdbcTemplate.query(
				query, this.rwMap, campanhacierre.getTycmcodigo());
		return (CampanhaCierre) DataAccessUtils
				.uniqueResult(campanhacierreList);
	}

	/**
	 * Removes a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return
	 */
	public void remove(CampanhaCierre campanhacierre) {
		String query = "DELETE FROM CAMPANHA_CIERRE WHERE TYCMCODIGO=?";
		this.jdbcTemplate.update(query, campanhacierre.getTycmcodigo());
	}

	/**
	 * Finds a List of rows in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaCierre> findAll(CampanhaCierre campanhacierre,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TYCODIGO TYCODIGO,t1.TYCMCODIGO TYCMCODIGO,t1.TYVALORACIONARABA TYVALORACIONARABA,t1.TYPROPUESTAARABA TYPROPUESTAARABA,t1.TYFINALIZADOARABA TYFINALIZADOARABA,t1.TYVALORACIONBIZKAIA TYVALORACIONBIZKAIA,t1.TYPROPUESTABIZKAIA TYPROPUESTABIZKAIA,t1.TYFINALIZADOBIZKAIA TYFINALIZADOBIZKAIA,t1.TYVALORACIONGIPUZKOA TYVALORACIONGIPUZKOA,t1.TYPROPUESTAGIPUZKOA TYPROPUESTAGIPUZKOA,t1.TYFINALIZADOGIPUZKOA TYFINALIZADOGIPUZKOA,t1.TYVALORACIONSSCC TYVALORACIONSSCC,t1.TYPROPUESTASSCC TYPROPUESTASSCC,t1.TYFINALIZADOSSCC TYFINALIZADOSSCC ");
		query.append("FROM CAMPANHA_CIERRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhacierre);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaCierre>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampanhaCierre campanhacierre) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_CIERRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(campanhacierre);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampanhaCierre> findAllLike(CampanhaCierre campanhacierre,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TYCODIGO TYCODIGO,t1.TYCMCODIGO TYCMCODIGO,t1.TYVALORACIONARABA TYVALORACIONARABA,t1.TYPROPUESTAARABA TYPROPUESTAARABA,t1.TYFINALIZADOARABA TYFINALIZADOARABA,t1.TYVALORACIONBIZKAIA TYVALORACIONBIZKAIA,t1.TYPROPUESTABIZKAIA TYPROPUESTABIZKAIA,t1.TYFINALIZADOBIZKAIA TYFINALIZADOBIZKAIA,t1.TYVALORACIONGIPUZKOA TYVALORACIONGIPUZKOA,t1.TYPROPUESTAGIPUZKOA TYPROPUESTAGIPUZKOA,t1.TYFINALIZADOGIPUZKOA TYFINALIZADOGIPUZKOA,t1.TYVALORACIONSSCC TYVALORACIONSSCC,t1.TYPROPUESTASSCC TYPROPUESTASSCC,t1.TYFINALIZADOSSCC TYFINALIZADOSSCC ");
		query.append("FROM CAMPANHA_CIERRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhacierre,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<CampanhaCierre>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(CampanhaCierre campanhacierre,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM CAMPANHA_CIERRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(campanhacierre,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaCierre entity
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CampanhaCierre campanhacierre) {

		StringBuilder where = new StringBuilder(
				CampanhaCierreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhacierre != null && campanhacierre.getTycodigo() != null) {
			where.append(" AND t1.TYCODIGO = ?");
			params.add(campanhacierre.getTycodigo());
		}
		if (campanhacierre != null && campanhacierre.getTycmcodigo() != null) {
			where.append(" AND t1.TYCMCODIGO = ?");
			params.add(campanhacierre.getTycmcodigo());
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadoaraba() != null) {
			where.append(" AND t1.TYFINALIZADOARABA = ?");
			params.add(campanhacierre.getTyfinalizadoaraba());
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadobizkaia() != null) {
			where.append(" AND t1.TYFINALIZADOBIZKAIA = ?");
			params.add(campanhacierre.getTyfinalizadobizkaia());
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadogipuzkoa() != null) {
			where.append(" AND t1.TYFINALIZADOGIPUZKOA = ?");
			params.add(campanhacierre.getTyfinalizadogipuzkoa());
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadosscc() != null) {
			where.append(" AND t1.TYFINALIZADOSSCC = ?");
			params.add(campanhacierre.getTyfinalizadosscc());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CampanhaCierre entity
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(CampanhaCierre campanhacierre,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CampanhaCierreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (campanhacierre != null && campanhacierre.getTycodigo() != null) {
			where.append(" AND UPPER(t1.TYCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTycodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhacierre.getTycodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TYCODIGO IS NOT NULL");
		}
		if (campanhacierre != null && campanhacierre.getTycmcodigo() != null) {
			where.append(" AND UPPER(t1.TYCMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTycmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + campanhacierre.getTycmcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TYCMCODIGO IS NOT NULL");
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadoaraba() != null) {
			where.append(" AND UPPER(t1.TYFINALIZADOARABA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTyfinalizadoaraba().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhacierre.getTyfinalizadoaraba().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TYFINALIZADOARABA IS NOT NULL");
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadobizkaia() != null) {
			where.append(" AND UPPER(t1.TYFINALIZADOBIZKAIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTyfinalizadobizkaia()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ campanhacierre.getTyfinalizadobizkaia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TYFINALIZADOBIZKAIA IS NOT NULL");
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadogipuzkoa() != null) {
			where.append(" AND UPPER(t1.TYFINALIZADOGIPUZKOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTyfinalizadogipuzkoa()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ campanhacierre.getTyfinalizadogipuzkoa()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TYFINALIZADOGIPUZKOA IS NOT NULL");
		}
		if (campanhacierre != null
				&& campanhacierre.getTyfinalizadosscc() != null) {
			where.append(" AND UPPER(t1.TYFINALIZADOSSCC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campanhacierre.getTyfinalizadosscc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campanhacierre.getTyfinalizadosscc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TYFINALIZADOSSCC IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
