package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.CampanhaCierre;

/**
 * CampanhaCierreDao  
 * 
 *  
 */

public interface CampanhaCierreDao {

	/**
	 * Inserts a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	CampanhaCierre add(CampanhaCierre campanhacierre);

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	CampanhaCierre update(CampanhaCierre campanhacierre);

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            Pagination
	 * @return CampanhaCierre
	 */
	public CampanhaCierre updateReabrirCampana(CampanhaCierre campanhacierre);

	/**
	 * Finds a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	CampanhaCierre find(CampanhaCierre campanhacierre);

	/**
	 * Deletes a single row in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return
	 */
	void remove(CampanhaCierre campanhacierre);

	/**
	 * Finds a List of rows in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampanhaCierre> findAll(CampanhaCierre campanhacierre,
			Pagination pagination);

	/**
	 * Counts rows in the CampanhaCierre table.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @return Long
	 */
	Long findAllCount(CampanhaCierre campanhacierre);

	/**
	 * Finds rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CampanhaCierre> findAllLike(CampanhaCierre campanhacierre,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhacierre
	 *            CampanhaCierre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(CampanhaCierre campanhacierre, Boolean startsWith);
}
