package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteHechoModal;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaSolicitudesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BandejaSolicitudesDaoImpl implements BandejaSolicitudesDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaSolicitudes> rwMap = new RowMapper<BandejaSolicitudes>() {
		public BandejaSolicitudes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new BandejaSolicitudes(resultSet.getString("EHCODIGO"), resultSet.getString("HDCODIGO"),
					resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
					resultSet.getBigDecimal("HDNROR"), resultSet.getString("DECOTFP"), resultSet.getString("HDCOMO"),
					resultSet.getString("HDCOSC"), resultSet.getString("HCCOOR"), resultSet.getString("FCODIGOACTUAL"),
					resultSet.getString("TRCODIGOACTUAL"), resultSet.getString("Q5ORIGEN"),
					resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
					resultSet.getString("IDDESTINATARIO"), resultSet.getString("ESTADOTRAMITE"),
					resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"), resultSet.getString("TIPOAVISO"),
					null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return BandejaSolicitudes
	 */
	public BandejaSolicitudes add(BandejaSolicitudes bandejasolicitudes) {
		String query = "INSERT INTO BANDEJA_SOLICITUDES (EHCODIGO, HDCODIGO, DECOOR, DENRAN, DENROR, HDNROR, DECOTFP, HDCOMO, HDCOSC, HCCOOR, FCODIGOACTUAL, TRCODIGOACTUAL, Q5ORIGEN, Q5NOFILE, FECHATRAMITE, IDDESTINATARIO, ESTADOTRAMITE, FECHALIMITE, INDAVISO, TIPOAVISO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, bandejasolicitudes.getEhcodigo(), bandejasolicitudes.getHdcodigo(),
				bandejasolicitudes.getDecoor(), bandejasolicitudes.getDenran(), bandejasolicitudes.getDenror(),
				bandejasolicitudes.getHdnror(), bandejasolicitudes.getDecotfp(), bandejasolicitudes.getHdcomo(),
				bandejasolicitudes.getHdcosc(), bandejasolicitudes.getHccoor(), bandejasolicitudes.getFcodigoactual(),
				bandejasolicitudes.getTrcodigoactual(), bandejasolicitudes.getQ5origen(),
				bandejasolicitudes.getQ5nofile(), bandejasolicitudes.getFechatramite(),
				bandejasolicitudes.getIddestinatario(), bandejasolicitudes.getEstadotramite(),
				bandejasolicitudes.getFechalimite(), bandejasolicitudes.getIndaviso(),
				bandejasolicitudes.getTipoaviso());
		return bandejasolicitudes;
	}

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return BandejaSolicitudes
	 */
	public BandejaSolicitudes update(BandejaSolicitudes bandejasolicitudes) {
		String query = "UPDATE BANDEJA_SOLICITUDES SET HDCODIGO=?, DECOOR=?, DENRAN=?, DENROR=?, HDNROR=?, DECOTFP=?, HDCOMO=?, HDCOSC=?, HCCOOR=?, FCODIGOACTUAL=?, TRCODIGOACTUAL=?, Q5ORIGEN=?, Q5NOFILE=?, FECHATRAMITE=?, IDDESTINATARIO=?, ESTADOTRAMITE=?, FECHALIMITE=?, INDAVISO=?, TIPOAVISO=? WHERE EHCODIGO=?";
		this.jdbcTemplate.update(query, bandejasolicitudes.getHdcodigo(), bandejasolicitudes.getDecoor(),
				bandejasolicitudes.getDenran(), bandejasolicitudes.getDenror(), bandejasolicitudes.getHdnror(),
				bandejasolicitudes.getDecotfp(), bandejasolicitudes.getHdcomo(), bandejasolicitudes.getHdcosc(),
				bandejasolicitudes.getHccoor(), bandejasolicitudes.getFcodigoactual(),
				bandejasolicitudes.getTrcodigoactual(), bandejasolicitudes.getQ5origen(),
				bandejasolicitudes.getQ5nofile(), bandejasolicitudes.getFechatramite(),
				bandejasolicitudes.getIddestinatario(), bandejasolicitudes.getEstadotramite(),
				bandejasolicitudes.getFechalimite(), bandejasolicitudes.getIndaviso(),
				bandejasolicitudes.getTipoaviso(), bandejasolicitudes.getEhcodigo());
		return bandejasolicitudes;
	}

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return BandejaSolicitudes
	 */
	public BandejaSolicitudes updateFechaLimite(BandejaSolicitudes bandejasolicitudes) {
		String query = "UPDATE BANDEJA_SOLICITUDES SET FECHALIMITE=? WHERE EHCODIGO=?";
		this.jdbcTemplate.update(query, bandejasolicitudes.getHdcodigo(), bandejasolicitudes.getFechalimite());
		return bandejasolicitudes;
	}

	/**
	 * Finds a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return BandejaSolicitudes
	 */
	@Transactional(readOnly = true)
	public BandejaSolicitudes find(BandejaSolicitudes bandejasolicitudes) {
		String query = "SELECT t1.EHCODIGO EHCODIGO, t1.HDCODIGO HDCODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.HDNROR HDNROR, t1.DECOTFP DECOTFP, t1.HDCOMO HDCOMO, t1.HDCOSC HDCOSC, t1.HCCOOR HCCOOR, t1.FCODIGOACTUAL FCODIGOACTUAL, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.FECHATRAMITE FECHATRAMITE, t1.IDDESTINATARIO IDDESTINATARIO, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, t1.INDAVISO INDAVISO, t1.TIPOAVISO TIPOAVISO FROM BANDEJA_SOLICITUDES t1  WHERE t1.EHCODIGO = ?  ";

		List<BandejaSolicitudes> bandejasolicitudesList = this.jdbcTemplate.query(query, this.rwMap,
				bandejasolicitudes.getEhcodigo());
		return (BandejaSolicitudes) DataAccessUtils.uniqueResult(bandejasolicitudesList);
	}

	/**
	 * Removes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaSolicitudes bandejasolicitudes) {
		String query = "DELETE FROM BANDEJA_SOLICITUDES WHERE EHCODIGO=?";
		this.jdbcTemplate.update(query, bandejasolicitudes.getEhcodigo());
	}

	/**
	 * Removes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return
	 */
	public void removeAllTramitesExpediente(BandejaSolicitudes bandejasolicitudes) {
		String query = "DELETE FROM BANDEJA_SOLICITUDES WHERE HDCODIGO=?";
		this.jdbcTemplate.update(query, bandejasolicitudes.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudes> findAll(BandejaSolicitudes bandejasolicitudes, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.HDCODIGO HDCODIGO,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.HDNROR HDNROR,t1.DECOTFP DECOTFP,t1.HDCOMO HDCOMO,t1.HDCOSC HDCOSC,t1.HCCOOR HCCOOR,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.Q5ORIGEN Q5ORIGEN,t1.Q5NOFILE Q5NOFILE,t1.FECHATRAMITE FECHATRAMITE,t1.IDDESTINATARIO IDDESTINATARIO,t1.ESTADOTRAMITE ESTADOTRAMITE,t1.FECHALIMITE FECHALIMITE,t1.INDAVISO INDAVISO,t1.TIPOAVISO TIPOAVISO ");
		query.append("FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejasolicitudes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudes>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaSolicitudes bandejasolicitudes) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejasolicitudes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudes> findAllLike(BandejaSolicitudes bandejasolicitudes, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.HDCODIGO HDCODIGO,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.HDNROR HDNROR,t1.DECOTFP DECOTFP,t1.HDCOMO HDCOMO,t1.HDCOSC HDCOSC,t1.HCCOOR HCCOOR,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.Q5ORIGEN Q5ORIGEN,t1.Q5NOFILE Q5NOFILE,t1.FECHATRAMITE FECHATRAMITE,t1.IDDESTINATARIO IDDESTINATARIO,t1.ESTADOTRAMITE ESTADOTRAMITE,t1.FECHALIMITE FECHALIMITE,t1.INDAVISO INDAVISO,t1.TIPOAVISO TIPOAVISO ");
		query.append("FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejasolicitudes, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudes>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaSolicitudes bandejasolicitudes, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejasolicitudes, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaSolicitudes entity
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaSolicitudes bandejasolicitudes) {

		StringBuilder where = new StringBuilder(BandejaSolicitudesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejasolicitudes != null && bandejasolicitudes.getEhcodigo() != null) {
			where.append(" AND t1.EHCODIGO = ?");
			params.add(bandejasolicitudes.getEhcodigo());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcodigo() != null) {
			where.append(" AND t1.HDCODIGO = ?");
			params.add(bandejasolicitudes.getHdcodigo());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDecoor() != null) {
			where.append(" AND t1.DECOOR = ?");
			params.add(bandejasolicitudes.getDecoor());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(bandejasolicitudes.getDenran());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(bandejasolicitudes.getDenror());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(bandejasolicitudes.getHdnror());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDecotfp() != null) {
			where.append(" AND t1.DECOTFP = ?");
			params.add(bandejasolicitudes.getDecotfp());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcomo() != null) {
			where.append(" AND t1.HDCOMO = ?");
			params.add(bandejasolicitudes.getHdcomo());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcosc() != null) {
			where.append(" AND t1.HDCOSC = ?");
			params.add(bandejasolicitudes.getHdcosc());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHccoor() != null) {
			where.append(" AND t1.HCCOOR = ?");
			params.add(bandejasolicitudes.getHccoor());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFcodigoactual() != null) {
			where.append(" AND t1.FCODIGOACTUAL = ?");
			params.add(bandejasolicitudes.getFcodigoactual());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getTrcodigoactual() != null) {
			where.append(" AND t1.TRCODIGOACTUAL = ?");
			params.add(bandejasolicitudes.getTrcodigoactual());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(bandejasolicitudes.getQ5origen());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(bandejasolicitudes.getQ5nofile());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(bandejasolicitudes.getFechatramite());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getIddestinatario() != null) {
			where.append(" AND t1.IDDESTINATARIO = ?");
			params.add(bandejasolicitudes.getIddestinatario());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getEstadotramite() != null) {
			where.append(" AND t1.ESTADOTRAMITE = ?");
			params.add(bandejasolicitudes.getEstadotramite());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(bandejasolicitudes.getFechalimite());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getIndaviso() != null) {
			where.append(" AND t1.INDAVISO = ?");
			params.add(bandejasolicitudes.getIndaviso());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getTipoaviso() != null) {
			where.append(" AND t1.TIPOAVISO = ?");
			params.add(bandejasolicitudes.getTipoaviso());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaSolicitudes entity
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaSolicitudes bandejasolicitudes, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BandejaSolicitudesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejasolicitudes != null && bandejasolicitudes.getEhcodigo() != null) {
			where.append(" AND UPPER(t1.EHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getEhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getEhcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EHCODIGO IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcodigo() != null) {
			where.append(" AND UPPER(t1.HDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getHdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getHdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCODIGO IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getDecoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getDecoor().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOOR IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(bandejasolicitudes.getDenran());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(bandejasolicitudes.getDenror());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(bandejasolicitudes.getHdnror());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getDecotfp() != null) {
			where.append(" AND UPPER(t1.DECOTFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getDecotfp().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getDecotfp().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOTFP IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcomo() != null) {
			where.append(" AND UPPER(t1.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getHdcomo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getHdcomo().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOMO IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHdcosc() != null) {
			where.append(" AND UPPER(t1.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getHdcosc().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getHdcosc().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOSC IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getHccoor() != null) {
			where.append(" AND UPPER(t1.HCCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getHccoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getHccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.HCCOOR IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFcodigoactual() != null) {
			where.append(" AND UPPER(t1.FCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getFcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getFcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.FCODIGOACTUAL IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getTrcodigoactual() != null) {
			where.append(" AND UPPER(t1.TRCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getTrcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getTrcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGOACTUAL IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getQ5origen() != null) {
			where.append(" AND UPPER(t1.Q5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getQ5origen().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getQ5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ORIGEN IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getQ5nofile() != null) {
			where.append(" AND UPPER(t1.Q5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getQ5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getQ5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5NOFILE IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(bandejasolicitudes.getFechatramite());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getIddestinatario() != null) {
			where.append(" AND UPPER(t1.IDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getIddestinatario().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getIddestinatario().toUpperCase() + "%");
			}
			where.append(" AND t1.IDDESTINATARIO IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getEstadotramite() != null) {
			where.append(" AND UPPER(t1.ESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getEstadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getEstadotramite().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADOTRAMITE IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(bandejasolicitudes.getFechalimite());
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getIndaviso() != null) {
			where.append(" AND UPPER(t1.INDAVISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getIndaviso().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getIndaviso().toUpperCase() + "%");
			}
			where.append(" AND t1.INDAVISO IS NOT NULL");
		}
		if (bandejasolicitudes != null && bandejasolicitudes.getTipoaviso() != null) {
			where.append(" AND UPPER(t1.TIPOAVISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejasolicitudes.getTipoaviso().toUpperCase() + "%");
			} else {
				params.add("%" + bandejasolicitudes.getTipoaviso().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOAVISO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.HDCODIGO HDCODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.HDNROR HDNROR, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t1.HDCOSC HDCOSC, t3.FCODIGO FCODIGO, t3.FNOMBRE FNOMBRE, t3.FNOMBREE FNOMBREE, t4.TRCODIGO TRCODIGO, DECODE(t4.TRCODIGO, 'K25',t7.EHNOMBRETRAMITE,t4.TRNOMBRE) TRNOMBRE, DECODE(t4.TRCODIGO, 'K25',t7.EHNOMBRETRAMITE,t4.TRNOMBREE) TRNOMBREE, t5.MOCODIGO MOCODIGO, t5.MONOMBRE MONOMBRE, t1.HCCOOR HCCOOR, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.FECHATRAMITE FECHATRAMITE, t1.IDDESTINATARIO IDDESTINATARIO,	t6.NOMBRE || ' ' || t6.APELLIDO1 || ' ' || t6.APELLIDO2 NOMBRE, t6.NIF NIF, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, t1.INDAVISO INDAVISO, t1.TIPOAVISO TIPOAVISO, t7.EHFECHAENVIOBOPVBOE EHFECHAENVIOBOPVBOE, t7.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO, t8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, t7.EHISTELEMATICO EHISTELEMATICO, t7.EHISWEBSINCERTIFICADO EHISWEBSINCERTIFICADO ");
		query.append(
				"FROM BANDEJA_SOLICITUDES t1, FORMA_PRESENTACION t2, FASE t3, TRAMITE t4,CENSO_MONITOR t5, INTERVINIENTES t6,TRAMITE_HECHO t7, ENVIOS_POR_REMESA t8 WHERE  (1=1) AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.FCODIGOACTUAL = t3.FCODIGO(+) AND t1.TRCODIGOACTUAL = t4.TRCODIGO(+) AND t1.HDCOMO = t5.MOCODIGO(+) AND t1.IDDESTINATARIO = t6.IDINTERVINIENTE(+) AND t1.EHCODIGO=t7.EHCODIGO(+) AND t7.EHCODIGO = t8.EHCODIGO(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(" AND (t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_BOPV_AYTO);
			where.append(" OR (t1.HCCOOR = ? ");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {

			where.append(" AND t1.HCCOOR = ? ");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		}

		if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_COMUNICACION);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_NOTIFICACION);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_BOPV_AYTO);
			where.append(" OR (t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_ACUSE_RECIBO);
			where.append(" AND t7.EHFECHAFIN IS NULL) ");
			where.append(" OR t4.TRCODIGO=?) ");
			params.add(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			where.append(" AND t5.MOCODIGO = ? ");
			params.add(censoMonitor.getMocodigo());
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			where.append(" OR t5.MOCODIGO = ?) ");
			params.add(censoMonitor.getMocodigo());
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			where.append(" OR t5.MOCODIGO = ?) ");
			params.add(censoMonitor.getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(" )) ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, null, resultSet.getString("TFPCODIGO"),
								resultSet.getString("TFPNOMBRE"), resultSet.getString("TFPNOMBREE"),
								resultSet.getString("HDCOSC"), resultSet.getString("FCODIGO"),
								resultSet.getString("FNOMBRE"), resultSet.getString("FNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getString("MOCODIGO"),
								resultSet.getString("MONOMBRE"), resultSet.getString("HCCOOR"),
								resultSet.getString("Q5ORIGEN"), resultSet.getString("Q5NOFILE"),
								resultSet.getDate("FECHATRAMITE"), resultSet.getString("IDDESTINATARIO"),
								resultSet.getString("NOMBRE"), resultSet.getString("NIF"),
								resultSet.getString("ESTADOTRAMITE"), resultSet.getDate("FECHALIMITE"),
								resultSet.getString("INDAVISO"), resultSet.getString("TIPOAVISO"),
								resultSet.getDate("EHFECHAENVIOBOPVBOE"), resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_SOLICITUDES t1, FORMA_PRESENTACION t2, FASE t3, TRAMITE t4,CENSO_MONITOR t5, INTERVINIENTES t6,TRAMITE_HECHO t7 WHERE  (1=1) AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.FCODIGOACTUAL = t3.FCODIGO(+) AND t1.TRCODIGOACTUAL = t4.TRCODIGO(+) AND t1.HDCOMO = t5.MOCODIGO(+) AND t1.IDDESTINATARIO = t6.IDINTERVINIENTE(+) AND t1.EHCODIGO=t7.EHCODIGO(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(" AND (t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_BOPV_AYTO);
			where.append(" OR (t1.HCCOOR = ? ");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {

			where.append(" AND t1.HCCOOR = ? ");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		}

		if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_COMUNICACION);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_NOTIFICACION);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_BOPV_AYTO);
			where.append(" OR (t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_ACUSE_RECIBO);
			where.append(" AND t7.EHFECHAFIN IS NULL) ");
			where.append(" OR t4.TRCODIGO=?) ");
			params.add(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			where.append(" AND t5.MOCODIGO = ? ");
			params.add(censoMonitor.getMocodigo());
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			where.append(" OR t5.MOCODIGO = ?) ");
			params.add(censoMonitor.getMocodigo());
		} else if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			where.append(" AND (t4.TRCODIGO= ? ");
			params.add(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR);
			where.append(" OR t4.TRCODIGO=? ");
			params.add(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO);
			where.append(" OR t5.MOCODIGO = ?) ");
			params.add(censoMonitor.getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(" )) ");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudes> findAllTramitesPendientesSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t2.HDCODIGO HDCODIGO, t3.DECOOR DECOOR, t3.DENRAN DENRAN, t3.DENROR DENROR, t2.HDNROR HDNROR, t3.DECOTFP DECOTFP, t2.HDCOMO HDCOMO, t2.HDCOSC HDCOSC, t4.HCCOOR HCCOOR, t2.FCODIGOACTUAL FCODIGOACTUAL, t1.EHCOTEE TRCODIGOACTUAL, t1.EHFECHAINICIO FECHATRAMITE,	t1.EHIDDESTINATARIO IDDESTINATARIO,	t1.EHESTADOTRAMITE ESTADOTRAMITE, t1.EHFECHALIMITE EHFECHALIMITE ");
		query.append(
				"FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudes>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudes>() {
					public BandejaSolicitudes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudes(resultSet.getString("EHCODIGO"), resultSet.getString("HDCODIGO"),
								resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("DENROR"), resultSet.getBigDecimal("HDNROR"),
								resultSet.getString("DECOTFP"), resultSet.getString("HDCOMO"),
								resultSet.getString("HDCOSC"), resultSet.getString("HCCOOR"),
								resultSet.getString("FCODIGOACTUAL"), resultSet.getString("TRCODIGOACTUAL"), null, null,
								resultSet.getDate("FECHATRAMITE"), resultSet.getString("IDDESTINATARIO"),
								resultSet.getString("ESTADOTRAMITE"), resultSet.getDate("EHFECHALIMITE"), null, null,
								resultSet.getString("EHCOTEE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesPendientesSolicitudesCount(BandejaSolicitudes bandejaSolicitudes) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteHechoModal> findAllTramitesPendientesSolicitudesBandejas(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t1.EHISTELEMATICO EHISTELEMATICO, t2.HDCODIGO HDCODIGO, t3.DECOOR DECOOR, t3.DENRAN DENRAN, t3.DENROR DENROR, t2.HDNROR HDNROR, t3.DECOTFP DECOTFP, t2.HDCOMO HDCOMO, t2.HDCOSC HDCOSC, t4.HCCOOR HCCOOR, t2.FCODIGOACTUAL FCODIGOACTUAL, t1.EHCOTEE TRCODIGOACTUAL, t1.EHFECHAINICIO FECHATRAMITE,	t1.EHIDDESTINATARIO IDDESTINATARIO,	t1.EHESTADOTRAMITE ESTADOTRAMITE, t1.EHFECHALIMITE EHFECHALIMITE, t1.EHFECHAENVIOBOPVBOE EHFECHAENVIOBOPVBOE, t1.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO ");
		query.append(", t7.FCODIGO FCODIGO, t7.FNOMBRE FNOMBRE, t7.FNOMBREE FNOMBREE ");
		query.append(
				", t1.EHCOTEE TRCODIGO, DECODE(t6.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t6.TRNOMBRE) TRNOMBRE, DECODE(t6.TRCODIGO, 'K25',t1.EHNOMBRETRAMITE,t6.TRNOMBREE) TRNOMBREE ");
		query.append(
				", DECODE(t_EJECUCION.MOCODIGO,null,t_ASIGNADO.MOCODIGO,t_EJECUCION.MOCODIGO) MOCODIGO,DECODE(t_EJECUCION.MONOMBRE,null,t_ASIGNADO.MONOMBRE,t_EJECUCION.MONOMBRE) MONOMBRE ");
		query.append(", t8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU ");
		query.append(
				"FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4, BANDEJA_SOLICITUDES t5, TRAMITE t6 ,FASE t7, CENSO_MONITOR t_ASIGNADO, CENSO_MONITOR t_EJECUCION, ENVIOS_POR_REMESA t8 ");
		query.append(
				"WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD ");
		query.append(
				"AND t5.EHCODIGO=t1.EHCODIGO(+) AND t1.EHFCODIGO = t7.FCODIGO(+) AND t1.EHCOTEE= t6.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t_ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t_EJECUCION.MOCODIGO(+) ");
		// t5.FCODIGOACTUAL = t7.FCODIGO(+) por AND t1.EHFCODIGO = t7.FCODIGO(+)
		query.append("AND t1.EHCODIGORELACIONADO = t8.EHCODIGO(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteHechoModal>) this.jdbcTemplate.query(query.toString(), new RowMapper<TramiteHechoModal>() {
			public TramiteHechoModal mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TramiteHechoModal(resultSet.getString("HDCODIGO"), resultSet.getString("EHCODIGO"),
						resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"), resultSet.getString("FNOMBREE"),
						resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
						resultSet.getString("TRNOMBREE"), resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("FECHATRAMITE"),
						resultSet.getString("ESTADOTRAMITE"), resultSet.getDate("EHFECHALIMITE"),
						resultSet.getDate("EHFECHAENVIOBOPVBOE"), resultSet.getString("EHACUSERECIBORECIBIDO"),
						resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
						resultSet.getString("EHISTELEMATICO"));
			}
		}, params.toArray());

	}

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesPendientesSolicitudesBandejasCount(BandejaSolicitudes bandejaSolicitudes) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");
		query.append(
				"FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4, BANDEJA_SOLICITUDES t5, TRAMITE t6 ,FASE t7, CENSO_MONITOR t_ASIGNADO, CENSO_MONITOR t_EJECUCION, ENVIOS_POR_REMESA t8 ");
		query.append(
				"WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD ");
		query.append(
				"AND t5.EHCODIGO=t1.EHCODIGO(+) AND t5.FCODIGOACTUAL = t7.FCODIGO(+) AND t1.EHCOTEE= t6.TRCODIGO(+) AND t1.EHCOMOASIGNADO= t_ASIGNADO.MOCODIGO(+) AND t1.EHCOMOEJECUCION= t_EJECUCION.MOCODIGO(+) ");
		query.append("AND t1.EHCODIGORELACIONADO = t8.EHCODIGO(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudes> findAllTramitesFinalizadosSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t2.HDCODIGO HDCODIGO, t3.DECOOR DECOOR, t3.DENRAN DENRAN, t3.DENROR DENROR, t2.HDNROR HDNROR, t3.DECOTFP DECOTFP, t2.HDCOMO HDCOMO, t2.HDCOSC HDCOSC, t4.HCCOOR HCCOOR, t2.FCODIGOACTUAL FCODIGOACTUAL, t2.TRCODIGOACTUAL TRCODIGOACTUAL,	t1.EHFECHAFIN FECHATRAMITE,	t1.EHIDDESTINATARIO IDDESTINATARIO,	t1.EHESTADOTRAMITE ESTADOTRAMITE ");
		query.append(
				"FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		} else {
			query.append(" ORDER BY EHFECHA DESC, EHHORA DESC ");
		}

		return (List<BandejaSolicitudes>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudes>() {
					public BandejaSolicitudes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudes(resultSet.getString("EHCODIGO"), resultSet.getString("HDCODIGO"),
								resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("DENROR"), resultSet.getBigDecimal("HDNROR"),
								resultSet.getString("DECOTFP"), resultSet.getString("HDCOMO"),
								resultSet.getString("HDCOSC"), resultSet.getString("HCCOOR"),
								resultSet.getString("FCODIGOACTUAL"), resultSet.getString("TRCODIGOACTUAL"), null, null,
								resultSet.getDate("FECHATRAMITE"), resultSet.getString("IDDESTINATARIO"),
								resultSet.getString("ESTADOTRAMITE"), null, null, null, resultSet.getString("EHCOTEE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesFinalizadosSolicitudesCount(BandejaSolicitudes bandejaSolicitudes) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(bandejaSolicitudes.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	private void construyeSelectBandejas(StringBuilder query) {
		query.append("SELECT t1.EHCODIGO EHCODIGO, t1.HDCODIGO HDCODIGO,");
		// reclamante-reclamado
		query.append(
				" (SELECT tReclamante.NOMBRE  || ' '  || tReclamante.APELLIDO1  || ' '  || tReclamante.APELLIDO2 NOMBRE FROM INTERVINIENTES tReclamante");
		query.append(" WHERE tReclamante.TIPO_INTERVINIENTE = 'I' AND tReclamante.HDCODIGO = t1.HDCODIGO) reclamante,");
		query.append(
				"(SELECT tReclamado.NOMBRE || ' ' || tReclamado.APELLIDO1 || ' ' || tReclamado.APELLIDO2 NOMBRE FROM INTERVINIENTES tReclamado");
		query.append(" WHERE  tReclamado.TIPO_INTERVINIENTE = 'D' AND tReclamado.HDCODIGO  = t1.HDCODIGO) reclamado,");
		query.append(" t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.HDNROR HDNROR, T7.EHFECHA, T7.EHHORA");
		query.append(" , to_char (t1.FECHATRAMITE, 'yyyy/mm/dd HH:MM:SS') fecha_hora,");
		query.append(" (SELECT COUNT(1)");
		query.append(" FROM TRAMITE_HECHO t11, HECHO_DENUNCIADO t22");
		query.append(
				" WHERE  (1=1) AND t11.EHCOHD = t22.HDCODIGO AND t22.HDCODIGO=t1.HDCODIGO AND t11.EHFECHAINICIO IS NOT NULL AND t11.EHFECHAFIN IS NULL) num_pdtes");
		query.append(
				" , t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t1.HDCOSC HDCOSC, t3.FCODIGO FCODIGO, t3.FNOMBRE FNOMBRE");
		query.append(
				" , t3.FNOMBREE FNOMBREE, t4.TRCODIGO TRCODIGO, DECODE(t4.TRCODIGO, 'K25',t7.EHNOMBRETRAMITE,t4.TRNOMBRE) TRNOMBRE");
		query.append(
				" , DECODE(t4.TRCODIGO, 'K25',t7.EHNOMBRETRAMITE,t4.TRNOMBREE) TRNOMBREE, t5.MOCODIGO MOCODIGO, t5.MONOMBRE MONOMBRE, t1.HCCOOR HCCOOR");
		query.append(
				" , t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.FECHATRAMITE FECHATRAMITE, t1.IDDESTINATARIO IDDESTINATARIO");
		query.append(
				" , t6.NOMBRE || ' ' || t6.APELLIDO1 || ' ' || t6.APELLIDO2 NOMBRE, t6.NIF NIF, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE");
		query.append(
				" , t1.INDAVISO INDAVISO, t1.TIPOAVISO TIPOAVISO, t7.EHFECHAENVIOBOPVBOE EHFECHAENVIOBOPVBOE, t7.EHACUSERECIBORECIBIDO EHACUSERECIBORECIBIDO, t7.EHISTELEMATICO EHISTELEMATICO, t7.EHISWEBSINCERTIFICADO EHISWEBSINCERTIFICADO, t9.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t9.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU ");
	}

	private void construyeFromBandejas(StringBuilder query) {
		query.append(
				" FROM BANDEJA_SOLICITUDES t1, FORMA_PRESENTACION t2, FASE t3, TRAMITE t4, CENSO_MONITOR t5, INTERVINIENTES t6, TRAMITE_HECHO t7, DECISION_HECHO t8, ENVIOS_POR_REMESA t9 ");
		query.append(" WHERE (1=1)");
		query.append(
				" AND t1.DECOTFP = t2.TFPCODIGO(+)AND t1.FCODIGOACTUAL = t3.FCODIGO(+) AND t1.TRCODIGOACTUAL = t4.TRCODIGO(+) AND t1.HDCOMO = t5.MOCODIGO(+)");
		query.append(
				" AND t1.IDDESTINATARIO = t6.IDINTERVINIENTE(+) AND t1.EHCODIGO = t7.EHCODIGO(+) AND t7.EHCOHD = t8.HCCOHD AND t7.EHCODIGORELACIONADO = t9.EHCODIGO(+)");
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja Solicitudes Administrativos y/o Bandeja Solicitudes con perfil
	 * especial BOPV-BOE
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesAdministrativo(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesAdministrativoPropias("t1", "t1_2", "t7_2",
				bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX (t1_3.FECHATRAMITE) ");
		query.append(construyeCondicionesBandejaSolicitudesAdministrativoPropias("t1_2", "t1_3", "t7_3",
				bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" ) )");

		// Aplicar el filtro de tramite pendiente dentro del expediente
		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND t1.HDCODIGO = ( ");
			query.append(
					" SELECT MAX(HDCODIGO) FROM BANDEJA_SOLICITUDES BS WHERE t1.HDCODIGO = BS.HDCODIGO AND BS.TRCODIGOACTUAL='");
			query.append(bandejaSolicitudes.getTrcodigo());
			query.append("')");
		}

		return query;
	}

	private String construyeCondicionesBandejaSolicitudesAdministrativoPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAFIN    IS NULL");

		if (censoMonitor != null) {
			if (censoMonitor.getPerfilSolicitudes() != null && censoMonitor.getPerfilSolicitudes().getIdPerfil() != null
					&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)) {

				query.append(" AND (").append(aliasTablaBandejaSolicitudes).append(".HCCOOR = '")
						.append(censoMonitor.getOrganismo().getCodOrg()).append("'");
				query.append(" AND ( ");
				query.append(" (").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
						.append(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD).append("' )");
				query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
						.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
				query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
						.append(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA).append("' )");
				query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
						.append(Y41bConstantes.TRAMITE_COMUNICACION).append("' AND ").append(aliasTablaTramiteHecho)
						.append(".EHCOMOASIGNADO = '").append(censoMonitor.getMocodigo()).append("')");
				query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
						.append(Y41bConstantes.TRAMITE_NOTIFICACION).append("' AND ").append(aliasTablaTramiteHecho)
						.append(".EHCOMOASIGNADO ='").append(censoMonitor.getMocodigo()).append("')");
				if ((censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI))) {
					query.append(" ) OR ");
					query.append(" (").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
							.append(Y41bConstantes.TRAMITE_BOPV_AYTO).append("' )");
				} else {
					query.append(" )");
				}
				query.append(" )");
			} else {
				if ((censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI))) {

					query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
							.append(Y41bConstantes.TRAMITE_BOPV_AYTO).append("' ");
				}
			}
		}

		// RESTO DE FILTROS....
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getDecotfp() != null) {
			query.append(" AND (").append(aliasTablaBandejaSolicitudes).append(".DECOTFP='")
					.append(bandejaSolicitudes.getDecotfp()).append("' )");
		}

		if (Y41bConstantes.VALOR_SI.equals(excluirAcuses)) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE!='")
					.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesAdministrativo(
			BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta,
			String excluirAcuses, Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesAdministrativoCount(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses));

		return this.jdbcTemplate.queryForLong(query.toString());
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja expedientes nuevos y pendientes decisin
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesENYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(construyeCondicionEspecialDecision());
		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesENYPDPropias("t1", "t1_2", "t7_2", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses));
		query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX (t1_3.FECHATRAMITE) ");
		query.append(construyeCondicionesBandejaSolicitudesENYPDPropias("t1_2", "t1_3", "t7_3", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses));
		query.append(" ) )");

		return query;
	}

	private String construyeCondicionEspecialDecision() {

		StringBuilder subquery = new StringBuilder();
		subquery.append(" AND ( t8.HCCOTTD IS NULL ");
		subquery.append(" OR EHCOHD IN ");
		subquery.append(" ( ");
		subquery.append(" SELECT tr22.EHCOHD ");
		subquery.append(" FROM TRAMITE_HECHO tr22 ");
		subquery.append(" WHERE tr22.EHCOHD=t7.EHCOHD AND t8.HCCOTTD IS NOT NULL ");
		subquery.append(" AND tr22.EHCOTEE = '").append(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO)
				.append("' AND tr22.EHESTADOTRAMITE='").append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
				.append("' AND tr22.EHESTIMACION = '").append(Y41bConstantes.SI).append("' ");
		subquery.append(
				" AND tr22.EHFECHA = (SELECT MAX(tr333.EHFECHA) FROM TRAMITE_HECHO tr333 WHERE tr333.EHCOHD = tr22.EHCOHD AND tr333.EHESTADOTRAMITE='")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND tr333.EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO).append("') ");
		subquery.append(
				" AND NVL(tr22.EHHORA, 0) = (SELECT NVL(MAX(tr333.EHHORA), 0) FROM TRAMITE_HECHO tr333 WHERE tr333.EHFECHA = tr22.EHFECHA AND tr333.EHCOHD = tr22.EHCOHD AND tr333.EHESTADOTRAMITE='")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND tr333.EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_RECEPCION_ORDEN_CONSEJERO).append("') ");
		subquery.append(" AND ");
		subquery.append("     ( ");
		subquery.append("        ( ");
		subquery.append(
				"          tr22.EHFECHA > (SELECT NVL(MAX(tr333.EHFECHA),to_date('01/01/1900', 'DD/MM/YYYY')) FROM TRAMITE_HECHO tr333 WHERE tr333.EHCOHD = tr22.EHCOHD AND tr333.EHESTADOTRAMITE='")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND tr333.EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_REGISTRO_DECISION).append("') ");
		subquery.append("        ) ");
		subquery.append("        OR ");
		subquery.append("        ( ");
		subquery.append(
				"          tr22.EHFECHA = (SELECT MAX(tr444.EHFECHA) FROM TRAMITE_HECHO tr444 WHERE tr444.EHCOHD = tr22.EHCOHD AND tr444.EHESTADOTRAMITE='")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND tr444.EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_REGISTRO_DECISION).append("') ");
		subquery.append(
				"        AND NVL(tr22.EHHORA, 0) > (SELECT NVL(MAX(tr555.EHHORA), 0) FROM TRAMITE_HECHO tr555 WHERE tr555.EHFECHA = tr22.EHFECHA AND tr555.EHCOHD = tr22.EHCOHD AND tr555.EHESTADOTRAMITE='")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND tr555.EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_REGISTRO_DECISION).append("') ");
		subquery.append("        ) ");
		subquery.append("     ) ");
		subquery.append("   ) ");
		subquery.append(") ");
		return subquery.toString();
	}

	private String construyeCondicionesBandejaSolicitudesENYPDPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" , HECHO_DENUNCIADO ");
		query.append(" HECHO_DENUNCIADO ");

		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HDCODIGO = ").append("HECHO_DENUNCIADO")
				.append(".HDCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HDCOMO  = '")
				.append(censoMonitor.getMocodigo()).append("'");
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAINICIO IS NOT NULL");

		query.append(" AND ((").append(aliasTablaTramiteHecho).append(".EHFECHAFIN    IS NOT NULL");

		if (conAsignacionResp) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR).append("'");
			query.append(" ))");

			query.append(
					" OR ((SELECT COUNT(*) FROM TRAMITE_HECHO TRAMITEHECHO1 WHERE TRAMITEHECHO1.EHCOHD = HECHO_DENUNCIADO.HDCODIGO AND TRAMITEHECHO1.EHFECHAFIN IS NOT NULL AND TRAMITEHECHO1.EHCOMOEJECUCION = '")
					.append(censoMonitor.getMocodigo()).append("') = 0)");
		} else {
			query.append(" ) ");
		}

		if (conStandBy) {
			query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHFECHAFIN    IS NOT NULL").append(" AND ")
					.append("HECHO_DENUNCIADO").append(".TRPOSIBLECODIGO <> '")
					.append(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR).append("')");
		}

		query.append(" ) ");

		if (!(conAsignacionResp)) {
			query.append(" AND ").append("HECHO_DENUNCIADO").append(".TRPOSIBLECODIGO <> '")
					.append(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR).append("'");
		}

		// RESTO DE FILTROS....
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(bandejaSolicitudes.getTrcodigo()).append("'");
			query.append(" OR ").append("HECHO_DENUNCIADO").append(".TRPOSIBLECODIGO='")
					.append(bandejaSolicitudes.getTrcodigo()).append("' )");
		}

		if (Y41bConstantes.VALOR_SI.equals(excluirAcuses)) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE!='")
					.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesENYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses, Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesENYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesENYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesENYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses));

		return this.jdbcTemplate.queryForLong(query.toString());
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja expedientes con trmites pendientes
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesECTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta) {

		StringBuilder query = new StringBuilder();

		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesECTPPropias("t1", "t1_2", "t7_2", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta));
		// original
		// query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX
		// (t1_3.FECHATRAMITE) ");
		query.append(" AND t7_2.EHFECHAINICIO = ( SELECT MAX (t7_3.EHFECHAINICIO) ");
		// alternativa por si fechas requieren transformacion al comparara
		// query.append(" AND to_timestamp(to_char(t7_2.EHFECHAINICIO,
		// 'dd/mm/yyyy HH:MM')) = to_timestamp(to_char(( SELECT MIN
		// (t7_3.EHFECHAINICIO) ");
		query.append(construyeCondicionesBandejaSolicitudesECTPPropias("t1_2", "t1_3", "t7_3", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta));
		query.append(" ) )");
		// query.append(" ) , 'dd/mm/yyyy HH:MM')) )");

		// Aplicar el filtro de tramite pendiente dentro del expediente
		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND t1.HDCODIGO = ( ");
			query.append(
					" SELECT MAX(HDCODIGO) FROM BANDEJA_SOLICITUDES BS WHERE t1.HDCODIGO = BS.HDCODIGO AND BS.TRCODIGOACTUAL='");
			query.append(bandejaSolicitudes.getTrcodigo());
			query.append("')");
		}

		return query;
	}

	private String construyeCondicionesBandejaSolicitudesECTPPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".ESTADOTRAMITE != '")
				.append(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA).append("'");
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAFIN    IS NULL");
		query.append(" AND (");
		query.append("       ( ").append(aliasTablaBandejaSolicitudes).append(".HDCOMO  = '")
				.append(censoMonitor.getMocodigo()).append("'");

		query.append("         AND (");
		query.append("	             (");
		query.append("		                ").append(aliasTablaTramiteHecho).append(".EHCOTEE        != '")
				.append(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD).append("'");
		query.append("					AND ").append(aliasTablaTramiteHecho).append(".EHCOTEE        != '")
				.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("'");
		query.append("					AND ").append(aliasTablaTramiteHecho).append(".EHCOTEE        != '")
				.append(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA).append("'");
		query.append("					AND ").append(aliasTablaTramiteHecho).append(".EHCOTEE        != '")
				.append(Y41bConstantes.TRAMITE_BOPV_AYTO).append("'");
		query.append("				 )");
		query.append("               OR");
		query.append("				 (");
		query.append("					   (").append(aliasTablaTramiteHecho).append(".EHCOTEE     = '")
				.append(Y41bConstantes.TRAMITE_COMUNICACION).append("'        AND ").append(aliasTablaTramiteHecho)
				.append(".EHCOMOASIGNADO ='").append(censoMonitor.getMocodigo()).append("')");
		query.append("					OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE     = '")
				.append(Y41bConstantes.TRAMITE_NOTIFICACION).append("'        AND ").append(aliasTablaTramiteHecho)
				.append(".EHCOMOASIGNADO ='").append(censoMonitor.getMocodigo()).append("')");
		query.append("				 )");
		query.append("			   )");
		query.append("	     )");

		if (censoMonitor != null && censoMonitor.getPerfilSolicitudes() != null
				&& censoMonitor.getPerfilSolicitudes().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			query.append("   OR");
			query.append("   (");
			query.append("	   ").append(aliasTablaBandejaSolicitudes).append(".HCCOOR = '")
					.append(censoMonitor.getOrganismo().getCodOrg()).append("'");
			query.append("	   AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
					.append(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR).append("' OR ").append(aliasTablaTramiteHecho)
					.append(".EHCOTEE        = '").append(Y41bConstantes.TRAMITE_RECEPCION_TRASLADO).append("')");
			query.append("   )");
		}
		query.append("     )");

		// RESTO DE FILTROS....
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(bandejaSolicitudes.getTrcodigo()).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesECTP(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesECTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesECTP(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta));

		return this.jdbcTemplate.queryForLong(query.toString());
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja expedientes con trmites pendientes (OTROS)
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesECTPO(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesECTPOPropias("t1", "t1_2", "t7_2", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX (t1_3.FECHATRAMITE) ");
		query.append(construyeCondicionesBandejaSolicitudesECTPOPropias("t1_2", "t1_3", "t7_3", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" ) )");

		// Aplicar el filtro de tramite pendiente dentro del expediente
		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND t1.HDCODIGO = ( ");
			query.append(
					" SELECT MAX(HDCODIGO) FROM BANDEJA_SOLICITUDES BS WHERE t1.HDCODIGO = BS.HDCODIGO AND BS.TRCODIGOACTUAL='");
			query.append(bandejaSolicitudes.getTrcodigo());
			query.append("')");
		}

		return query;
	}

	private String construyeCondicionesBandejaSolicitudesECTPOPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HDCOMO  = '")
				.append(censoMonitor.getMocodigo()).append("'");
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAFIN IS NULL");
		query.append(" AND ( ");
		query.append(" 		").append(aliasTablaBandejaSolicitudes).append(".ESTADOTRAMITE = '")
				.append(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA).append("'");
		query.append(" OR ").append(aliasTablaTramiteHecho).append(".EHCOTEE = '")
				.append(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD).append("'");
		query.append(" OR ").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
				.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("'");
		query.append(" OR ").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
				.append(Y41bConstantes.TRAMITE_ELABORACION_BOPV_AYUNTA).append("'");
		query.append(" OR ").append(aliasTablaTramiteHecho).append(".EHCOTEE        = '")
				.append(Y41bConstantes.TRAMITE_BOPV_AYTO).append("'");
		query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE       = '")
				.append(Y41bConstantes.TRAMITE_COMUNICACION).append("' AND ").append(aliasTablaTramiteHecho)
				.append(".EHCOMOASIGNADO !='").append(censoMonitor.getMocodigo()).append("')");
		query.append(" OR (").append(aliasTablaTramiteHecho).append(".EHCOTEE       = '")
				.append(Y41bConstantes.TRAMITE_NOTIFICACION).append("' AND ").append(aliasTablaTramiteHecho)
				.append(".EHCOMOASIGNADO !='").append(censoMonitor.getMocodigo()).append("')");
		query.append(" 	)");

		// RESTO DE FILTROS....
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(bandejaSolicitudes.getTrcodigo()).append("' )");
		}

		if (Y41bConstantes.VALOR_SI.equals(excluirAcuses)) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE!='")
					.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTPO(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesECTPO(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesECTPOCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesECTPO(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		return this.jdbcTemplate.queryForLong(query.toString());
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja estado oficina: nuevos y pendientes decisin
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(construyeCondicionEspecialDecision());
		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesEONYPDPropias("t1", "t1_2", "t7_2", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, excluirAcuses));
		query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX (t1_3.FECHATRAMITE) ");
		query.append(construyeCondicionesBandejaSolicitudesEONYPDPropias("t1_2", "t1_3", "t7_3", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, conAsignacionResp, excluirAcuses));
		query.append(" ) )");

		// Aplicar el filtro de tramite pendiente dentro del expediente
		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND t1.HDCODIGO = ( ");
			query.append(
					" SELECT MAX(BS.HDCODIGO) FROM BANDEJA_SOLICITUDES BS, HECHO_DENUNCIADO HD WHERE t1.HDCODIGO = BS.HDCODIGO AND BS.HDCODIGO=HD.HDCODIGO AND (BS.TRCODIGOACTUAL='");
			query.append(bandejaSolicitudes.getTrcodigo());
			query.append("' )");
			query.append(")");
		}

		return query;
	}

	private String construyeCondicionesBandejaSolicitudesEONYPDPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" , HECHO_DENUNCIADO ");
		query.append(" HECHO_DENUNCIADO ");

		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HDCODIGO = ").append("HECHO_DENUNCIADO")
				.append(".HDCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAINICIO IS NOT NULL");
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAFIN IS NOT NULL");
		if (!(conAsignacionResp)) {
			query.append(" AND ").append("HECHO_DENUNCIADO").append(".TRPOSIBLECODIGO <> '")
					.append(Y41bConstantes.TRAMITE_ASIGNACION_INSTRUCTOR).append("'");
		}

		// RESTO DE FILTROS....
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HCCOOR = '")
				.append(bandejaSolicitudes.getHccoor()).append("'");
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(bandejaSolicitudes.getTrcodigo()).append("'");
			query.append(" )");
		}

		if (bandejaSolicitudes.getHdcomo() != null) {
			query.append(" AND (").append(aliasTablaBandejaSolicitudes).append(".HDCOMO='")
					.append(bandejaSolicitudes.getHdcomo()).append("' )");
		}

		if (Y41bConstantes.VALOR_SI.equals(excluirAcuses)) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE!='")
					.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses, Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesEONYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, excluirAcuses));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesEONYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesEONYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, excluirAcuses));

		return this.jdbcTemplate.queryForLong(query.toString());
	}

	/*
	 * *****************************************************************
	 * 
	 * Bandeja estado oficina: con trmites pendientes
	 * 
	 * *****************************************************************
	 */
	private StringBuilder construyeCondicionesBandejaSolicitudesEOCTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" AND t1.EHCODIGO =  (SELECT MIN(t1_2.EHCODIGO) ");
		query.append(construyeCondicionesBandejaSolicitudesEOCTPPropias("t1", "t1_2", "t7_2", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" AND t1_2.FECHATRAMITE = ( SELECT MAX(t1_3.FECHATRAMITE) ");
		query.append(construyeCondicionesBandejaSolicitudesEOCTPPropias("t1_2", "t1_3", "t7_3", bandejaSolicitudes,
				censoMonitor, trFechaDesde, trFechaHasta, excluirAcuses));
		query.append(" ) )");

		// Aplicar el filtro de tramite pendiente dentro del expediente
		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND t1.HDCODIGO = ( ");
			query.append(
					" SELECT MAX(HDCODIGO) FROM BANDEJA_SOLICITUDES BS WHERE t1.HDCODIGO = BS.HDCODIGO AND BS.TRCODIGOACTUAL='");
			query.append(bandejaSolicitudes.getTrcodigo());
			query.append("')");
		}

		return query;
	}

	private String construyeCondicionesBandejaSolicitudesEOCTPPropias(String aliasTablaBandejaAnterior,
			String aliasTablaBandejaSolicitudes, String aliasTablaTramiteHecho, BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder();

		query.append(" FROM BANDEJA_SOLICITUDES ");
		query.append(aliasTablaBandejaSolicitudes);
		query.append(" , TRAMITE_HECHO ");
		query.append(aliasTablaTramiteHecho);
		query.append(" WHERE ").append(aliasTablaBandejaAnterior).append(".HDCODIGO = ")
				.append(aliasTablaBandejaSolicitudes).append(".HDCODIGO");
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".EHCODIGO = ").append(aliasTablaTramiteHecho)
				.append(".EHCODIGO");

		// Condiciones propias
		query.append(" AND ").append(aliasTablaTramiteHecho).append(".EHFECHAFIN IS NULL");

		// RESTO DE FILTROS....
		query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".HCCOOR = '")
				.append(bandejaSolicitudes.getHccoor()).append("'");
		if (trFechaDesde != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE>= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (trFechaHasta != null) {
			query.append(" AND ").append(aliasTablaBandejaSolicitudes).append(".FECHATRAMITE<= to_date ('")
					.append(Y41bUtils.parseDateToString(trFechaHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (bandejaSolicitudes.getTrcodigo() != null) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE='")
					.append(bandejaSolicitudes.getTrcodigo()).append("' )");
		}

		if (bandejaSolicitudes.getHdcomo() != null) {
			query.append(" AND (").append(aliasTablaBandejaSolicitudes).append(".HDCOMO='")
					.append(bandejaSolicitudes.getHdcomo()).append("' )");
		}

		if (Y41bConstantes.VALOR_SI.equals(excluirAcuses)) {
			query.append(" AND (").append(aliasTablaTramiteHecho).append(".EHCOTEE!='")
					.append(Y41bConstantes.TRAMITE_ACUSE_RECIBO).append("' )");
		}

		return query.toString();
	}

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEOCTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination) {

		StringBuilder query = new StringBuilder();
		construyeSelectBandejas(query);
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesEOCTP(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaSolicitudesBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaSolicitudesBusqueda>() {
					public BandejaSolicitudesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaSolicitudesBusqueda(resultSet.getString("EHCODIGO"),
								resultSet.getString("HDCODIGO"), resultSet.getString("RECLAMANTE"),
								resultSet.getString("RECLAMADO"), resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), null, resultSet.getString("num_pdtes"),
								resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
								resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCOSC"),
								resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
								resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
								resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("HCCOOR"), resultSet.getString("Q5ORIGEN"),
								resultSet.getString("Q5NOFILE"), resultSet.getDate("FECHATRAMITE"),
								resultSet.getString("IDDESTINATARIO"), resultSet.getString("NOMBRE"),
								resultSet.getString("NIF"), resultSet.getString("ESTADOTRAMITE"),
								resultSet.getDate("FECHALIMITE"), resultSet.getString("INDAVISO"),
								resultSet.getString("TIPOAVISO"), resultSet.getDate("EHFECHAENVIOBOPVBOE"),
								resultSet.getString("EHACUSERECIBORECIBIDO"),
								resultSet.getString("ENVCDESSITCORREOSES"), resultSet.getString("ENVCDESSITCORREOSEU"),
								resultSet.getString("EHISTELEMATICO"), resultSet.getString("EHISWEBSINCERTIFICADO"));
					}
				});
	}

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaSolicitudesEOCTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		construyeFromBandejas(query);
		query.append(construyeCondicionesBandejaSolicitudesEOCTP(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		return this.jdbcTemplate.queryForLong(query.toString());
	}
}
