package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteHechoModal;

/**
 * BandejaSolicitudesDao  
 * 
 *  
 */

public interface BandejaSolicitudesDao {

	/**
	 * Inserts a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes add(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes update(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes updateFechaLimite(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Finds a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes find(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Deletes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return
	 */
	void remove(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Removes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            Pagination
	 * @return
	 */
	public void removeAllTramitesExpediente(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BandejaSolicitudes> findAll(BandejaSolicitudes bandejasolicitudes, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	Long findAllCount(BandejaSolicitudes bandejasolicitudes);

	/**
	 * Finds rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaSolicitudes> findAllLike(BandejaSolicitudes bandejasolicitudes, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejasolicitudes
	 *            BandejaSolicitudes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaSolicitudes bandejasolicitudes, Boolean startsWith);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudes> findAllTramitesPendientesSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination);

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	public Long findAllTramitesPendientesSolicitudesCount(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoModal> findAllTramitesPendientesSolicitudesBandejas(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination);

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	public Long findAllTramitesPendientesSolicitudesBandejasCount(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudes> findAllTramitesFinalizadosSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination);

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	public Long findAllTramitesFinalizadosSolicitudesCount(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesAdministrativo(
			BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta,
			String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesAdministrativoCount(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesENYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesENYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Pagination pagination);

	/**
	 * 
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTPO(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPOCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEONYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses);

	/**
	 * Finds a List of rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEOCTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination);

	/**
	 * Counts rows in the bandeja solicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEOCTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

}
