package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteInspeccionDetalle;

/**
 * BandejaInspeccionesDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class BandejaInspeccionesDaoImpl implements BandejaInspeccionesDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaInspecciones> rwMap = new RowMapper<BandejaInspecciones>() {
		public BandejaInspecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new BandejaInspecciones(resultSet.getString("TICODIGO"), resultSet.getString("ATCODIGO"),
					resultSet.getString("ACCODIGO"), resultSet.getString("ORIGEN"), resultSet.getString("IDORIGEN"),
					resultSet.getString("EXPEDIENTEORIGEN"), resultSet.getString("ACCOOR"),
					resultSet.getString("ACNROR"), resultSet.getBigDecimal("ACNRAN"), resultSet.getBigDecimal("ATNROR"),
					resultSet.getString("ACCOMO"), resultSet.getString("MONOMBRE"), resultSet.getString("ADCOOR"),
					resultSet.getString("FCODIGOACTUAL"), resultSet.getString("FNOMBRE"),
					resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGOACTUAL"),
					resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
					resultSet.getString("Q5CODOCUMENTO"), resultSet.getString("Q5ORIGEN"),
					resultSet.getString("Q5NOFILE"), resultSet.getString("VARIOSDOCUMENTOS"),
					resultSet.getDate("FECHATRAMITE"), resultSet.getString("ESTVISITADO"),
					resultSet.getString("ESNOCO"), resultSet.getString("ESMUNICIPIO"),
					resultSet.getString("ESTADOTRAMITE"), resultSet.getDate("FECHALIMITE"),
					resultSet.getBigDecimal("TRAMITESPENDIENTES"), resultSet.getString("TIISTELEMATICO"),
					resultSet.getString("ATTIPO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            Pagination
	 * @return BandejaInspecciones
	 */
	public BandejaInspecciones add(BandejaInspecciones bandejainspecciones) {
		String query = "INSERT INTO BANDEJA_INSPECCIONES (TICODIGO, ATCODIGO, ORIGEN, IDORIGEN, ACCOOR, ACNROR, ACNRAN, ATNROR, ACCOMO, ADCOOR, FCODIGOACTUAL, TRCODIGOACTUAL, Q5CODOCUMENTO, Q5ORIGEN, Q5NOFILE, VARIOSDOCUMENTOS, FECHATRAMITE, ESTVISITADO, ESTADOTRAMITE, FECHALIMITE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, bandejainspecciones.getTicodigo(), bandejainspecciones.getAtcodigo(),
				bandejainspecciones.getOrigen(), bandejainspecciones.getIdorigen(), bandejainspecciones.getAccoor(),
				bandejainspecciones.getAcnror(), bandejainspecciones.getAcnran(), bandejainspecciones.getAtnror(),
				bandejainspecciones.getAccomo(), bandejainspecciones.getAdcoor(),
				bandejainspecciones.getFcodigoactual(), bandejainspecciones.getTrcodigoactual(),
				bandejainspecciones.getQ5codocumento(), bandejainspecciones.getQ5origen(),
				bandejainspecciones.getQ5nofile(), bandejainspecciones.getVariosDocumentos(),
				bandejainspecciones.getFechatramite(), bandejainspecciones.getEstvisitado(),
				bandejainspecciones.getEstadotramite(), bandejainspecciones.getFechalimite());
		return bandejainspecciones;
	}

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            Pagination
	 * @return BandejaInspecciones
	 */
	public BandejaInspecciones update(BandejaInspecciones bandejainspecciones) {
		String query = "UPDATE BANDEJA_INSPECCIONES SET  WHERE TICODIGO=? AND ATCODIGO=? AND ORIGEN=? AND IDORIGEN=? AND ACCOOR=? AND ACNROR=? AND ACNRAN=? AND ATNROR=? AND ACCOMO=? AND ADCOOR=? AND FCODIGOACTUAL=? AND TRCODIGOACTUAL=? AND Q5CODOCUMENTO=? AND Q5ORIGEN=? AND Q5NOFILE=? AND VARIOSDOCUMENTOS=? AND FECHATRAMITE=? AND ESTVISITADO=? AND ESTADOTRAMITE=? AND FECHALIMITE=?";
		this.jdbcTemplate.update(query, bandejainspecciones.getTicodigo(), bandejainspecciones.getAtcodigo(),
				bandejainspecciones.getOrigen(), bandejainspecciones.getIdorigen(), bandejainspecciones.getAccoor(),
				bandejainspecciones.getAcnror(), bandejainspecciones.getAcnran(), bandejainspecciones.getAtnror(),
				bandejainspecciones.getAccomo(), bandejainspecciones.getAdcoor(),
				bandejainspecciones.getFcodigoactual(), bandejainspecciones.getTrcodigoactual(),
				bandejainspecciones.getQ5codocumento(), bandejainspecciones.getQ5origen(),
				bandejainspecciones.getQ5nofile(), bandejainspecciones.getVariosDocumentos(),
				bandejainspecciones.getFechatramite(), bandejainspecciones.getEstvisitado(),
				bandejainspecciones.getEstadotramite(), bandejainspecciones.getFechalimite());
		return bandejainspecciones;
	}

	/**
	 * Finds a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            Pagination
	 * @return BandejaInspecciones
	 */
	@Transactional(readOnly = true)
	public BandejaInspecciones find(BandejaInspecciones bandejainspecciones) {
		String query = "SELECT t1.TICODIGO TICODIGO, t1.ATCODIGO ATCODIGO, t7.TIISTELEMATICO  TIISTELEMATICO, t6.ATCOAC ACCODIGO, t6.ATTIPO ATTIPO, t1.ORIGEN ORIGEN, t1.IDORIGEN IDORIGEN, (CASE WHEN t1.ORIGEN = 'C' THEN t1.IDORIGEN WHEN t1.ORIGEN = 'A' THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t1.IDORIGEN = t1a.ALCODIGO) WHEN t1.ORIGEN = 'S' THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t1.IDORIGEN = t2a.IDCOMUNICACIONSOIVRE) WHEN t1.ORIGEN = 'D' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t1.ORIGEN = 'E' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) EXPEDIENTEORIGEN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ATNROR ATNROR, t1.ACCOMO ACCOMO, t5.MONOMBRE MONOMBRE, t1.ADCOOR ADCOOR, t1.FCODIGOACTUAL FCODIGOACTUAL, t3.FNOMBRE FNOMBRE, t3.FNOMBREE FNOMBREE, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t2.TRNOMBRE TRNOMBRE, t2.TRNOMBREE TRNOMBREE, t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.VARIOSDOCUMENTOS VARIOSDOCUMENTOS, t1.FECHATRAMITE FECHATRAMITE, t1.ESTVISITADO ESTVISITADO, t4.ESNOCO ESNOCO, t4.NOMBRE_MUNICIPIO ESMUNICIPIO, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, (SELECT COUNT(1) FROM TRAMITE_INSPECCION t4a WHERE t4a.TIATCODIGO = t1.ATCODIGO AND t4a.TIESTADOTRAMITE <> 'T') TRAMITESPENDIENTES FROM BANDEJA_INSPECCIONES t1, TRAMITE t2, FASE t3, INTERVINIENTES t4, CENSO_MONITOR t5, ACTUACION t6, TRAMITE_INSPECCION t7 WHERE t1.TICODIGO=t7.TICODIGO AND t1.TRCODIGOACTUAL = t2.TRCODIGO AND t1.FCODIGOACTUAL = t3.FCODIGO AND t1.ESTVISITADO = t4.ESCODIGO(+) AND t1.ATCODIGO = t4.HDCODIGO(+) AND (t4.TIPO_INTERVINIENTE = 'V' OR t4.TIPO_INTERVINIENTE IS NULL) AND t1.ACCOMO = t5.MOCODIGO AND t1.ATCODIGO = t6.ATCODIGO AND T1.TICODIGO = ?";

		List<BandejaInspecciones> bandejainspeccionesList = this.jdbcTemplate.query(query, this.rwMap,
				bandejainspecciones.getTicodigo());
		return (BandejaInspecciones) DataAccessUtils.uniqueResult(bandejainspeccionesList);
	}

	/**
	 * Removes a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaInspecciones bandejainspecciones) {
		String query = "DELETE FROM BANDEJA_INSPECCIONES WHERE ATCODIGO=?";
		this.jdbcTemplate.update(query, bandejainspecciones.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaInspecciones> findAll(BandejaInspecciones bandejainspecciones, Pagination pagination,
			CensoMonitor censoMonitor, BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {
		StringBuffer query = new StringBuffer(
				"SELECT t1.TICODIGO TICODIGO, t1.ATCODIGO ATCODIGO, t7.TIISTELEMATICO  TIISTELEMATICO, t6.ATCOAC ACCODIGO, t6.ATTIPO ATTIPO, t1.ORIGEN ORIGEN, t1.IDORIGEN IDORIGEN, (CASE WHEN t1.ORIGEN = 'C' THEN t1.IDORIGEN WHEN t1.ORIGEN = 'A' THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t1.IDORIGEN = t1a.ALCODIGO) WHEN t1.ORIGEN = 'S' THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t1.IDORIGEN = t2a.IDCOMUNICACIONSOIVRE) WHEN t1.ORIGEN = 'D' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t1.ORIGEN = 'E' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) EXPEDIENTEORIGEN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ATNROR ATNROR, t1.ACCOMO ACCOMO, t5.MONOMBRE MONOMBRE, t1.ADCOOR ADCOOR, t1.FCODIGOACTUAL FCODIGOACTUAL, t3.FNOMBRE FNOMBRE, t3.FNOMBREE FNOMBREE, t1.TRCODIGOACTUAL TRCODIGOACTUAL, DECODE(t1.TRCODIGOACTUAL, 'IN25',t7.TINOMBRETRAMITE,t2.TRNOMBRE) TRNOMBRE , DECODE(t1.TRCODIGOACTUAL, 'IN25',t7.TINOMBRETRAMITE,t2.TRNOMBRE) TRNOMBREE, t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.VARIOSDOCUMENTOS VARIOSDOCUMENTOS, t1.FECHATRAMITE FECHATRAMITE, t1.ESTVISITADO ESTVISITADO, t4.ESNOCO ESNOCO, t4.NOMBRE_MUNICIPIO ESMUNICIPIO, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, (SELECT COUNT(1) FROM TRAMITE_INSPECCION t4a WHERE t4a.TIATCODIGO = t1.ATCODIGO AND t4a.TIESTADOTRAMITE <> 'T') TRAMITESPENDIENTES ");
		query.append(
				"FROM BANDEJA_INSPECCIONES t1, TRAMITE t2, FASE t3, INTERVINIENTES t4, CENSO_MONITOR t5, ACTUACION t6, TRAMITE_INSPECCION t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejainspecciones, bandejaInspeccionesFiltro, censoMonitor);
		StringBuffer where = new StringBuffer(
				"WHERE t1.TRCODIGOACTUAL = t2.TRCODIGO AND t1.FCODIGOACTUAL = t3.FCODIGO AND t1.ESTVISITADO = t4.ESCODIGO(+) AND t4.TIPO_INTERVINIENTE(+) = 'V' AND t1.ATCODIGO = t4.HDCODIGO(+) AND t1.ACCOMO = t5.MOCODIGO(+) AND t1.ATCODIGO = t6.ATCODIGO AND t1.TICODIGO=t7.TICODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSidx() != null) {
				order.append(" ORDER BY " + pagination.getSidx() + " " + pagination.getSord());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<BandejaInspecciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaInspecciones bandejainspecciones, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_INSPECCIONES t1, TRAMITE t2, FASE t3, INTERVINIENTES t4, CENSO_MONITOR t5, ACTUACION t6, TRAMITE_INSPECCION t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejainspecciones, bandejaInspeccionesFiltro, censoMonitor);
		StringBuilder where = new StringBuilder(
				"WHERE t1.TRCODIGOACTUAL = t2.TRCODIGO AND t1.FCODIGOACTUAL = t3.FCODIGO AND t1.ESTVISITADO = t4.ESCODIGO(+) AND t4.TIPO_INTERVINIENTE(+) = 'V' AND t1.ATCODIGO = t4.HDCODIGO(+) AND t1.ACCOMO = t5.MOCODIGO(+) AND t1.ATCODIGO = t6.ATCODIGO AND t1.TICODIGO=t7.TICODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaInspecciones> findAllLike(BandejaInspecciones bandejainspecciones, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.TICODIGO TICODIGO, t1.ATCODIGO ATCODIGO, t6.TIISTELEMATICO  TIISTELEMATICO, t6.ATCOAC ACCODIGO, null ATTIPO, t1.ORIGEN ORIGEN, t1.IDORIGEN IDORIGEN, (CASE WHEN t1.ORIGEN = 'C' THEN t1.IDORIGEN WHEN t1.ORIGEN = 'A' THEN (SELECT ALNROR || '-' || ALNRAN FROM ALERTA t1a WHERE t1.IDORIGEN = t1a.ALCODIGO) WHEN t1.ORIGEN = 'S' THEN (SELECT V6CODIGO FROM COMUNICACION_SOIVRE t2a WHERE t1.IDORIGEN = t2a.IDCOMUNICACIONSOIVRE) WHEN t1.ORIGEN = 'D' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) WHEN t1.ORIGEN = 'E' THEN (SELECT t3b.DECOOR || '-' || t3b.DENROR || '-' || t3b.DENRAN || '-' || t3a.HDNROR FROM HECHO_DENUNCIADO t3a, DENUNCIA t3b WHERE t1.IDORIGEN = HDCODIGO AND t3a.HDCODE = t3b.DECODIGO) ELSE null END) EXPEDIENTEORIGEN, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ATNROR ATNROR, t1.ACCOMO ACCOMO, t5.MONOMBRE MONOMBRE, t1.ADCOOR ADCOOR, t1.FCODIGOACTUAL FCODIGOACTUAL, t3.FNOMBRE FNOMBRE, t3.FNOMBREE FNOMBREE, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t2.TRNOMBRE TRNOMBRE, t2.TRNOMBREE TRNOMBREE, t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.VARIOSDOCUMENTOS VARIOSDOCUMENTOS, t1.FECHATRAMITE FECHATRAMITE, t1.ESTVISITADO ESTVISITADO, t4.ESNOCO ESNOCO, t4.NOMBRE_MUNICIPIO ESMUNICIPIO, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, (SELECT COUNT(1) FROM TRAMITE_INSPECCION t4a WHERE t4a.TIATCODIGO = t1.ATCODIGO AND t4a.TIESTADOTRAMITE <> 'T') TRAMITESPENDIENTES ");
		query.append(
				"FROM BANDEJA_INSPECCIONES t1, TRAMITE t2, FASE t3, INTERVINIENTES t4, CENSO_MONITOR t5, TRAMITE_INSPECCION t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejainspecciones, startsWith);
		StringBuilder where = new StringBuilder(
				"WHERE t1.TICODIGO=t6.TICODIGO AND t1.TRCODIGOACTUAL = t2.TRCODIGO AND t1.ESTVISITADO = t4.ESCODIGO AND t1.ATCODIGO = t4.HDCODIGO AND t4.TIPO_INTERVINIENTE = 'V' AND t1.ESTVISITADO = t4.IDINTERVINIENTE AND t1.ACCOMO = t5.MOCODIGO AND t1.ATCODIGO = t6.ATCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaInspecciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaInspecciones bandejainspecciones, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_INSPECCIONES t1, TRAMITE t2, FASE t3, INTERVINIENTES t4, CENSO_MONITOR t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejainspecciones, startsWith);
		StringBuilder where = new StringBuilder(
				"WHERE t1.TRCODIGOACTUAL = t2.TRCODIGO AND t1.FCODIGOACTUAL = t3.FCODIGO AND t1.ESTVISITADO = t4.ESCODIGO(+) AND t1.ATCODIGO = t4.HDCODIGO(+) AND (t4.TIPO_INTERVINIENTE = 'V' OR t4.TIPO_INTERVINIENTE IS NULL) AND t1.ACCOMO = t5.MOCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TramiteInspeccionDetalle> findAllTramitesPendientes(BandejaInspecciones bandejainspecciones,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.TICODIGO TICODIGO, t1.TIATCODIGO TIATCODIGO, t1.TICOTEE TICOTEE, t8.TIISTELEMATICO TIISTELEMATICO, t3.TRCODIGO TRCODIGO, DECODE(t3.TRCODIGO, 'IN25',t1.TINOMBRETRAMITE,t3.TRNOMBRE) TRNOMBRE , DECODE(t3.TRCODIGO, 'IN25',t1.TINOMBRETRAMITE,t3.TRNOMBRE) TRNOMBREE, t1.TICOMOASIGNADO TICOMOASIGNADO, t5.MONOMBRE MONOMBRE, t1.TIFECHAINICIO TIFECHAINICIO, t1.TIFECHALIMITE TIFECHALIMITE, t1.TIESTADOTRAMITE TIESTADOTRAMITE, t2.TICODIGO ORIGENTICODIGO, t2.TICOTEE ORIGENTICOTEE, t4.TRNOMBRE ORIGENTRNOMBRE, t4.TRNOMBREE ORIGENTRNOMBREE, t1.TIORIGENALEGACION TIORIGENALEGACION, t6.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.TIIDDESTINATARIO TIIDDESTINATARIO, t6.ESNOCO ESNOCO, t1.TIACUSERECIBORECIBIDO TIACUSERECIBORECIBIDO, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, t2.TIFECHAFIN ORIGENTIFECHAFIN ");
		query.append(
				"FROM TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, TRAMITE t3, TRAMITE t4, CENSO_MONITOR t5, INTERVINIENTES t6, ENVIOS_POR_REMESA t7, TRAMITE_INSPECCION t8 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				"WHERE t1.TICODIGO=t8.TICODIGO AND t1.TICODIGORELACIONADO = t2.TICODIGO(+) AND t1.TICOTEE = t3.TRCODIGO(+) AND t2.TICOTEE = t4.TRCODIGO(+) AND t1.TICOMOASIGNADO = t5.MOCODIGO(+) AND (t1.TIESTADOTRAMITE <> 'T' OR t1.TIESTADOTRAMITE IS NULL) AND t1.TICODIGO = t7.EHCODIGO(+) AND t1.TIIDDESTINATARIO = t6.IDINTERVINIENTE(+) AND t1.TIATCODIGO = ?");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TramiteInspeccionDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<TramiteInspeccionDetalle>() {
					public TramiteInspeccionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
						tramiteInspeccionDetalle.setTicodigo(resultSet.getString("TICODIGO"));
						tramiteInspeccionDetalle.setAtcodigo(resultSet.getString("TIATCODIGO"));
						tramiteInspeccionDetalle.setTicotee(resultSet.getString("TICOTEE"));
						tramiteInspeccionDetalle.setTrcodigo(resultSet.getString("TRCODIGO"));
						tramiteInspeccionDetalle.setTrnombre(resultSet.getString("TRNOMBRE"));
						tramiteInspeccionDetalle.setTrnombree(resultSet.getString("TRNOMBREE"));
						tramiteInspeccionDetalle.setMocodigo(resultSet.getString("TICOMOASIGNADO"));
						tramiteInspeccionDetalle.setMonombre(resultSet.getString("MONOMBRE"));
						tramiteInspeccionDetalle.setTifechainicio(resultSet.getTimestamp("TIFECHAINICIO"));
						tramiteInspeccionDetalle.setTifechalimite(resultSet.getTimestamp("TIFECHALIMITE"));
						tramiteInspeccionDetalle.setTiestadotramite(resultSet.getString("TIESTADOTRAMITE"));
						tramiteInspeccionDetalle.setTiorigenalegacion(resultSet.getString("TIORIGENALEGACION"));
						tramiteInspeccionDetalle.setTipoDestinatario(resultSet.getString("TIPOINTERVINIENTE"));
						tramiteInspeccionDetalle.setIdDestinatario(resultSet.getString("TIIDDESTINATARIO"));
						tramiteInspeccionDetalle.setNomDestinatario(resultSet.getString("ESNOCO"));
						tramiteInspeccionDetalle.setSituacionacuse(resultSet.getString("TIACUSERECIBORECIBIDO"));
						tramiteInspeccionDetalle.setTivcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
						tramiteInspeccionDetalle.setTivcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
						tramiteInspeccionDetalle.setTiistelematico(resultSet.getString("TIISTELEMATICO"));

						TramiteInspeccionDetalle tramiteInspeccionDetalleOrigen = new TramiteInspeccionDetalle();
						tramiteInspeccionDetalleOrigen.setTicodigo(resultSet.getString("ORIGENTICODIGO"));
						tramiteInspeccionDetalleOrigen.setTicotee(resultSet.getString("ORIGENTICOTEE"));
						tramiteInspeccionDetalleOrigen.setTrnombre(resultSet.getString("ORIGENTRNOMBRE"));
						tramiteInspeccionDetalleOrigen.setTrnombree(resultSet.getString("ORIGENTRNOMBREE"));
						tramiteInspeccionDetalleOrigen.setTifechafin(resultSet.getTimestamp("ORIGENTIFECHAFIN"));
						tramiteInspeccionDetalle.setTramiteInspeccionDetalle(tramiteInspeccionDetalleOrigen);

						return tramiteInspeccionDetalle;
					}
				}, bandejainspecciones.getAtcodigo());
	}

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesPendientesCount(BandejaInspecciones bandejainspecciones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_INSPECCION t1, TRAMITE_INSPECCION t2, TRAMITE t3, TRAMITE t4, CENSO_MONITOR t5, INTERVINIENTES t6, ENVIOS_POR_REMESA t7 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				"WHERE t1.TICODIGORELACIONADO = t2.TICODIGO(+) AND t1.TICOTEE = t3.TRCODIGO(+) AND t2.TICOTEE = t4.TRCODIGO(+) AND t1.TICOMOASIGNADO = t5.MOCODIGO(+) AND (t1.TIESTADOTRAMITE <> 'T' OR t1.TIESTADOTRAMITE IS NULL) AND t1.TICODIGO = t7.EHCODIGO(+) AND t1.TIIDDESTINATARIO = t6.IDINTERVINIENTE(+) AND t1.TIATCODIGO = ?");
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), bandejainspecciones.getAtcodigo());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaInspecciones entity
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones Bean with the criteria values to filter
	 *            by.
	 * @param bandejainspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaInspecciones bandejainspecciones,
			BandejaInspeccionesFiltro bandejainspeccionesFiltro, CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(BandejaInspeccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejainspecciones != null && bandejainspecciones.getTicodigo() != null) {
			where.append(" AND t1.TICODIGO = ?");
			params.add(bandejainspecciones.getTicodigo());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAtcodigo() != null) {
			where.append(" AND t1.ATCODIGO = ?");
			params.add(bandejainspecciones.getAtcodigo());
		}
		if (bandejainspecciones != null && bandejainspecciones.getOrigen() != null) {
			where.append(" AND t1.ORIGEN = ?");
			params.add(bandejainspecciones.getOrigen());
		}
		if (bandejainspecciones != null && bandejainspecciones.getIdorigen() != null) {
			where.append(" AND t1.IDORIGEN = ?");
			params.add(bandejainspecciones.getIdorigen());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAccoor() != null) {
			where.append(" AND t1.ACCOOR = ?");
			params.add(bandejainspecciones.getAccoor());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ?");
			params.add(bandejainspecciones.getAcnror());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(bandejainspecciones.getAcnran());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(bandejainspecciones.getAtnror());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAccomo() != null) {
			where.append(" AND t1.ACCOMO = ?");
			params.add(bandejainspecciones.getAccomo());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAdcoor() != null) {
			where.append(" AND t1.ADCOOR = ?");
			params.add(bandejainspecciones.getAdcoor());
		}
		if (bandejainspecciones != null && bandejainspecciones.getFcodigoactual() != null) {
			where.append(" AND t1.FCODIGOACTUAL = ?");
			params.add(bandejainspecciones.getFcodigoactual());
		}
		if (bandejainspecciones != null && bandejainspecciones.getTrcodigoactual() != null) {
			where.append(" AND t1.TRCODIGOACTUAL = ?");
			params.add(bandejainspecciones.getTrcodigoactual());
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO = ?");
			params.add(bandejainspecciones.getQ5codocumento());
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(bandejainspecciones.getQ5origen());
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(bandejainspecciones.getQ5nofile());
		}
		if (bandejainspecciones != null && bandejainspecciones.getVariosDocumentos() != null) {
			where.append(" AND t1.VARIOSDOCUMENTOS = ?");
			params.add(bandejainspecciones.getVariosDocumentos());
		}
		if (bandejainspecciones != null && bandejainspecciones.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(bandejainspecciones.getFechatramite());
		}
		if (bandejainspecciones != null && bandejainspecciones.getEstvisitado() != null) {
			where.append(" AND t1.ESTVISITADO = ?");
			params.add(bandejainspecciones.getEstvisitado());
		}
		if (bandejainspecciones != null && bandejainspecciones.getEstadotramite() != null) {
			where.append(" AND t1.ESTADOTRAMITE = ?");
			params.add(bandejainspecciones.getEstadotramite());
		}
		if (bandejainspecciones != null && bandejainspecciones.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(bandejainspecciones.getFechalimite());
		}

		// FILTRO
		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getMocodigoExpediente() != null) {
			where.append(" AND t1.ACCOMO = ?");
			params.add(bandejainspeccionesFiltro.getMocodigoExpediente());
		}

		if ((Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				|| Y41bConstantes.PERFIL_COORDINADOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				|| Y41bConstantes.PERFIL_TECNICO_CONTROL_MERCADO
						.equals(censoMonitor.getPerfilInspecciones().getIdPerfil()))
				&& Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
						.equals(censoMonitor.getPerfilOrganizacion().getIdPerfil())) {

			if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
				where.append(" AND (t1.ACCOMO = ?");
				params.add(censoMonitor.getMocodigo());
			} else {
				where.append(" AND (t1.ADCOOR = ?");
				params.add(censoMonitor.getOrganismo().getCodOrg());
			}

			where.append(
					" OR (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE IN(?,?) AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO AND t1.ORIGEN IN (?,?,?))>0 ");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_SOLICITUD);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_DENUNCIA);

			where.append(
					" OR (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE IN(?,?,?,?,?,?,?,?) AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO AND t1.ORIGEN IN (?,?,?,?,?))>0 ");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RESOLUCION_ACUERDO_INICIO_PROCEDIMIENTO);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_REVISION_INCLUSION_EN_RED_DE_ALERTA);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ESTABLECIMIENTO_RELACION_CON_RED_DE_ALERTA);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ELABORACION_INFORME_PARA_ASESORIA);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ORDEN_DEL_CONSEJERO);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES);
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_COMUNICAR_NUEVO_DISTRIBUIDOR);

			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA);

			where.append(
					" OR ((SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE IN(?) AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO AND t1.ORIGEN IN (?,?,?,?,?))>0 ");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ARCHIVO_AIP);

			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA);

			where.append(
					" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE = ? AND tt1.TIATCODIGO = t1.ATCODIGO AND t1.ORIGEN IN (?,?,?,?,?))>0 ))");
			params.add(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO);

			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES);
			params.add(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA);
		}

		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getCodOrg() != null) {
			where.append(" AND t1.ADCOOR = ?");
			params.add(bandejainspeccionesFiltro.getCodOrg());
		}

		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getAccoororigen() != null) {
			where.append(" AND t1.ORIGEN = ?");
			params.add(bandejainspeccionesFiltro.getAccoororigen());

			if ("C".equals(bandejainspeccionesFiltro.getAccoororigen())
					&& bandejainspeccionesFiltro.getAtcocm() != null) {
				where.append(" AND IDORIGEN IN (SELECT CMCODIGO FROM CAMPANHA t11 WHERE UPPER(t11.CMCODIGO) LIKE ?)");
				params.add("%" + bandejainspeccionesFiltro.getAtcocm().toUpperCase() + "%");
			}
			if ("A".equals(bandejainspeccionesFiltro.getAccoororigen()) && bandejainspeccionesFiltro.getAlnror() != null
					&& bandejainspeccionesFiltro.getAlnran() != null) {
				where.append(
						" AND IDORIGEN IN (SELECT ALCODIGO FROM ALERTA t12 WHERE UPPER(t12.ALNROR) LIKE ? AND UPPER(t12.ALNRAN) LIKE ?)");
				params.add("%" + bandejainspeccionesFiltro.getAlnror().toUpperCase() + "%");
				params.add("%" + bandejainspeccionesFiltro.getAlnran().toUpperCase() + "%");
			} else if ("A".equals(bandejainspeccionesFiltro.getAccoororigen())
					&& bandejainspeccionesFiltro.getAlnror() != null) {
				where.append(" AND IDORIGEN IN (SELECT ALCODIGO FROM ALERTA t12 WHERE UPPER(t12.ALNROR) LIKE ?)");
				params.add("%" + bandejainspeccionesFiltro.getAlnror().toUpperCase() + "%");
			} else if ("A".equals(bandejainspeccionesFiltro.getAccoororigen())
					&& bandejainspeccionesFiltro.getAlnran() != null) {
				where.append(" AND IDORIGEN IN (SELECT ALCODIGO FROM ALERTA t12 WHERE UPPER(t12.ALNRAN) LIKE ?)");
				params.add("%" + bandejainspeccionesFiltro.getAlnran().toUpperCase() + "%");
			}
			if ("S".equals(bandejainspeccionesFiltro.getAccoororigen())
					&& bandejainspeccionesFiltro.getV6codigo() != null) {
				where.append(
						" AND IDORIGEN IN (SELECT IDCOMUNICACIONSOIVRE FROM COMUNICACION_SOIVRE t13 WHERE UPPER(t13.V6CODIGO) LIKE ?)");
				params.add("%" + bandejainspeccionesFiltro.getV6codigo().toUpperCase() + "%");
			}
			if (("D".equals(bandejainspeccionesFiltro.getAccoororigen())
					|| "E".equals(bandejainspeccionesFiltro.getAccoororigen()))
					&& (bandejainspeccionesFiltro.getDecoor() != null || bandejainspeccionesFiltro.getDenror() != null
							|| bandejainspeccionesFiltro.getDenran() != null)) {
				where.append(
						" AND IDORIGEN IN (SELECT HDCODIGO FROM HECHO_DENUNCIADO t14, DENUNCIA t15 WHERE t14.HDCODE = t15.DECODIGO AND");
				List<String> strAuxList = new ArrayList<String>();
				if (bandejainspeccionesFiltro.getDecoor() != null) {
					strAuxList.add(" UPPER(t15.DECOOR) LIKE ? ");
					params.add("%" + bandejainspeccionesFiltro.getDecoor().toUpperCase() + "%");
				}
				if (bandejainspeccionesFiltro.getDenror() != null) {
					strAuxList.add(" UPPER(t15.DENROR) LIKE ? ");
					params.add("%" + bandejainspeccionesFiltro.getDenror().toUpperCase() + "%");
				}
				if (bandejainspeccionesFiltro.getDenran() != null) {
					strAuxList.add(" UPPER(t15.DENRAN) LIKE ? ");
					params.add("%" + bandejainspeccionesFiltro.getDenran().toUpperCase() + "%");
				}

				String[] strAuxArr = strAuxList.toArray(new String[strAuxList.size()]);
				where.append(StringUtils.join(strAuxArr, " AND "));
				where.append(")");
			}

			if ("O".equals(bandejainspeccionesFiltro.getAccoororigen())) {
				where.append(
						" AND IDORIGEN IS NULL AND t1.ATCODIGO = (SELECT ATCODIGO FROM ACTUACION t15, ACTA t16 WHERE t15.ATCOAC = t16.ACCODIGO AND t16.ACTIORORIGEN IS NULL AND t15.ATCODIGO = t1.ATCODIGO)");
			}
			if ("X".equals(bandejainspeccionesFiltro.getAccoororigen())) {
				where.append(
						" AND IDORIGEN IS NULL AND t1.ATCODIGO = (SELECT ATCODIGO FROM ACTUACION t15, ACTA t16 WHERE t15.ATCOAC = t16.ACCODIGO AND t16.ACTIORORIGEN = 'C' AND t15.ATCODIGO = t1.ATCODIGO)");
			}
			if ("N".equals(bandejainspeccionesFiltro.getAccoororigen())) {
				where.append(
						" AND IDORIGEN IS NULL AND t1.ATCODIGO = (SELECT ATCODIGO FROM ACTUACION t15, ACTA t16 WHERE t15.ATCOAC = t16.ACCODIGO AND t16.ACTIORORIGEN = 'N' AND t15.ATCODIGO = t1.ATCODIGO)");
			}
		}

		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getTrFechaDesde() != null) {

			if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getTrcodigo() != null) {
				where.append(
						" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE = ? AND tt1.TIFECHAINICIO >= ? AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO)>0 ");
				params.add(bandejainspeccionesFiltro.getTrcodigo());
				params.add(bandejainspeccionesFiltro.getTrFechaDesde());
			} else {
				where.append(
						" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TIFECHAINICIO >= ? AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO)>0 ");
				params.add(bandejainspeccionesFiltro.getTrFechaDesde());
			}
		}

		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getTrFechaHasta() != null) {
			if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getTrcodigo() != null) {
				where.append(
						" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE = ? AND tt1.TIFECHAINICIO <= ? AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO)>0 ");
				params.add(bandejainspeccionesFiltro.getTrcodigo());
				params.add(bandejainspeccionesFiltro.getTrFechaHasta());

			} else {
				where.append(
						" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TIFECHAINICIO <= ? AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO)>0 ");
				params.add(bandejainspeccionesFiltro.getTrFechaHasta());
			}
		}

		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getTrcodigo() != null) {
			where.append(
					" AND (SELECT COUNT(1) FROM TRAMITE_INSPECCION tt1 WHERE 1=1 AND tt1.TICOTEE = ? AND (tt1.TIESTADOTRAMITE <> 'T' OR tt1.TIESTADOTRAMITE IS NULL)  AND tt1.TIATCODIGO = t1.ATCODIGO)>0 ");
			params.add(bandejainspeccionesFiltro.getTrcodigo());
		}

		where.append(" AND ((t1.ORIGEN = ?");
		params.add(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);

		where.append(
				" AND IDORIGEN IN (SELECT CMCODIGO FROM CAMPANHA t11 WHERE t11.CMCODIGO=IDORIGEN AND t11.CMACTIVA = ? )) ");
		params.add(Y41bConstantes.VALOR_SI);

		where.append(" OR (t1.ORIGEN = ?");
		params.add(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);

		where.append(
				" AND IDORIGEN IN (SELECT ALCODIGO FROM ALERTA t12 WHERE t12.ALCODIGO=IDORIGEN AND t12.ALACTIVA = ?))");
		params.add(Y41bConstantes.VALOR_SI);

		where.append(" OR (t1.ORIGEN != ? AND t1.ORIGEN != ?))");
		params.add(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
		params.add(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);

		// tipo inspeccion
		if (bandejainspeccionesFiltro != null && bandejainspeccionesFiltro.getAttipo() != null) {
			where.append(" AND t6.ATTIPO = ?");
			params.add(bandejainspeccionesFiltro.getAttipo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaInspecciones entity
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaInspecciones bandejainspecciones, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BandejaInspeccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejainspecciones != null && bandejainspecciones.getTicodigo() != null) {
			where.append(" AND UPPER(t1.TICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getTicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getTicodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TICODIGO IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getAtcodigo() != null) {
			where.append(" AND UPPER(t1.ATCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getAtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getAtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCODIGO IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getOrigen() != null) {
			where.append(" AND UPPER(t1.ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getOrigen().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getOrigen().toUpperCase() + "%");
			}
			where.append(" AND t1.ORIGEN IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getIdorigen() != null) {
			where.append(" AND UPPER(t1.IDORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getIdorigen().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getIdorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.IDORIGEN IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getAccoor() != null) {
			where.append(" AND UPPER(t1.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getAccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOOR IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getAcnror() != null) {
			where.append(" AND t1.ACNROR = ?");
			params.add(bandejainspecciones.getAcnror());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAcnran() != null) {
			where.append(" AND t1.ACNRAN = ?");
			params.add(bandejainspecciones.getAcnran());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(bandejainspecciones.getAtnror());
		}
		if (bandejainspecciones != null && bandejainspecciones.getAccomo() != null) {
			where.append(" AND UPPER(t1.ACCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getAccomo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getAccomo().toUpperCase() + "%");
			}
			where.append(" AND t1.ACCOMO IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getAdcoor() != null) {
			where.append(" AND UPPER(t1.ADCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getAdcoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getAdcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ADCOOR IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getFcodigoactual() != null) {
			where.append(" AND UPPER(t1.FCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getFcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getFcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.FCODIGOACTUAL IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getTrcodigoactual() != null) {
			where.append(" AND UPPER(t1.TRCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getTrcodigoactual().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getTrcodigoactual().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGOACTUAL IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5codocumento() != null) {
			where.append(" AND UPPER(t1.Q5CODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getQ5codocumento().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getQ5codocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5CODOCUMENTO IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5origen() != null) {
			where.append(" AND UPPER(t1.Q5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getQ5origen().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getQ5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5ORIGEN IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getQ5nofile() != null) {
			where.append(" AND UPPER(t1.Q5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getQ5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getQ5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q5NOFILE IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getVariosDocumentos() != null) {
			where.append(" AND UPPER(t1.VARIOSDOCUMENTOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getVariosDocumentos().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getVariosDocumentos().toUpperCase() + "%");
			}
			where.append(" AND t1.VARIOSDOCUMENTOS IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(bandejainspecciones.getFechatramite());
		}
		if (bandejainspecciones != null && bandejainspecciones.getEstvisitado() != null) {
			where.append(" AND UPPER(t1.ESTVISITADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getEstvisitado().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getEstvisitado().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTVISITADO IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getEstadotramite() != null) {
			where.append(" AND UPPER(t1.ESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejainspecciones.getEstadotramite().toUpperCase() + "%");
			} else {
				params.add("%" + bandejainspecciones.getEstadotramite().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADOTRAMITE IS NOT NULL");
		}
		if (bandejainspecciones != null && bandejainspecciones.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(bandejainspecciones.getFechalimite());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
