package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteInspeccionDetalle;

/**
 * BandejaInspeccionesDao  
 * 
 *  
 */

public interface BandejaInspeccionesDao {

	/**
	 * Inserts a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones add(BandejaInspecciones bandejainspecciones);

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones update(BandejaInspecciones bandejainspecciones);

	/**
	 * Finds a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones find(BandejaInspecciones bandejainspecciones);

	/**
	 * Deletes a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return
	 */
	void remove(BandejaInspecciones bandejainspecciones);

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return List
	 */
	List<BandejaInspecciones> findAll(BandejaInspecciones bandejainspecciones,
			Pagination pagination, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro);

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return Long
	 */
	Long findAllCount(BandejaInspecciones bandejainspecciones,
			CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro);

	/**
	 * Finds rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaInspecciones> findAllLike(
			BandejaInspecciones bandejainspecciones, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaInspecciones bandejainspecciones,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteInspeccionDetalle> findAllTramitesPendientes(
			BandejaInspecciones bandejainspecciones, Pagination pagination);

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejainspecciones
	 *            BandejaInspecciones
	 * @return Long
	 */
	Long findAllTramitesPendientesCount(BandejaInspecciones bandejainspecciones);
}