package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * BandejaFirmaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BandejaFirmaDaoImpl implements BandejaFirmaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaFirma> rwMap = new RowMapper<BandejaFirma>() {
		public BandejaFirma mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new BandejaFirma(resultSet.getString("IDBANDEJAFIRMA"), resultSet.getString("IDEXPEDIENTE"),
					resultSet.getString("EXPEDIENTE"), resultSet.getString("PCODIGO"), resultSet.getString("HCCOOR"),
					resultSet.getString("IDTRAMITEHECHO"), resultSet.getString("TRCODIGO"),
					resultSet.getString("CODOCUMENTO"), resultSet.getString("IDDOCUMENTUM"),
					resultSet.getString("NOFILE"), resultSet.getDate("FECHALIMFIRMA"), resultSet.getString("COMOFIRMA"),
					resultSet.getString("ID_PERFILFIRMA"), resultSet.getString("DESFILE"),
					new Fase(resultSet.getString("FaseFCODIGO"), resultSet.getString("FaseFNOMBRE"),
							resultSet.getString("FaseFNOMBREE"), resultSet.getDate("FaseFBAJA"),
							new TipoProcedimiento(resultSet.getString("FasePCODIGO"), null, null, null, null)),
					resultSet.getString("HASHFILE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma add(BandejaFirma bandejafirma) {
		String query = "INSERT INTO BANDEJA_FIRMA (IDBANDEJAFIRMA, FCODIGO, IDEXPEDIENTE, EXPEDIENTE, PCODIGO, HCCOOR, IDTRAMITEHECHO, TRCODIGO, CODOCUMENTO, IDDOCUMENTUM, NOFILE, FECHALIMFIRMA, COMOFIRMA,ID_PERFILFIRMA,DESFILE,HASHFILE,COMOASIGFIRMA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getFaseFcodigoAux = null;
		if (bandejafirma.getFase() != null && bandejafirma.getFase().getFcodigo() != null) {
			getFaseFcodigoAux = bandejafirma.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, bandejafirma.getIdbandejafirma(), getFaseFcodigoAux,
				bandejafirma.getIdexpediente(), bandejafirma.getExpediente(), bandejafirma.getPcodigo(),
				bandejafirma.getHccoor(), bandejafirma.getIdtramitehecho(), bandejafirma.getTrcodigo(),
				bandejafirma.getCodocumento(), bandejafirma.getIddocumentum(), bandejafirma.getNofile(),
				bandejafirma.getFechalimfirma(), bandejafirma.getComofirma(), bandejafirma.getIdperfilfirma(),
				bandejafirma.getDesfile(), bandejafirma.getHashfile(), bandejafirma.getComoasigfirma());

		query = "UPDATE BANDEJA_FIRMA SET COMORESPONSABLE=(SELECT MONITOR FROM BANDEJA_FIRMA_DESTINATARIO WHERE IDBANDEJAFIRMA=? AND ROWNUM=1), DESTINATARIO=(SELECT DESTINATARIO FROM BANDEJA_FIRMA_DESTINATARIO WHERE IDBANDEJAFIRMA=? AND ROWNUM=1) WHERE IDBANDEJAFIRMA=?";

		this.jdbcTemplate.update(query, bandejafirma.getIdbandejafirma(), bandejafirma.getIdbandejafirma(),
				bandejafirma.getIdbandejafirma());

		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma update(BandejaFirma bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA SET FCODIGO=?, IDEXPEDIENTE=?, EXPEDIENTE=?, PCODIGO=?, HCCOOR=?, IDTRAMITEHECHO=?, TRCODIGO=?, CODOCUMENTO=?, IDDOCUMENTUM=?, NOFILE=?, FECHALIMFIRMA=?, COMOFIRMA=?,ID_PERFILFIRMA=?,DESFILE=? WHERE IDBANDEJAFIRMA=?";
		Object getFaseFcodigoAux = null;
		if (bandejafirma.getFase() != null && bandejafirma.getFase().getFcodigo() != null) {
			getFaseFcodigoAux = bandejafirma.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, getFaseFcodigoAux, bandejafirma.getIdexpediente(), bandejafirma.getExpediente(),
				bandejafirma.getPcodigo(), bandejafirma.getHccoor(), bandejafirma.getIdtramitehecho(),
				bandejafirma.getTrcodigo(), bandejafirma.getCodocumento(), bandejafirma.getIddocumentum(),
				bandejafirma.getNofile(), bandejafirma.getFechalimfirma(), bandejafirma.getComofirma(),
				bandejafirma.getIdperfilfirma(), bandejafirma.getDesfile(), bandejafirma.getIdbandejafirma());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma updateDocumentoBandejaFirma(BandejaFirma bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA SET NOFILE=? WHERE IDDOCUMENTUM=?";

		this.jdbcTemplate.update(query, bandejafirma.getNofile(), bandejafirma.getIddocumentum());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma updateHashFileBandejaFirma(BandejaFirma bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA SET HASHFILE=? WHERE IDDOCUMENTUM=?";

		this.jdbcTemplate.update(query, bandejafirma.getHashfile(), bandejafirma.getIddocumentum());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma updateComoFirma(BandejaFirma bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA SET COMOFIRMA=? WHERE IDBANDEJAFIRMA=?";
		this.jdbcTemplate.update(query, bandejafirma.getComofirma(), bandejafirma.getIdbandejafirma());
		return bandejafirma;
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	@Transactional(readOnly = true)
	public BandejaFirma find(BandejaFirma bandejafirma) {
		String query = "SELECT t1.IDBANDEJAFIRMA IDBANDEJAFIRMA, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.PCODIGO PCODIGO, t1.HCCOOR HCCOOR, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.TRCODIGO TRCODIGO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t2.FCODIGO FASEFCODIGO, t2.FNOMBRE FASEFNOMBRE, t2.FNOMBREE FASEFNOMBREE, t2.FBAJA FASEFBAJA, t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA t1 , FASE t2  WHERE t1.IDBANDEJAFIRMA = ?   AND t1.FCODIGO= t2.FCODIGO(+)";

		List<BandejaFirma> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap,
				bandejafirma.getIdbandejafirma());
		return (BandejaFirma) DataAccessUtils.uniqueResult(bandejafirmaList);
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	@Transactional(readOnly = true)
	public BandejaFirma findByHash(BandejaFirma bandejafirma) {
		String query = "SELECT t1.IDBANDEJAFIRMA IDBANDEJAFIRMA, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.PCODIGO PCODIGO, t1.HCCOOR HCCOOR, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.TRCODIGO TRCODIGO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t2.FCODIGO FASEFCODIGO, t2.FNOMBRE FASEFNOMBRE, t2.FNOMBREE FASEFNOMBREE, t2.FBAJA FASEFBAJA, t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA t1 , FASE t2  WHERE t1.HASHFILE = ?   AND t1.FCODIGO= t2.FCODIGO(+) AND t1.COMOFIRMA IS NULL AND ROWNUM=1";

		List<BandejaFirma> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap, bandejafirma.getHashfile());
		return (BandejaFirma) DataAccessUtils.uniqueResult(bandejafirmaList);
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirma bandejafirma) {
		String query = "SELECT   IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA, t1.COMORESPONSABLE COMORESPONSABLE, t1.DESTINATARIO DESTINATARIO, t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) AND t1.IDBANDEJAFIRMA = ? ";

		List<BandejaFirmaBusqueda> bandejaFirmaBusquedaList = this.jdbcTemplate.query(query,
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null,
								resultSet.getString("COMORESPONSABLE"), resultSet.getString("DESTINATARIO"));
					}
				}, bandejafirma.getIdbandejafirma());
		return (BandejaFirmaBusqueda) DataAccessUtils.uniqueResult(bandejaFirmaBusquedaList);
	}

	/**
	 * Removes a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaFirma bandejafirma) {
		String query = "DELETE FROM BANDEJA_FIRMA WHERE IDBANDEJAFIRMA=?";
		this.jdbcTemplate.update(query, bandejafirma.getIdbandejafirma());
	}

	/**
	 * Removes a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpediente(BandejaFirma bandejafirma) {
		String query = "DELETE FROM BANDEJA_FIRMA WHERE IDTRAMITEHECHO=? ";
		this.jdbcTemplate.update(query, bandejafirma.getIdtramitehecho());
	}

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(BandejaFirma bandejafirma, CensoMonitor censoMonitor,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA, t1.COMORESPONSABLE COMORESPONSABLE, t1.DESTINATARIO DESTINATARIO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO  ");
		query.append(" FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4  ");

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())) {
			where.append(" AND ((t3.PCODIGO='SOL' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" AND ((t3.PCODIGO='SOL' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='SAN' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='SAN' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='INS' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='INS' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())) {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND t1.HCCOOR = ?))");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND 1=1))");
		}

		where.append(" AND (t1.COMOASIGFIRMA=?");
		params.add(censoMonitor.getMocodigo());

		where.append(" OR ((t3.PCODIGO='SOL' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
		where.append(" OR(t3.PCODIGO='SAN' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
		where.append(" OR(t3.PCODIGO='INS' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
		where.append(
				" OR((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB') AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
		where.append(" OR(t3.PCODIGO='ARB' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)))");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());

		where.append(" AND t1.COMOFIRMA IS NULL ");

		where.append(" AND UPPER(t1.NOFILE) LIKE '%.PDF'");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirmaBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null,
								resultSet.getString("COMORESPONSABLE"), resultSet.getString("DESTINATARIO"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaFirmaCount(BandejaFirma bandejafirma, CensoMonitor censoMonitor) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 ");

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())) {
			where.append(" AND ((t3.PCODIGO='SOL' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" AND ((t3.PCODIGO='SOL' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='SAN' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='SAN' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='INS' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='INS' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())) {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND t1.HCCOOR = ?))");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND 1=1))");
		}

		where.append(" AND (t1.COMOASIGFIRMA=?");
		params.add(censoMonitor.getMocodigo());

		where.append(" OR ((t3.PCODIGO='SOL' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
		where.append(" OR(t3.PCODIGO='SAN' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
		where.append(" OR(t3.PCODIGO='INS' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
		where.append(
				" OR((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB') AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
		where.append(" OR(t3.PCODIGO='ARB' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)))");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());

		where.append(" AND t1.COMOFIRMA IS NULL ");

		where.append(" AND UPPER(t1.NOFILE) LIKE '%.PDF'");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a list of rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirma>
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA, t1.COMORESPONSABLE COMORESPONSABLE, t1.DESTINATARIO DESTINATARIO,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO  ");
		query.append(" FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4  ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuffer idsbandejafirma = new StringBuffer();
		for (int posId = 0; posId < ids.size(); posId++) {
			if (posId > 0) {
				idsbandejafirma.append(",");
			}
			idsbandejafirma.append("'").append((String) ids.get(posId)).append("'");
		}
		where.append(" AND  t1.IDBANDEJAFIRMA IN (" + idsbandejafirma.toString() + ")");
		where.append(" ORDER BY FECHALIMFIRMA ASC ");
		query.append(where);
		return (List<BandejaFirmaBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null,
								resultSet.getString("COMORESPONSABLE"), resultSet.getString("DESTINATARIO"));
					}
				}, null);
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllByIdsCount(List<String> ids) {
		StringBuilder query = new StringBuilder(
				"SELECT  COUNT(1) FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");
		StringBuffer idsbandejafirma = new StringBuffer();
		for (int posId = 0; posId < ids.size(); posId++) {
			if (posId > 0) {
				idsbandejafirma.append(",");
			}
			idsbandejafirma.append("'").append((String) ids.get(posId)).append("'");
		}
		where.append(" AND  t1.IDBANDEJAFIRMA IN (" + idsbandejafirma.toString() + ")");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), null);
	}

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirma> findAll(BandejaFirma bandejafirma, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE,t1.PCODIGO PCODIGO,t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO,t1.TRCODIGO TRCODIGO,t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM BANDEJA_FIRMA t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirma>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaFirma bandejafirma) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_FIRMA t1 , FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the BandejaFirma table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirma> findAllLike(BandejaFirma bandejafirma, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE,t1.PCODIGO PCODIGO,t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO,t1.TRCODIGO TRCODIGO,t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM BANDEJA_FIRMA t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirma>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirma table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaFirma bandejafirma, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_FIRMA t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaFirma entity
	 * 
	 * @param bandejafirma
	 *            BandejaFirma Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaFirma bandejafirma) {

		StringBuilder where = new StringBuilder(BandejaFirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejafirma != null && bandejafirma.getIdbandejafirma() != null) {
			where.append(" AND t1.IDBANDEJAFIRMA = ?");
			params.add(bandejafirma.getIdbandejafirma());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFcodigo() != null) {
			where.append(" AND t2.FCODIGO = ?");
			params.add(bandejafirma.getFase().getFcodigo());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null
				&& bandejafirma.getFase().getTipoProcedimiento() != null
				&& bandejafirma.getFase().getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(bandejafirma.getFase().getTipoProcedimiento().getPcodigo());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFnombre() != null) {
			where.append(" AND t2.FNOMBRE = ?");
			params.add(bandejafirma.getFase().getFnombre());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFnombree() != null) {
			where.append(" AND t2.FNOMBREE = ?");
			params.add(bandejafirma.getFase().getFnombree());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFbaja() != null) {
			where.append(" AND t2.FBAJA = ?");
			params.add(bandejafirma.getFase().getFbaja());
		}
		if (bandejafirma != null && bandejafirma.getIdexpediente() != null) {
			where.append(" AND t1.IDEXPEDIENTE = ?");
			params.add(bandejafirma.getIdexpediente());
		}
		if (bandejafirma != null && bandejafirma.getExpediente() != null) {
			where.append(" AND t1.EXPEDIENTE = ?");
			params.add(bandejafirma.getExpediente());
		}
		if (bandejafirma != null && bandejafirma.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(bandejafirma.getPcodigo());
		}
		if (bandejafirma != null && bandejafirma.getHccoor() != null) {
			where.append(" AND t1.HCCOOR = ?");
			params.add(bandejafirma.getHccoor());
		}
		if (bandejafirma != null && bandejafirma.getIdtramitehecho() != null) {
			where.append(" AND t1.IDTRAMITEHECHO = ?");
			params.add(bandejafirma.getIdtramitehecho());
		}
		if (bandejafirma != null && bandejafirma.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(bandejafirma.getTrcodigo());
		}
		if (bandejafirma != null && bandejafirma.getCodocumento() != null) {
			where.append(" AND t1.CODOCUMENTO = ?");
			params.add(bandejafirma.getCodocumento());
		}
		if (bandejafirma != null && bandejafirma.getIddocumentum() != null) {
			where.append(" AND t1.IDDOCUMENTUM = ?");
			params.add(bandejafirma.getIddocumentum());
		}
		if (bandejafirma != null && bandejafirma.getNofile() != null) {
			where.append(" AND t1.NOFILE = ?");
			params.add(bandejafirma.getNofile());
		}
		if (bandejafirma != null && bandejafirma.getFechalimfirma() != null) {
			where.append(" AND t1.FECHALIMFIRMA = ?");
			params.add(bandejafirma.getFechalimfirma());
		}
		if (bandejafirma != null && bandejafirma.getComofirma() != null) {
			where.append(" AND t1.COMOFIRMA = ?");
			params.add(bandejafirma.getComofirma());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaFirma entity
	 * 
	 * @param bandejafirma
	 *            BandejaFirma Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaFirma bandejafirma, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BandejaFirmaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejafirma != null && bandejafirma.getIdbandejafirma() != null) {
			where.append(" AND UPPER(t1.IDBANDEJAFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdbandejafirma().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdbandejafirma().toUpperCase() + "%");
			}
			where.append(" AND t1.IDBANDEJAFIRMA IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFcodigo() != null) {
			where.append(" AND t2.FCODIGO = ?");
			params.add(bandejafirma.getFase().getFcodigo());
		}
		if (bandejafirma != null && bandejafirma.getFase() != null
				&& bandejafirma.getFase().getTipoProcedimiento() != null
				&& bandejafirma.getFase().getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND UPPER(t2.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getFase().getTipoProcedimiento().getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getFase().getTipoProcedimiento().getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.PCODIGO IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFnombre() != null) {
			where.append(" AND UPPER(t2.FNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getFase().getFnombre().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getFase().getFnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.FNOMBRE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFnombree() != null) {
			where.append(" AND UPPER(t2.FNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getFase().getFnombree().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getFase().getFnombree().toUpperCase() + "%");
			}
			where.append(" AND t2.FNOMBREE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFase() != null && bandejafirma.getFase().getFbaja() != null) {
			where.append(" AND t2.FBAJA = ?");
			params.add(bandejafirma.getFase().getFbaja());
		}
		if (bandejafirma != null && bandejafirma.getIdexpediente() != null) {
			where.append(" AND UPPER(t1.IDEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdexpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEXPEDIENTE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getExpediente() != null) {
			where.append(" AND UPPER(t1.EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getExpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.EXPEDIENTE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getHccoor() != null) {
			where.append(" AND UPPER(t1.HCCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getHccoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getHccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.HCCOOR IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getIdtramitehecho() != null) {
			where.append(" AND UPPER(t1.IDTRAMITEHECHO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdtramitehecho().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdtramitehecho().toUpperCase() + "%");
			}
			where.append(" AND t1.IDTRAMITEHECHO IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getCodocumento() != null) {
			where.append(" AND t1.CODOCUMENTO = ?");
			params.add(bandejafirma.getCodocumento());
		}
		if (bandejafirma != null && bandejafirma.getIddocumentum() != null) {
			where.append(" AND UPPER(t1.IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.IDDOCUMENTUM IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getNofile() != null) {
			where.append(" AND UPPER(t1.NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getNofile().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getNofile().toUpperCase() + "%");
			}
			where.append(" AND t1.NOFILE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFechalimfirma() != null) {
			where.append(" AND t1.FECHALIMFIRMA = ?");
			params.add(bandejafirma.getFechalimfirma());
		}
		if (bandejafirma != null && bandejafirma.getComofirma() != null) {
			where.append(" AND UPPER(t1.COMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getComofirma().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getComofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.COMOFIRMA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaBusqueda findBandejaFirmaPorCodocumento(BandejaFirma bandejafirma) {
		String query = "SELECT   IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA, t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) AND t1.CODOCUMENTO = ? ";

		List<BandejaFirmaBusqueda> bandejaFirmaBusquedaList = this.jdbcTemplate.query(query,
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null, null,
								null);
					}
				}, bandejafirma.getCodocumento());
		return (BandejaFirmaBusqueda) DataAccessUtils.uniqueResult(bandejaFirmaBusquedaList);
	}
}
