package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaFirmaDao  
 * 
 *  
 */

public interface BandejaFirmaDao {

	/**
	 * Inserts a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma add(BandejaFirma bandejafirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma update(BandejaFirma bandejafirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma updateComoFirma(BandejaFirma bandejafirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma updateDocumentoBandejaFirma(BandejaFirma bandejafirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma updateHashFileBandejaFirma(BandejaFirma bandejafirma);

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma find(BandejaFirma bandejafirma);

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirma findByHash(BandejaFirma bandejafirma);

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirma
	 */
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirma bandejafirma);

	/**
	 * Deletes a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return
	 */
	void remove(BandejaFirma bandejafirma);

	/**
	 * Removes a single row in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpediente(BandejaFirma bandejafirma);

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BandejaFirma> findAll(BandejaFirma bandejafirma, Pagination pagination);

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @return Long
	 */
	Long findAllCount(BandejaFirma bandejafirma);

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(
			BandejaFirma bandejafirma, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaFirmaCount(BandejaFirma bandejafirma,
			CensoMonitor censoMonitor);

	/**
	 * Finds a list of rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirma>
	 */
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids);

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	public Long findAllByIdsCount(List<String> ids);

	/**
	 * Finds rows in the BandejaFirma table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaFirma> findAllLike(BandejaFirma bandejafirma,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaFirma table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaFirma bandejafirma, Boolean startsWith);

	BandejaFirmaBusqueda findBandejaFirmaPorCodocumento(BandejaFirma bandeja);
}
