package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaFirmaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BandejaFirmaArbitrajeDaoImpl implements BandejaFirmaArbitrajeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaFirmaArbitraje> rwMap = new RowMapper<BandejaFirmaArbitraje>() {
		public BandejaFirmaArbitraje mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new BandejaFirmaArbitraje(resultSet.getString("IDBANDEJAFIRMAARB"),
					resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
					resultSet.getString("IDTRAMITEHECHO"), resultSet.getString("CODOCUMENTO"),
					resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
					resultSet.getDate("FECHALIMFIRMA"), resultSet.getDate("FECHAENVIO"), resultSet.getString("ESTADO"),
					resultSet.getString("OBSERVACIONES"), resultSet.getString("HASHFILE"),
					resultSet.getString("ARCODIGO"), resultSet.getString("DESFILE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje add(BandejaFirmaArbitraje bandejafirma) {
		String query = "INSERT INTO BANDEJA_FIRMA_ARBITROS (IDBANDEJAFIRMAARB, IDEXPEDIENTE, EXPEDIENTE, IDTRAMITEHECHO, CODOCUMENTO, IDDOCUMENTUM, NOFILE, FECHALIMFIRMA, FECHAENVIO, ESTADO, OBSERVACIONES, HASHFILE, ARCODIGO, DESFILE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, bandejafirma.getIdbandejafirma(), bandejafirma.getIdexpediente(),
				bandejafirma.getExpediente(), bandejafirma.getIdtramitehecho(), bandejafirma.getCodocumento(),
				bandejafirma.getIddocumentum(), bandejafirma.getNofile(), bandejafirma.getFechalimfirma(),
				bandejafirma.getFechaenvio(), bandejafirma.getEstado(), bandejafirma.getObservaciones(),
				bandejafirma.getHashfile(), bandejafirma.getArcodigo(), bandejafirma.getDesfile());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje update(BandejaFirmaArbitraje bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA_ARBITROS SET  IDEXPEDIENTE=?, EXPEDIENTE=?, IDTRAMITEHECHO=?, CODOCUMENTO=?, IDDOCUMENTUM=?, NOFILE=?, FECHALIMFIRMA=?, FECHAENVIO=?, ESTADO=?, OBSERVACIONES=?, HASHFILE=?, ARCODIGO=? WHERE IDBANDEJAFIRMAARB=?";

		this.jdbcTemplate.update(query, bandejafirma.getIdexpediente(), bandejafirma.getExpediente(),
				bandejafirma.getIdtramitehecho(), bandejafirma.getCodocumento(), bandejafirma.getIddocumentum(),
				bandejafirma.getNofile(), bandejafirma.getFechalimfirma(), bandejafirma.getFechaenvio(),
				bandejafirma.getEstado(), bandejafirma.getObservaciones(), bandejafirma.getHashfile(),
				bandejafirma.getIdbandejafirma(), bandejafirma.getArcodigo());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje updateEstado(BandejaFirmaArbitraje bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA_ARBITROS SET  FECHAENVIO=?, ESTADO=?, FECHALIMFIRMA=?, HASHFILE=?, NOFILE=?, IDDOCUMENTUM=? WHERE CODOCUMENTO=? AND IDTRAMITEHECHO=?";

		this.jdbcTemplate.update(query, bandejafirma.getFechaenvio(), bandejafirma.getEstado(),
				bandejafirma.getFechalimfirma(), bandejafirma.getHashfile(), bandejafirma.getNofile(),
				bandejafirma.getIddocumentum(), bandejafirma.getCodocumento(), bandejafirma.getIdtramitehecho());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje updateDocumentoBandejaFirma(BandejaFirmaArbitraje bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA_ARBITROS SET NOFILE=? WHERE IDDOCUMENTUM=?";

		this.jdbcTemplate.update(query, bandejafirma.getNofile(), bandejafirma.getIddocumentum());
		return bandejafirma;
	}

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje updateHashFileBandejaFirma(BandejaFirmaArbitraje bandejafirma) {
		String query = "UPDATE BANDEJA_FIRMA_ARBITROS SET HASHFILE=? WHERE IDDOCUMENTUM=?";

		this.jdbcTemplate.update(query, bandejafirma.getHashfile(), bandejafirma.getIddocumentum());
		return bandejafirma;
	}

	// /**
	// * Updates a single row in the BandejaFirmaArbitraje table.
	// *
	// * @param bandejafirma
	// * Pagination
	// * @return BandejaFirmaArbitraje
	// */
	// public BandejaFirmaArbitraje updateComoFirma(
	// BandejaFirmaArbitraje bandejafirma) {
	// String query =
	// "UPDATE BANDEJA_FIRMA_ARBITROS SET COMOFIRMA=? WHERE IDBANDEJAFIRMA=?";
	// this.jdbcTemplate.update(query, bandejafirma.getComofirma(),
	// bandejafirma.getIdbandejafirma());
	// return bandejafirma;
	// }

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaArbitraje find(BandejaFirmaArbitraje bandejafirma) {
		String query = "SELECT t1.IDBANDEJAFIRMAARB IDBANDEJAFIRMAARB, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.FECHAENVIO FECHAENVIO, t1.ESTADO ESTADO, t1.OBSERVACIONES OBSERVACIONES, t1.HASHFILE HASHFILE, t1.ARCODIGO ARCODIGO, t1.DESFILE DESFILE FROM BANDEJA_FIRMA_ARBITROS t1  WHERE t1.IDBANDEJAFIRMAARB = ?  ";

		List<BandejaFirmaArbitraje> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap,
				bandejafirma.getIdbandejafirma());
		return (BandejaFirmaArbitraje) DataAccessUtils.uniqueResult(bandejafirmaList);
	}

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaArbitraje findByHash(BandejaFirmaArbitraje bandejafirma) {
		String query = "SELECT t1.IDBANDEJAFIRMA IDBANDEJAFIRMA, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.PCODIGO PCODIGO, t1.HCCOOR HCCOOR, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.TRCODIGO TRCODIGO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t2.FCODIGO FASEFCODIGO, t2.FNOMBRE FASEFNOMBRE, t2.FNOMBREE FASEFNOMBREE, t2.FBAJA FASEFBAJA, t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA_ARBITROS t1 , FASE t2  WHERE t1.HASHFILE = ?   AND t1.FCODIGO= t2.FCODIGO(+) AND t1.COMOFIRMA IS NULL AND ROWNUM=1";

		List<BandejaFirmaArbitraje> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap,
				bandejafirma.getHashfile());
		return (BandejaFirmaArbitraje) DataAccessUtils.uniqueResult(bandejafirmaList);
	}

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirmaArbitraje bandejafirma) {
		String query = "SELECT   IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE, t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA, t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) AND t1.IDBANDEJAFIRMA = ? ";

		List<BandejaFirmaBusqueda> bandejaFirmaBusquedaList = this.jdbcTemplate.query(query,
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null, null,
								null);
					}
				}, bandejafirma.getIdbandejafirma());
		return (BandejaFirmaBusqueda) DataAccessUtils.uniqueResult(bandejaFirmaBusquedaList);
	}

	/**
	 * Removes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaFirmaArbitraje bandejafirma) {
		String query = "DELETE FROM BANDEJA_FIRMA_ARBITROS WHERE IDBANDEJAFIRMAARB=?";
		this.jdbcTemplate.update(query, bandejafirma.getIdbandejafirma());
	}

	/**
	 * Removes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpediente(BandejaFirmaArbitraje bandejafirma) {
		String query = "DELETE FROM BANDEJA_FIRMA_ARBITROS WHERE IDTRAMITEHECHO=? ";
		this.jdbcTemplate.update(query, bandejafirma.getIdtramitehecho());
	}

	/**
	 * Removes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpedientePendientes(BandejaFirmaArbitraje bandejafirma) {
		String query = "DELETE FROM BANDEJA_FIRMA_ARBITROS WHERE IDTRAMITEHECHO=? AND ESTADO=? ";
		this.jdbcTemplate.update(query, bandejafirma.getIdtramitehecho(),
				Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
	}

	/**
	 * Finds a List of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(BandejaFirmaArbitraje bandejafirma, CensoMonitor censoMonitor,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO  ");
		query.append(" FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4  ");

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())) {
			where.append(" AND ((t3.PCODIGO='SOL' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" AND ((t3.PCODIGO='SOL' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='SAN' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='SAN' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='INS' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='INS' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())) {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND t1.HCCOOR = ?))");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND 1=1))");
		}

		where.append(" AND (t1.COMOASIGFIRMA=?");
		params.add(censoMonitor.getMocodigo());

		where.append(" OR ((t3.PCODIGO='SOL' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
		where.append(" OR(t3.PCODIGO='SAN' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
		where.append(" OR(t3.PCODIGO='INS' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
		where.append(
				" OR((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB') AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
		where.append(" OR(t3.PCODIGO='ARB' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)))");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());

		where.append(" AND t1.COMOFIRMA IS NULL ");

		where.append(" AND UPPER(t1.NOFILE) LIKE '%.PDF'");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirmaBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null, null,
								null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaFirmaCount(BandejaFirmaArbitraje bandejafirma, CensoMonitor censoMonitor) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 ");

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSolicitudes().getIdPerfil())) {
			where.append(" AND ((t3.PCODIGO='SOL' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" AND ((t3.PCODIGO='SOL' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilSanciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='SAN' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='SAN' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
			where.append(" OR (t3.PCODIGO='INS' AND t1.HCCOOR = ?)");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(" OR (t3.PCODIGO='INS' AND 1=1) ");
		}

		if (!Y41bConstantes.PERFIL_DIRECTOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil())) {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND t1.HCCOOR = ?))");
			if (censoMonitor.getOrganismo() != null) {
				params.add(censoMonitor.getOrganismo().getCodOrg());
			} else {
				params.add("");
			}
		} else {
			where.append(
					" OR ((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB' OR t3.PCODIGO='ARB') AND 1=1))");
		}

		where.append(" AND (t1.COMOASIGFIRMA=?");
		params.add(censoMonitor.getMocodigo());

		where.append(" OR ((t3.PCODIGO='SOL' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSolicitudes().getIdPerfil());
		where.append(" OR(t3.PCODIGO='SAN' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilSanciones().getIdPerfil());
		where.append(" OR(t3.PCODIGO='INS' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilInspecciones().getIdPerfil());
		where.append(
				" OR((t3.PCODIGO='ADA' OR t3.PCODIGO='ADM' OR t3.PCODIGO='ADB') AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());
		where.append(" OR(t3.PCODIGO='ARB' AND t1.COMOASIGFIRMA IS NULL AND t1.ID_PERFILFIRMA=?)))");
		params.add(censoMonitor.getPerfilArbitraje().getIdPerfil());

		where.append(" AND t1.COMOFIRMA IS NULL ");

		where.append(" AND UPPER(t1.NOFILE) LIKE '%.PDF'");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a list of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirmaArbitraje>
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE, t3.PCODIGO PCODIGO,t3.PNOMBRE PNOMBRE,t3.PNOMBREE PNOMBREE, t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO, t4.TRCODIGO TRCODIGO, t4.TRNOMBRE TRNOMBRE, t4.TRNOMBREE TRNOMBREE, t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA, t1.HASHFILE HASHFILE, t1.COMOASIGFIRMA COMOASIGFIRMA,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO  ");
		query.append(" FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4  ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");

		StringBuffer idsbandejafirma = new StringBuffer();
		for (int posId = 0; posId < ids.size(); posId++) {
			if (posId > 0) {
				idsbandejafirma.append(",");
			}
			idsbandejafirma.append("'").append((String) ids.get(posId)).append("'");
		}
		where.append(" AND  t1.IDBANDEJAFIRMA IN (" + idsbandejafirma.toString() + ")");
		where.append(" ORDER BY FECHALIMFIRMA ASC ");
		query.append(where);
		return (List<BandejaFirmaBusqueda>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<BandejaFirmaBusqueda>() {
					public BandejaFirmaBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new BandejaFirmaBusqueda(resultSet.getString("IDBANDEJAFIRMA"),
								resultSet.getString("IDEXPEDIENTE"), resultSet.getString("EXPEDIENTE"),
								resultSet.getString("HCCOOR"), resultSet.getString("IDTRAMITEHECHO"),
								resultSet.getString("PCODIGO"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("FaseFCODIGO"),
								resultSet.getString("FaseFNOMBRE"), resultSet.getString("FaseFNOMBREE"),
								resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
								resultSet.getString("TRNOMBREE"), resultSet.getInt("CODOCUMENTO"),
								resultSet.getString("IDDOCUMENTUM"), resultSet.getString("NOFILE"),
								resultSet.getString("DESFILE"), resultSet.getDate("FECHALIMFIRMA"),
								resultSet.getString("COMOFIRMA"), resultSet.getString("ID_PERFILFIRMA"),
								resultSet.getString("HASHFILE"), resultSet.getString("COMOASIGFIRMA"), null, null,
								null);
					}
				}, null);
	}

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllByIdsCount(List<String> ids) {
		StringBuilder query = new StringBuilder(
				"SELECT  COUNT(1) FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2,TIPO_PROCEDIMIENTO t3,TRAMITE t4 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) AND t1.PCODIGO= t3.PCODIGO(+) AND t1.TRCODIGO=t4.TRCODIGO(+) ");
		StringBuffer idsbandejafirma = new StringBuffer();
		for (int posId = 0; posId < ids.size(); posId++) {
			if (posId > 0) {
				idsbandejafirma.append(",");
			}
			idsbandejafirma.append("'").append((String) ids.get(posId)).append("'");
		}
		where.append(" AND  t1.IDBANDEJAFIRMA IN (" + idsbandejafirma.toString() + ")");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), null);
	}

	/**
	 * Finds a List of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaArbitraje> findAll(BandejaFirmaArbitraje bandejafirma, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDBANDEJAFIRMA IDBANDEJAFIRMA,t1.IDEXPEDIENTE IDEXPEDIENTE,t1.EXPEDIENTE EXPEDIENTE,t1.PCODIGO PCODIGO,t1.HCCOOR HCCOOR,t1.IDTRAMITEHECHO IDTRAMITEHECHO,t1.TRCODIGO TRCODIGO,t1.CODOCUMENTO CODOCUMENTO,t1.IDDOCUMENTUM IDDOCUMENTUM,t1.NOFILE NOFILE, DECODE(t1.DESFILE, null,t1.NOFILE,t1.DESFILE) DESFILE,t1.FECHALIMFIRMA FECHALIMFIRMA,t1.COMOFIRMA COMOFIRMA, t1.ID_PERFILFIRMA ID_PERFILFIRMA,t2.FCODIGO FASEFCODIGO,t2.FNOMBRE FASEFNOMBRE,t2.FNOMBREE FASEFNOMBREE,t2.FBAJA FASEFBAJA,t2.PCODIGO FASEPCODIGO ");
		query.append("FROM BANDEJA_FIRMA_ARBITROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirmaArbitraje>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaFirmaArbitraje bandejafirma) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_FIRMA_ARBITROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejafirma);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the BandejaFirmaArbitraje table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaFirmaArbitraje> findAllLike(BandejaFirmaArbitraje bandejafirma, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDBANDEJAFIRMAARB IDBANDEJAFIRMAARB, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.FECHAENVIO FECHAENVIO, t1.ESTADO ESTADO, t1.OBSERVACIONES OBSERVACIONES, t1.HASHFILE HASHFILE, t1.ARCODIGO ARCODIGO, t1.DESFILE DESFILE ");
		query.append("FROM BANDEJA_FIRMA_ARBITROS t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirmaArbitraje>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<BandejaFirmaArbitraje> findAllLikeEstado(BandejaFirmaArbitraje bandejafirma, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDBANDEJAFIRMAARB IDBANDEJAFIRMAARB, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.FECHAENVIO FECHAENVIO, t1.ESTADO ESTADO, t1.OBSERVACIONES OBSERVACIONES, t1.HASHFILE HASHFILE, t1.ARCODIGO ARCODIGO, t1.DESFILE DESFILE ");
		query.append("FROM BANDEJA_FIRMA_ARBITROS t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.ESTADO IS NOT NULL");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaFirmaArbitraje>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaFirmaArbitraje table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaFirmaArbitraje bandejafirma, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_FIRMA_ARBITROS t1 ,FASE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejafirma, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.FCODIGO= t2.FCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaFirmaArbitraje entity
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaFirmaArbitraje bandejafirma) {

		StringBuilder where = new StringBuilder(BandejaFirmaArbitrajeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejafirma != null && bandejafirma.getIdbandejafirma() != null) {
			where.append(" AND t1.IDBANDEJAFIRMA = ?");
			params.add(bandejafirma.getIdbandejafirma());
		}

		if (bandejafirma != null && bandejafirma.getIdexpediente() != null) {
			where.append(" AND t1.IDEXPEDIENTE = ?");
			params.add(bandejafirma.getIdexpediente());
		}
		if (bandejafirma != null && bandejafirma.getExpediente() != null) {
			where.append(" AND t1.EXPEDIENTE = ?");
			params.add(bandejafirma.getExpediente());
		}

		if (bandejafirma != null && bandejafirma.getIdtramitehecho() != null) {
			where.append(" AND t1.IDTRAMITEHECHO = ?");
			params.add(bandejafirma.getIdtramitehecho());
		}

		if (bandejafirma != null && bandejafirma.getCodocumento() != null) {
			where.append(" AND t1.CODOCUMENTO = ?");
			params.add(bandejafirma.getCodocumento());
		}
		if (bandejafirma != null && bandejafirma.getIddocumentum() != null) {
			where.append(" AND t1.IDDOCUMENTUM = ?");
			params.add(bandejafirma.getIddocumentum());
		}
		if (bandejafirma != null && bandejafirma.getNofile() != null) {
			where.append(" AND t1.NOFILE = ?");
			params.add(bandejafirma.getNofile());
		}
		if (bandejafirma != null && bandejafirma.getFechalimfirma() != null) {
			where.append(" AND t1.FECHALIMFIRMA = ?");
			params.add(bandejafirma.getFechalimfirma());
		}
		if (bandejafirma != null && bandejafirma.getEstado() != null) {
			where.append(" AND t1.ESTADO = ?");
			params.add(bandejafirma.getEstado());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaFirmaArbitraje entity
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaFirmaArbitraje bandejafirma, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BandejaFirmaArbitrajeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejafirma != null && bandejafirma.getIdbandejafirma() != null) {
			where.append(" AND UPPER(t1.IDBANDEJAFIRMAARB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdbandejafirma().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdbandejafirma().toUpperCase() + "%");
			}
			where.append(" AND t1.IDBANDEJAFIRMAARB IS NOT NULL");
		}

		if (bandejafirma != null && bandejafirma.getIdexpediente() != null) {
			where.append(" AND UPPER(t1.IDEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdexpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.IDEXPEDIENTE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getExpediente() != null) {
			where.append(" AND UPPER(t1.EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getExpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.EXPEDIENTE IS NOT NULL");
		}

		if (bandejafirma != null && bandejafirma.getIdtramitehecho() != null) {
			where.append(" AND UPPER(t1.IDTRAMITEHECHO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIdtramitehecho().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIdtramitehecho().toUpperCase() + "%");
			}
			where.append(" AND t1.IDTRAMITEHECHO IS NOT NULL");
		}

		if (bandejafirma != null && bandejafirma.getCodocumento() != null) {
			where.append(" AND t1.CODOCUMENTO = ?");
			params.add(bandejafirma.getCodocumento());
		}

		if (bandejafirma != null && bandejafirma.getEstado() != null) {
			where.append(" AND t1.ESTADO = ?");
			params.add(bandejafirma.getEstado());
		}
		if (bandejafirma != null && bandejafirma.getIddocumentum() != null) {
			where.append(" AND UPPER(t1.IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getIddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getIddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.IDDOCUMENTUM IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getNofile() != null) {
			where.append(" AND UPPER(t1.NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getNofile().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getNofile().toUpperCase() + "%");
			}
			where.append(" AND t1.NOFILE IS NOT NULL");
		}
		if (bandejafirma != null && bandejafirma.getFechalimfirma() != null) {
			where.append(" AND t1.FECHALIMFIRMA = ?");
			params.add(bandejafirma.getFechalimfirma());
		}

		if (bandejafirma != null && bandejafirma.getArcodigo() != null) {
			where.append(" AND UPPER(t1.ARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejafirma.getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejafirma.getArcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	@Transactional(readOnly = true)
	public String findPorCodocumento(String codocumento) {
		// TODO Auto-generated method stub

		String query = "SELECT t1.IDBANDEJAFIRMAARB IDBANDEJAFIRMAARB, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.FECHAENVIO FECHAENVIO, t1.ESTADO ESTADO, t1.OBSERVACIONES OBSERVACIONES, t1.HASHFILE HASHFILE, t1.ARCODIGO ARCODIGO, t1.DESFILE DESFILE FROM BANDEJA_FIRMA_ARBITROS t1  WHERE t1.CODOCUMENTO = ?  ";

		List<BandejaFirmaArbitraje> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap, codocumento);
		BandejaFirmaArbitraje bandeja = new BandejaFirmaArbitraje();
		bandeja = (BandejaFirmaArbitraje) DataAccessUtils.uniqueResult(bandejafirmaList);
		if (null != bandeja && null != bandeja.getObservaciones()) {
			return bandeja.getObservaciones();
		} else {
			return "";
		}

	}

	/**
	 * Devuelve el registro de la bandeja de firma de arbitros mas reciente de
	 * un expediente
	 * 
	 * @param idexpediente
	 *            String
	 * @return BandejaFirmaArbitraje
	 */
	@Transactional(readOnly = true)
	public BandejaFirmaArbitraje findUltimoDocumentoFirmaArbitrosExpediente(String idexpediente) {
		String query = "SELECT t1.IDBANDEJAFIRMAARB IDBANDEJAFIRMAARB, t1.IDEXPEDIENTE IDEXPEDIENTE, t1.EXPEDIENTE EXPEDIENTE, t1.IDTRAMITEHECHO IDTRAMITEHECHO, t1.CODOCUMENTO CODOCUMENTO, t1.IDDOCUMENTUM IDDOCUMENTUM, t1.NOFILE NOFILE, t1.FECHALIMFIRMA FECHALIMFIRMA, t1.FECHAENVIO FECHAENVIO, t1.ESTADO ESTADO, t1.OBSERVACIONES OBSERVACIONES, t1.HASHFILE HASHFILE, t1.ARCODIGO ARCODIGO, t1.DESFILE DESFILE FROM BANDEJA_FIRMA_ARBITROS t1 WHERE IDEXPEDIENTE=? ORDER BY FECHAENVIO DESC";
		List<BandejaFirmaArbitraje> bandejafirmaList = this.jdbcTemplate.query(query, this.rwMap, idexpediente);
		if (null != bandejafirmaList && bandejafirmaList.size() > 0) {
			return bandejafirmaList.get(0);
		} else {
			return null;
		}
	}

}
