package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaFirmaDao  
 * 
 *  
 */

public interface BandejaFirmaArbitrajeDao {

	/**
	 * Inserts a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return BandejaFirmaArbitraje
	 */
	BandejaFirmaArbitraje add(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return BandejaFirmaArbitraje
	 */
	BandejaFirmaArbitraje update(BandejaFirmaArbitraje bandejafirma);

	// /**
	// * Updates a single row in the BandejaFirmaArbitraje table.
	// *
	// * @param bandejafirma
	// * BandejaFirmaArbitraje
	// * @return BandejaFirmaArbitraje
	// */
	// BandejaFirmaArbitraje updateComoFirma(BandejaFirmaArbitraje
	// bandejafirma);

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje updateDocumentoBandejaFirma(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Updates a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje updateHashFileBandejaFirma(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return BandejaFirmaArbitraje
	 */
	BandejaFirmaArbitraje find(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje findByHash(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Deletes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return
	 */
	void remove(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Removes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpediente(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Removes a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            Pagination
	 * @return
	 */
	public void removeBandejaFirmaExpedientePendientes(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Finds a List of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BandejaFirmaArbitraje> findAll(BandejaFirmaArbitraje bandejafirma, Pagination pagination);

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @return Long
	 */
	Long findAllCount(BandejaFirmaArbitraje bandejafirma);

	/**
	 * Finds a List of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(BandejaFirmaArbitraje bandejafirma, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaFirmaCount(BandejaFirmaArbitraje bandejafirma, CensoMonitor censoMonitor);

	/**
	 * Finds a list of rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirmaArbitraje>
	 */
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids);

	/**
	 * Counts rows in the BandejaFirmaArbitraje table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	public Long findAllByIdsCount(List<String> ids);

	/**
	 * Finds rows in the BandejaFirmaArbitraje table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaFirmaArbitraje> findAllLike(BandejaFirmaArbitraje bandejafirma, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the BandejaFirmaArbitraje table using like.
	 * 
	 * @param bandejafirma
	 *            BandejaFirmaArbitraje
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaFirmaArbitraje bandejafirma, Boolean startsWith);

	/**
	 * Finds a single row in the BandejaFirmaArbitraje table.
	 * 
	 * @param codocumento
	 *            Pagination
	 * @return BandejaFirmaArbitraje
	 */
	String findPorCodocumento(String codocumento);

	BandejaFirmaArbitraje updateEstado(BandejaFirmaArbitraje documentoBandejaFirmaArbitraje);

	List<BandejaFirmaArbitraje> findAllLikeEstado(BandejaFirmaArbitraje bandejafirma, Pagination pagination,
			Boolean startsWith);

	/**
	 * Devuelve el registro de la bandeja de firma de arbitros mas reciente de
	 * un expediente
	 * 
	 * @param idexpediente
	 *            String
	 * @return BandejaFirmaArbitraje
	 */
	public BandejaFirmaArbitraje findUltimoDocumentoFirmaArbitrosExpediente(String idexpediente);

}
