package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaCampanhaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BandejaCampanhaDaoImpl implements BandejaCampanhaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaCampanha> rwMap = new RowMapper<BandejaCampanha>() {
		public BandejaCampanha mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new BandejaCampanha(resultSet.getString("TZCODIGO"),
					new Campanha(resultSet.getString("TZCOCM"), resultSet.getString("CMNOMBRE"), null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null),
					new CampanhaProgramacion(resultSet.getString("TZPGCODIGO"), null, null, null, null, null, null,
							null, null, null, null, null, null),
					resultSet.getDate("TZFEDESD"), resultSet.getDate("TZFEHAST"), resultSet.getString("TZCOOR"),
					resultSet.getInt("TZNUMTOMASMUESTRASSOL"), resultSet.getInt("TZNUMCONTROLESESTANDARSOL"),
					resultSet.getInt("TZNUMCONTROLESOTROSSOL"), resultSet.getInt("TZNUMINSPECADICIONALESSOL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha add(BandejaCampanha bandejacampanha) {
		String query = "INSERT INTO BANDEJA_CAMPANHA (TZCODIGO, TZCOCM, TZPGCODIGO, TZFEDESD, TZFEHAST, TZCOOR, TZNUM_TOMAS_MUESTRAS_SOL, TZNUM_CONTROLES_ESTANDAR_SOL, TZNUM_CONTROLES_OTROS_SOL, TZNUM_INSPEC_ADICIONALES_SOL) VALUES (?,?,?,?,?,?,?,?,?,?)";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}
		this.jdbcTemplate.update(query, bandejacampanha.getTzcodigo(), CampanhaCmcodigoAux,
				CampanhaProgramacionPgcodigoAux, bandejacampanha.getTzfedesd(), bandejacampanha.getTzfehast(),
				bandejacampanha.getTzcoor(), bandejacampanha.getTznumTomasMuestrasSol(),
				bandejacampanha.getTznumControlesEstandarSol(), bandejacampanha.getTznumControlesOtrosSol(),
				bandejacampanha.getTznumInspecAdicionalesSol());
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha update(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  WHERE TZCODIGO=? AND TZCOCM=? AND TZPGCODIGO=? AND TZFEDESD=? AND TZFEHAST=? AND TZCOOR=? AND TZNUM_TOMAS_MUESTRAS_SOL=? AND TZNUM_CONTROLES_ESTANDAR_SOL=? AND TZNUM_CONTROLES_OTROS_SOL=? AND TZNUM_INSPEC_ADICIONALES_SOL=?";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}
		this.jdbcTemplate.update(query, bandejacampanha.getTzcodigo(), CampanhaCmcodigoAux,
				CampanhaProgramacionPgcodigoAux, bandejacampanha.getTzfedesd(), bandejacampanha.getTzfehast(),
				bandejacampanha.getTzcoor(), bandejacampanha.getTznumTomasMuestrasSol(),
				bandejacampanha.getTznumControlesEstandarSol(), bandejacampanha.getTznumControlesOtrosSol(),
				bandejacampanha.getTznumInspecAdicionalesSol());
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateInspeccionAdicionalSSCC(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_INSPEC_ADICIONALES_SOL= NVL(TZNUM_INSPEC_ADICIONALES_SOL,0) + ? WHERE TZCOCM=? AND TZPGCODIGO IS NULL ";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, bandejacampanha.getTznumInspecAdicionalesSol(), CampanhaCmcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateInspeccionAdicional(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_INSPEC_ADICIONALES_SOL= NVL(TZNUM_INSPEC_ADICIONALES_SOL,0) + ? WHERE TZPGCODIGO=? ";
		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}
		this.jdbcTemplate.update(query, bandejacampanha.getTznumInspecAdicionalesSol(),
				CampanhaProgramacionPgcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionTomaMuestras(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_TOMAS_MUESTRAS_SOL= NVL(TZNUM_TOMAS_MUESTRAS_SOL,0) - 1 WHERE TZPGCODIGO=? ";

		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}

		this.jdbcTemplate.update(query, CampanhaProgramacionPgcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionTomaMuestrasSSCC(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_TOMAS_MUESTRAS_SOL= NVL(TZNUM_TOMAS_MUESTRAS_SOL,0) - 1 WHERE TZCOCM=? AND TZPGCODIGO IS NULL ";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, CampanhaCmcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlEstandar(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_CONTROLES_ESTANDAR_SOL= NVL(TZNUM_CONTROLES_ESTANDAR_SOL,0) - 1 WHERE TZPGCODIGO=? ";

		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}

		this.jdbcTemplate.update(query, CampanhaProgramacionPgcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlEstandarSSCC(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_CONTROLES_ESTANDAR_SOL= NVL(TZNUM_CONTROLES_ESTANDAR_SOL,0) - 1 WHERE TZCOCM=? AND TZPGCODIGO IS NULL ";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, CampanhaCmcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlOtros(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_CONTROLES_OTROS_SOL= NVL(TZNUM_CONTROLES_OTROS_SOL,0) - 1 WHERE TZPGCODIGO=? ";

		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}

		this.jdbcTemplate.update(query, CampanhaProgramacionPgcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlOtrosSSCC(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_CONTROLES_OTROS_SOL= NVL(TZNUM_CONTROLES_OTROS_SOL,0) - 1 WHERE TZCOCM=? AND TZPGCODIGO IS NULL ";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, CampanhaCmcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionAdicional(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_INSPEC_ADICIONALES_SOL= NVL(TZNUM_INSPEC_ADICIONALES_SOL,0) - 1 WHERE TZPGCODIGO=? ";

		Object CampanhaProgramacionPgcodigoAux = null;
		if (bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			CampanhaProgramacionPgcodigoAux = bandejacampanha.getCampanhaProgramacion().getPgcodigo();
		}

		this.jdbcTemplate.update(query, CampanhaProgramacionPgcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionAdicionalSSCC(BandejaCampanha bandejacampanha) {
		String query = "UPDATE BANDEJA_CAMPANHA SET  TZNUM_INSPEC_ADICIONALES_SOL= NVL(TZNUM_INSPEC_ADICIONALES_SOL,0) - 1 WHERE TZCOCM=? AND TZPGCODIGO IS NULL ";
		Object CampanhaCmcodigoAux = null;
		if (bandejacampanha.getCampanha() != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			CampanhaCmcodigoAux = bandejacampanha.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, CampanhaCmcodigoAux);
		return bandejacampanha;
	}

	/**
	 * Finds a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	@Transactional(readOnly = true)
	public BandejaCampanha find(BandejaCampanha bandejacampanha) {
		String query = "SELECT t1.TZCODIGO TZCODIGO, t1.TZCOCM TZCOCM, t2.CMNOMBRE, t1.TZPGCODIGO TZPGCODIGO, t1.TZFEDESD TZFEDESD, t1.TZFEHAST TZFEHAST, t1.TZCOOR TZCOOR, t1.TZNUM_TOMAS_MUESTRAS_SOL TZNUMTOMASMUESTRASSOL, t1.TZNUM_CONTROLES_ESTANDAR_SOL TZNUMCONTROLESESTANDARSOL, t1.TZNUM_CONTROLES_OTROS_SOL TZNUMCONTROLESOTROSSOL, t1.TZNUM_INSPEC_ADICIONALES_SOL TZNUMINSPECADICIONALESSOL FROM BANDEJA_CAMPANHA t1, CAMPANHA t2  WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO AND t1.TZCODIGO = ? ";

		List<BandejaCampanha> bandejacampanhaList = this.jdbcTemplate.query(query, this.rwMap,
				bandejacampanha.getTzcodigo());
		return (BandejaCampanha) DataAccessUtils.uniqueResult(bandejacampanhaList);
	}

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaCampanha bandejacampanha) {
		String query = "DELETE FROM BANDEJA_CAMPANHA WHERE TZCODIGO=?";
		this.jdbcTemplate.update(query, bandejacampanha.getTzcodigo());
	}

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanhaProgramacion(BandejaCampanha bandejacampanha) {
		String query = "DELETE FROM BANDEJA_CAMPANHA WHERE TZPGCODIGO=?";
		this.jdbcTemplate.update(query, bandejacampanha.getCampanhaProgramacion().getPgcodigo());
	}

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanha(BandejaCampanha bandejacampanha) {
		String query = "DELETE FROM BANDEJA_CAMPANHA WHERE TZCOCM=?";
		this.jdbcTemplate.update(query, bandejacampanha.getCampanha().getCmcodigo());
	}

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanhaSSCC(BandejaCampanha bandejacampanha) {
		String query = "DELETE FROM BANDEJA_CAMPANHA WHERE TZCOCM=? AND TZPGCODIGO IS NULL";
		this.jdbcTemplate.update(query, bandejacampanha.getCampanha().getCmcodigo());
	}

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaCampanha> findAll(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TZCODIGO TZCODIGO,t1.TZCOCM TZCOCM, t2.CMNOMBRE,t1.TZPGCODIGO TZPGCODIGO,t1.TZFEDESD TZFEDESD,t1.TZFEHAST TZFEHAST,t1.TZCOOR TZCOOR,t1.TZNUM_TOMAS_MUESTRAS_SOL TZNUMTOMASMUESTRASSOL,t1.TZNUM_CONTROLES_ESTANDAR_SOL TZNUMCONTROLESESTANDARSOL,t1.TZNUM_CONTROLES_OTROS_SOL TZNUMCONTROLESOTROSSOL,t1.TZNUM_INSPEC_ADICIONALES_SOL TZNUMINSPECADICIONALESSOL ");
		query.append("FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejacampanha, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaCampanha>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(bandejacampanha, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaCampanha> findAllSSCC(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TZCODIGO TZCODIGO,t1.TZCOCM TZCOCM, t2.CMNOMBRE,t1.TZPGCODIGO TZPGCODIGO,t1.TZFEDESD TZFEDESD,t1.TZFEHAST TZFEHAST,t1.TZCOOR TZCOOR,t1.TZNUM_TOMAS_MUESTRAS_SOL TZNUMTOMASMUESTRASSOL,t1.TZNUM_CONTROLES_ESTANDAR_SOL TZNUMCONTROLESESTANDARSOL,t1.TZNUM_CONTROLES_OTROS_SOL TZNUMCONTROLESOTROSSOL,t1.TZNUM_INSPEC_ADICIONALES_SOL TZNUMINSPECADICIONALESSOL ");
		query.append("FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereSSCCMap(bandejacampanha, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaCampanha>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllSSCCCount(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereSSCCMap(bandejacampanha, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaCampanha> findAllLike(BandejaCampanha bandejacampanha, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TZCODIGO TZCODIGO,t1.TZCOCM TZCOCM, t2.CMNOMBRE,t1.TZPGCODIGO TZPGCODIGO,t1.TZFEDESD TZFEDESD,t1.TZFEHAST TZFEHAST,t1.TZCOOR TZCOOR,t1.TZNUM_TOMAS_MUESTRAS_SOL TZNUMTOMASMUESTRASSOL,t1.TZNUM_CONTROLES_ESTANDAR_SOL TZNUMCONTROLESESTANDARSOL,t1.TZNUM_CONTROLES_OTROS_SOL TZNUMCONTROLESOTROSSOL,t1.TZNUM_INSPEC_ADICIONALES_SOL TZNUMINSPECADICIONALESSOL ");
		query.append("FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejacampanha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaCampanha>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaCampanha bandejacampanha, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM BANDEJA_CAMPANHA t1, CAMPANHA t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejacampanha, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TZCOCM=t2.CMCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaCampanha entity
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha Bean with the criteria values to filter by.
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(BandejaCampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejacampanha != null && bandejacampanha.getTzcodigo() != null) {
			where.append(" AND t1.TZCODIGO = ?");
			params.add(bandejacampanha.getTzcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getCampanha() != null
				&& bandejacampanha.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(bandejacampanha.getCampanha().getCmcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			where.append(" AND t1.PGCODIGO = ?");
			params.add(bandejacampanha.getCampanhaProgramacion().getPgcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getTzfedesd() != null) {
			where.append(" AND t1.TZFEDESD = ?");
			params.add(bandejacampanha.getTzfedesd());
		}
		if (bandejacampanha != null && bandejacampanha.getTzfehast() != null) {
			where.append(" AND t1.TZFEHAST = ?");
			params.add(bandejacampanha.getTzfehast());
		}

		where.append(" AND t1.TZCOOR = ?");
		params.add(bandejacampanha.getTzcoor());

		where.append(" AND t2.CMACTIVA = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		if (bandejacampanha != null && bandejacampanha.getTznumTomasMuestrasSol() != null) {
			where.append(" AND t1.TZNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(bandejacampanha.getTznumTomasMuestrasSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesEstandarSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(bandejacampanha.getTznumControlesEstandarSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesOtrosSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_OTROS_SOL = ?");
			params.add(bandejacampanha.getTznumControlesOtrosSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumInspecAdicionalesSol() != null) {
			where.append(" AND t1.TZNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(bandejacampanha.getTznumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaCampanha entity
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha Bean with the criteria values to filter by.
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereSSCCMap(BandejaCampanha bandejacampanha, CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(BandejaCampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejacampanha != null && bandejacampanha.getTzcodigo() != null) {
			where.append(" AND t1.TZCODIGO = ?");
			params.add(bandejacampanha.getTzcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getCampanha() != null
				&& bandejacampanha.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(bandejacampanha.getCampanha().getCmcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getCampanhaProgramacion() != null
				&& bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			where.append(" AND t1.PGCODIGO = ?");
			params.add(bandejacampanha.getCampanhaProgramacion().getPgcodigo());
		}
		if (bandejacampanha != null && bandejacampanha.getTzfedesd() != null) {
			where.append(" AND t1.TZFEDESD = ?");
			params.add(bandejacampanha.getTzfedesd());
		}
		if (bandejacampanha != null && bandejacampanha.getTzfehast() != null) {
			where.append(" AND t1.TZFEHAST = ?");
			params.add(bandejacampanha.getTzfehast());
		}

		where.append(" AND t1.TZCOOR IS NULL");

		where.append(" AND t2.CMACTIVA = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		if (bandejacampanha != null && bandejacampanha.getTznumTomasMuestrasSol() != null) {
			where.append(" AND t1.TZNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(bandejacampanha.getTznumTomasMuestrasSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesEstandarSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(bandejacampanha.getTznumControlesEstandarSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesOtrosSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_OTROS_SOL = ?");
			params.add(bandejacampanha.getTznumControlesOtrosSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumInspecAdicionalesSol() != null) {
			where.append(" AND t1.TZNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(bandejacampanha.getTznumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaCampanha entity
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaCampanha bandejacampanha, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BandejaCampanhaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejacampanha != null && bandejacampanha.getTzcodigo() != null) {
			where.append(" AND UPPER(t1.TZCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejacampanha.getTzcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejacampanha.getTzcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TZCODIGO IS NOT NULL");
		}
		if (bandejacampanha != null && bandejacampanha.getCampanha().getCmcodigo() != null) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejacampanha.getCampanha().getCmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejacampanha.getCampanha().getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.CMCODIGO IS NOT NULL");
		}
		if (bandejacampanha != null && bandejacampanha.getCampanhaProgramacion().getPgcodigo() != null) {
			where.append(" AND UPPER(t1.PGCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejacampanha.getCampanhaProgramacion().getPgcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejacampanha.getCampanhaProgramacion().getPgcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PGCODIGO IS NOT NULL");
		}
		if (bandejacampanha != null && bandejacampanha.getTzfedesd() != null) {
			where.append(" AND t1.TZFEDESD = ?");
			params.add(bandejacampanha.getTzfedesd());
		}
		if (bandejacampanha != null && bandejacampanha.getTzfehast() != null) {
			where.append(" AND t1.TZFEHAST = ?");
			params.add(bandejacampanha.getTzfehast());
		}
		if (bandejacampanha != null && bandejacampanha.getTzcoor() != null) {
			where.append(" AND UPPER(t1.TZCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejacampanha.getTzcoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejacampanha.getTzcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.TZCOOR IS NOT NULL");
		}
		if (bandejacampanha != null && bandejacampanha.getTznumTomasMuestrasSol() != null) {
			where.append(" AND t1.TZNUM_TOMAS_MUESTRAS_SOL = ?");
			params.add(bandejacampanha.getTznumTomasMuestrasSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesEstandarSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_ESTANDAR_SOL = ?");
			params.add(bandejacampanha.getTznumControlesEstandarSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumControlesOtrosSol() != null) {
			where.append(" AND t1.TZNUM_CONTROLES_OTROS_SOL = ?");
			params.add(bandejacampanha.getTznumControlesOtrosSol());
		}
		if (bandejacampanha != null && bandejacampanha.getTznumInspecAdicionalesSol() != null) {
			where.append(" AND t1.TZNUM_INSPEC_ADICIONALES_SOL = ?");
			params.add(bandejacampanha.getTznumInspecAdicionalesSol());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
