package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaCampanhaDao  
 * 
 *  
 */

public interface BandejaCampanhaDao {

	/**
	 * Inserts a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha add(BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha update(BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateInspeccionAdicional(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateInspeccionAdicionalSSCC(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionTomaMuestras(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionTomaMuestrasSSCC(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlEstandar(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlEstandarSSCC(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlOtros(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionControlOtrosSSCC(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionAdicional(
			BandejaCampanha bandejacampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return BandejaCampanha
	 */
	public BandejaCampanha updateEliminarInspeccionAdicionalSSCC(
			BandejaCampanha bandejacampanha);

	/**
	 * Finds a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha find(BandejaCampanha bandejacampanha);

	/**
	 * Deletes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @return
	 */
	void remove(BandejaCampanha bandejacampanha);

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanha(BandejaCampanha bandejacampanha);

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanhaProgramacion(
			BandejaCampanha bandejacampanha);

	/**
	 * Removes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            Pagination
	 * @return
	 */
	public void removeBandejaCampanhaSSCC(BandejaCampanha bandejacampanha);

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAll(BandejaCampanha bandejacampanha,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaCampanha bandejacampanha,
			CensoMonitor censoMonitor);

	/**
	 * Finds rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaCampanha> findAllLike(BandejaCampanha bandejacampanha,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaCampanha bandejacampanha, Boolean startsWith);

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAllSSCC(BandejaCampanha bandejacampanha,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejacampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllSSCCCount(BandejaCampanha bandejacampanha,
			CensoMonitor censoMonitor);
}
