package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * BandejaAlertaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BandejaAlertaDaoImpl implements BandejaAlertaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<BandejaAlerta> rwMap = new RowMapper<BandejaAlerta>() {
		public BandejaAlerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new BandejaAlerta(
					resultSet.getString("V5CODIGO"),
					resultSet.getString("ALCODIGO"),
					resultSet.getString("CRCODIGO"),
					resultSet.getString("CRCOOR"),
					resultSet.getString("CRCODIGODISTRIBUIDOR"),
					resultSet.getDate("CRFECHACOMUNICACION"),
					resultSet.getInt("CRCNACTU"),
					new Alerta(
							resultSet.getString("ALCODIGO"),
							resultSet.getString("ALCOOR"),
							resultSet.getLong("ALNRAN"),
							resultSet.getString("ALNROR"),
							resultSet.getDate("ALFEEN"),
							resultSet.getDate("ALFEPLRR"),
							resultSet.getString("ALCOPS"),
							resultSet.getString("PRODUCTOPSNOMBRE"),
							resultSet.getString("PRODUCTOPSNOMBREE"),
							resultSet.getString("ALNOPRSE"),
							resultSet.getString("ALNRLOPS"),
							resultSet.getString("ALNOMAPS"),
							resultSet.getString("ALNOMOPS"),
							resultSet.getDate("ALFEDUMI"),
							resultSet.getString("ALCOCA"),
							resultSet.getString("ALCOPA"),
							resultSet.getString("ALCOTOP"),
							resultSet.getString("ALTEIN"),
							resultSet.getString("ALCOES"),
							resultSet.getDate("ALFERRIN"),
							resultSet.getString("ALINRE"),
							resultSet.getDate("ALFECOOR"),
							resultSet.getString("ALCOTMO"),
							resultSet.getString("ALAECOSAN"),
							resultSet.getString("ALACTIVA"),
							resultSet.getString("ALANULADA"),
							resultSet.getDate("ALFECHAANULACION"),
							resultSet.getString("ALINDICACIONES"),
							resultSet.getString("ALCODIGOBARRAS"),
							resultSet.getString("ALORIGENPRODUCTO"),
							resultSet.getString("ALCCAAPRODUCTO"),
							resultSet.getString("ALPAISPRODUCTO"),
							null,
							new NaturalezaPeligro(
									resultSet
											.getString("NatPeligroIDNATURALEZAPELIGRO"),
									resultSet
											.getString("NatPeligroNATURALEZAPELIGRO"),
									resultSet
											.getString("NatPeligroNATURALEZAPELIGROE")),
							null), new Intervinientes(
							resultSet.getString("IDINTERVINIENTE"),
							resultSet.getString("DTCODIGO"),
							resultSet.getString("ESCODIGO"),
							resultSet.getString("ENTIDAD_ID"),
							resultSet.getString("NOMBRE"),
							resultSet.getString("APELLIDO1"),
							resultSet.getString("APELLIDO2"),
							resultSet.getString("ESNOCO"),
							resultSet.getString("DTINTIPID"),
							resultSet.getString("NIF"),
							resultSet.getString("DTRANGO_EDAD"),
							resultSet.getString("DTCOSX"),
							resultSet.getString("COIDCO"),
							resultSet.getString("ESTEURL"),
							resultSet.getString("ESNOPECO"),
							resultSet.getDate("ESFEBA"),
							resultSet.getString("NRTEL"),
							resultSet.getString("NRTEL2"),
							resultSet.getString("COEM"),
							resultSet.getString("EXTRANJERO"),
							resultSet.getString("NORAPROVINCIAID"),
							resultSet.getString("NOMBREPROVINCIA"),
							resultSet.getString("NORAMUNICIPIOID"),
							resultSet.getString("NOMBREMUNICIPIO"),
							resultSet.getString("NORALOCALIDADID"),
							resultSet.getString("NOMBRELOCALIDAD"),
							resultSet.getString("NORACALLEID"),
							resultSet.getString("NOMBRECALLE"),
							resultSet.getString("NORACPID"),
							resultSet.getString("NOMBRECP"),
							resultSet.getString("NORAPORTALID"),
							resultSet.getString("NOMBREPORTAL"),
							resultSet.getString("NOMBREPISO"),
							resultSet.getString("NORAPAISID"),
							resultSet.getString("NOMBREPAIS"),
							resultSet.getString("DIRECCIONNOCAPV"),
							resultSet.getString("DIRECCIONANTIGUA"),
							resultSet.getString("INADAR"),
							resultSet.getString("SECODIGO"),
							resultSet.getString("SENOMBRE"),
							resultSet.getString("SENOMBREE"),
							resultSet.getString("TIPOINTERVINIENTE"),
							resultSet.getString("HDCODIGO"), null,
							resultSet.getString("INFEMOD"),
							resultSet.getString("INCOZS"), null),
					resultSet.getDate("CRFECHAPLAZO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta add(BandejaAlerta bandejaalerta) {
		String query = "INSERT INTO BANDEJA_ALERTA (V5CODIGO, ALCODIGO, CRCODIGO, CRCOOR, CRCODIGODISTRIBUIDOR, CRFECHACOMUNICACION, CRCNACTU) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, bandejaalerta.getV5codigo(),
				bandejaalerta.getAlcodigo(), bandejaalerta.getCrcodigo(),
				bandejaalerta.getCrcoor(),
				bandejaalerta.getCrcodigodistribuidor(),
				bandejaalerta.getCrfechacomunicacion(),
				bandejaalerta.getCrcnactu());
		return bandejaalerta;
	}

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateNumInspecciones(BandejaAlerta bandejaalerta) {
		String query = "UPDATE BANDEJA_ALERTA SET CRCNACTU=? WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getCrcnactu(),
				bandejaalerta.getCrcodigo());
		return bandejaalerta;
	}

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta update(BandejaAlerta bandejaalerta) {
		String query = "UPDATE BANDEJA_ALERTA SET ALCODIGO=?, CRCODIGO=?, CRCOOR=?, CRCODIGODISTRIBUIDOR=?, CRFECHACOMUNICACION=?, CRCNACTU=? WHERE V5CODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getAlcodigo(),
				bandejaalerta.getCrcodigo(), bandejaalerta.getCrcoor(),
				bandejaalerta.getCrcodigodistribuidor(),
				bandejaalerta.getCrfechacomunicacion(),
				bandejaalerta.getCrcnactu(), bandejaalerta.getV5codigo());
		return bandejaalerta;
	}

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateEliminarInspeccionNumActuaciones(
			BandejaAlerta bandejaalerta) {
		String query = "UPDATE BANDEJA_ALERTA SET  CRCNACTU=NVL(CRCNACTU,0) - 1 WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getCrcodigo());
		return bandejaalerta;
	}

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateEliminarInspeccionNumActuacionesSSCC(
			BandejaAlerta bandejaalerta) {
		String query = "UPDATE BANDEJA_ALERTA SET  CRCNACTU=NVL(CRCNACTU,0) - 1 WHERE ALCODIGO=? AND CRCODIGO IS NULL ";
		this.jdbcTemplate.update(query, bandejaalerta.getAlcodigo());
		return bandejaalerta;
	}

	/**
	 * Finds a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	@Transactional(readOnly = true)
	public BandejaAlerta find(BandejaAlerta bandejaalerta) {
		StringBuilder query = new StringBuilder(
				"SELECT  t0.V5CODIGO V5CODIGO,t0.CRCODIGO CRCODIGO,t0.CRCOOR CRCOOR,t0.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR,t0.CRFECHACOMUNICACION CRFECHACOMUNICACION,t0.CRCNACTU CRCNACTU, ");
		query.append(" t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALCOCA ALCOCA,t1.ALCOPA ALCOPA,t1.ALCOTOP ALCOTOP,t1.ALTEIN ALTEIN,t1.ALCOES ALCOES,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t1.ALAECOSAN ALAECOSAN,t1.ALACTIVA ALACTIVA,t1.ALANULADA ALANULADA,t1.ALFECHAANULACION ALFECHAANULACION,t1.ALINDICACIONES ALINDICACIONES,t1.ALCODIGOBARRAS ALCODIGOBARRAS,t1.ALORIGENPRODUCTO ALORIGENPRODUCTO,t1.ALCCAAPRODUCTO ALCCAAPRODUCTO,t1.ALPAISPRODUCTO ALPAISPRODUCTO,t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO,t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO,t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE, ");
		query.append(" t6.IDINTERVINIENTE IDINTERVINIENTE, t6.DTCODIGO DTCODIGO, t6.ESCODIGO ESCODIGO, t6.ENTIDAD_ID ENTIDAD_ID, t6.NOMBRE NOMBRE, t6.APELLIDO1 APELLIDO1,t6.APELLIDO2 APELLIDO2,t6.ESNOCO ESNOCO,t6.DTINTIPID DTINTIPID,t6.NIF NIF, t6.DTRANGO_EDAD DTRANGO_EDAD, t6.DTCOSX DTCOSX, t6.COIDCO COIDCO, t6.ESTEURL ESTEURL, t6.ESNOPECO ESNOPECO, t6.ESFEBA ESFEBA,t6.NRTEL NRTEL, t6.NRTEL2 NRTEL2, t6.COEM COEM, t6.EXTRANJERO EXTRANJERO, t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL, t6.NOMBRE_PISO NOMBREPISO, t6.NORA_PAIS_ID NORAPAISID, t6.NOMBRE_PAIS NOMBREPAIS, t6.DIRECCION_NOCAPV DIRECCIONNOCAPV, t6.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t6.INADAR INADAR, t6.SECODIGO SECODIGO, t6.SENOMBRE SENOMBRE, t6.SENOMBREE SENOMBREE, t6.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t6.HDCODIGO HDCODIGO, t6.INFEMOD INFEMOD, t6.INCOZS, t7.CRFECHAPLAZO ");
		query.append(" FROM BANDEJA_ALERTA t0, ALERTA t1, NATURALEZA_PELIGRO t3, PRODUCTO t4, DISTRIBUIDOR t5, INTERVINIENTES t6 ");
		query.append(" WHERE 1=1 AND t0.ALCODIGO=t1.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) AND t1.ALCODIGO = t5.RDCOAL(+) AND t5.RDIDINTERVINIENTE=t6.IDINTERVINIENTE(+) WHERE t0.V5CODIGO = ?  ");

		List<BandejaAlerta> bandejaalertaList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, bandejaalerta.getV5codigo());
		return (BandejaAlerta) DataAccessUtils.uniqueResult(bandejaalertaList);
	}

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaAlerta bandejaalerta) {
		String query = "DELETE FROM BANDEJA_ALERTA WHERE V5CODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getV5codigo());
	}

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return
	 */
	public void removeBandejaAlertaProgramacion(BandejaAlerta bandejaalerta) {
		String query = "DELETE FROM BANDEJA_ALERTA WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getCrcodigo());
	}

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return
	 */
	public void removeBandejaAlertaSSCC(BandejaAlerta bandejaalerta) {
		String query = "DELETE FROM BANDEJA_ALERTA WHERE ALCODIGO=? AND CRCODIGO IS NULL";
		this.jdbcTemplate.update(query, bandejaalerta.getAlcodigo());
	}

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return
	 */
	public void removeBandejaAlertaAlerta(BandejaAlerta bandejaalerta) {
		String query = "DELETE FROM BANDEJA_ALERTA WHERE ALCODIGO=?";
		this.jdbcTemplate.update(query, bandejaalerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaAlerta> findAll(BandejaAlerta bandejaalerta,
			CensoMonitor censoMonitor, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t0.V5CODIGO V5CODIGO,t0.CRCODIGO CRCODIGO,t0.CRCOOR CRCOOR,t0.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR,t0.CRFECHACOMUNICACION CRFECHACOMUNICACION,t0.CRCNACTU CRCNACTU, ");
		query.append(" t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALCOCA ALCOCA,t1.ALCOPA ALCOPA,t1.ALCOTOP ALCOTOP,t1.ALTEIN ALTEIN,t1.ALCOES ALCOES,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t1.ALAECOSAN ALAECOSAN,t1.ALACTIVA ALACTIVA,t1.ALANULADA ALANULADA,t1.ALFECHAANULACION ALFECHAANULACION,t1.ALINDICACIONES ALINDICACIONES,t1.ALCODIGOBARRAS ALCODIGOBARRAS,t1.ALORIGENPRODUCTO ALORIGENPRODUCTO,t1.ALCCAAPRODUCTO ALCCAAPRODUCTO,t1.ALPAISPRODUCTO ALPAISPRODUCTO,t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO,t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO,t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE, ");
		query.append(" t6.IDINTERVINIENTE IDINTERVINIENTE, t6.DTCODIGO DTCODIGO, t6.ESCODIGO ESCODIGO, t6.ENTIDAD_ID ENTIDAD_ID, t6.NOMBRE NOMBRE, t6.APELLIDO1 APELLIDO1,t6.APELLIDO2 APELLIDO2,t6.ESNOCO ESNOCO,t6.DTINTIPID DTINTIPID,t6.NIF NIF, t6.DTRANGO_EDAD DTRANGO_EDAD, t6.DTCOSX DTCOSX, t6.COIDCO COIDCO, t6.ESTEURL ESTEURL, t6.ESNOPECO ESNOPECO, t6.ESFEBA ESFEBA,t6.NRTEL NRTEL, t6.NRTEL2 NRTEL2, t6.COEM COEM, t6.EXTRANJERO EXTRANJERO, t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL, t6.NOMBRE_PISO NOMBREPISO, t6.NORA_PAIS_ID NORAPAISID, t6.NOMBRE_PAIS NOMBREPAIS, t6.DIRECCION_NOCAPV DIRECCIONNOCAPV, t6.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t6.INADAR INADAR, t6.SECODIGO SECODIGO, t6.SENOMBRE SENOMBRE, t6.SENOMBREE SENOMBREE, t6.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t6.HDCODIGO HDCODIGO, t6.INFEMOD INFEMOD, t6.INCOZS, t7.CRFECHAPLAZO ");
		query.append(" FROM BANDEJA_ALERTA t0, ALERTA t1, NATURALEZA_PELIGRO t3, PRODUCTO t4, DISTRIBUIDOR t5, INTERVINIENTES t6, ALERTA_PROGRAMACION t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMap(bandejaalerta, censoMonitor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t0.ALCODIGO=t1.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) AND t0.CRCODIGODISTRIBUIDOR = t5.RDCODIGO(+) AND t5.RDIDINTERVINIENTE=t6.IDINTERVINIENTE(+) AND t0.CRCODIGO=t7.CRCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaAlerta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaAlerta bandejaalerta,
			CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_ALERTA t0, ALERTA t1, NATURALEZA_PELIGRO t3, PRODUCTO t4, DISTRIBUIDOR t5, INTERVINIENTES t6, ALERTA_PROGRAMACION t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMap(bandejaalerta, censoMonitor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t0.ALCODIGO=t1.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) AND t0.CRCODIGODISTRIBUIDOR = t5.RDCODIGO(+) AND t5.RDIDINTERVINIENTE=t6.IDINTERVINIENTE(+) AND t0.CRCODIGO=t7.CRCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaAlerta> findAllLike(BandejaAlerta bandejaalerta,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t0.V5CODIGO V5CODIGO,t0.CRCODIGO CRCODIGO,t0.CRCOOR CRCOOR,t0.CRCODIGODISTRIBUIDOR CRCODIGODISTRIBUIDOR,t0.CRFECHACOMUNICACION CRFECHACOMUNICACION,t0.CRCNACTU CRCNACTU, ");
		query.append(" t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALCOCA ALCOCA,t1.ALCOPA ALCOPA,t1.ALCOTOP ALCOTOP,t1.ALTEIN ALTEIN,t1.ALCOES ALCOES,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t1.ALAECOSAN ALAECOSAN,t1.ALACTIVA ALACTIVA,t1.ALANULADA ALANULADA,t1.ALFECHAANULACION ALFECHAANULACION,t1.ALINDICACIONES ALINDICACIONES,t1.ALCODIGOBARRAS ALCODIGOBARRAS,t1.ALORIGENPRODUCTO ALORIGENPRODUCTO,t1.ALCCAAPRODUCTO ALCCAAPRODUCTO,t1.ALPAISPRODUCTO ALPAISPRODUCTO,t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO,t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO,t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE, ");
		query.append(" t6.IDINTERVINIENTE IDINTERVINIENTE, t6.DTCODIGO DTCODIGO, t6.ESCODIGO ESCODIGO, t6.ENTIDAD_ID ENTIDAD_ID, t6.NOMBRE NOMBRE, t6.APELLIDO1 APELLIDO1,t6.APELLIDO2 APELLIDO2,t6.ESNOCO ESNOCO,t6.DTINTIPID DTINTIPID,t6.NIF NIF, t6.DTRANGO_EDAD DTRANGO_EDAD, t6.DTCOSX DTCOSX, t6.COIDCO COIDCO, t6.ESTEURL ESTEURL, t6.ESNOPECO ESNOPECO, t6.ESFEBA ESFEBA,t6.NRTEL NRTEL, t6.NRTEL2 NRTEL2, t6.COEM COEM, t6.EXTRANJERO EXTRANJERO, t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL, t6.NOMBRE_PISO NOMBREPISO, t6.NORA_PAIS_ID NORAPAISID, t6.NOMBRE_PAIS NOMBREPAIS, t6.DIRECCION_NOCAPV DIRECCIONNOCAPV, t6.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t6.INADAR INADAR, t6.SECODIGO SECODIGO, t6.SENOMBRE SENOMBRE, t6.SENOMBREE SENOMBREE, t6.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t6.HDCODIGO HDCODIGO, t6.INFEMOD INFEMOD, t6.INCOZS, t7.CRFECHAPLAZO ");
		query.append(" FROM BANDEJA_ALERTA t0, ALERTA t1, NATURALEZA_PELIGRO t3, PRODUCTO t4, DISTRIBUIDOR t5, INTERVINIENTES t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejaalerta,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t0.ALCODIGO=t1.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) AND t0.CRCODIGODISTRIBUIDOR = t5.RDCODIGO(+) AND t5.RDIDINTERVINIENTE=t6.IDINTERVINIENTE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<BandejaAlerta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(BandejaAlerta bandejaalerta, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_ALERTA t0, ALERTA t1, NATURALEZA_PELIGRO t3, PRODUCTO t4, DISTRIBUIDOR t5, INTERVINIENTES t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(bandejaalerta,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t0.ALCODIGO=t1.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) AND t0.CRCODIGODISTRIBUIDOR = t5.RDCODIGO(+) AND t5.RDIDINTERVINIENTE=t6.IDINTERVINIENTE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaAlerta entity
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta Bean with the criteria values to filter by.
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(BandejaAlerta bandejaalerta,
			CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(
				BandejaAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejaalerta != null && bandejaalerta.getV5codigo() != null) {
			where.append(" AND t0.V5CODIGO = ?");
			params.add(bandejaalerta.getV5codigo());
		}
		if (bandejaalerta != null && bandejaalerta.getAlcodigo() != null) {
			where.append(" AND t0.ALCODIGO = ?");
			params.add(bandejaalerta.getAlcodigo());
		}
		if (bandejaalerta != null && bandejaalerta.getCrcodigo() != null) {
			where.append(" AND t0.CRCODIGO = ?");
			params.add(bandejaalerta.getCrcodigo());
		}

		if (censoMonitor != null
				&& censoMonitor.getPerfilOrganizacion() != null
				&& !censoMonitor
						.getPerfilOrganizacion()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			where.append(" AND t0.CRCOOR = ?");
			params.add(bandejaalerta.getCrcoor());
		} else {
			where.append(" AND t0.CRCOOR IS NULL");
		}

		if (bandejaalerta != null
				&& bandejaalerta.getCrcodigodistribuidor() != null) {
			where.append(" AND t0.CRCODIGODISTRIBUIDOR = ?");
			params.add(bandejaalerta.getCrcodigodistribuidor());
		}
		if (bandejaalerta != null
				&& bandejaalerta.getCrfechacomunicacion() != null) {
			where.append(" AND t0.CRFECHACOMUNICACION = ?");
			params.add(bandejaalerta.getCrfechacomunicacion());
		}
		if (bandejaalerta != null && bandejaalerta.getCrcnactu() != null) {
			where.append(" AND t0.CRCNACTU = ?");
			params.add(bandejaalerta.getCrcnactu());
		}

		where.append(" AND t1.ALACTIVA = ? ");
		params.add(Y41bConstantes.VALOR_SI);

		where.append(" AND t7.CRFECHACIERRE IS NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaAlerta entity
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(BandejaAlerta bandejaalerta,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				BandejaAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (bandejaalerta != null && bandejaalerta.getV5codigo() != null) {
			where.append(" AND UPPER(t1.V5CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejaalerta.getV5codigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejaalerta.getV5codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V5CODIGO IS NOT NULL");
		}
		if (bandejaalerta != null && bandejaalerta.getAlcodigo() != null) {
			where.append(" AND UPPER(t1.ALCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejaalerta.getAlcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejaalerta.getAlcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ALCODIGO IS NOT NULL");
		}
		if (bandejaalerta != null && bandejaalerta.getCrcodigo() != null) {
			where.append(" AND UPPER(t1.CRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejaalerta.getCrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + bandejaalerta.getCrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCODIGO IS NOT NULL");
		}
		if (bandejaalerta != null && bandejaalerta.getCrcoor() != null) {
			where.append(" AND UPPER(t1.CRCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejaalerta.getCrcoor().toUpperCase() + "%");
			} else {
				params.add("%" + bandejaalerta.getCrcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.CRCOOR IS NOT NULL");
		}
		if (bandejaalerta != null
				&& bandejaalerta.getCrcodigodistribuidor() != null) {
			where.append(" AND UPPER(t1.CRCODIGODISTRIBUIDOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(bandejaalerta.getCrcodigodistribuidor()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ bandejaalerta.getCrcodigodistribuidor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCODIGODISTRIBUIDOR IS NOT NULL");
		}
		if (bandejaalerta != null
				&& bandejaalerta.getCrfechacomunicacion() != null) {
			where.append(" AND t1.CRFECHACOMUNICACION = ?");
			params.add(bandejaalerta.getCrfechacomunicacion());
		}
		if (bandejaalerta != null && bandejaalerta.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(bandejaalerta.getCrcnactu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
