package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaAlertaDao  
 * 
 *  
 */

public interface BandejaAlertaDao {

	/**
	 * Inserts a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta add(BandejaAlerta bandejaalerta);

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta update(BandejaAlerta bandejaalerta);

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateNumInspecciones(BandejaAlerta bandejaalerta);

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateEliminarInspeccionNumActuaciones(
			BandejaAlerta bandejaalerta);

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return BandejaAlerta
	 */
	public BandejaAlerta updateEliminarInspeccionNumActuacionesSSCC(
			BandejaAlerta bandejaalerta);

	/**
	 * Finds a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta find(BandejaAlerta bandejaalerta);

	/**
	 * Deletes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return
	 */
	void remove(BandejaAlerta bandejaalerta);

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return
	 */
	public void removeBandejaAlertaProgramacion(BandejaAlerta bandejaalerta);

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @return
	 */
	public void removeBandejaAlertaSSCC(BandejaAlerta bandejaalerta);

	/**
	 * Removes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            Pagination
	 * @return
	 */
	public void removeBandejaAlertaAlerta(BandejaAlerta bandejaalerta);

	/**
	 * Finds a List of rows in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaAlerta> findAll(BandejaAlerta bandejaalerta,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaAlerta table.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaAlerta bandejaalerta,
			CensoMonitor censoMonitor);

	/**
	 * Finds rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaAlerta> findAllLike(BandejaAlerta bandejaalerta,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaalerta
	 *            BandejaAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaAlerta bandejaalerta, Boolean startsWith);
}
