package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.CensoMonitor;

/**
 * AsientoRegistralDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AsientoRegistralDaoImpl implements AsientoRegistralDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AsientoRegistral> rwMap = new RowMapper<AsientoRegistral>() {
		public AsientoRegistral mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return new AsientoRegistral(resultSet.getString("ID_ASIENTO_REGISTRAL"), resultSet.getString("PCODIGO"),
					resultSet.getString("PNOMBRE"), resultSet.getString("PNOMBREE"),
					resultSet.getTimestamp("FECHA_REGISTRO"), resultSet.getString("NUM_REGISTRO"),
					resultSet.getString("SOLICITANTE"), resultSet.getString("RESUMEN"),
					resultSet.getString("TERRITORIOHISTORICO"), resultSet.getString("TERRITORIOHISTORICONOMBRE"),
					resultSet.getTimestamp("FECHA_REGISTRO_ORIGEN"), resultSet.getString("NUM_REGISTRO_ORIGEN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AsientoRegistral> findAllBandejaAsientoRegistral(AsientoRegistral asientoRegistral,
			CensoMonitor censoMonitor, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ASIENTO_REGISTRAL ID_ASIENTO_REGISTRAL, t1.PCODIGO PCODIGO, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE,t1.FECHA_REGISTRO FECHA_REGISTRO, t1.NUM_REGISTRO NUM_REGISTRO, t1.SOLICITANTE SOLICITANTE, t1.RESUMEN RESUMEN, t1.TERRITORIOHISTORICO TERRITORIOHISTORICO, t3.DS_O TERRITORIOHISTORICONOMBRE, t1.FECHA_REGISTRO_ORIGEN FECHA_REGISTRO_ORIGEN, t1.NUM_REGISTRO_ORIGEN NUM_REGISTRO_ORIGEN ");
		query.append("FROM ASIENTO_REGISTRAL t1 , TIPO_PROCEDIMIENTO t2, T17_PROVINCIA t3 ");

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO = t2.PCODIGO AND t1.TERRITORIOHISTORICO= t3.ID ");

		if (censoMonitor != null && censoMonitor.getOrganismo() != null
				&& censoMonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.TERRITORIOHISTORICO LIKE ? ");
			params.add(censoMonitor.getOrganismo().getCodOrg().substring(0, 2));
		}
		if (asientoRegistral != null && asientoRegistral.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO LIKE ? ");
			params.add(asientoRegistral.getPcodigo());
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AsientoRegistral>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AsientoRegistral t able.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBandejaAsientoRegistralCount(AsientoRegistral asientoRegistral, CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ASIENTO_REGISTRAL t1, TIPO_PROCEDIMIENTO t2, T17_PROVINCIA t3 ");

		List<Object> params = new ArrayList<Object>();
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND  t1.PCODIGO = t2.PCODIGO AND t1.TERRITORIOHISTORICO= t3.ID ");
		if (censoMonitor != null && censoMonitor.getOrganismo() != null
				&& censoMonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.TERRITORIOHISTORICO LIKE ? ");
			params.add(censoMonitor.getOrganismo().getCodOrg().substring(0, 2));
		}
		if (asientoRegistral != null && asientoRegistral.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO LIKE ? ");
			params.add(asientoRegistral.getPcodigo());
		}
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Inserts a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return AsientoRegistral
	 */
	public AsientoRegistral add(AsientoRegistral asientoRegistral) {
		String query = "INSERT INTO ASIENTO_REGISTRAL (ID_ASIENTO_REGISTRAL, PCODIGO, FECHA_REGISTRO, NUM_REGISTRO, SOLICITANTE, RESUMEN,TERRITORIOHISTORICO, TERRITORIOHISTORICONOMBRE, FECHA_REGISTRO_ORIGEN, NUM_REGISTRO_ORIGEN) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, asientoRegistral.getIdAsiento(), asientoRegistral.getPcodigo(),
				asientoRegistral.getFechaRegistro(), asientoRegistral.getNumRegistro(),
				asientoRegistral.getSolicitante(), asientoRegistral.getResumen(),
				asientoRegistral.getTerritorioHistorico(), asientoRegistral.getTerritorioHistoricoNombre(),
				asientoRegistral.getFechaRegistroOrigen(), asientoRegistral.getNumRegistroOrigen());
		return asientoRegistral;
	}

	/**
	 * Finds a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @return AsientoRegistral
	 */
	@Transactional(readOnly = true)
	public AsientoRegistral findAsientoRegistral(AsientoRegistral asientoRegistral) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_ASIENTO_REGISTRAL ID_ASIENTO_REGISTRAL, t1.PCODIGO PCODIGO, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE,t1.FECHA_REGISTRO FECHA_REGISTRO, t1.NUM_REGISTRO NUM_REGISTRO, t1.SOLICITANTE SOLICITANTE, t1.RESUMEN RESUMEN, t1.TERRITORIOHISTORICO TERRITORIOHISTORICO,t3.DS_O TERRITORIOHISTORICONOMBRE, t1.FECHA_REGISTRO_ORIGEN FECHA_REGISTRO_ORIGEN, t1.NUM_REGISTRO_ORIGEN NUM_REGISTRO_ORIGEN ");
		query.append("FROM ASIENTO_REGISTRAL t1 , TIPO_PROCEDIMIENTO t2 , T17_PROVINCIA t3 ");
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO = t2.PCODIGO AND t1.TERRITORIOHISTORICO= t3.ID AND t1.ID_ASIENTO_REGISTRAL=?");
		query.append(where);

		return (AsientoRegistral) this.jdbcTemplate.queryForObject(query.toString(), new RowMapper<AsientoRegistral>() {
			public AsientoRegistral mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				return new AsientoRegistral(resultSet.getString("ID_ASIENTO_REGISTRAL"), resultSet.getString("PCODIGO"),
						resultSet.getString("PNOMBRE"), resultSet.getString("PNOMBREE"),
						resultSet.getTimestamp("FECHA_REGISTRO"), resultSet.getString("NUM_REGISTRO"),
						resultSet.getString("SOLICITANTE"), resultSet.getString("RESUMEN"),
						resultSet.getString("TERRITORIOHISTORICO"), resultSet.getString("TERRITORIOHISTORICONOMBRE"),
						resultSet.getTimestamp("FECHA_REGISTRO_ORIGEN"), resultSet.getString("NUM_REGISTRO_ORIGEN"));
			}
		}, asientoRegistral.getIdAsiento()

		);
	}

	/**
	 * Removes a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeAsientoRegistral(AsientoRegistral asientoRegistral) {
		String query = "DELETE FROM ASIENTO_REGISTRAL WHERE ID_ASIENTO_REGISTRAL=?";
		this.jdbcTemplate.update(query, asientoRegistral.getIdAsiento());
	}
}