package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.CensoMonitor;

/**
 * AsientoRegistralDao  
 * 
 *  
 */

public interface AsientoRegistralDao {

	/**
	 * Finds a List of rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AsientoRegistral> findAllBandejaAsientoRegistral(AsientoRegistral asientoRegistral,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaAsientoRegistralCount(AsientoRegistral asientoRegistral, CensoMonitor censoMonitor);

	/**
	 * Inserts a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return AsientoRegistral
	 */
	public AsientoRegistral add(AsientoRegistral asientoRegistral);

	/**
	 * Finds a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @return AsientoRegistral
	 */
	public AsientoRegistral findAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * Removes a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeAsientoRegistral(AsientoRegistral asientoRegistral);
}
