package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbitro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arta1;

/**
 * Arta1DaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class Arta1DaoImpl implements Arta1Dao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arta1> rwMap = new RowMapper<Arta1>() {
		public Arta1 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arta1(new Arbitro(resultSet.getString("M3COAR"), null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null), resultSet.getString("M3COTA1"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Pagination
	 * @return Arta1
	 */
	public Arta1 add(Arta1 arta1) {
		String query = "INSERT INTO ARTA1 (M3COAR, M3COTA1) VALUES (?,?)";
		Object ArbitroArcodigoAux = null;
		if (arta1.getArbitro() != null
				&& arta1.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = arta1.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ArbitroArcodigoAux, arta1.getM3cota1());
		return arta1;
	}

	/**
	 * Updates a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Pagination
	 * @return Arta1
	 */
	public Arta1 update(Arta1 arta1) {
		String query = "UPDATE ARTA1 SET  WHERE M3COAR=? AND M3COTA1=?";
		Object ArbitroArcodigoAux = null;
		if (arta1.getArbitro() != null
				&& arta1.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = arta1.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ArbitroArcodigoAux, arta1.getM3cota1());
		return arta1;
	}

	/**
	 * Finds a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Pagination
	 * @return Arta1
	 */
	@Transactional(readOnly = true)
	public Arta1 find(Arta1 arta1) {
		String query = "SELECT t1.M3COAR M3COAR, t1.M3COTA1 M3COTA1 FROM ARTA1 t1  WHERE t1.M3COAR = ?   AND t1.M3COTA1 = ?  ";

		List<Arta1> arta1List = this.jdbcTemplate.query(query, this.rwMap,
				arta1.getArbitro().getArcodigo(), arta1.getM3cota1());
		return (Arta1) DataAccessUtils.uniqueResult(arta1List);
	}

	/**
	 * Removes a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Pagination
	 * @return
	 */
	public void remove(Arta1 arta1) {
		String query = "DELETE FROM ARTA1 WHERE M3COAR=? AND M3COTA1 IN ('01','20','48') ";
		this.jdbcTemplate.update(query, arta1.getArbitro().getArcodigo()/*
																		 * ,
																		 * arta1
																		 * .
																		 * getM3cota1
																		 * ()
																		 */);
	}

	/**
	 * Finds a List of rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arta1> findAll(Arta1 arta1, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M3COAR M3COAR,t1.M3COTA1 M3COTA1 ");
		query.append("FROM ARTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arta1 arta1) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arta1);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arta1> findAllLike(Arta1 arta1, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M3COAR M3COAR,t1.M3COTA1 M3COTA1 ");
		query.append("FROM ARTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arta1>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arta1 arta1, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARTA1 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arta1, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arta1 entity
	 * 
	 * @param arta1
	 *            Arta1 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arta1 arta1) {

		StringBuilder where = new StringBuilder(
				Arta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arta1 != null && arta1.getArbitro().getArcodigo() != null) {
			where.append(" AND t1.M3COAR = ?");
			params.add(arta1.getArbitro().getArcodigo());
		}
		if (arta1 != null && arta1.getM3cota1() != null) {
			where.append(" AND t1.M3COTA1 = ?");
			params.add(arta1.getM3cota1());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arta1 entity
	 * 
	 * @param arta1
	 *            Arta1 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arta1 arta1, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Arta1DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arta1 != null && arta1.getArbitro().getArcodigo() != null) {
			where.append(" AND UPPER(t1.M3COAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arta1.getArbitro().getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arta1.getArbitro().getArcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M3COAR IS NOT NULL");
		}
		if (arta1 != null && arta1.getM3cota1() != null) {
			where.append(" AND UPPER(t1.M3COTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arta1.getM3cota1().toUpperCase() + "%");
			} else {
				params.add("%" + arta1.getM3cota1().toUpperCase() + "%");
			}
			where.append(" AND t1.M3COTA1 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
