package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arse;
import com.ejie.y41b.model.Sector;

/**
 * ArseDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArseDaoImpl implements ArseDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arse> rwMap = new RowMapper<Arse>() {
		public Arse mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arse arse = new Arse();
			Arbitro arbitro = new Arbitro();
			arbitro.setArcodigo(resultSet.getString("M4COAR"));
			arse.setArbitro(arbitro);
			arse.setM4cose(resultSet.getString("M4COSE"));
			Sector sector = new Sector();
			sector.setSecodigo(resultSet.getString("M4COSE"));
			sector.setSenombre(resultSet.getString("SectorSENOMBRE"));
			sector.setSenombree(resultSet.getString("SectorSENOMBREE"));
			arse.setSector(sector);
			return arse;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arse table.
	 * 
	 * @param arse
	 *            Pagination
	 * @return Arse
	 */
	public Arse add(Arse arse) {
		String query = "INSERT INTO Y41BC2T00 (M4COAR, M4COSE) VALUES (?,?)";
		Object ArbitroArcodigoAux = null;
		if (arse.getArbitro() != null
				&& arse.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = arse.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ArbitroArcodigoAux, arse.getM4cose());
		return arse;
	}

	/**
	 * Updates a single row in the Arse table.
	 * 
	 * @param arse
	 *            Pagination
	 * @return Arse
	 */
	public Arse update(Arse arse) {
		String query = "UPDATE ARSE SET  WHERE M4COAR=? AND M4COSE=?";
		Object ArbitroArcodigoAux = null;
		if (arse.getArbitro() != null
				&& arse.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = arse.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ArbitroArcodigoAux, arse.getM4cose());
		return arse;
	}

	/**
	 * Finds a single row in the Arse table.
	 * 
	 * @param arse
	 *            Pagination
	 * @return Arse
	 */
	@Transactional(readOnly = true)
	public Arse find(Arse arse) {
		String query = "SELECT t1.M4COAR M4COAR, t1.M4COSE M4COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE FROM Y41BC2T00 t1, SECTOR t2  WHERE t1.M4COSE=t2.SECODIGO(+) AND t1.M4COAR = ?   AND t1.M4COSE = ?  ";

		List<Arse> arseList = this.jdbcTemplate.query(query, this.rwMap, arse
				.getArbitro().getArcodigo(), arse.getM4cose());
		return (Arse) DataAccessUtils.uniqueResult(arseList);
	}

	/**
	 * Removes a single row in the Arse table.
	 * 
	 * @param arse
	 *            Pagination
	 * @return
	 */
	public void remove(Arse arse) {
		String query = "DELETE FROM Y41BC2T00 WHERE M4COAR=? AND M4COSE=?";
		this.jdbcTemplate.update(query, arse.getArbitro().getArcodigo(),
				arse.getM4cose());
	}

	/**
	 * Finds a List of rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arse> findAll(Arse arse, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M4COAR M4COAR,t1.M4COSE M4COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BC2T00 t1, SECTOR t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arse);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M4COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arse>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arse arse) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BC2T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arse);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arse> findAllLike(Arse arse, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M4COAR M4COAR,t1.M4COSE M4COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BC2T00 t1, SECTOR t2  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arse, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M4COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arse>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arse arse, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BC2T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arse, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arse entity
	 * 
	 * @param arse
	 *            Arse Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arse arse) {

		StringBuilder where = new StringBuilder(ArseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arse != null && arse.getArbitro().getArcodigo() != null) {
			where.append(" AND t1.M4COAR = ?");
			params.add(arse.getArbitro().getArcodigo());
		}
		if (arse != null && arse.getM4cose() != null) {
			where.append(" AND t1.M4COSE = ?");
			params.add(arse.getM4cose());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arse entity
	 * 
	 * @param arse
	 *            Arse Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arse arse, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arse != null && arse.getArbitro().getArcodigo() != null) {
			where.append(" AND UPPER(t1.M4COAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arse.getArbitro().getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arse.getArbitro().getArcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M4COAR IS NOT NULL");
		}
		if (arse != null && arse.getM4cose() != null) {
			where.append(" AND UPPER(t1.M4COSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arse.getM4cose().toUpperCase() + "%");
			} else {
				params.add("%" + arse.getM4cose().toUpperCase() + "%");
			}
			where.append(" AND t1.M4COSE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * @param arbitro
	 *            Arbitro
	 */
	public void volcarArbitroSectores(Arbitro arbitro) {
		String query = "DELETE FROM Y41BC2T00 WHERE M4COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
		query = "INSERT INTO Y41BC2T00 SELECT M4COAR,M4COSE FROM ARSE WHERE M4COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
	}

	/**
	 * @param arse
	 *            Arse
	 */
	public void removeArse(Arse arse) {
		String query = "DELETE FROM ARSE WHERE M4COAR = ? ";
		this.jdbcTemplate.update(query, arse.getArbitro().getArcodigo());
	}

	/**
	 * @param arse
	 *            Arse
	 */
	public void addArse(Arse arse) {
		String query = "INSERT INTO ARSE (M4COAR, M4COSE) VALUES (?,?)";
		Object ArbitroOecodigoAux = null;
		if (arse.getArbitro() != null
				&& arse.getArbitro().getArcodigo() != null) {
			ArbitroOecodigoAux = arse.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, ArbitroOecodigoAux, arse.getM4cose());

	}
}
