package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arse;

/**
 * ArseDao  
 * 
 *  
 */

public interface ArseDao {

	/**
	 * Inserts a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse add(Arse arse);

	/**
	 * Updates a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse update(Arse arse);

	/**
	 * Finds a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse find(Arse arse);

	/**
	 * Deletes a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return
	 */
	void remove(Arse arse);

	/**
	 * Finds a List of rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arse> findAll(Arse arse, Pagination pagination);

	/**
	 * Counts rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Long
	 */
	Long findAllCount(Arse arse);

	/**
	 * Finds rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arse> findAllLike(Arse arse, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arse arse, Boolean startsWith);

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	void volcarArbitroSectores(Arbitro arbitro);

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param arse
	 *            Arse
	 */
	void removeArse(Arse arse);

	/**
	 * Aadir sobre la tabla temporal
	 * 
	 * @param arse
	 *            Arse
	 */
	void addArse(Arse arse);

}
