package com.ejie.y41b.dao;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Tipsubsana;
import com.ejie.y41b.model.Tramite;

//import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbtramexpDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArbtramexpDaoImpl implements ArbtramexpDao {

	private static final Logger logger = LoggerFactory.getLogger(ArbtramexpDaoImpl.class);

	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbtramexp> rwMap = new RowMapper<Arbtramexp>() {
		public Arbtramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils.cargarDatosBDVO(resultSet);

			CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("TRMOCODIGO"),
					resultSet.getString("MONOMBRE"));

			CensoMonitor censoMonitorEj = new CensoMonitor(resultSet.getString("TRMOCODIGOEJ"),
					resultSet.getString("MONOMBREEJ"));

			Solarb solarb = new Solarb(resultSet.getString("SACODIGO"));
			solarb.setSacoja(resultSet.getString("SACOJA"));
			solarb.setSanror(resultSet.getBigDecimal("SANROR"));
			solarb.setSanran(resultSet.getBigDecimal("SANRAN"));
			Arbexp arbexp = new Arbexp(resultSet.getString("SACODIGO"));
			solarb.setArbexp(arbexp);

			Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);

			Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("TRID"), resultSet.getTimestamp("TRFECINI"),
					resultSet.getTimestamp("TRFECFIN"), resultSet.getString("TRNOMTRAMES"),
					resultSet.getDate("TRRESOFECHA"), resultSet.getString("TRRESOTIPO"),
					resultSet.getBigDecimal("TRRESOIMPORTE"), resultSet.getDate("TRFECENVIO"),
					resultSet.getDate("TRFECCIERRE"), resultSet.getString("TRTIPONOT"), resultSet.getString("TRESTADO"),
					null, null, null, null, resultSet.getDate("TRFECBOPV"), resultSet.getDate("TRFECINITABL"),
					resultSet.getDate("TRFECNOTIF"), resultSet.getBigDecimal("TRUAIDINTERV"),
					resultSet.getString("TRCODIGOREL"), resultSet.getString("TRIDNOTIFPLATEA"),
					resultSet.getDate("TRFECREGS"), resultSet.getString("TRTIPOCOM"),
					resultSet.getString("TRESTADOACUSE"), resultSet.getString("TRNUMREGS"),
					resultSet.getDate("TRFECACUSE"), resultSet.getString("TRIDESPERAPLATEA"),
					resultSet.getString("TRMATARESPERA"), resultSet.getString("TRASUNTOCOMUNICACION"),
					resultSet.getString("TRTIPONOTPLATEA"), resultSet.getString("TRSEDE"),
					resultSet.getString("TRCODREM"), resultSet.getString("TRENVREM"),
					resultSet.getString("TRIDMAILORIGEN"), resultSet.getString("TRMAILORIGEN"),
					resultSet.getString("TRIDMAILDESTINO"), resultSet.getString("TRMAILDESTINO"),
					resultSet.getDate("TRFECHAENVIOBOPVBOE"), resultSet.getString("TRPROCEEDINGSIDPLATEA"),
					resultSet.getString("TRMONITOR"), resultSet.getDate("TRFECRECEPCION"),
					resultSet.getString("TRRESPSUBSANA"), resultSet.getString("TRADHERIDA"),
					resultSet.getString("TRANALISIS"), resultSet.getString("TRRESPARB"),
					resultSet.getString("TRHAYCONTEST"), resultSet.getString("TRTIPOARBITRAJE"),
					resultSet.getDate("TRFECDESIGNA"), resultSet.getString("TRINTICA"),
					resultSet.getString("TRTIPOAUDIENCIA"), resultSet.getDate("TRFECCITACION"),
					resultSet.getString("TRHORACITACION"), resultSet.getString("TRNORAPROVINCIAID"),
					resultSet.getString("TRNORAMUNICIPIOID"), resultSet.getString("TRNORALOCALIDADID"),
					resultSet.getString("TRNORACPID"), resultSet.getString("TRNORACALLEID"),
					resultSet.getString("TRNORAPORTALID"), resultSet.getString("TRNOMBREPISO"),
					resultSet.getString("TRNODIR"), resultSet.getString("TRNRTEL"),
					resultSet.getDate("TRFECSUSPENSION"), resultSet.getString("TRMOTIVO"),
					resultSet.getString("TRNOTCOMRECLAMADO"), resultSet.getString("TRNOTCOMRECLAMANTE"),
					resultSet.getString("TRNOTCOMTERCEROS"), resultSet.getDate("TRFECAUDIENCIA"),
					resultSet.getString("TRHORAAUDIENCIA"), resultSet.getString("TRSOLPRUEBA"),
					resultSet.getBigDecimal("TRIDDECISION"), resultSet.getString("TRREALIZADAPOR"),
					resultSet.getString("TRAINSTANCIADE"), resultSet.getString("TRCOPE1"),
					resultSet.getString("TRCOPE2"), resultSet.getDate("TRFECINFORME"),
					resultSet.getString("TRRESPPAGOPER"), resultSet.getBigDecimal("TRIMPORTE"),
					resultSet.getString("TRREFFACTURA"), resultSet.getDate("TRFECEMISION"),
					resultSet.getDate("TRFECDESIS"), resultSet.getString("TRCOT5"), resultSet.getDate("TRFECAUERDO"),
					resultSet.getString("TRCOSAAC"), resultSet.getString("TRCOMOTR"), resultSet.getString("TRCOORTR"),
					resultSet.getString("TRMONOL"), resultSet.getString("TRRESULTADO"),
					resultSet.getString("TRMODOLAUDO"), resultSet.getBigDecimal("TRIMPRECONV"),
					resultSet.getString("TRRESPMOTIV"), resultSet.getBigDecimal("TRAINSTCOPIA"),
					resultSet.getDate("TRFEOPLA"), resultSet.getString("TRTIPOSOLAC"), resultSet.getString("TRVALORAC"),
					resultSet.getDate("TRFECREM"), resultSet.getString("TRTEL1MEDIACION"),
					resultSet.getString("TRTEL2MEDIACION"), resultSet.getString("TRTEL3MEDIACION"),
					resultSet.getString("TRHORAMEDIACIONINICIO"), resultSet.getString("TRHORAMEDIACIONFIN"),
					resultSet.getBigDecimal("TRINTERVORIGEN"), resultSet.getString("TRTIPOALEGA"), fase, tramite,
					censoMonitor, censoMonitorEj, resultSet.getString("TRTRIDREL"), solarb,
					resultSet.getString("TRCLUGAUD"), resultSet.getString("TRFICHADO"), null, null, null, null);

			arbtramexp.setTrcodigo(resultSet.getString("TRCODIGO"));
			arbtramexp.setTrexcodigo(resultSet.getString("TREXCODIGO"));
			arbtramexp.setTrcopexptipo(resultSet.getString("TRCOPEXPTIPO"));
			arbtramexp.setTrobserves(resultSet.getClob("TROBSERVES"));
			arbtramexp.setTrtexto(resultSet.getClob("TRTEXTO"));
			arbtramexp.setTrsiguientestramites(resultSet.getClob("TRSIGUIENTESTRAMITES"));
			arbtramexp.setTrresumen(resultSet.getClob("TRRESUMEN"));
			arbtramexp.setTrlimitaciones(resultSet.getClob("TRLIMITACIONES"));
			arbtramexp.setTrobjeto(resultSet.getClob("TROBJETO"));
			arbtramexp.setTrdecision(resultSet.getClob("TRDECISION"));
			arbtramexp.setTrjustificacion(resultSet.getClob("TRJUSTIFICACION"));
			arbtramexp.setTrinterlocutor(resultSet.getClob("TRINTERLOCUTOR"));
			try {
				arbtramexp.setEnvcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
				arbtramexp.setEnvcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
			} catch (Exception e) {
				ArbtramexpDaoImpl.logger.debug("CAMPO ENVCDESSITCORREOSES NO PRESENTE");
				ArbtramexpDaoImpl.logger.debug("CAMPO ENVCDESSITCORREOSEU NO PRESENTE");
			}
			arbtramexp.setTridioma(resultSet.getString("TRIDIOMA"));
			arbtramexp.setTracusereintentado((columnasSeleccionadas.contains("TRACUSEREINTENTADO"))
					? resultSet.getString("TRACUSEREINTENTADO") : null);
			arbtramexp.setTrautomatico(
					(columnasSeleccionadas.contains("TRAUTOMATICO")) ? resultSet.getString("TRAUTOMATICO") : null);
			arbtramexp.setTipoDestOrigen(resultSet.getString("TRDESTORIGEN"));
			arbtramexp.setTrrespuesta(resultSet.getString("TRRESPUESTA"));
			arbtramexp.setTrresumenalegaciones(resultSet.getClob("TRRESUMENALEGACIONES"));
			arbtramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));
			arbtramexp.setTrIsSir(resultSet.getString("TRISSIR"));
			arbtramexp.setTrIsSirConNumRegEntOri(resultSet.getString("TRISSIRCONNUMREGENTORI"));
			arbtramexp.setTrExcluirCierre(resultSet.getString("TREXCLUIRCIERRE"));
			return arbtramexp;
		}
	};

	private RowMapper<Arbtramexp> rwMapTRID = new RowMapper<Arbtramexp>() {
		public Arbtramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(resultSet.getString("TRID"));
			arbtramexp.setFase(new Fase(resultSet.getString("TRFCODIGO")));
			arbtramexp.setTrnomtrames(resultSet.getString("TRNOMTRAMES"));
			arbtramexp.setTrfecini(resultSet.getTimestamp("TRFECINI"));
			arbtramexp.setTrfecfin(resultSet.getTimestamp("TRFECFIN"));
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(resultSet.getString("TRCODIGO"));
			tramite.setTrnombre(resultSet.getString("TRNOMBRE"));
			tramite.setTrnombree(resultSet.getString("TRNOMBREE"));
			arbtramexp.setTramite(tramite);
			return arbtramexp;
		}
	};

	private RowMapper<Arbtramexp> rwMapUltimoTRID = new RowMapper<Arbtramexp>() {
		public Arbtramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(resultSet.getString("TRID"));
			arbtramexp.setFase(new Fase(resultSet.getString("TRFCODIGO")));
			arbtramexp.setTrnomtrames(resultSet.getString("TRNOMTRAMES"));
			arbtramexp.setTrfecini(resultSet.getTimestamp("TRFECINI"));
			arbtramexp.setTrfecfin(resultSet.getTimestamp("TRFECFIN"));
			arbtramexp.setTrrealizadapor(resultSet.getString("TRREALIZADAPOR"));
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(resultSet.getString("TRCODIGO"));
			tramite.setTrnombre(resultSet.getString("TRNOMBRE"));
			tramite.setTrnombree(resultSet.getString("TRNOMBREE"));
			arbtramexp.setTramite(tramite);
			return arbtramexp;
		}
	};

	private RowMapper<NotificacionesComunicacionesBusqueda> rwMapNotifiComunica = new RowMapper<NotificacionesComunicacionesBusqueda>() {
		public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionesComunicacionesBusqueda(resultSet.getString("TRID"),
					resultSet.getString("CODEXPEDIENTE"), resultSet.getString("EXCOOR"), resultSet.getString("EXNRAN"),
					resultSet.getBigDecimal("EXNROR"), null, resultSet.getDate("EHFECHAINICIO"),
					resultSet.getString("EHNUMREGISTROSALIDA"), resultSet.getString("EHTIPONOTIFICACIONPLATEA"),
					resultSet.getString("TRMOCODIGOEJ"), resultSet.getString("MONOMBRE"),
					resultSet.getString("UAIDINTERV"), resultSet.getString("NIF"),
					resultSet.getString("NOMBREDESTINATARIO"), resultSet.getString("NOMBRECOMERCIALDESTINATARIO"),
					resultSet.getString("EXTRANJERO"), resultSet.getString("NOMBRE_PROVINCIA"),
					resultSet.getString("NOMBRE_MUNICIPIO"), resultSet.getString("NOMBRE_LOCALIDAD"),
					resultSet.getString("NOMBRE_CP"), resultSet.getString("NOMBRE_CALLE"),
					resultSet.getString("NOMBREPORTAL"), resultSet.getString("NOMBREPISO"),
					resultSet.getString("NOMBREPAIS"), resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("DIRECCIONANTIGUA"), resultSet.getString("DIRECCION1"),
					resultSet.getString("DIRECCION2"), resultSet.getString("TRASUNTOCOMUNICACION"),
					resultSet.getString("EHESTADOTRAMITE"), resultSet.getString("EHSEDE"),
					resultSet.getString("ESCODIGO"), resultSet.getString("EXCODIGO"), resultSet.getString("CODORG"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIAORG"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIOORG"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDADORG"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLEORG"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECPORG"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTALORG"),
					resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
					resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"),
					resultSet.getString("TRCODIGO"), resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("USUARIOXLNET"), resultSet.getString("PUESTOXLNET"),
					resultSet.getString("ENVCESTADO"), resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"), resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODSITCORREOS"), resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"), resultSet.getDate("ENVFECHAACTUALIZACION"),
					resultSet.getString("ENVCCODBARRAS"), resultSet.getString("IDTRAMITEACUSERELACIONADO"),
					resultSet.getString("EHACUSERECIBORECIBIDO"));

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return Arbtramexp
	 */
	public Arbtramexp add(Arbtramexp arbtramexp) {
		String query = "INSERT INTO ARBTRAMEXP (TRID, TRCODIGO, TREXCODIGO, TRFECINI, TRFECFIN, TROBSERVES, TRNOMTRAMES, TRMOCODIGO, TRMOCODIGOEJ, TRTRIDREL, TRRESOFECHA, TRRESOTIPO, TRRESOIMPORTE, TRFECENVIO, TRFECCIERRE, TRFCODIGO, TRTIPONOT, TRESTADO, TRFECBOPV, TRFECINITABL, TRFECNOTIF, TRUAIDINTERV, TRCODIGOREL, TRIDNOTIFPLATEA, TRFECREGS, TRTIPOCOM, TRESTADOACUSE, TRNUMREGS, TRFECACUSE, TRIDESPERAPLATEA, TRMATARESPERA, TRASUNTOCOMUNICACION, TRTIPONOTPLATEA, TRSEDE, TRCODREM, TRENVREM, TRIDMAILORIGEN, TRMAILORIGEN, TRIDMAILDESTINO, TRMAILDESTINO, TRFECHAENVIOBOPVBOE, TRPROCEEDINGSIDPLATEA, TRMONITOR, TRFECRECEPCION, TRRESPSUBSANA, TRADHERIDA, TRANALISIS, TRRESPARB, TRHAYCONTEST, TRTIPOARBITRAJE, TRFECDESIGNA, TRINTICA, TRTIPOAUDIENCIA, TRFECCITACION, TRHORACITACION, TRNORA_PROVINCIA_ID, TRNORA_MUNICIPIO_ID,TRNORA_LOCALIDAD_ID,TRNORA_CP_ID,TRNORA_CALLE_ID, TRNORA_PORTAL_ID, TRNOMBRE_PISO, TRNODIR, TRNRTEL, TRFECSUSPENSION, TRMOTIVO, TRNOTCOMRECLAMADO, TRNOTCOMRECLAMANTE, TRNOTCOMTERCEROS, TRFECAUDIENCIA, TRHORAAUDIENCIA, TRSOLPRUEBA, TRIDDECISION, TRREALIZADAPOR, TRAINSTANCIADE, TRCOPE1, TRCOPE2, TRFECINFORME, TRRESPPAGOPER, TRIMPORTE, TRREFFACTURA, TRFECEMISION, TRFECDESIS, TRCOT5, TRFECAUERDO, TRCOSAAC, TRCOMOTR, TRCOORTR, TRMONOL, TRRESULTADO, TRMODOLAUDO, TRIMPRECONV, TRRESPMOTIV, TRAINSTCOPIA, TRFEOPLA, TRTIPOSOLAC, TRVALORAC, TRFECREM, TRTEL1MEDIACION, TRTEL2MEDIACION, TRTEL3MEDIACION, TRHORAMEDIACIONINICIO, TRHORAMEDIACIONFIN, TRINTERVORIGEN, TRTIPOALEGA,TRCLUGAUD, TRFICHADO, TRCOPEXPTIPO, TRIDIOMA, TRAUTOMATICO, TRDESTORIGEN, TRRESPUESTA, TRRESUMENALEGACIONES, TRISTELEMATICA, TRISSIR, TRISSIRCONNUMREGENTORI, TREXCLUIRCIERRE) VALUES (?,?,?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?)";

		Object getSolarbSacodigoAux = null;
		Object getCensoMonitorAux = null;
		Object getCensoMonitorEjAux = null;
		Object getFaseAux = null;
		if (arbtramexp.getTrid() == null) {
			arbtramexp.setTrid(this.getNewPK().toString());
		}
		if (arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			getSolarbSacodigoAux = arbtramexp.getSolarb().getSacodigo();
		}
		if (arbtramexp.getCensoMonitor() != null && arbtramexp.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorAux = arbtramexp.getCensoMonitor().getMocodigo();
		}
		if (arbtramexp.getCensoMonitorEj() != null && arbtramexp.getCensoMonitorEj().getMocodigo() != null) {
			getCensoMonitorEjAux = arbtramexp.getCensoMonitorEj().getMocodigo();
		}
		if (arbtramexp.getFase() != null && arbtramexp.getFase().getFcodigo() != null) {
			getFaseAux = arbtramexp.getFase().getFcodigo();
		}
		arbtramexp.setTrfecini(new Date());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp.getTrestado())) {
			arbtramexp.setTrfecfin(new Date());
		}
		this.jdbcTemplate.update(query, arbtramexp.getTrid(), arbtramexp.getTrcodigo(), getSolarbSacodigoAux,
				arbtramexp.getTrfecini(), arbtramexp.getTrfecfin(), Y41bUtils.clobToString(arbtramexp.getTrobserves()),
				arbtramexp.getTrnomtrames(), getCensoMonitorAux, getCensoMonitorEjAux, arbtramexp.getTrtridrel(),
				arbtramexp.getTrresofecha(), arbtramexp.getTrresotipo(), arbtramexp.getTrresoimporte(),
				arbtramexp.getTrfecenvio(), arbtramexp.getTrfeccierre(), getFaseAux, arbtramexp.getTrtiponot(),
				arbtramexp.getTrestado(), arbtramexp.getTrfecbopv(), arbtramexp.getTrfecinitabl(),
				arbtramexp.getTrfecnotif(), arbtramexp.getTruaidinterv(), arbtramexp.getTrcodigorel(),
				arbtramexp.getTridnotifplatea(), arbtramexp.getTrfecregs(), arbtramexp.getTrtipocom(),
				arbtramexp.getTrestadoacuse(), arbtramexp.getTrnumregs(), arbtramexp.getTrfecacuse(),
				arbtramexp.getTridesperaplatea(), arbtramexp.getTrmatarespera(), arbtramexp.getTrasuntocomunicacion(),
				arbtramexp.getTrtiponotplatea(), arbtramexp.getTrsede(), arbtramexp.getTrcodrem(),
				arbtramexp.getTrenvrem(), arbtramexp.getTridmailorigen(), arbtramexp.getTrmailorigen(),
				arbtramexp.getTridmaildestino(), arbtramexp.getTrmaildestino(), arbtramexp.getTrfechaenviobopvboe(),
				arbtramexp.getTrproceedingsidplatea(), arbtramexp.getTrmonitor(), arbtramexp.getTrfecrecepcion(),
				arbtramexp.getTrrespsubsana(), arbtramexp.getTradherida(), arbtramexp.getTranalisis(),
				arbtramexp.getTrresparb(), arbtramexp.getTrhaycontest(), arbtramexp.getTrtipoarbitraje(),
				arbtramexp.getTrfecdesigna(), arbtramexp.getTrintica(), arbtramexp.getTrtipoaudiencia(),
				arbtramexp.getTrfeccitacion(), arbtramexp.getTrhoracitacion(), arbtramexp.getTrnoraProvinciaId(),
				arbtramexp.getTrnoraMunicipioId(), arbtramexp.getTrnoraLocalidadId(), arbtramexp.getTrnoraCpId(),
				arbtramexp.getTrnoraCalleId(), arbtramexp.getTrnoraPortalId(), arbtramexp.getTrnombrePiso(),
				arbtramexp.getTrnodir(), arbtramexp.getTrnrtel(), arbtramexp.getTrfecsuspension(),
				arbtramexp.getTrmotivo(), arbtramexp.getTrnotcomreclamado(), arbtramexp.getTrnotcomreclamante(),
				arbtramexp.getTrnotcomterceros(), arbtramexp.getTrfecaudiencia(), arbtramexp.getTrhoraaudiencia(),
				arbtramexp.getTrsolprueba(), arbtramexp.getTriddecision(), arbtramexp.getTrrealizadapor(),
				arbtramexp.getTrainstanciade(), arbtramexp.getTrcope1(), arbtramexp.getTrcope2(),
				arbtramexp.getTrfecinforme(), arbtramexp.getTrresppagoper(), arbtramexp.getTrimporte(),
				arbtramexp.getTrreffactura(), arbtramexp.getTrfecemision(), arbtramexp.getTrfecdesis(),
				arbtramexp.getTrcot5(), arbtramexp.getTrfecauerdo(), arbtramexp.getTrcosaac(), arbtramexp.getTrcomotr(),
				arbtramexp.getTrcoortr(), arbtramexp.getTrmonol(), arbtramexp.getTrresultado(),
				arbtramexp.getTrmodolaudo(), arbtramexp.getTrimpreconv(), arbtramexp.getTrrespmotiv(),
				arbtramexp.getTrainstcopia(), arbtramexp.getTrfeopla(), arbtramexp.getTrtiposolac(),
				arbtramexp.getTrvalorac(), arbtramexp.getTrfecrem(), arbtramexp.getTrtel1mediacion(),
				arbtramexp.getTrtel2mediacion(), arbtramexp.getTrtel3mediacion(), arbtramexp.getTrhoramediacioninicio(),
				arbtramexp.getTrhoramediacionfin(), arbtramexp.getTrintervorigen(), arbtramexp.getTrtipoalega(),
				arbtramexp.getTrclugaud(), arbtramexp.getTrfichado(), arbtramexp.getTrcopexptipo(),
				arbtramexp.getTridioma(), arbtramexp.getTrautomatico(), arbtramexp.getTipoDestOrigen(),
				arbtramexp.getTrrespuesta(), Y41bUtils.clobToString(arbtramexp.getTrresumenalegaciones()),
				arbtramexp.getTristelematica(), arbtramexp.getTrIsSir(), arbtramexp.getTrIsSirConNumRegEntOri(),
				arbtramexp.getTrExcluirCierre());

		// Cuando se trata de una notificacion o comunicacion actualizamos
		// el campo TRTEXTO por separado
		if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRTEXTO = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrtexto()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRSIGUIENTESTRAMITES = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrsiguientestramites()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRRESUMEN = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrresumen()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRINTERLOCUTOR = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrinterlocutor()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRLIMITACIONES = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrlimitaciones()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TROBJETO = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrobjeto()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRDECISION = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrdecision()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_PROPUESTA_SANCIONADOR.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRJUSTIFICACION = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrjustificacion()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		return arbtramexp;
	}

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return Arbtramexp
	 */
	public Arbtramexp update(Arbtramexp arbtramexp) {
		// String query =
		// "UPDATE ARBTRAMEXP SET
		// TRCODIGO=?,TREXCODIGO=?,/*TRFECINI=?,*/TRFECFIN=?,TROBSERVES=?,TRNOMTRAMES=?,TRMOCODIGO=?,TRMOCODIGOEJ=?,TRRESOFECHA=?,TRRESOTIPO=?,TRRESOIMPORTE=?,TRFECENVIO=?,"
		String query = "UPDATE ARBTRAMEXP SET TRCODIGO=?,TREXCODIGO=?,TRFECFIN=?,TROBSERVES=?,TRNOMTRAMES=?,TRMOCODIGO=?,TRMOCODIGOEJ=?,TRRESOFECHA=?,TRRESOTIPO=?,TRRESOIMPORTE=?,TRFECENVIO=?,"
				+ "TRFECCIERRE=?,TRFCODIGO=?,TRTIPONOT=?,TRESTADO=?,TRFECBOPV=?,TRFECINITABL=?,TRFECNOTIF=?,TRUAIDINTERV=?,TRCODIGOREL=?,TRIDNOTIFPLATEA=?,TRFECREGS=?,TRTIPOCOM=?,TRESTADOACUSE=?,TRNUMREGS=?,TRFECACUSE=?,TRIDESPERAPLATEA=?,TRMATARESPERA=?,TRASUNTOCOMUNICACION=?,TRTIPONOTPLATEA=?,TRSEDE=?,TRCODREM=?,TRENVREM=?,TRIDMAILORIGEN=?,TRMAILORIGEN=?,TRIDMAILDESTINO=?,TRMAILDESTINO=?,TRFECHAENVIOBOPVBOE=?,TRPROCEEDINGSIDPLATEA=?,TRMONITOR=?,TRFECRECEPCION=?,TRRESPSUBSANA=?,TRADHERIDA=?,TRANALISIS=?,TRRESPARB=?,TRHAYCONTEST=?,TRTIPOARBITRAJE=?,TRFECDESIGNA=?,TRINTICA=?,TRTIPOAUDIENCIA=?,TRFECCITACION=?,TRHORACITACION=?,TRNORA_PROVINCIA_ID=?, TRNORA_MUNICIPIO_ID=?,TRNORA_LOCALIDAD_ID=?,TRNORA_CP_ID=?,TRNORA_CALLE_ID=?, TRNORA_PORTAL_ID=?, TRNOMBRE_PISO=?, TRNODIR=?, TRNRTEL=?,TRFECSUSPENSION=?,TRMOTIVO=?,TRNOTCOMRECLAMADO=?,TRNOTCOMRECLAMANTE=?,TRNOTCOMTERCEROS=?,TRFECAUDIENCIA=?,TRHORAAUDIENCIA=?,TRSOLPRUEBA=?,TRIDDECISION=?,TRREALIZADAPOR=?,TRAINSTANCIADE=?,TRCOPE1=?,TRCOPE2=?,TRFECINFORME=?,TRRESPPAGOPER=?,TRIMPORTE=?,TRREFFACTURA=?,TRFECEMISION=?,TRFECDESIS=?,TRCOT5=?,TRFECAUERDO=?,TRCOSAAC=?,TRCOMOTR=?,TRCOORTR=?,TRMONOL=?,TRRESULTADO=?,TRMODOLAUDO=?,TRIMPRECONV=?,TRRESPMOTIV=?,TRAINSTCOPIA=?,TRFEOPLA=?,TRTIPOSOLAC=?,TRVALORAC=?,TRFECREM=?,TRTEL1MEDIACION=?, TRTEL2MEDIACION=?, TRTEL3MEDIACION=?, TRHORAMEDIACIONINICIO=?, TRHORAMEDIACIONFIN=?,TRINTERVORIGEN=?,TRTIPOALEGA=?,TRCLUGAUD=?, TRFICHADO=?, TRCOPEXPTIPO=?, TRIDIOMA=?, TRDESTORIGEN=?, TRRESPUESTA=?, TRRESUMENALEGACIONES=?, TRISTELEMATICA=?, TRISSIR=?, TRISSIRCONNUMREGENTORI=?, TREXCLUIRCIERRE=? WHERE TRID=? ";
		Object getSolarbSacodigoAux = null;
		Object getCensoMonitorAux = null;
		Object getCensoMonitorEjAux = null;
		Object getFaseAux = null;
		if (arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			getSolarbSacodigoAux = arbtramexp.getSolarb().getSacodigo();
		}
		if (arbtramexp.getCensoMonitor() != null && arbtramexp.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorAux = arbtramexp.getCensoMonitor().getMocodigo();
		}
		if (arbtramexp.getCensoMonitorEj() != null && arbtramexp.getCensoMonitorEj().getMocodigo() != null) {
			getCensoMonitorEjAux = arbtramexp.getCensoMonitorEj().getMocodigo();
		}
		if (arbtramexp.getFase() != null && arbtramexp.getFase().getFcodigo() != null) {
			getFaseAux = arbtramexp.getFase().getFcodigo();
		}
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp.getTrestado())) {
			arbtramexp.setTrfecfin(new Date());
		}
		this.jdbcTemplate.update(query, arbtramexp.getTrcodigo(),
				getSolarbSacodigoAux, /* arbtramexp.getTrfecini(), */
				arbtramexp.getTrfecfin(), Y41bUtils.clobToString(arbtramexp.getTrobserves()),
				arbtramexp.getTrnomtrames(), getCensoMonitorAux, getCensoMonitorEjAux, arbtramexp.getTrresofecha(),
				arbtramexp.getTrresotipo(), arbtramexp.getTrresoimporte(), arbtramexp.getTrfecenvio(),
				arbtramexp.getTrfeccierre(), getFaseAux, arbtramexp.getTrtiponot(), arbtramexp.getTrestado(),
				arbtramexp.getTrfecbopv(), arbtramexp.getTrfecinitabl(), arbtramexp.getTrfecnotif(),
				arbtramexp.getTruaidinterv(), arbtramexp.getTrcodigorel(), arbtramexp.getTridnotifplatea(),
				arbtramexp.getTrfecregs(), arbtramexp.getTrtipocom(), arbtramexp.getTrestadoacuse(),
				arbtramexp.getTrnumregs(), arbtramexp.getTrfecacuse(), arbtramexp.getTridesperaplatea(),
				arbtramexp.getTrmatarespera(), arbtramexp.getTrasuntocomunicacion(), arbtramexp.getTrtiponotplatea(),
				arbtramexp.getTrsede(), arbtramexp.getTrcodrem(), arbtramexp.getTrenvrem(),
				arbtramexp.getTridmailorigen(), arbtramexp.getTrmailorigen(), arbtramexp.getTridmaildestino(),
				arbtramexp.getTrmaildestino(), arbtramexp.getTrfechaenviobopvboe(),
				arbtramexp.getTrproceedingsidplatea(), arbtramexp.getTrmonitor(), arbtramexp.getTrfecrecepcion(),
				arbtramexp.getTrrespsubsana(), arbtramexp.getTradherida(), arbtramexp.getTranalisis(),
				arbtramexp.getTrresparb(), arbtramexp.getTrhaycontest(), arbtramexp.getTrtipoarbitraje(),
				arbtramexp.getTrfecdesigna(), arbtramexp.getTrintica(), arbtramexp.getTrtipoaudiencia(),
				arbtramexp.getTrfeccitacion(), arbtramexp.getTrhoracitacion(), arbtramexp.getTrnoraProvinciaId(),
				arbtramexp.getTrnoraMunicipioId(), arbtramexp.getTrnoraLocalidadId(), arbtramexp.getTrnoraCpId(),
				arbtramexp.getTrnoraCalleId(), arbtramexp.getTrnoraPortalId(), arbtramexp.getTrnombrePiso(),
				arbtramexp.getTrnodir(), arbtramexp.getTrnrtel(), arbtramexp.getTrfecsuspension(),
				arbtramexp.getTrmotivo(), arbtramexp.getTrnotcomreclamado(), arbtramexp.getTrnotcomreclamante(),
				arbtramexp.getTrnotcomterceros(), arbtramexp.getTrfecaudiencia(), arbtramexp.getTrhoraaudiencia(),
				arbtramexp.getTrsolprueba(), arbtramexp.getTriddecision(), arbtramexp.getTrrealizadapor(),
				arbtramexp.getTrainstanciade(), arbtramexp.getTrcope1(), arbtramexp.getTrcope2(),
				arbtramexp.getTrfecinforme(), arbtramexp.getTrresppagoper(), arbtramexp.getTrimporte(),
				arbtramexp.getTrreffactura(), arbtramexp.getTrfecemision(), arbtramexp.getTrfecdesis(),
				arbtramexp.getTrcot5(), arbtramexp.getTrfecauerdo(), arbtramexp.getTrcosaac(), arbtramexp.getTrcomotr(),
				arbtramexp.getTrcoortr(), arbtramexp.getTrmonol(), arbtramexp.getTrresultado(),
				arbtramexp.getTrmodolaudo(), arbtramexp.getTrimpreconv(), arbtramexp.getTrrespmotiv(),
				arbtramexp.getTrainstcopia(), arbtramexp.getTrfeopla(), arbtramexp.getTrtiposolac(),
				arbtramexp.getTrvalorac(), arbtramexp.getTrfecrem(), arbtramexp.getTrtel1mediacion(),
				arbtramexp.getTrtel2mediacion(), arbtramexp.getTrtel3mediacion(), arbtramexp.getTrhoramediacioninicio(),
				arbtramexp.getTrhoramediacionfin(), arbtramexp.getTrintervorigen(), arbtramexp.getTrtipoalega(),
				arbtramexp.getTrclugaud(), arbtramexp.getTrfichado(), arbtramexp.getTrcopexptipo(),
				arbtramexp.getTridioma(), arbtramexp.getTipoDestOrigen(), arbtramexp.getTrrespuesta(),
				Y41bUtils.clobToString(arbtramexp.getTrresumenalegaciones()), arbtramexp.getTristelematica(),
				arbtramexp.getTrIsSir(), arbtramexp.getTrIsSirConNumRegEntOri(), arbtramexp.getTrExcluirCierre(),
				arbtramexp.getTrid());

		// Cuando se trata de una notificacion o comunicacion actualizamos
		// el campo TRTEXTO por separado
		if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRTEXTO = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrtexto()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRSIGUIENTESTRAMITES = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrsiguientestramites()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRRESUMEN = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrresumen()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRINTERLOCUTOR = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrinterlocutor()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRLIMITACIONES = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrlimitaciones()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TROBJETO = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrobjeto()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRDECISION = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrdecision()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_PROPUESTA_SANCIONADOR.equals(arbtramexp.getTrcodigo())) {
			String query1 = "UPDATE ARBTRAMEXP SET TRJUSTIFICACION = ? WHERE TRID=? ";
			Object[] params1 = { Y41bUtils.clobToString(arbtramexp.getTrjustificacion()), arbtramexp.getTrid() };
			this.jdbcTemplate.update(query1, params1);
		}
		return arbtramexp;
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp find(Arbtramexp arbtramexp) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID, t1.TRCOPEXPTIPO, t1.TRCODIGO, t1.TREXCODIGO, t1.TRFECINI, t1.TRFECFIN, t1.TRNOMTRAMES, t1.TRMOCODIGO, t1.TRMOCODIGOEJ, t1.TRTRIDREL, t1.TRRESOFECHA, t1.TRRESOTIPO, t1.TRRESOIMPORTE, t1.TRFECENVIO, t1.TRFECCIERRE, t1.TRFCODIGO, t1.TRTIPONOT, t1.TRESTADO, t1.TRFECBOPV, t1.TRFECINITABL, t1.TRFECNOTIF, t1.TRUAIDINTERV, t1.TRCODIGOREL, t1.TRIDNOTIFPLATEA, t1.TRFECREGS, t1.TRTIPOCOM, t1.TRESTADOACUSE, t1.TRNUMREGS, t1.TRFECACUSE, t1.TRIDESPERAPLATEA, t1.TRMATARESPERA, t1.TRASUNTOCOMUNICACION, t1.TRTIPONOTPLATEA, t1.TRSEDE, t1.TRCODREM, t1.TRENVREM, t1.TRIDMAILORIGEN, t1.TRMAILORIGEN, t1.TRIDMAILDESTINO, t1.TRMAILDESTINO, t1.TRFECHAENVIOBOPVBOE, t1.TRPROCEEDINGSIDPLATEA, t1.TRMONITOR, t1.TRFECRECEPCION, t1.TRRESPSUBSANA, t1.TRADHERIDA, t1.TRANALISIS, t1.TRRESPARB, t1.TRHAYCONTEST, t1.TRTIPOARBITRAJE, t1.TRFECDESIGNA, t1.TRINTICA, t1.TRTIPOAUDIENCIA, t1.TRFECCITACION, t1.TRHORACITACION, t1.TRNORA_PROVINCIA_ID TRNORAPROVINCIAID, t1.TRNORA_MUNICIPIO_ID TRNORAMUNICIPIOID,t1.TRNORA_LOCALIDAD_ID TRNORALOCALIDADID,t1.TRNORA_CP_ID TRNORACPID,t1.TRNORA_CALLE_ID TRNORACALLEID, t1.TRNORA_PORTAL_ID TRNORAPORTALID, t1.TRNOMBRE_PISO TRNOMBREPISO, t1.TRNODIR, t1.TRNRTEL, t1.TRFECSUSPENSION, t1.TRMOTIVO, t1.TRNOTCOMRECLAMADO, t1.TRNOTCOMRECLAMANTE, t1.TRNOTCOMTERCEROS, t1.TRFECAUDIENCIA, t1.TRHORAAUDIENCIA, t1.TRSOLPRUEBA, t1.TRIDDECISION, t1.TRREALIZADAPOR, t1.TRAINSTANCIADE, t1.TRCOPE1, t1.TRCOPE2, t1.TRFECINFORME, t1.TRRESPPAGOPER, t1.TRIMPORTE, t1.TRREFFACTURA, t1.TRFECEMISION, t1.TRFECDESIS, t1.TRCOT5, t1.TRFECAUERDO, t1.TRCOSAAC, t1.TRCOMOTR, t1.TRCOORTR, t1.TRMONOL, t1.TRRESULTADO, t1.TRMODOLAUDO, t1.TRIMPRECONV, t1.TRRESPMOTIV, t1.TRAINSTCOPIA, t1.TRFEOPLA, t1.TRTIPOSOLAC, t1.TRVALORAC, t1.TRFECREM, t1.TRTEL1MEDIACION, t1.TRTEL2MEDIACION, t1.TRTEL3MEDIACION, t1.TRHORAMEDIACIONINICIO, t1.TRHORAMEDIACIONFIN, t1.TRINTERVORIGEN, t1.TRTIPOALEGA, t1.TRCLUGAUD TRCLUGAUD, t1.TRFICHADO TRFICHADO ");
		query.append(
				" ,t1.TROBSERVES,t1.TRTEXTO,t1.TRSIGUIENTESTRAMITES,t1.TRRESUMEN,t1.TRLIMITACIONES,t1.TROBJETO,t1.TRDECISION,t1.TRJUSTIFICACION,t1.TRINTERLOCUTOR, t1.TRIDIOMA, t1.TRDESTORIGEN TRDESTORIGEN, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES, t1.TRISTELEMATICA TRISTELEMATICA, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI, t1.TREXCLUIRCIERRE TREXCLUIRCIERRE ");
		query.append(" ,t2.SACODIGO SACODIGO, t2.SACOJA SACOJA, t2.SANROR SANROR, t2.SANRAN SANRAN ");
		query.append(
				" ,t3.FCODIGO FASEFCODIGO, t3.FNOMBRE FASEFNOMBRE, t3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE, t1.TRACUSEREINTENTADO, t1.TRAUTOMATICO ");
		query.append(" FROM ARBTRAMEXP t1 , SOLARB t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6 ");
		query.append(
				" WHERE t1.TRID = ? AND t1.TREXCODIGO= t2.SACODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO ");

		List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query.toString(), this.rwMap, arbtramexp.getTrid());
		return (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp findUltimoTramiteConFase(Arbtramexp arbtramexp) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID, t1.TRCODIGO,t1.TRFECINI, t1.TRFECFIN, t1.TRNOMTRAMES, ");
		query.append(" t6.TRNOMBRE, t6.TRNOMBREE , t6.FCODIGO AS TRFCODIGO ");
		query.append(" FROM ARBTRAMEXP t1 , TRAMITE t6 ");
		query.append(" WHERE t6.TRCODIGO(+) = t1.TRCODIGO ");
		query.append(
				" AND t6.FCODIGO IS NOT NULL AND t1.TREXCODIGO=? AND t1.TRFECFIN = (SELECT MAX(TRFECFIN) FROM ARBTRAMEXP tr2, TRAMITE tr3 WHERE tr2.TRCODIGO = tr3.TRCODIGO AND tr3.FCODIGO IS NOT NULL AND tr2.TREXCODIGO=? )  AND ROWNUM=1");
		List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query.toString(), this.rwMapTRID,
				arbtramexp.getSolarb().getSacodigo(), arbtramexp.getSolarb().getSacodigo());
		return (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp dameUltimaAudiencia(Arbtramexp arbtramexp) {
		StringBuilder query = new StringBuilder(
				"SELECT  TRID, TRCOPEXPTIPO, TRCODIGO, TREXCODIGO, TRFECINI, TRFECFIN, TRNOMTRAMES, TRMOCODIGO, TRMOCODIGOEJ, TRTRIDREL, TRRESOFECHA, TRRESOTIPO, TRRESOIMPORTE, TRFECENVIO, TRFECCIERRE, TRFCODIGO, TRTIPONOT, TRESTADO, TRFECBOPV, TRFECINITABL, TRFECNOTIF, TRUAIDINTERV, TRCODIGOREL, TRIDNOTIFPLATEA, TRFECREGS, TRTIPOCOM, TRESTADOACUSE, TRNUMREGS, TRFECACUSE, TRIDESPERAPLATEA, TRMATARESPERA, TRASUNTOCOMUNICACION, TRTIPONOTPLATEA, TRSEDE, TRCODREM, TRENVREM, TRIDMAILORIGEN, TRMAILORIGEN, TRIDMAILDESTINO, TRMAILDESTINO, TRFECHAENVIOBOPVBOE, TRPROCEEDINGSIDPLATEA, TRMONITOR, TRFECRECEPCION, TRRESPSUBSANA, TRADHERIDA, TRANALISIS, TRRESPARB, TRHAYCONTEST, TRTIPOARBITRAJE, TRFECDESIGNA, TRINTICA, TRTIPOAUDIENCIA, TRFECCITACION, TRHORACITACION, TRNORAPROVINCIAID, TRNORAMUNICIPIOID, TRNORALOCALIDADID, TRNORACPID, TRNORACALLEID,  TRNORAPORTALID, TRNOMBREPISO, TRNODIR, TRNRTEL, TRFECSUSPENSION, TRMOTIVO, TRNOTCOMRECLAMADO, TRNOTCOMRECLAMANTE, TRNOTCOMTERCEROS, TRFECAUDIENCIA, TRHORAAUDIENCIA, TRSOLPRUEBA, TRIDDECISION, TRREALIZADAPOR, TRAINSTANCIADE, TRCOPE1, TRCOPE2, TRFECINFORME, TRRESPPAGOPER, TRIMPORTE, TRREFFACTURA, TRFECEMISION, TRFECDESIS, TRCOT5, TRFECAUERDO, TRCOSAAC, TRCOMOTR, TRCOORTR, TRMONOL, TRRESULTADO, TRMODOLAUDO, TRIMPRECONV, TRRESPMOTIV, TRAINSTCOPIA, TRFEOPLA, TRTIPOSOLAC, TRVALORAC, TRFECREM, TRTEL1MEDIACION, TRTEL2MEDIACION, TRTEL3MEDIACION, TRHORAMEDIACIONINICIO, TRHORAMEDIACIONFIN, TRINTERVORIGEN, TRTIPOALEGA, TRCLUGAUD TRCLUGAUD, TRFICHADO TRFICHADO, ");
		query.append(
				" TROBSERVES,TRTEXTO,TRSIGUIENTESTRAMITES,TRRESUMEN,TRLIMITACIONES,TROBJETO,TRDECISION,TRJUSTIFICACION,TRINTERLOCUTOR,TRIDIOMA,TRDESTORIGEN,TRRESPUESTA,TRRESUMENALEGACIONES,TRISTELEMATICA, TRISSIR, TRISSIRCONNUMREGENTORI, TREXCLUIRCIERRE, ");
		query.append(
				" SACODIGO, SACOJA, SANROR, SANRAN, FASEFCODIGO, FASEFNOMBRE, FASEFNOMBREE, MONOMBRE, MONOMBREEJ, TRNOMBRE, TRNOMBREE FROM ");
		query.append(
				" (SELECT  t1.TRID, t1.TRCOPEXPTIPO, t1.TRCODIGO, t1.TREXCODIGO, t1.TRFECINI, t1.TRFECFIN, t1.TRNOMTRAMES, t1.TRMOCODIGO, t1.TRMOCODIGOEJ, t1.TRTRIDREL, t1.TRRESOFECHA, t1.TRRESOTIPO, t1.TRRESOIMPORTE, t1.TRFECENVIO, t1.TRFECCIERRE, t1.TRFCODIGO, t1.TRTIPONOT, t1.TRESTADO, t1.TRFECBOPV, t1.TRFECINITABL, t1.TRFECNOTIF, t1.TRUAIDINTERV, t1.TRCODIGOREL, t1.TRIDNOTIFPLATEA, t1.TRFECREGS, t1.TRTIPOCOM, t1.TRESTADOACUSE, t1.TRNUMREGS, t1.TRFECACUSE, t1.TRIDESPERAPLATEA, t1.TRMATARESPERA, t1.TRASUNTOCOMUNICACION, t1.TRTIPONOTPLATEA, t1.TRSEDE, t1.TRCODREM, t1.TRENVREM, t1.TRIDMAILORIGEN, t1.TRMAILORIGEN, t1.TRIDMAILDESTINO, t1.TRMAILDESTINO, t1.TRFECHAENVIOBOPVBOE, t1.TRPROCEEDINGSIDPLATEA, t1.TRMONITOR, t1.TRFECRECEPCION, t1.TRRESPSUBSANA, t1.TRADHERIDA, t1.TRANALISIS, t1.TRRESPARB, t1.TRHAYCONTEST, t1.TRTIPOARBITRAJE, t1.TRFECDESIGNA, t1.TRINTICA, t1.TRTIPOAUDIENCIA, t1.TRFECCITACION, t1.TRHORACITACION, t1.TRNORA_PROVINCIA_ID TRNORAPROVINCIAID, t1.TRNORA_MUNICIPIO_ID TRNORAMUNICIPIOID,t1.TRNORA_LOCALIDAD_ID TRNORALOCALIDADID,t1.TRNORA_CP_ID TRNORACPID,t1.TRNORA_CALLE_ID TRNORACALLEID, t1.TRNORA_PORTAL_ID TRNORAPORTALID, t1.TRNOMBRE_PISO TRNOMBREPISO, t1.TRNODIR, t1.TRNRTEL, t1.TRFECSUSPENSION, t1.TRMOTIVO, t1.TRNOTCOMRECLAMADO, t1.TRNOTCOMRECLAMANTE, t1.TRNOTCOMTERCEROS, t1.TRFECAUDIENCIA, t1.TRHORAAUDIENCIA, t1.TRSOLPRUEBA, t1.TRIDDECISION, t1.TRREALIZADAPOR, t1.TRAINSTANCIADE, t1.TRCOPE1, t1.TRCOPE2, t1.TRFECINFORME, t1.TRRESPPAGOPER, t1.TRIMPORTE, t1.TRREFFACTURA, t1.TRFECEMISION, t1.TRFECDESIS, t1.TRCOT5, t1.TRFECAUERDO, t1.TRCOSAAC, t1.TRCOMOTR, t1.TRCOORTR, t1.TRMONOL, t1.TRRESULTADO, t1.TRMODOLAUDO, t1.TRIMPRECONV, t1.TRRESPMOTIV, t1.TRAINSTCOPIA, t1.TRFEOPLA, t1.TRTIPOSOLAC, t1.TRVALORAC, t1.TRFECREM, t1.TRTEL1MEDIACION, t1.TRTEL2MEDIACION, t1.TRTEL3MEDIACION, t1.TRHORAMEDIACIONINICIO, t1.TRHORAMEDIACIONFIN, t1.TRINTERVORIGEN, t1.TRTIPOALEGA, t1.TRCLUGAUD TRCLUGAUD, t1.TRFICHADO TRFICHADO ");
		query.append(
				" ,t1.TROBSERVES,t1.TRTEXTO,t1.TRSIGUIENTESTRAMITES,t1.TRRESUMEN,t1.TRLIMITACIONES,t1.TROBJETO,t1.TRDECISION,t1.TRJUSTIFICACION,t1.TRINTERLOCUTOR, t1.TRIDIOMA, t1.TRDESTORIGEN TRDESTORIGEN, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES, t1.TRISTELEMATICA TRISTELEMATICA, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI, t1.TREXCLUIRCIERRE TREXCLUIRCIERRE ");
		query.append(" ,t2.SACODIGO SACODIGO, t2.SACOJA SACOJA, t2.SANROR SANROR, t2.SANRAN SANRAN ");
		query.append(
				" ,t3.FCODIGO FASEFCODIGO, t3.FNOMBRE FASEFNOMBRE, t3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE");
		query.append(" FROM ARBTRAMEXP t1 , SOLARB t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6 ");
		query.append(
				" WHERE t1.TREXCODIGO= t2.SACODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO ");
		query.append(
				" AND t1.TREXCODIGO= ? AND (t1.TRCODIGO = 'K61' OR t1.TRCODIGO = 'K67') AND t1.TRESTADO = ? ORDER BY TRID DESC) WHERE ROWNUM = 1");
		List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query.toString(), this.rwMap,
				arbtramexp.getTrexcodigo(), arbtramexp.getTrestado());
		return (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);
	}

	/**
	 * Removes a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Pagination
	 * @return
	 */
	public void remove(Arbtramexp arbtramexp) {
		String query = "DELETE FROM ARBTRAMEXP WHERE TRID=?";
		this.jdbcTemplate.update(query, arbtramexp.getTrid());
	}

	/**
	 * Finds a List of rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbtramexp> findAll(Arbtramexp arbtramexp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID, t1.TRCOPEXPTIPO, t1.TRCODIGO, t1.TREXCODIGO, t1.TRFECINI, t1.TRFECFIN, t1.TRNOMTRAMES, t1.TRMOCODIGO, t1.TRMOCODIGOEJ, t1.TRTRIDREL, t1.TRRESOFECHA, t1.TRRESOTIPO, t1.TRRESOIMPORTE, t1.TRFECENVIO, t1.TRFECCIERRE, t1.TRFCODIGO, t1.TRTIPONOT, t1.TRESTADO, t1.TRFECBOPV, t1.TRFECINITABL, t1.TRFECNOTIF, t1.TRUAIDINTERV, t1.TRCODIGOREL, t1.TRIDNOTIFPLATEA, t1.TRFECREGS, t1.TRTIPOCOM, t1.TRESTADOACUSE, t1.TRNUMREGS, t1.TRFECACUSE, t1.TRIDESPERAPLATEA, t1.TRMATARESPERA, t1.TRASUNTOCOMUNICACION, t1.TRTIPONOTPLATEA, t1.TRSEDE, t1.TRCODREM, t1.TRENVREM, t1.TRIDMAILORIGEN, t1.TRMAILORIGEN, t1.TRIDMAILDESTINO, t1.TRMAILDESTINO, t1.TRFECHAENVIOBOPVBOE, t1.TRPROCEEDINGSIDPLATEA, t1.TRMONITOR, t1.TRFECRECEPCION, t1.TRRESPSUBSANA, t1.TRADHERIDA, t1.TRANALISIS, t1.TRRESPARB, t1.TRHAYCONTEST, t1.TRTIPOARBITRAJE, t1.TRFECDESIGNA, t1.TRINTICA, t1.TRTIPOAUDIENCIA, t1.TRFECCITACION, t1.TRHORACITACION,  t1.TRNORA_PROVINCIA_ID TRNORAPROVINCIAID, t1.TRNORA_MUNICIPIO_ID TRNORAMUNICIPIOID,t1.TRNORA_LOCALIDAD_ID TRNORALOCALIDADID,t1.TRNORA_CP_ID TRNORACPID,t1.TRNORA_CALLE_ID TRNORACALLEID, t1.TRNORA_PORTAL_ID TRNORAPORTALID, t1.TRNOMBRE_PISO TRNOMBREPISO, t1.TRNODIR, t1.TRNRTEL, t1.TRFECSUSPENSION, t1.TRMOTIVO, t1.TRNOTCOMRECLAMADO, t1.TRNOTCOMRECLAMANTE, t1.TRNOTCOMTERCEROS, t1.TRFECAUDIENCIA, t1.TRHORAAUDIENCIA, t1.TRSOLPRUEBA, t1.TRIDDECISION, t1.TRREALIZADAPOR, t1.TRAINSTANCIADE, t1.TRCOPE1, t1.TRCOPE2, t1.TRFECINFORME, t1.TRRESPPAGOPER, t1.TRIMPORTE, t1.TRREFFACTURA, t1.TRFECEMISION, t1.TRFECDESIS, t1.TRCOT5, t1.TRFECAUERDO, t1.TRCOSAAC, t1.TRCOMOTR, t1.TRCOORTR, t1.TRMONOL, t1.TRRESULTADO, t1.TRMODOLAUDO, t1.TRIMPRECONV, t1.TRRESPMOTIV, t1.TRAINSTCOPIA, t1.TRFEOPLA, t1.TRTIPOSOLAC, t1.TRVALORAC, t1.TRFECREM, t1.TRTEL1MEDIACION, t1.TRTEL2MEDIACION, t1.TRTEL3MEDIACION, t1.TRHORAMEDIACIONINICIO, t1.TRHORAMEDIACIONFIN, t1.TRINTERVORIGEN, t1.TRTIPOALEGA, t1.TRFECALTA TRFECALTA,t1.TRCLUGAUD TRCLUGAUD, t1.TRFICHADO TRFICHADO  ");
		query.append(
				" ,t1.TROBSERVES,t1.TRTEXTO,t1.TRSIGUIENTESTRAMITES,t1.TRRESUMEN,t1.TRLIMITACIONES,t1.TROBJETO,t1.TRDECISION,t1.TRJUSTIFICACION,t1.TRINTERLOCUTOR, t1.TRIDIOMA, t1.TRACUSEREINTENTADO, t1.TRDESTORIGEN TRDESTORIGEN, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES, t1.TRISTELEMATICA TRISTELEMATICA, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI, t1.TREXCLUIRCIERRE TREXCLUIRCIERRE  ");
		query.append(" ,t2.SACODIGO SACODIGO, t2.SACOJA SACOJA, t2.SANROR SANROR, t2.SANRAN SANRAN ");
		query.append(
				" ,t3.FCODIGO FASEFCODIGO, t3.FNOMBRE FASEFNOMBRE, t3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU");
		query.append(
				" FROM ARBTRAMEXP t1 , SOLARB t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6, ENVIOS_POR_REMESA t7  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtramexp);
		StringBuilder where = new StringBuilder(
				" WHERE t1.TREXCODIGO= t2.SACODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO AND to_char(t1.TRTRIDREL) = t7.EHCODIGO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbtramexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbtramexp arbtramexp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBTRAMEXP t1, SOLARB t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtramexp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TREXCODIGO= t2.SACODIGO(+)  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbtramexp entity
	 * 
	 * @param arbtramexp
	 *            Arbtramexp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMap(Arbtramexp arbtramexp) {

		StringBuilder where = new StringBuilder(ArbtramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbtramexp != null && arbtramexp.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(arbtramexp.getTrid());
		}
		if (arbtramexp != null && arbtramexp.getTruaidinterv() != null) {
			where.append(" AND t1.TRUAIDINTERV = ?");
			params.add(arbtramexp.getTruaidinterv());
		}
		if (arbtramexp != null && arbtramexp.getTrtridrel() != null) {
			where.append(" AND t1.TRTRIDREL = ?");
			params.add(arbtramexp.getTrtridrel());
		}
		if (arbtramexp != null && arbtramexp.getArbinterv() != null
				&& arbtramexp.getArbinterv().getUaidinterv() != null) {
			where.append(" AND t1.TRUAIDINTERV = ?");
			params.add(arbtramexp.getArbinterv().getUaidinterv());
		}
		if (arbtramexp != null && arbtramexp.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(arbtramexp.getTrcodigo());
		}
		// Si se aaden ms filtros de Solarb, revisar todos los
		// arbtramexp.setSolarb
		if (arbtramexp != null && arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			where.append(" AND t1.TREXCODIGO = ?");
			params.add(arbtramexp.getSolarb().getSacodigo());
		}
		if (arbtramexp != null && arbtramexp.getTrfecini() != null) {
			where.append(" AND t1.TRFECINI = ?");
			params.add(arbtramexp.getTrfecini());
		}
		if (arbtramexp != null && arbtramexp.getTrfecfin() != null) {
			where.append(" AND t1.TRFECFIN = ?");
			params.add(arbtramexp.getTrfecfin());
		}
		if (arbtramexp != null && arbtramexp.getTrnomtrames() != null) {
			where.append(" AND t1.TRNOMTRAMES = ?");
			params.add(arbtramexp.getTrnomtrames());
		}
		if (arbtramexp != null && arbtramexp.getCensoMonitor() != null
				&& arbtramexp.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t1.TRMOCODIGO = ?");
			params.add(arbtramexp.getCensoMonitor().getMocodigo());
		}
		if (arbtramexp != null && arbtramexp.getCensoMonitorEj() != null
				&& arbtramexp.getCensoMonitorEj().getMocodigo() != null) {
			where.append(" AND t1.TRMOCODIGOEJ = ?");
			params.add(arbtramexp.getCensoMonitorEj().getMocodigo());
		}

		if (arbtramexp != null && arbtramexp.getTrresultado() != null) {
			where.append(" AND t1.TRRESULTADO = ?");
			params.add(arbtramexp.getTrresultado());
		}

		if (arbtramexp != null && arbtramexp.getTrresofecha() != null) {
			where.append(" AND t1.TRRESOFECHA = ?");
			params.add(arbtramexp.getTrresofecha());
		}
		if (arbtramexp != null && arbtramexp.getTrresotipo() != null) {
			where.append(" AND t1.TRRESOTIPO = ?");
			params.add(arbtramexp.getTrresotipo());
		}
		if (arbtramexp != null && arbtramexp.getTrresoimporte() != null) {
			where.append(" AND t1.TRRESOIMPORTE = ?");
			params.add(arbtramexp.getTrresoimporte());
		}
		if (arbtramexp != null && arbtramexp.getTrfecenvio() != null) {
			where.append(" AND t1.TRFECENVIO = ?");
			params.add(arbtramexp.getTrfecenvio());
		}
		if (arbtramexp != null && arbtramexp.getTrfeccierre() != null) {
			where.append(" AND t1.TRFECCIERRE = ?");
			params.add(arbtramexp.getTrfeccierre());
		}
		if (arbtramexp != null && arbtramexp.getFase() != null && arbtramexp.getFase().getFcodigo() != null) {
			where.append(" AND t1.TRFCODIGO = ?");
			params.add(arbtramexp.getFase().getFcodigo());
		}
		if (arbtramexp != null && arbtramexp.getTrtiponot() != null) {
			where.append(" AND t1.TRTIPONOT = ?");
			params.add(arbtramexp.getTrtiponot());
		}
		if (arbtramexp != null && arbtramexp.getTrestado() != null) {
			where.append(" AND t1.TRESTADO = ?");
			params.add(arbtramexp.getTrestado());
		}
		if (arbtramexp != null && arbtramexp.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(arbtramexp.getTrfecalta());
		}
		if (arbtramexp != null && arbtramexp.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(arbtramexp.getTrfecmodif());
		}
		if (arbtramexp != null && arbtramexp.getTrusualta() != null) {
			where.append(" AND t1.TRUSUALTA = ?");
			params.add(arbtramexp.getTrusualta());
		}
		if (arbtramexp != null && arbtramexp.getTrusumodif() != null) {
			where.append(" AND t1.TRUSUMODIF = ?");
			params.add(arbtramexp.getTrusumodif());
		}
		if (arbtramexp != null && arbtramexp.getTrfecbopv() != null) {
			where.append(" AND t1.TRFECBOPV = ?");
			params.add(arbtramexp.getTrfecbopv());
		}
		if (arbtramexp != null && arbtramexp.getTrfecinitabl() != null) {
			where.append(" AND t1.TRFECINITABL = ?");
			params.add(arbtramexp.getTrfecinitabl());
		}
		if (arbtramexp != null && arbtramexp.getTrfecnotif() != null) {
			where.append(" AND t1.TRFECNOTIF = ?");
			params.add(arbtramexp.getTrfecnotif());
		}
		if (arbtramexp != null && arbtramexp.getTrcodigorel() != null) {
			where.append(" AND t1.TRCODIGOREL = ?");
			params.add(arbtramexp.getTrcodigorel());
		}
		if (arbtramexp != null && arbtramexp.getTridnotifplatea() != null) {
			where.append(" AND t1.TRIDNOTIFPLATEA = ?");
			params.add(arbtramexp.getTridnotifplatea());
		}

		if (arbtramexp != null && arbtramexp.getTrfecregs() != null) {
			where.append(" AND t1.TRFECREGS = ?");
			params.add(arbtramexp.getTrfecregs());
		}
		if (arbtramexp != null && arbtramexp.getTrtipocom() != null) {
			where.append(" AND t1.TRTIPOCOM = ?");
			params.add(arbtramexp.getTrtipocom());
		}
		if (arbtramexp != null && arbtramexp.getTrestadoacuse() != null) {
			where.append(" AND t1.TRESTADOACUSE = ?");
			params.add(arbtramexp.getTrestadoacuse());
		}
		if (arbtramexp != null && arbtramexp.getTrnumregs() != null) {
			where.append(" AND t1.TRNUMREGS = ?");
			params.add(arbtramexp.getTrnumregs());
		}
		if (arbtramexp != null && arbtramexp.getTrfecacuse() != null) {
			where.append(" AND t1.TRFECACUSE = ?");
			params.add(arbtramexp.getTrfecacuse());
		}
		if (arbtramexp != null && arbtramexp.getTridesperaplatea() != null) {
			where.append(" AND t1.TRIDESPERAPLATEA = ?");
			params.add(arbtramexp.getTridesperaplatea());
		}
		if (arbtramexp != null && arbtramexp.getTrmatarespera() != null) {
			where.append(" AND t1.TRMATARESPERA = ?");
			params.add(arbtramexp.getTrmatarespera());
		}
		if (arbtramexp != null && arbtramexp.getTrasuntocomunicacion() != null) {
			where.append(" AND t1.TRASUNTOCOMUNICACION = ?");
			params.add(arbtramexp.getTrasuntocomunicacion());
		}
		if (arbtramexp != null && arbtramexp.getTrtiponotplatea() != null) {
			where.append(" AND t1.TRTIPONOTPLATEA = ?");
			params.add(arbtramexp.getTrtiponotplatea());
		}
		if (arbtramexp != null && arbtramexp.getTrsede() != null) {
			where.append(" AND t1.TRSEDE = ?");
			params.add(arbtramexp.getTrsede());
		}
		if (arbtramexp != null && arbtramexp.getTrcodrem() != null) {
			where.append(" AND t1.TRCODREM = ?");
			params.add(arbtramexp.getTrcodrem());
		}
		if (arbtramexp != null && arbtramexp.getTrenvrem() != null) {
			where.append(" AND t1.TRENVREM = ?");
			params.add(arbtramexp.getTrenvrem());
		}
		if (arbtramexp != null && arbtramexp.getTridmailorigen() != null) {
			where.append(" AND t1.TRIDMAILORIGEN = ?");
			params.add(arbtramexp.getTridmailorigen());
		}
		if (arbtramexp != null && arbtramexp.getTrmailorigen() != null) {
			where.append(" AND t1.TRMAILORIGEN = ?");
			params.add(arbtramexp.getTrmailorigen());
		}
		if (arbtramexp != null && arbtramexp.getTridmaildestino() != null) {
			where.append(" AND t1.TRIDMAILDESTINO = ?");
			params.add(arbtramexp.getTridmaildestino());
		}
		if (arbtramexp != null && arbtramexp.getTrmaildestino() != null) {
			where.append(" AND t1.TRMAILDESTINO = ?");
			params.add(arbtramexp.getTrmaildestino());
		}
		if (arbtramexp != null && arbtramexp.getTrfechaenviobopvboe() != null) {
			where.append(" AND t1.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbtramexp.getTrfechaenviobopvboe());
		}
		if (arbtramexp != null && arbtramexp.getTrproceedingsidplatea() != null) {
			where.append(" AND t1.TRPROCEEDINGSIDPLATEA = ?");
			params.add(arbtramexp.getTrproceedingsidplatea());
		}

		if (arbtramexp != null && arbtramexp.getTrfichado() != null) {
			where.append(" AND t1.TRFICHADO = ?");
			params.add(arbtramexp.getTrfichado());
		}

		if (arbtramexp != null && arbtramexp.getTrresparbNot() != null) {
			where.append(" AND t1.TRRESPARB <> ?");
			params.add(arbtramexp.getTrresparbNot());
		}

		if (arbtramexp != null && arbtramexp.getTrtipoalega() != null) {
			where.append(" AND t1.TRTIPOALEGA = ?");
			params.add(arbtramexp.getTrtipoalega());
		}

		if (arbtramexp != null && arbtramexp.getListaCodigosTramiteRelacionados() != null
				&& arbtramexp.getListaCodigosTramiteRelacionados().size() > 0) {
			where.append(" AND t1.TRCODIGOREL IN (");
			for (int i = 0; i < arbtramexp.getListaCodigosTramiteRelacionados().size(); i++) {

				if (i > 0) {
					where.append(", ");
				}
				where.append("? ");
				params.add(arbtramexp.getListaCodigosTramiteRelacionados().get(i));

			}
			where.append(" )");
		}

		if (arbtramexp != null && arbtramexp.getTipoIntervinienteDestino() != null) {

			where.append(
					" AND t1.TRUAIDINTERV IN (SELECT UAIDINTERV FROM ARBINTERV tInterv WHERE t1.TREXCODIGO=tInterv.UAEXCODIGO AND tInterv.UATIPOINTERV=?)");
			params.add(arbtramexp.getTipoIntervinienteDestino());
		}

		if (arbtramexp != null && arbtramexp.getListaCodigosTramites() != null) {
			where.append(" AND t1.TRCODIGO IN (").append(arbtramexp.getListaCodigosTramites()).append(")");
		}

		if (arbtramexp != null && arbtramexp.getTipoDestOrigen() != null) {
			where.append(" AND t1.TRDESTORIGEN = ?");
			params.add(arbtramexp.getTipoDestOrigen());
		}

		if (arbtramexp != null && arbtramexp.getTrrespuesta() != null) {
			where.append(" AND t1.TRRESPUESTA = ?");
			params.add(arbtramexp.getTrrespuesta());
		}

		// if (arbtramexp != null && arbtramexp.getTrresumenalegaciones() !=
		// null) {
		// where.append(" AND t1.TRRESUMENALEGACIONES = ?");
		// params.add(arbtramexp.getTrresumenalegaciones());
		// }

		if (arbtramexp != null && arbtramexp.getTristelematica() != null) {
			where.append(" AND t1.TRISTELEMATICA = ?");
			params.add(arbtramexp.getTristelematica());
		}

		if (arbtramexp != null && arbtramexp.getTrIsSir() != null) {
			where.append(" AND t1.TRISSIR = ?");
			params.add(arbtramexp.getTrIsSir());
		}

		if (arbtramexp != null && arbtramexp.getTrIsSirConNumRegEntOri() != null) {
			where.append(" AND t1.TRISSIRCONNUMREGENTORI = ?");
			params.add(arbtramexp.getTrIsSirConNumRegEntOri());
		}

		if (arbtramexp != null && arbtramexp.getTrExcluirCierre() != null) {
			where.append(" AND t1.TREXCLUIRCIERRE = ?");
			params.add(arbtramexp.getTrExcluirCierre());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param sacodigo
	 *            the sacodigo
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp dameUltimoTramiteTramitado(String sacodigo) {
		try {
			String query = "SELECT MAX(TRID) AS TRID, '' TRCODIGO,  '' TRNOMTRAMES, '' TRNOMBRE, '' TRNOMBREE, '' TRFECINI, '' TRFECFIN, MAX(TRFCODIGO) AS TRFCODIGO FROM ARBTRAMEXP WHERE TREXCODIGO = ? AND TRESTADO='T'  ";
			List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query, this.rwMapTRID, sacodigo);
			return (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);

		} catch (Exception e) {
			e.printStackTrace();
			ArbtramexpDaoImpl.logger.error("Error producido en find de Arbtramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param sacodigo
	 *            the sacodigo
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp dameUltimoTramiteEnCurso(String sacodigo) {
		try {
			String query = "SELECT TRID, TRCODIGO, TRNOMTRAMES, TRNOMBRE, TRNOMBREE, TRFECINI, TRFECFIN, TRFCODIGO FROM (SELECT A.TRID, A.TRCODIGO, A.TRNOMTRAMES, B.TRNOMBRE, B.TRNOMBREE, A.TRFECINI, A.TRFECFIN, A.TRFCODIGO FROM ARBTRAMEXP A, TRAMITE B WHERE A.TRCODIGO = B.TRCODIGO AND A.TREXCODIGO = ? ORDER BY A.TRFECALTA DESC, A.TRID DESC) WHERE ROWNUM = 1 ";
			List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query, this.rwMapTRID, sacodigo);
			Arbtramexp resultado = (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);

			return resultado;

		} catch (Exception e) {
			e.printStackTrace();
			ArbtramexpDaoImpl.logger.error("Error producido en find de Arbtramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * /** Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT L21U2Q00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			ArbtramexpDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return boolean
	 */
	@Transactional(readOnly = true)
	public boolean exists(Arbtramexp arbtramexp) {
		String query = "SELECT COUNT(1) FROM ARBTRAMEXP WHERE 1=1 AND TRID = ?";

		List<String> params = new ArrayList<String>();
		if (arbtramexp.getTrid() == null) {
			return false;
		}
		params.add(arbtramexp.getTrid().toString());

		Long numResultado = this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		if (numResultado == null) {
			return false;
		} else {
			return numResultado > 0;
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateIdNotificacionPlatea(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRIDNOTIFPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbtramexp.getTridnotifplatea(), arbtramexp.getTrid());
		return arbtramexp;
	}

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "INSERT INTO NOTIFICACION_ACUSERECIBO (EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE, EHPCODIGO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, notificacionAcuseRecibo.getEhidnotificacionplatea(),
				notificacionAcuseRecibo.getEhcodigoacuse(), notificacionAcuseRecibo.getEhpcodigo());
		return notificacionAcuseRecibo;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateRegistroSalidaPlatea(Arbtramexp tramite) {
		String query = "UPDATE ARBTRAMEXP SET TRNUMREGS=?, TRFECREGS=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramite.getTrnumregs(), tramite.getTrfecregs(), tramite.getTrid());
		return tramite;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateMatarEspera(Arbtramexp tramitehecho) {
		String query = "UPDATE ARBTRAMEXP SET TRMATARESPERA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramitehecho.getTrmatarespera(), tramitehecho.getTrid());
		return tramitehecho;
	}

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateAcuseReintentado(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRACUSEREINTENTADO=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbtramexp.getTracusereintentado(), arbtramexp.getTrid());
		return arbtramexp;
	}

	/**
	 * addArbtramtsubs
	 * 
	 * @param trid
	 *            String
	 * @param lSubsana
	 *            List<Tipsubsana>
	 */
	public void addArbtramtsubs(String trid, List<Tipsubsana> lSubsana) {
		String query = "DELETE FROM ARBTRAMTSUBS WHERE XDTRID=?";
		this.jdbcTemplate.update(query, trid);
		for (int i = 0; i < lSubsana.size(); i++) {
			query = "INSERT INTO ARBTRAMTSUBS (XDTRID, XDTSID) VALUES (?,?)";
			this.jdbcTemplate.update(query, trid, lSubsana.get(i).getTsid());
		}
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination) {
		// Nota: en la sql idtramite es el codigo del expediente y codexpediente
		// es el id del tramite
		StringBuilder query = new StringBuilder("SELECT " + "t1.TRID, "
				+ "t4.SACOJA||' '||t4.SANRAN||' '||t4.SANROR idTramite, " + "t4.SACOJA EXCOOR, " + "t4.SANRAN EXNRAN, "
				+ "t4.SANROR EXNROR, " + "t4.SACODIGO EXCODIGO, " + "T1.TRID CODEXPEDIENTE, " + "T1.TRFECINI, "
				+ "T1.TRFECINI EHFECHAINICIO, " + "T1.TRNUMREGS EHNUMREGISTROSALIDA, "
				// + "T1.TRASUNTOCOMUNICACION ASUNTO, "
				// + "T1.TRASUNTOCOMUNICACION ACTO, "
				+ "T9.TRESTADO EHESTADOTRAMITE, " + "T1.TRTIPONOTPLATEA ACTO, " + "T1.TRUAIDINTERV UAIDINTERV, "
				+ "T1.TRUAIDINTERV AS EHIDDESTINATARIO, " + "T1.TRMOCODIGOEJ, "
				+ "T1.TRTIPONOTPLATEA EHTIPONOTIFICACIONPLATEA, " + "T2.UANOMBRE UANOMBRE, T2.UANIF NIF, "
				+ "TRIM(T2.UANOMBRE ||' '||T2.UAAPELLIDO1||' '||T2.UAAPELLIDO2) AS NOMBREDESTINATARIO, "
				+ "T2.UANOCO AS NOMBRECOMERCIALDESTINATARIO, " + "T2.UACP_ID AS NOMBRE_CP, "
				+ "(SELECT DS_O FROM T17I.T17_PROVINCIA WHERE T2.UAPROV_ID = ID) AS NOMBRE_PROVINCIA, "
				+ "(SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T2.UAPROV_ID = PROVINCIA_ID AND T2.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO, "
				+ "(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE T2.UALOC_ID = ID) AS NOMBRE_LOCALIDAD, "
				+ "(SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE T2.UACALLE_ID = ID) AS NOMBRE_CALLE, "
				+ "(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE T2.UAPORTAL_ID = ID) AS NOMBREPORTAL, "
				+ "T2.UANOMBRE_PISO AS NOMBREPISO, "
				+ "(SELECT DS_O FROM T17I.T17_PAIS WHERE T2.UAPAIS_ID = ID) AS NOMBREPAIS, "
				+ "((SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE T2.UACALLE_ID = ID)||' '||(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE T2.UAPORTAL_ID = ID)) AS DIRECCION1, "
				+ "T2.UACP_ID||' '||(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE T2.UALOC_ID = ID) AS DIRECCION2, "
				+ "T2.UADIRE_NOCAPV AS DIRECCIONNOCAPV, " + "T2.UADIRE_ANT AS DIRECCIONANTIGUA, "
				+ "DECODE(T2.UAPAIS_ID," + Y41bConstantes.COD_PAIS_ESTADO + ",'" + Y41bConstantes.NO + "','"
				+ Y41bConstantes.SI + "') AS EXTRANJERO, " + "T1.TRSEDE EHSEDE, " + "T2.UAESCODIGO ESCODIGO, "
				+ "T5.MONOMBRE MONOMBRE, T1.TRASUNTOCOMUNICACION, "

				+ " T7.COD_ORG CODORG, T7.NOMBRE_ES NOMBREES, T7.NOMBRE_EU NOMBREEU,  T7.NORA_PROVINCIA_ID NORAPROVINCIAID, T7.NOMBRE_PROVINCIA NOMBREPROVINCIAORG, T7.NORA_MUNICIPIO_ID NORAMUNICIPIOID, T7.NOMBRE_MUNICIPIO NOMBREMUNICIPIOORG, "
				+ " T7.NORA_LOCALIDAD_ID NORALOCALIDADID, T7.NOMBRE_LOCALIDAD NOMBRELOCALIDADORG, T7.NORA_CALLE_ID NORACALLEID, T7.NOMBRE_CALLE NOMBRECALLEORG, T7.NORA_CP_ID NORACPID, T7.NOMBRE_CP NOMBRECPORG, T7.NORA_PORTAL_ID NORAPORTALID, "
				+ " T7.NOMBRE_PORTAL NOMBREPORTALORG, T7.TELEFONO TELEFONOORGANISMO, T7.FAX FAXORGANISMO, T7.EMAIL EMAILORGANISMO, T7.URL WEBORGANISMO, "
				+ " T1.TRCODIGO TRCODIGO, T1.TRID EHCODIGO, T2.UATIPOINTERV TIPOINTERVINIENTE, T5.USUARIOXLNET USUARIOXLNET, T5.PUESTOXLNET PUESTOXLNET, "
				+ " T8.ENVCESTADO ENVCESTADO, T8.ENVCDESERRORES ENVCDESERRORES, T8.ENVCDESERROREU ENVCDESERROREU, T8.ENVC_ID_ENVIO ENVCIDENVIO, T8.ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, T8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, T8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, "
				+ " T8.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION,T8.ENVCCODBARRAS ENVCCODBARRAS, "
				+ " T9.TRID IDTRAMITEACUSERELACIONADO, T9.TRESTADOACUSE EHACUSERECIBORECIBIDO");

		StringBuilder from = new StringBuilder(
				" FROM ARBTRAMEXP T1, ARBINTERV T2, ARBEXP T3, SOLARB T4, CENSO_MONITOR T5, ORGANISMO T7, ENVIOS_POR_REMESA T8, ARBTRAMEXP T9 ");

		query.append(from);

		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV AND T3.EXCODIGO = T1.TREXCODIGO AND T3.EXCODIGO = t4.SACODIGO AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND t4.SACOJA= t7.COD_ORG  AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION + "','"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION + "') "
						+ " AND to_char(T1.TRID) = T8.EHCODIGO(+) "
						+ "AND T1.TRID = T9.TRTRIDREL(+) AND t9.TRCODIGO(+) = '"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO + "' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
				this.rwMapNotifiComunica, params.toArray());
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapNotifiComunica(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder where = new StringBuilder(ArbtramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.getRmcodigo() == null) {
			where.append(" AND T1.TRENVREM=? ");
			params.add(Y41bConstantes.SI);

			where.append(" AND T1.TRESTADO=? ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			where.append(" AND T1.TRCODREM IS NULL ");
		}
		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.getRmcodigo() != null) {
			where.append(" AND T1.TRCODREM = ? ");
			params.add(notificacionComunicacionDetalle.getRmcodigo());

		}
		if (notificacionComunicacionDetalle.getRmtipo() != null
				&& notificacionComunicacionDetalle.getModoRemesa() != null
				&& notificacionComunicacionDetalle.getModoRemesa().equalsIgnoreCase(Y41bConstantes.MODO_POPUP_ALTA)) {
			String tipo = notificacionComunicacionDetalle.getRmtipo();
			if (tipo.contains(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				if (notificacionComunicacionDetalle.isCompatibleAA66()) {
					if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
						where.append(" AND (T2.UAPAIS_ID IS NULL OR T2.UAPAIS_ID = '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("')");
					} else {
						where.append(" AND T2.UAPAIS_ID<> '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("' ");
					}
				}
				tipo = Y41bConstantes.TRAMITE_NOTIFICACION;
			}
			where.append(" AND T1.TRCODIGO = '");
			if (tipo.equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
				where.append(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
			} else if (tipo.equals(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				where.append(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
			} else if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
				where.append(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
			}
			where.append("'");
		}

		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.isRmcapv() != null) {
			where.append(" AND T2.UAPROV_ID IN ('48','01','20') ");
		}
		if (notificacionComunicacionDetalle != null
				/* && notificacionComunicacionDetalle.getRmorganico() != null */
				&& !Y41bUtils.esNullOCadenaVacia(notificacionComunicacionDetalle.getRmorganico())) {
			where.append(" AND T4.SACOJA = ? ");
			params.add(notificacionComunicacionDetalle.getRmorganico());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		StringBuilder from = new StringBuilder(
				" FROM ARBTRAMEXP T1, ARBINTERV T2, ARBEXP T3, SOLARB T4, CENSO_MONITOR T5 ");

		query.append(from);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV AND T3.EXCODIGO = T1.TREXCODIGO AND T3.EXCODIGO = t4.SACODIGO AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION + "','"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION + "') ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.ArbtramexpDao#updateRemesa(com.ejie.y41b.model.
	 * Arbtramexp )
	 */
	@Override
	public Arbtramexp updateRemesa(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRCODREM=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbtramexp.getTrcodrem(), arbtramexp.getTrid().toString());
		return arbtramexp;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbtramexpDao#removeRemesaFromTramitesByEhcodigo(java
	 * .lang.String)
	 */
	@Override
	public void removeRemesaFromTramitesByEhcodigo(String trcodigo) {
		String query = "UPDATE ARBTRAMEXP SET trcodrem = NULL WHERE trid=?";

		this.jdbcTemplate.update(query, trcodigo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbtramexpDao#removeRemesaFromTramites(java.lang.String
	 * )
	 */
	@Override
	public void removeRemesaFromTramites(String rmcodigo) {
		String query = "UPDATE ARBTRAMEXP SET TRCODREM = NULL WHERE TRCODREM=?";

		this.jdbcTemplate.update(query, rmcodigo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbtramexpDao#updateReabrirTramite(com.ejie.y41b.model
	 * .Arbtramexp)
	 */
	@Override
	public Arbtramexp updateReabrirTramite(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRESTADO=?, TRFECFIN=null, TRMOCODIGOEJ=null, TRPROCEEDINGSIDPLATEA=null WHERE TRID=?";

		this.jdbcTemplate.update(query, arbtramexp.getTrestado(), arbtramexp.getTrid());
		return arbtramexp;
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni) {
		try {
			String query = "SELECT T2.TRCODREM DHCODREM, T2.TRID DHTRCODIGO, T1.X5CODOCUMENTO DHCODDOC, T1.X5DATAFILE DHDATAFILE, NULL DHFECHA, T1.X5IDDOCUMENTUM"
					+ " FROM ARBDOCTEMP T1, ARBTRAMEXP T2, ARBDOCTRAMITE T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.X5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ?";

			return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<NotificacionesComunicacionesBusqueda>() {
						public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new NotificacionesComunicacionesBusqueda(resultSet.getString("DHCODREM"),
									resultSet.getString("DHTRCODIGO"), resultSet.getString("DHCODDOC"),
									resultSet.getBlob("DHDATAFILE"), resultSet.getString("X5IDDOCUMENTUM"));
						}
					}, notifiComuni.getRmtipoExpediente(), notifiComuni.getRmcodigo());

		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPKProceedingsPlatea() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT L21X2Q01.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			ArbtramexpDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateProceedingsIdPlatea(Arbtramexp tramite) {
		String query = "UPDATE ARBTRAMEXP SET TRPROCEEDINGSIDPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramite.getTrproceedingsidplatea(), tramite.getTrid());
		return tramite;
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo.
	 * 
	 * @param exCodigo
	 *            the ex codigo
	 * @param fechaInicio
	 *            the fecha inicio
	 * @param censoMonitor
	 *            the censo monitor
	 * @param observaciones
	 *            the observaciones
	 * @return TramiteHecho
	 */

	public Arbtramexp generarTramiteAperturaoAutomatico(String exCodigo, Date fechaInicio, CensoMonitor censoMonitor,
			String observaciones) {
		try {
			Arbtramexp tramiteNuevo = new Arbtramexp();

			tramiteNuevo.setTrid(this.getNewPK().toString());
			tramiteNuevo.setSolarb(new Solarb(exCodigo));
			tramiteNuevo.setTrcodigo((Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA));
			tramiteNuevo.setTrobserves(Y41bUtils.stringToClob(observaciones));
			tramiteNuevo.setTrfecini(fechaInicio);
			tramiteNuevo.setTrfecfin(fechaInicio);
			tramiteNuevo.setCensoMonitor(censoMonitor);
			tramiteNuevo.setCensoMonitorEj(censoMonitor);
			tramiteNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			tramiteNuevo.setFase(new Fase(Y41bConstantes.FASE_REGISTRO_ARBITRAJE));

			// Se inserta el tramite
			this.add(tramiteNuevo);

			return tramiteNuevo;
		} catch (Exception e) {
			e.printStackTrace();
			ArbtramexpDaoImpl.logger.error("Error producido en generarTramiteAperturaoAutomatico: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public Arbtramexp completaAcuseRecibo(Arbtramexp tramitehechoAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception {
		try {
			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Inicio");

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Paso1: " + todayWithZeroTime + ".");
			tramitehechoAcuse.setTrfecfin(todayWithZeroTime);
			tramitehechoAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			tramitehechoAcuse.setTrestadoacuse(situacionNotificacion);
			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Paso2: " + todayWithZeroTime + ".");
			if (Y41bUtils.isFilled(deliveredNotificationInfo.getDeliveryTimestamp())) {
				try {
					SimpleDateFormat formatterAcuseRecibo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
					Date dateAcuseRecibo = formatterAcuseRecibo.parse(deliveredNotificationInfo.getDeliveryTimestamp());
					ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Paso3: " + dateAcuseRecibo + ".");
					;
					tramitehechoAcuse.setTrfecacuse(dateAcuseRecibo);
				} catch (Exception e) {
					ArbtramexpDaoImpl.logger.error("Error producido al parsear la fecha del acuse: ", e);
					// Si falla el parseo meto la fecha de hoy
					tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
				}
			} else {
				tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
			}
			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Paso4: ANTES DEL UPDATE.");
			this.update(tramitehechoAcuse);
			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Fin");
			return tramitehechoAcuse;
		} catch (Exception e) {
			ArbtramexpDaoImpl.logger.error("completaAcuseRecibo. ERROR" + e.getMessage());
			throw e;

		} finally {
			ArbtramexpDaoImpl.logger.info("completaAcuseRecibo. Fin");
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateCensoMonitorNoTramitados(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRMOCODIGO=? WHERE TREXCODIGO=? AND TRESTADO!='T'";

		this.jdbcTemplate.update(query, arbtramexp.getCensoMonitor().getMocodigo(),
				arbtramexp.getSolarb().getSacodigo());
		return arbtramexp;
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param santramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp findUltimoTramiteExpedientePorTipoTramite(Arbtramexp arbtramexp) {
		try {
			String query2 = "SELECT TRID, TRCODIGO,  TRNOMTRAMES, TRNOMBRE, TRNOMBREE, TRFECINI,TRFECFIN,TRFCODIGO FROM (SELECT A.TRID,  A.TRCODIGO, A.TRNOMTRAMES, B.TRNOMBRE, B.TRNOMBREE, A.TRFECINI, A.TRFECFIN, A.TRFCODIGO  FROM ARBTRAMEXP A, TRAMITE B WHERE A.TRCODIGO = B.TRCODIGO AND A.TREXCODIGO = ? AND A.TRCODIGO=? ORDER BY A.TRFECALTA DESC, A.TRID DESC)  WHERE ROWNUM = 1 ";
			List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query2, this.rwMapTRID,
					arbtramexp.getSolarb().getSacodigo(), arbtramexp.getTrcodigo());
			Arbtramexp resultado = (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);

			return resultado;
		} catch (EmptyResultDataAccessException e) {
			return new Arbtramexp();
		}
	}

	/**
	 * Metodo para devolver el ultimo tramite tramitado del expediente
	 * 
	 * @param santramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(readOnly = true)
	public Arbtramexp findUltimoTramiteTramitadoExpedientePorTipoTramite(Arbtramexp arbtramexp) {
		try {
			String query2 = "SELECT TRID, TRCODIGO,  TRNOMTRAMES, TRNOMBRE, TRNOMBREE, TRFECINI,TRFECFIN,TRFCODIGO,TRREALIZADAPOR FROM (SELECT A.TRID,  A.TRCODIGO, A.TRNOMTRAMES, B.TRNOMBRE, B.TRNOMBREE, A.TRFECINI, A.TRFECFIN, A.TRFCODIGO, A.TRREALIZADAPOR FROM ARBTRAMEXP A, TRAMITE B WHERE A.TRCODIGO = B.TRCODIGO AND A.TRESTADO=? AND A.TREXCODIGO = ? AND A.TRCODIGO=? ORDER BY A.TRFECALTA DESC, A.TRID DESC)  WHERE ROWNUM = 1 ";
			List<Arbtramexp> arbtramexpList = this.jdbcTemplate.query(query2, this.rwMapUltimoTRID,
					Y41bConstantes.ESTADO_TRAMITE_TRAMITADO, arbtramexp.getSolarb().getSacodigo(),
					arbtramexp.getTrcodigo());
			Arbtramexp resultado = (Arbtramexp) DataAccessUtils.uniqueResult(arbtramexpList);

			return resultado;
		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * 
	 */
	public void updateTrasGenerarFicheroADO(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TRFEOPLA=?, TRFICHADO=?, TRIMPORTE=? WHERE  TRID=?";

		this.jdbcTemplate.update(query, arbtramexp.getTrfeopla(), arbtramexp.getTrfichado(), arbtramexp.getTrimporte(),
				arbtramexp.getTrid());

	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	public Arbtramexp updateDenegacionTramite(Arbtramexp arbtramexp) {
		String query = "UPDATE ARBTRAMEXP SET TROBSERVES=?,TRESTADO=? WHERE TRID=?";

		this.jdbcTemplate.update(query, Y41bUtils.clobToString(arbtramexp.getTrobserves()), arbtramexp.getTrestado(),
				arbtramexp.getTrid());
		return arbtramexp;
	}

	/**
	 * @param trid
	 * 
	 */
	public void deleteArbtramtsubs(String trid) {
		String query = "DELETE FROM ARBTRAMTSUBS WHERE XDTRID=?";
		this.jdbcTemplate.update(query, trid);

	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni) {

		String query = "SELECT SUM(T1.X5SIZEFILE) TAMANO "
				+ " FROM ARBDOCTEMP T1, ARBTRAMEXP T2, ARBDOCTRAMITE T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.X5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(notifiComuni.getRmtipoExpediente());
		params.add(notifiComuni.getRmcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
