package com.ejie.y41b.dao;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;

//import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Tipsubsana;

/**
 * ArbtramexpDao  
 * 
 *  
 */

public interface ArbtramexpDao {

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp add(Arbtramexp arbtramexp);

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp update(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp find(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp findUltimoTramiteConFase(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp dameUltimaAudiencia(Arbtramexp arbtramexp);

	/**
	 * Deletes a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return
	 */
	void remove(Arbtramexp arbtramexp);

	/**
	 * Finds a List of rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbtramexp> findAll(Arbtramexp arbtramexp, Pagination pagination);

	/**
	 * Counts rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Long
	 */
	Long findAllCount(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param sacodigo
	 *            the sacodigo
	 * @return Arbtramexp
	 */
	Arbtramexp dameUltimoTramiteTramitado(String sacodigo);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param sacodigo
	 *            String
	 * @return Arbtramexp
	 */
	Arbtramexp dameUltimoTramiteEnCurso(String sacodigo);

	/**
	 * /** Get a New PK.
	 * 
	 * @return Long
	 */
	public Long getNewPK();

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return boolean
	 */
	boolean exists(Arbtramexp arbtramexp);

	/**
	 * @param arbtramexp
	 *            arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateIdNotificacionPlatea(Arbtramexp arbtramexp);

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(
			NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateRegistroSalidaPlatea(Arbtramexp tramite);

	/**
	 * @param arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateMatarEspera(Arbtramexp arbtramexp);

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateAcuseReintentado(Arbtramexp arbtramexp);

	/**
	 * @param trid
	 * @param lSubsana
	 */
	void addArbtramtsubs(String trid, List<Tipsubsana> lSubsana);

	/**
	 * @param filterNotifComuni
	 * @return
	 */
	Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * @param filterNotifComuni
	 * @param pagination
	 * @return
	 */
	List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni,
			Pagination pagination);

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateRemesa(Arbtramexp arbtramexp);

	/**
	 * @param trcodigo
	 */
	void removeRemesaFromTramitesByEhcodigo(String trcodigo);

	/**
	 * @param rmcodigo
	 */
	void removeRemesaFromTramites(String rmcodigo);

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateReabrirTramite(Arbtramexp arbtramexp);

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	Long getNewPKProceedingsPlatea();

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateProceedingsIdPlatea(Arbtramexp tramite);

	/**
	 * Generar Tramite automatico de Acuse de Recibo.
	 * 
	 * @param exCodigo
	 *            the ex codigo
	 * @param fechaInicio
	 *            the fecha inicio
	 * @param censoMonitor
	 *            the censo monitor
	 * @param observaciones
	 *            the observaciones
	 * @return TramiteHecho
	 */

	Arbtramexp generarTramiteAperturaoAutomatico(String exCodigo,
			Date fechaInicio, CensoMonitor censoMonitor, String observaciones);

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	Arbtramexp completaAcuseRecibo(Arbtramexp tramitehechoAcuse,
			String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo)
			throws Exception;

	/**
	 * @param santramexpTram
	 * @return
	 */
	Arbtramexp updateCensoMonitorNoTramitados(Arbtramexp arbtramexpTram);

	/**
	 * @param santramexp
	 * @return
	 */
	Arbtramexp findUltimoTramiteExpedientePorTipoTramite(Arbtramexp arbtramexp);

	/**
	 * Metodo para devolver el ultimo tramite tramitado del expediente
	 * 
	 * @param santramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp findUltimoTramiteTramitadoExpedientePorTipoTramite(
			Arbtramexp arbtramexp);

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	void updateTrasGenerarFicheroADO(Arbtramexp arbtramexp);

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param Arbtramexp
	 *            arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp updateDenegacionTramite(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * @param trid
	 * 
	 */
	public void deleteArbtramtsubs(String trid);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda notifiComuni);
}
